/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.FixedWidthFormatter;
import org.das2.util.NumberFormatUtil;
import org.virbo.qstream.TransferType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTransferType
extends TransferType {
    final int sizeBytes;
    private DecimalFormat formatter;
    private String formatStr;

    AsciiTransferType(int sizeBytes, boolean scientificNotation) {
        this.sizeBytes = sizeBytes;
        this.formatStr = AsciiTransferType.getFormat(sizeBytes - 1, scientificNotation);
        this.formatter = NumberFormatUtil.getDecimalFormat((String)this.formatStr);
    }

    AsciiTransferType(int sizeBytes, boolean scientificNotation, int decimals) {
        this.sizeBytes = sizeBytes;
        if (decimals == 0) {
            this.formatStr = "0";
        } else {
            String pounds = "################";
            this.formatStr = "0." + pounds.substring(0, decimals);
        }
        this.formatter = NumberFormatUtil.getDecimalFormat((String)this.formatStr);
    }

    private static String getFormat(int length, boolean sci) {
        if (length < 9 || !sci) {
            if (length == 9) {
                return "0.####";
            }
            if (length == 8) {
                return "0.###";
            }
            if (length == 7) {
                return "0.##";
            }
            if (length == 6) {
                return "0.#";
            }
            if (length < 6) {
                throw new IllegalArgumentException("length is too short: " + length);
            }
            return "0.####";
        }
        StringBuffer buffer = new StringBuffer(length);
        buffer.append("+0.");
        for (int i = 0; i < length - 7; ++i) {
            buffer.append('0');
        }
        buffer.append("E00;-#");
        return buffer.toString();
    }

    @Override
    public void write(double d, ByteBuffer buffer) {
        String s = this.formatter.format(d);
        if (s.length() < this.sizeBytes) {
            s = s + " ";
        }
        if (s.length() < this.sizeBytes) {
            s = FixedWidthFormatter.format((String)s, (int)this.sizeBytes);
        }
        if (s.charAt(this.sizeBytes - 1) != ' ' && s.charAt(0) == '+') {
            s = s.substring(1) + ' ';
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(AsciiTransferType.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (bytes.length != this.sizeBytes) {
            throw new IllegalAccessError();
        }
        buffer.put(bytes);
    }

    @Override
    public double read(ByteBuffer buffer) {
        byte[] bytes = new byte[this.sizeBytes];
        buffer.get(bytes);
        try {
            String str = new String(bytes, "US-ASCII").trim();
            return Double.parseDouble(str);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(AsciiTransferType.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int sizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public boolean isAscii() {
        return true;
    }

    @Override
    public String name() {
        return "ascii" + this.sizeBytes;
    }

    public static TransferType getByName(String name, Map<String, Object> properties) {
        Pattern p = Pattern.compile("ascii(\\d+)");
        Matcher m = p.matcher(name);
        if (m.matches()) {
            return new AsciiTransferType(Integer.parseInt(m.group(1)), true);
        }
        return null;
    }
}

