/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.virbo.qstream.SerializeDelegate;

public class EnumerationUnitsSerializeDelegate
implements SerializeDelegate {
    public String format(Object o) {
        EnumerationUnits eu = (EnumerationUnits)o;
        Map values = eu.getValues();
        StringBuffer buf = new StringBuffer();
        buf.append("" + eu.getId() + "[");
        for (Integer i : values.keySet()) {
            String s = ((Datum)values.get(i)).toString();
            s = s.replaceAll("::", ":");
            buf.append("" + i + ":" + s);
            if (i >= values.size()) continue;
            buf.append("::");
        }
        buf.append("]");
        return buf.toString();
    }

    public Object parse(String typeId, String s) {
        String[] ss;
        EnumerationUnits u;
        Pattern p = Pattern.compile("(.+)\\[(.*)\\]");
        Matcher m = p.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad format!");
        }
        String id = m.group(1);
        try {
            u = (EnumerationUnits)Units.getByName((String)s);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(id);
        }
        String values = m.group(2);
        for (String nv : ss = values.split("::")) {
            int idx = nv.indexOf(":");
            int ival = Integer.parseInt(nv.substring(0, idx));
            String sval = nv.substring(idx + 1);
            u.createDatum(ival, (Object)sval);
        }
        return u;
    }

    public String typeId(Class clas) {
        return "enumerationUnit";
    }
}

