/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.das2.dataset.CacheTag;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.ClassMap;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.qstream.CacheTagSerializeDelegate;
import org.virbo.qstream.DatumRangeSerializeDelegate;
import org.virbo.qstream.DefaultSerializeDelegate;
import org.virbo.qstream.EnumerationUnitsSerializeDelegate;
import org.virbo.qstream.MapSerializeDelegate;
import org.virbo.qstream.Rank0DataSetSerializeDelegate;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.StringSerializeDelegate;
import org.virbo.qstream.UnitsSerializeDelegate;

public class SerializeRegistry {
    static Map<Class, SerializeDelegate> delegates = new ClassMap();
    static Map<String, SerializeDelegate> sdelegates = new HashMap<String, SerializeDelegate>();

    public static void register(Class clas, SerializeDelegate sd) {
        delegates.put(clas, sd);
        sdelegates.put(sd.typeId(clas), sd);
    }

    public static SerializeDelegate getDelegate(Class clas) {
        return delegates.get(clas);
    }

    public static SerializeDelegate getByName(String name) {
        return sdelegates.get(name);
    }

    static {
        SerializeRegistry.register(Units.class, new UnitsSerializeDelegate());
        SerializeRegistry.register(EnumerationUnits.class, new EnumerationUnitsSerializeDelegate());
        SerializeRegistry.register(String.class, new StringSerializeDelegate());
        SerializeRegistry.register(CacheTag.class, new CacheTagSerializeDelegate());
        SerializeRegistry.register(AbstractMap.class, new MapSerializeDelegate());
        SerializeRegistry.register(RankZeroDataSet.class, new Rank0DataSetSerializeDelegate());
        SerializeRegistry.register(DatumRange.class, new DatumRangeSerializeDelegate());
        DefaultSerializeDelegate.registerDelegates();
    }
}

