/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.virbo.qstream.Descriptor;
import org.virbo.qstream.StreamException;
import org.virbo.qstream.StreamTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamDescriptor
implements Descriptor {
    Map<Integer, Descriptor> descriptors;
    Map<Descriptor, Integer> invPackets;
    Map<Descriptor, Document> documents;
    DocumentBuilderFactory factory;
    private Element element;
    int sizeBytes;
    protected ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    protected boolean asciiTypes = false;

    StreamDescriptor(DocumentBuilderFactory factory) {
        this();
        this.factory = factory;
    }

    StreamDescriptor(Element element) {
        this();
    }

    private StreamDescriptor() {
        this.descriptors = new HashMap<Integer, Descriptor>();
        this.invPackets = new HashMap<Descriptor, Integer>();
        this.documents = new HashMap<Descriptor, Document>();
    }

    public synchronized void addDescriptor(Descriptor pd) {
        int found = -1;
        for (int i = 0; i < 100; ++i) {
            if (this.descriptors.get(i) != null) continue;
            found = i;
            break;
        }
        if (found == -1) {
            throw new IllegalArgumentException("ran out of numbers, use retire to free");
        }
        this.descriptors.put(found, pd);
        this.invPackets.put(pd, found);
    }

    public synchronized int descriptorId(Descriptor pd) {
        if (pd == this) {
            return 0;
        }
        return this.invPackets.get(pd);
    }

    public synchronized void retireDescriptor(Descriptor pd) {
        int i = this.invPackets.get(pd);
        this.invPackets.remove(pd);
        this.descriptors.remove(i);
    }

    public void send(Descriptor pd, WritableByteChannel out) throws StreamException, IOException {
        Document document = this.documents.get(pd);
        document.appendChild(pd.getDomElement());
        ByteArrayOutputStream pdout = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter(pdout);
        StreamTool.formatHeader(document, writer);
        String packetTag = String.format("[%02d]", this.descriptorId(pd));
        out.write(ByteBuffer.wrap(packetTag.getBytes()));
        out.write(ByteBuffer.wrap(String.format("%06d", pdout.size()).getBytes()));
        out.write(ByteBuffer.wrap(pdout.toByteArray()));
    }

    public Document newDocument(Descriptor descriptor) throws ParserConfigurationException {
        Document document = this.factory.newDocumentBuilder().newDocument();
        this.documents.put(descriptor, document);
        return document;
    }

    String getCompression() {
        return "none";
    }

    public void setDomElement(Element element) {
        this.element = element;
    }

    public Element getDomElement() {
        return this.element;
    }

    int sizeBytes() {
        return this.sizeBytes;
    }

    void setSizeBytes(int size) {
        this.sizeBytes = size;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean isAsciiTypes() {
        return this.asciiTypes;
    }

    public void setAsciiTypes(boolean asciiTypes) {
        this.asciiTypes = asciiTypes;
    }
}

