/*
 * Decompiled with CFR 0.152.
 */
package ftpfs.ftp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;

public class SocketOpener {
    SocketFactory socketFactory;
    Socket socket;
    IOException ioexception;

    public SocketOpener(final String host, final int port) {
        this.socketFactory = new SocketFactory(){

            public Socket makeSocket() throws IOException {
                return new Socket(host, port);
            }
        };
    }

    public SocketOpener(final InetAddress address, final int port) {
        this.socketFactory = new SocketFactory(){

            public Socket makeSocket() throws IOException {
                return new Socket(address, port);
            }
        };
    }

    public SocketOpener(final String host, final int port, final InetAddress localAddr, final int localPort) {
        this.socketFactory = new SocketFactory(){

            public Socket makeSocket() throws IOException {
                return new Socket(host, port, localAddr, localPort);
            }
        };
    }

    public SocketOpener(final InetAddress address, final int port, final InetAddress localAddr, final int localPort) {
        this.socketFactory = new SocketFactory(){

            public Socket makeSocket() throws IOException {
                return new Socket(address, port, localAddr, localPort);
            }
        };
    }

    public synchronized Socket makeSocket(long timeout) throws IOException {
        this.socket = null;
        this.ioexception = null;
        Thread socketThread = new Thread(){

            public void run() {
                try {
                    SocketOpener.this.socket = SocketOpener.this.socketFactory.makeSocket();
                }
                catch (IOException e) {
                    SocketOpener.this.ioexception = e;
                }
            }
        };
        socketThread.setName("MakeSocketThread");
        socketThread.setDaemon(true);
        socketThread.start();
        try {
            socketThread.join(timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        socketThread.stop();
        if (this.ioexception != null) {
            throw this.ioexception;
        }
        if (this.socket == null) {
            throw new InterruptedIOException("Operation timed out");
        }
        return this.socket;
    }

    static interface SocketFactory {
        public Socket makeSocket() throws IOException;
    }
}

