/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataModel {
    public static MetadataModel createNullModel() {
        return new MetadataModel(){

            @Override
            public Map<String, Object> properties(Map<String, Object> meta) {
                return new HashMap<String, Object>();
            }
        };
    }

    public static TreeModel copyTree(TreeModel src) {
        DefaultMutableTreeNode destPos = new DefaultMutableTreeNode(src.getRoot());
        return MetadataModel.copyTree("", src, src.getRoot(), new DefaultTreeModel(destPos), destPos);
    }

    private static TreeModel copyTree(String prefix, TreeModel src, Object srcPos, DefaultTreeModel dest, MutableTreeNode destPos) {
        String myPath = prefix + "/" + String.valueOf(srcPos);
        int cc = src.getChildCount(srcPos);
        for (int i = 0; i < cc; ++i) {
            Object child = src.getChild(srcPos, i);
            DefaultMutableTreeNode cchild = new DefaultMutableTreeNode(child);
            if (src.isLeaf(child)) {
                dest.insertNodeInto(cchild, destPos, i);
                continue;
            }
            dest.insertNodeInto(cchild, destPos, i);
            MetadataModel.copyTree(myPath, src, child, dest, cchild);
        }
        return dest;
    }

    private static int indexOfChild(TreeNode node, String value) {
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            String schild = child.toString();
            if (!schild.equals(value)) continue;
            return j;
        }
        return -1;
    }

    public static String getNodeValue(Map<String, Object> tree, String[] path) {
        Object o = tree.get(path[1]);
        for (int i = 2; i < path.length; ++i) {
            Map subTree = (Map)o;
            o = subTree.get(path[i]);
        }
        return String.valueOf(o);
    }

    public static Object getNode(Map<String, Object> tree, String[] path) {
        Object o = tree.get(path[1]);
        for (int i = 2; i < path.length; ++i) {
            Map subTree = (Map)o;
            o = subTree.get(path[i]);
        }
        return o;
    }

    public static String getNodeValue(TreeModel tree, String[] path) {
        if (!path[0].equals(tree.getRoot().toString())) {
            throw new IllegalArgumentException("root node didn't match");
        }
        int index = MetadataModel.indexOfChild((TreeNode)tree.getRoot(), path[1]);
        if (index == -1) {
            throw new IllegalArgumentException("node didn't match: " + path[0]);
        }
        Object pos = tree.getChild(tree.getRoot(), index);
        for (int i = 2; i < path.length - 1; ++i) {
            index = MetadataModel.indexOfChild((TreeNode)pos, path[i]);
            if (index == -1) {
                throw new IllegalArgumentException("node didn't match: " + path[i]);
            }
            pos = tree.getChild(pos, index);
        }
        String result = null;
        String leafName = path[path.length - 1];
        for (int j = 0; j < tree.getChildCount(pos); ++j) {
            Object child = tree.getChild(pos, j);
            String schild = child.toString();
            if (!schild.startsWith(leafName) || schild.charAt(leafName.length()) != '=') continue;
            result = schild.substring(leafName.length() + 1);
        }
        return result;
    }

    public abstract Map<String, Object> properties(Map<String, Object> var1);

    public String getLabel() {
        return "";
    }
}

