/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.virbo.datasource.DataSetURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URISplit {
    public static final String PARAM_TIME_RANGE = "timerange";
    public static final String PARAM_TIME_RESOLUTION = "resolution";
    public static final String PARAM_RANK2 = "rank2";
    public static final String PARAM_REC_COUNT = "recCount";
    public static final String PARAM_ARG_0 = "arg_0";
    public static final String PARAM_ID = "id";
    public String vapScheme;
    public String scheme;
    public String surl;
    public URI resourceUri;
    public String authority;
    public String path;
    public String file;
    public String ext;
    public String params;
    public String sprocess;
    public int resourceUriCarotPos;
    public int formatCarotPos;
    public boolean implicitVap = false;
    static List<String> otherSchemes = Collections.emptyList();

    public static void setOtherSchemes(List<String> otherSchemes) {
        URISplit.otherSchemes = otherSchemes;
    }

    public static URISplit maybeAddFile(String surl, int caretPos) {
        int i0;
        String scheme;
        URISplit result = new URISplit();
        if (surl.length() == 0) {
            surl = "file:///";
            caretPos = surl.length();
            result.surl = surl;
            result.vapScheme = null;
            result.resourceUriCarotPos = caretPos;
            result.formatCarotPos = caretPos;
        }
        if ((scheme = (i0 = surl.indexOf(":")) == -1 ? "" : (i0 == 1 ? "" : surl.substring(0, i0))).startsWith("vap") || otherSchemes.contains(scheme)) {
            String resourcePart = surl.substring(i0 + 1);
            if (!scheme.equals("vap")) {
                result.vapScheme = scheme;
            }
            if (scheme.equals("vap+internal")) {
                result.surl = resourcePart;
            } else {
                URISplit resourceSplit = URISplit.maybeAddFile(resourcePart, caretPos - (i0 + 1));
                if (resourceSplit == null) {
                    result.surl = resourcePart;
                    result.file = "";
                    result.formatCarotPos = caretPos;
                } else {
                    result.surl = resourceSplit.surl;
                    result.formatCarotPos = caretPos > i0 ? resourceSplit.resourceUriCarotPos + (i0 + 1) : caretPos;
                    result.resourceUriCarotPos = result.formatCarotPos - (scheme.length() + 1);
                }
            }
        } else {
            result.surl = surl;
            result.resourceUriCarotPos = caretPos;
        }
        if (scheme.equals("")) {
            boolean isFile = true;
            int iquery = surl.indexOf("?");
            if (iquery == -1) {
                boolean notSlashStart;
                int ieq = surl.indexOf("=");
                char ch0 = surl.length() > 0 ? surl.charAt(0) : (char)'\u0000';
                char ch1 = surl.length() > 1 ? surl.charAt(1) : (char)'\u0000';
                boolean bl = notSlashStart = ch0 != '/' && ch0 != '\\' && ch1 != '/' && ch1 != '\\' && ch1 != ':';
                if (notSlashStart || ieq > -1 && surl.charAt(0) != '/') {
                    isFile = false;
                }
            }
            if (!isFile) {
                return null;
            }
            result.surl = "file://";
            result.scheme = "file";
            result.resourceUriCarotPos += 7;
            if (surl.charAt(0) == '/') {
                result.surl = result.surl + surl;
            } else {
                result.surl = result.surl + '/' + surl;
                ++result.resourceUriCarotPos;
            }
            int iq = result.surl.indexOf("?");
            if (iq == -1) {
                iq = result.surl.length();
            }
            result.surl = result.surl.replaceAll("\\\\", "/");
            int spaceCount = URISplit.charCount(result.surl, ' ', 0, result.surl.length());
            result.surl = URISplit.replaceAll(result.surl, " ", "%20", 0, iq);
            result.formatCarotPos += spaceCount * 2;
            result.resourceUriCarotPos += spaceCount * 2;
        }
        return result;
    }

    private static int charCount(String src, char find, int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            if (src.charAt(i) != find) continue;
            ++count;
        }
        return count;
    }

    private static String replaceAll(String src, String regex, String replacement, int start, int end) {
        String prefix = src.substring(0, start);
        String middle = src.substring(start, end);
        String suffix = src.substring(end);
        return prefix + middle.replaceAll(regex, replacement) + suffix;
    }

    public static URISplit parse(URI uri) {
        return URISplit.parse(DataSetURI.fromUri(uri), 0, true);
    }

    public static URISplit parse(String surl) {
        return URISplit.parse(surl, 0, true);
    }

    public static String implicitVapScheme(URISplit split) {
        if (split.vapScheme != null) {
            return split.vapScheme;
        }
        if (split.ext != null && split.ext.length() > 1) {
            return "vap+" + split.ext.substring(1);
        }
        return "";
    }

    public static String removeParam(String surl, String ... parm) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        for (String p : parm) {
            params.remove(p);
        }
        split.params = URISplit.formatParams(params);
        if (params.size() == 0) {
            split.params = null;
        }
        if (split.vapScheme != null && !surl.startsWith(split.vapScheme)) {
            split.vapScheme = null;
        }
        return URISplit.format(split);
    }

    public static String putParam(String surl, String name, String value) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        params.put(name, value);
        split.params = URISplit.formatParams(params);
        if (split.vapScheme != null && !surl.startsWith(split.vapScheme)) {
            split.vapScheme = null;
        }
        return URISplit.format(split);
    }

    public static String getParam(String surl, String name, String deft) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String val = (String)params.get(name);
        if (val == null) {
            val = deft;
        }
        return val;
    }

    private static String magikPop(String s, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private static void parseScheme(URISplit result, boolean normalize) throws URISyntaxException {
        String surl = result.surl;
        int h = surl.indexOf(":");
        String scheme = surl.substring(0, h);
        if (scheme.startsWith("vap")) {
            result.vapScheme = scheme;
            result.formatCarotPos = result.resourceUriCarotPos + scheme.length() + 1;
            result.surl = surl.substring(h + 1);
            result.scheme = URISplit.magikPop(result.surl, "([a-zA-Z\\+]+)\\:.*");
            int iq = result.surl.indexOf("?");
            if (iq == -1) {
                iq = result.surl.length();
            }
            try {
                result.resourceUri = new URI(URISplit.uriEncode(result.surl.substring(0, iq)));
                result.scheme = result.resourceUri.getScheme();
            }
            catch (URISyntaxException ex) {}
        } else if (scheme.contains(".")) {
            int j = scheme.indexOf(".");
            result.vapScheme = "vap+" + scheme.substring(0, j);
            result.surl = result.surl.substring(j + 1);
            if (result.resourceUriCarotPos > j) {
                result.resourceUriCarotPos -= j + 1;
            }
            result.formatCarotPos = result.resourceUriCarotPos + result.vapScheme.length() + 1;
            result.scheme = URISplit.magikPop(result.surl, "([a-zA-Z\\+]+)\\:.*");
            int iq = result.surl.indexOf("?");
            if (iq == -1) {
                iq = surl.length();
            }
            try {
                result.resourceUri = new URI(URISplit.uriEncode(result.surl.substring(0, iq)));
                result.scheme = result.resourceUri.getScheme();
            }
            catch (URISyntaxException ex) {}
        } else {
            if (result.vapScheme == null && normalize) {
                result.formatCarotPos = result.resourceUriCarotPos;
            }
            result.surl = surl;
            result.scheme = URISplit.magikPop(result.surl, "([a-zA-Z\\+]+)\\:.*");
            int iq = result.surl.indexOf("?");
            if (iq == -1) {
                iq = surl.length();
            }
            try {
                result.resourceUri = new URI(URISplit.uriEncode(result.surl.substring(0, iq)));
                result.scheme = result.resourceUri.getScheme();
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public static URISplit parse(String surl, int caretPos, boolean normalize) {
        String file;
        String[] popFront;
        Logger.getLogger("virbo.dataset").log(Level.FINE, "URISplit.parse(\"{0}\",{1},{2})", new Object[]{surl, caretPos, normalize});
        if (surl.startsWith("file:/") && surl.endsWith(":") && surl.length() < 11 && surl.charAt(surl.length() - 3) == '/') {
            if (caretPos == surl.length()) {
                ++caretPos;
            }
            surl = surl + "/";
        }
        for (String s : popFront = new String[]{"http://autoplot.org/jnlp.cgi?", "http://autoplot.org/autoplot.jnlp?"}) {
            if (!surl.startsWith(s)) continue;
            surl = surl.substring(s.length());
            caretPos = caretPos < s.length() ? 0 : caretPos - s.length();
        }
        URISplit result = URISplit.maybeAddFile(surl, caretPos);
        if (result == null) {
            result = new URISplit();
            result.surl = surl;
            result.vapScheme = null;
            result.formatCarotPos = caretPos;
            return result;
        }
        if (result.vapScheme != null && "vap+internal".equals(result.vapScheme)) {
            result.file = "";
        }
        try {
            if (result.vapScheme == null || result.file == null) {
                URISplit.parseScheme(result, normalize);
            }
        }
        catch (URISyntaxException ex) {
            result.surl = URISplit.uriEncode(result.surl);
            try {
                URISplit.parseScheme(result, normalize);
            }
            catch (URISyntaxException ex1) {
                throw new RuntimeException(ex1);
            }
        }
        String rsurl = result.surl;
        int iquery = rsurl.indexOf("?");
        int ieq = rsurl.indexOf("=");
        String string = file = result.resourceUri == null ? null : result.resourceUri.getPath();
        if (file == null) {
            file = iquery == -1 ? (ieq == -1 ? rsurl : null) : rsurl.substring(0, iquery);
        }
        String ext = null;
        if (file != null) {
            int i2;
            int i = file.lastIndexOf(".");
            ext = i > -1 ? ((i2 = file.indexOf("/", i)) == -1 ? file.substring(i) : "") : "";
            if (ext.length() > 0 && ext.contains("&")) {
                throw new IllegalArgumentException("The extension of a filename cannot contain ampersand (&): " + surl);
            }
        }
        String params = null;
        int fileEnd = -1;
        if (file != null && iquery != -1) {
            fileEnd = iquery;
            params = rsurl.substring(iquery + 1);
        } else if (ieq > -1) {
            iquery = 0;
            params = rsurl.startsWith("file:///") ? rsurl.substring(8) : rsurl;
        } else {
            iquery = rsurl.length();
            fileEnd = rsurl.length();
        }
        if (result.scheme != null) {
            int iauth;
            for (iauth = result.scheme.length() + 1; iauth < rsurl.length() && rsurl.charAt(iauth) == '/'; ++iauth) {
            }
            if ((iauth = rsurl.indexOf(47, iauth)) == -1) {
                iauth = rsurl.length();
            }
            result.authority = rsurl.substring(0, iauth);
        }
        if (file != null) {
            int i = rsurl.lastIndexOf("/", iquery);
            if (i == -1) {
                result.path = rsurl.substring(0, iquery);
                result.file = rsurl.substring(0, iquery);
                result.ext = ext;
            } else {
                String surlDir = rsurl.substring(0, i);
                result.path = surlDir + "/";
                result.file = rsurl.substring(0, fileEnd);
                result.ext = ext;
            }
        }
        result.params = params;
        if ("".equals(result.file)) {
            result.file = null;
        }
        return result;
    }

    private static int indexOf(String s, char ch, char ignoreBegin, char ignoreEnd) {
        int i = s.indexOf(ch);
        int i0 = s.indexOf(ignoreBegin);
        int i1 = s.indexOf(ignoreEnd);
        if (i != -1 && i0 < i && i < i1) {
            i = -1;
        }
        return i;
    }

    public static LinkedHashMap<String, String> parseParams(String params) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (params == null) {
            return result;
        }
        if (params.trim().equals("")) {
            return result;
        }
        params = URISplit.uriDecode(params);
        String[] ss = params.split("&");
        int argc = 0;
        for (int i = 0; i < ss.length; ++i) {
            String value;
            String name;
            int j = URISplit.indexOf(ss[i], '=', '(', ')');
            if (j == -1) {
                name = ss[i];
                value = "";
                name = name.replaceAll("%3D", "=");
                result.put("arg_" + argc++, name);
                continue;
            }
            name = ss[i].substring(0, j);
            value = ss[i].substring(j + 1);
            value = value.replaceAll("%3D", "=");
            value = value.replaceAll("%26", "&");
            result.put(name, value);
        }
        return result;
    }

    public static String formatParams(Map<String, String> parms) {
        StringBuilder result = new StringBuilder("");
        for (Map.Entry<String, String> e : parms.entrySet()) {
            String key = e.getKey();
            if (key.startsWith("arg_")) {
                if (e.getValue().equals("")) continue;
                result.append("&").append(e.getValue());
                continue;
            }
            String value = e.getValue();
            if (value != null) {
                value = URISplit.uriEncode(value);
                value = value.replaceAll("&", "%26");
                result.append("&").append(key).append("=").append(value);
                continue;
            }
            result.append("&").append(key);
        }
        return result.length() == 0 ? "" : result.substring(1);
    }

    public static String format(URISplit split) {
        String result = "";
        if (split.vapScheme != null && split.vapScheme.length() > 0 && !split.vapScheme.equals("vap")) {
            result = result + split.vapScheme + ":";
        }
        if (split.file == null && split.params != null) {
            result = result + split.params;
        } else if (split.file != null) {
            result = result + split.file;
            if (split.params != null) {
                result = result + "?" + split.params;
            }
        } else if (split.surl != null) {
            result = result + split.surl;
        }
        return result;
    }

    public static boolean isUriEncoded(String surl) {
        boolean result = false;
        if (surl.contains(" ")) {
            result = false;
        }
        if (Pattern.compile("%[0-9][0-9]").matcher(surl).find()) {
            result = true;
        }
        return result;
    }

    public static String uriEncode(String surl) {
        if (URISplit.isUriEncoded(surl)) {
            return surl;
        }
        surl = surl.replaceAll("%([^0-9])", "%25$1");
        surl = surl.replaceAll("\\%24", "\\$");
        surl = surl.replaceAll(" ", "%20");
        surl = surl.replaceAll("<", "%3C");
        surl = surl.replaceAll(">", "%3E");
        return surl;
    }

    public static String uriDecode(String s) {
        if (!URISplit.isUriEncoded(s)) {
            return s;
        }
        String surl = s;
        surl = surl.replaceAll("%20", " ");
        surl = surl.replaceAll("%25", "%");
        surl = surl.replaceAll("%2B", "+");
        surl = surl.replaceAll("%3C", "<");
        surl = surl.replaceAll("%3E", ">");
        return surl;
    }

    public static DatumRange parseTimeRange(String uri) throws ParseException {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String str = (String)params.get(PARAM_TIME_RANGE);
        if (str != null) {
            DatumRange timerange = DatumRangeUtil.parseTimeRange((String)str);
            return timerange;
        }
        return null;
    }

    public String toString() {
        return "\nvapScheme: " + this.vapScheme + "\nscheme: " + this.scheme + "\nresourceUri: " + this.resourceUri + "\npath: " + this.path + "\nfile: " + this.file + "\next: " + this.ext + "\nparams: " + this.params + "\nsurl: " + this.surl + "\ncaretPos: " + this.resourceUriCarotPos + "\nformatCarotPos: " + this.formatCarotPos;
    }
}

