/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PromptTextField
extends JTextField {
    JLabel promptLabel = new JLabel("enter text here");

    public PromptTextField(String label) {
        super(40);
        this.promptLabel.setText(label);
        this.promptLabel.setForeground(Color.GRAY);
        this.addFocusListener(this.createFocusListener());
        this.promptLabel.addNotify();
    }

    public void setPromptText(String text) {
        this.promptLabel.setText(text);
        this.repaint();
    }

    public String getPromptText() {
        return this.promptLabel.getText();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getText().length() == 0 && !this.hasFocus()) {
            Graphics scratch = g.create();
            this.promptLabel.setBounds(0, 0, this.getWidth(), this.getHeight());
            scratch.translate(this.getInsets().left, 0);
            this.promptLabel.paint(scratch);
            scratch.dispose();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.add(new PromptTextField("Enter text"));
        f.pack();
        f.setVisible(true);
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
                PromptTextField.this.repaint(PromptTextField.this.getBounds());
            }

            public void focusLost(FocusEvent e) {
                PromptTextField.this.repaint(PromptTextField.this.getBounds());
            }
        };
    }
}

