/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.metatree;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.MetadataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IstpMetadataModel
extends MetadataModel {
    public static final String USER_PROP_VIRTUAL_FUNCTION = "FUNCTION";
    public static final String USER_PROP_VIRTUAL_COMPONENT_ = "COMPONENT_";
    public static final Object VALUE_MIN = "MIN";
    public static final Object VALUE_MAX = "MAX";

    private static double doubleValue(Object o, Units units, Object minmax) {
        return IstpMetadataModel.doubleValue(o, units, Double.NaN, minmax);
    }

    public static double doubleValue(Object o, Units units, double deflt, Object minmax) {
        if (o == null) {
            return deflt;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            return ((Long)o).doubleValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).doubleValue();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("CDF_PARSE_EPOCH(")) {
                try {
                    return units.parse(s.substring(16, s.length() - 1)).doubleValue(units);
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException("unable to parse " + o);
                }
            }
            try {
                return units.parse(DataSourceUtil.unquote((String)o)).doubleValue(units);
            }
            catch (ParseException ex) {
                try {
                    return Double.parseDouble((String)o);
                }
                catch (NumberFormatException ex2) {
                    throw new IllegalArgumentException("unable to parse " + o);
                }
            }
        }
        Class<?> c = o.getClass();
        if (c.isArray()) {
            if (units == Units.cdfEpoch && Array.getLength(o) == 2) {
                double cdfEpoch = Array.getDouble(o, 0) * 1000.0 + Array.getDouble(o, 1) / 1.0E9;
                Units.cdfEpoch.createDatum(cdfEpoch);
                return cdfEpoch;
            }
            double v = Array.getDouble(o, 0);
            int n = Array.getLength(o);
            for (int i = 1; i < n; ++i) {
                if (minmax == VALUE_MAX) {
                    v = Math.max(v, Array.getDouble(o, i));
                    continue;
                }
                if (minmax == VALUE_MIN) {
                    v = Math.min(v, Array.getDouble(o, i));
                    continue;
                }
                throw new IllegalArgumentException("object is array: " + o + ", and minmax is not set");
            }
            return v;
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    public static DatumRange getValidRange(Map attrs, Units units) {
        double max = IstpMetadataModel.doubleValue(attrs.get("VALIDMAX"), units, Double.MAX_VALUE, VALUE_MAX);
        double min = IstpMetadataModel.doubleValue(attrs.get("VALIDMIN"), units, -1.0E29, VALUE_MIN);
        if (units.isFill(min)) {
            min /= 100.0;
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            DatumRange vrange = new DatumRange(3.15569952E13, 2.840126112E14, (Units)Units.cdfEpoch);
            if (vrange.min().doubleValue(units) > min) {
                min = vrange.min().doubleValue(units);
            }
            if (vrange.max().doubleValue(units) < max) {
                max = vrange.max().doubleValue(units);
            }
            if (vrange.min().doubleValue(units) > max) {
                max = vrange.max().doubleValue(units);
            }
        }
        return DatumRange.newDatumRange((double)min, (double)max, (Units)units);
    }

    private static DatumRange getRange(Map attrs, Units units) {
        double min;
        double max;
        if (attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX")) {
            max = IstpMetadataModel.doubleValue(attrs.get("SCALEMAX"), units, VALUE_MAX);
            min = IstpMetadataModel.doubleValue(attrs.get("SCALEMIN"), units, VALUE_MIN);
        } else if (attrs.containsKey("SCALEMAX")) {
            max = IstpMetadataModel.doubleValue(attrs.get("SCALEMAX"), units, VALUE_MAX);
            min = 0.0;
        } else {
            max = IstpMetadataModel.doubleValue(attrs.get("VALIDMAX"), units, Double.MAX_VALUE, VALUE_MAX);
            min = IstpMetadataModel.doubleValue(attrs.get("VALIDMIN"), units, -1.0E29, VALUE_MIN);
            if (min > 0.0 && max / min > 1.0E20) {
                return null;
            }
        }
        if ("log".equals(IstpMetadataModel.getScaleType(attrs)) && min <= 0.0) {
            min = max / 10000.0;
        }
        if (units.isFill(min)) {
            min /= 100.0;
        }
        if (max < min) {
            max = Double.MAX_VALUE;
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            DatumRange vrange = new DatumRange(3.15569952E13, 2.840126112E14, (Units)Units.cdfEpoch);
            if (vrange.min().doubleValue(units) > min) {
                min = vrange.min().doubleValue(units);
            }
            if (vrange.max().doubleValue(units) < max) {
                max = vrange.max().doubleValue(units);
            }
            if (vrange.min().doubleValue(units) > max) {
                max = vrange.max().doubleValue(units);
            }
        }
        DatumRange range = new DatumRange(min, max, units);
        return range;
    }

    private static String getScaleType(Map attrs) {
        String type = null;
        if (attrs.containsKey("SCALETYP") && attrs.get("SCALETYP") instanceof String) {
            type = (String)attrs.get("SCALETYP");
        }
        return type;
    }

    @Override
    public Map<String, Object> properties(Map<String, Object> meta) {
        return this.properties(meta, true);
    }

    public Map<String, Object> properties(Map<String, Object> meta, boolean recurse) {
        Map<String, Object> attrs;
        if (meta == null) {
            new Exception("null attributes").printStackTrace();
            attrs = Collections.emptyMap();
        } else {
            attrs = new HashMap<String, Object>(meta);
        }
        LinkedHashMap<String, Object> user = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (attrs.containsKey("LABLAXIS")) {
            properties.put("LABEL", attrs.get("LABLAXIS"));
        }
        if (attrs.containsKey("CATDESC")) {
            properties.put("TITLE", attrs.get("CATDESC"));
        }
        if (attrs.containsKey("DISPLAY_TYPE")) {
            String type = (String)attrs.get("DISPLAY_TYPE");
            properties.put("RENDER_TYPE", type);
        }
        if (attrs.containsKey("VIRTUAL")) {
            String v = (String)attrs.get("VIRTUAL");
            String function = (String)attrs.get(USER_PROP_VIRTUAL_FUNCTION);
            user.put(USER_PROP_VIRTUAL_FUNCTION, function);
            for (int i = 0; i < 4 && attrs.get(USER_PROP_VIRTUAL_COMPONENT_ + i) != null; ++i) {
                user.put(USER_PROP_VIRTUAL_COMPONENT_ + i, attrs.get(USER_PROP_VIRTUAL_COMPONENT_ + i));
            }
        }
        Units units = Units.dimensionless;
        if (attrs.containsKey("UNITS")) {
            boolean isEpoch;
            Object ofv;
            double dv;
            String sunits = (String)attrs.get("UNITS");
            try {
                units = SemanticOps.lookupUnits((String)DataSourceUtil.unquote(sunits));
            }
            catch (IllegalArgumentException e) {
                units = Units.dimensionless;
            }
            boolean isMillis = false;
            Object ovalidMax = attrs.get("VALIDMAX");
            Object ovalidMin = attrs.get("VALIDMIN");
            if (ovalidMax != null && ovalidMin != null && ovalidMax instanceof Number && ovalidMin instanceof Number && units == Units.milliseconds) {
                double validMax = ((Number)ovalidMax).doubleValue();
                double validMin = ((Number)ovalidMin).doubleValue();
                boolean bl = isMillis = validMin < validMax && validMin < 1.0E8 && validMax < 1.0E12;
            }
            if (!Double.isNaN(dv = IstpMetadataModel.doubleValue(ofv = attrs.get("FILLVAL"), units, Double.NaN, VALUE_MIN))) {
                properties.put("FILL_VALUE", dv);
            }
            boolean bl = isEpoch = units == Units.milliseconds && !isMillis || "Epoch".equals(attrs.get("NAME")) || "Epoch".equalsIgnoreCase(DataSourceUtil.unquote((String)attrs.get("LABLAXIS")));
            if (isEpoch) {
                units = Units.cdfEpoch;
                properties.put("LABEL", "");
            } else {
                String label = (String)attrs.get("LABLAXIS");
                if (label == null) {
                    label = sunits;
                } else if (!sunits.equals("")) {
                    label = label + " (" + sunits + ")";
                }
                properties.put("LABEL", label);
            }
            properties.put("UNITS", units);
        }
        try {
            DatumRange range = IstpMetadataModel.getRange(attrs, units);
            if (!attrs.containsKey("COMPONENT_0")) {
                Number fillVal;
                if (range != null) {
                    properties.put("TYPICAL_MIN", range.min().doubleValue(units));
                }
                if (range != null) {
                    properties.put("TYPICAL_MAX", range.max().doubleValue(units));
                }
                range = IstpMetadataModel.getValidRange(attrs, units);
                properties.put("VALID_MIN", range.min().doubleValue(units));
                properties.put("VALID_MAX", range.max().doubleValue(units));
                Object ofv = attrs.get("FILLVAL");
                if (ofv != null && ofv instanceof Number) {
                    fillVal = (Number)ofv;
                    double fillVald = fillVal.doubleValue();
                    if (fillVald >= range.min().doubleValue(units) && fillVald <= range.max().doubleValue(units)) {
                        properties.put("FILL_VALUE", fillVal);
                    }
                } else if (ofv != null && ofv.getClass().isArray()) {
                    fillVal = (Number)Array.get(ofv, 0);
                    int n = Array.getLength(ofv);
                    for (int i = 1; i < n; ++i) {
                        if (Array.get(ofv, i).equals(fillVal)) continue;
                        fillVal = Double.NaN;
                    }
                    double fillVald = fillVal.doubleValue();
                    if (fillVald >= range.min().doubleValue(units) && fillVald <= range.max().doubleValue(units)) {
                        properties.put("FILL_VALUE", fillVal);
                    }
                }
            }
            properties.put("SCALE_TYPE", IstpMetadataModel.getScaleType(attrs));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        if (recurse) {
            for (int i = 0; i < 4; ++i) {
                String key = "DEPEND_" + i;
                Object o = attrs.get(key);
                if (o == null) continue;
                if (!(o instanceof Map)) {
                    new RuntimeException("String where Map was expected").printStackTrace();
                    continue;
                }
                Map props = (Map)o;
                for (int j = 0; j < 4; ++j) {
                    if (!props.containsKey("DEPEND_" + j)) continue;
                    props.remove("DEPEND_" + j);
                }
                properties.put(key, this.properties(props, false));
            }
        }
        if (!user.isEmpty()) {
            properties.put("USER_PROPERTIES", user);
        }
        return properties;
    }

    @Override
    public String getLabel() {
        return "ISTP-CDF";
    }
}

