/*
 * Decompiled with CFR 0.152.
 */
package ftpfs.ftp;

import ftpfs.ftp.FtpException;
import ftpfs.ftp.FtpListResult;
import ftpfs.ftp.FtpObserver;
import ftpfs.ftp.FtpReplyResourceBundle;
import ftpfs.ftp.SocketOpener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FtpBean {
    protected static final String FTP_INIT = "FTP_INIT";
    protected static final String CMD_ACCT = "ACCT ";
    protected static final String CMD_APPE = "APPE ";
    protected static final String CMD_CWD = "CWD ";
    protected static final String CMD_CDUP = "CDUP";
    protected static final String CMD_DELE = "DELE ";
    protected static final String CMD_MKD = "MKD ";
    protected static final String CMD_PASV = "PASV";
    protected static final String CMD_PASS = "PASS ";
    protected static final String CMD_PORT = "PORT ";
    protected static final String CMD_PWD = "PWD";
    protected static final String CMD_QUIT = "QUIT";
    protected static final String CMD_RMD = "RMD ";
    protected static final String CMD_REST = "REST ";
    protected static final String CMD_RETR = "RETR ";
    protected static final String CMD_RNTO = "RNTO ";
    protected static final String CMD_RNFR = "RNFR ";
    protected static final String CMD_SITE = "SITE ";
    protected static final String CMD_STOR = "STOR ";
    protected static final String CMD_SYST = "SYST";
    protected static final String CMD_USER = "USER ";
    protected static final String CMD_TYPE = "TYPE ";
    protected static final String CMD_LIST = "LIST";
    protected static final String REPLY_POS_PRE = "1";
    protected static final String REPLY_POS_CMP = "2";
    protected static final String REPLY_POS_INT = "3";
    protected static final String REPLY_TRA_NEG = "4";
    protected static final String REPLY_PER_NEG = "5";
    protected static final String REPLY_UNDEF = "0";
    private final String TF_MOD_ASCII = "A";
    private final String TF_MOD_BIN = "I";
    private final String FTP_ENCODING = "US-ASCII";
    private final FtpReplyResourceBundle ftpReplies = new FtpReplyResourceBundle();
    private String acctInfo = "";
    private String server = "";
    private String user = "";
    private String replymessage = "";
    private String reply = "";
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;
    private int port = 21;
    private boolean passive = true;
    private int timeout;
    private int[] lock = new int[0];
    private boolean acquired = false;
    private Vector thread_spool = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean DEBUG = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void ftpConnect(String server, String user) throws IOException, FtpException {
        this.ftpConnect(server, user, "", "");
    }

    public void ftpConnect(String server, String user, String password) throws IOException, FtpException {
        this.ftpConnect(server, user, password, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ftpConnect(String server, String user, String password, String acct) throws IOException, FtpException {
        this.acquire();
        this.setServerName(server);
        this.setUserName(user);
        this.setAcctInfo(acct);
        try {
            this.socket = this.timeout == 0 ? new Socket(server, this.port) : new SocketOpener(server, this.port).makeSocket(this.timeout);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "US-ASCII"));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), "US-ASCII"), true);
            this.getRespond(FTP_INIT);
            this.ftpLogin(user, password, acct);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, FtpException {
        this.acquire();
        try {
            this.ftpCommand(CMD_QUIT);
            this.closeSocket();
            this.setServerName("");
            this.setUserName("");
            this.setAcctInfo("");
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDelete(String filename) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_DELE, filename);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRename(String oldfilename, String newfilename) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_RNFR, oldfilename);
            this.ftpCommand(CMD_RNTO, newfilename);
        }
        finally {
            this.release();
        }
    }

    public String getAsciiFile(String filename, String separator) throws IOException, FtpException {
        return this.getAsciiFile(filename, separator, (FtpObserver)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsciiFile(String filename, String separator, FtpObserver observer) throws IOException, FtpException {
        String str_content;
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.setTransferType(true);
            str_content = new String(this.getFile(filename, 0L, observer), "US-ASCII");
        }
        finally {
            this.release();
        }
        str_content = this.changeLineSeparator(str_content, "\r\n", separator);
        return str_content.toString();
    }

    public void getAsciiFile(String ftpfile, String localfile, String separator) throws IOException, FtpException {
        this.getAsciiFile(ftpfile, localfile, separator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAsciiFile(String ftpfile, String localfile, String separator, FtpObserver observer) throws IOException, FtpException {
        int BUF = 1024;
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            int offset;
            Socket sock = this.getDataSocket(CMD_RETR, ftpfile, 0L);
            BufferedInputStream reader = new BufferedInputStream(sock.getInputStream());
            RandomAccessFile out = new RandomAccessFile(localfile, "rw");
            byte[] data = new byte[1025];
            while ((offset = reader.read(data, 0, 1024)) != -1) {
                if ((char)data[offset - 1] == '\r') {
                    data[offset] = (byte)reader.read();
                    if (data[offset] != -1) {
                        ++offset;
                    }
                }
                String content = new String(data, 0, offset, "US-ASCII");
                content = this.changeLineSeparator(content, "\r\n", separator);
                out.writeBytes(content);
                if (observer == null) continue;
                observer.byteRead(offset);
            }
            out.close();
            reader.close();
            sock.close();
            this.getRespond(CMD_RETR);
            if (!this.reply.substring(0, 3).equals("226")) {
                throw new FtpException(this.reply);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendAsciiFile(String filename, String content, String separator) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        content = this.changeLineSeparator(content, separator, "\r\n");
        byte[] byte_content = content.getBytes("US-ASCII");
        this.acquire();
        try {
            this.setTransferType(true);
            this.appendFile(filename, byte_content);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAsciiFile(String filename, String content, String separator) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        content = this.changeLineSeparator(content, separator, "\r\n");
        byte[] byte_content = content.getBytes("US-ASCII");
        this.acquire();
        try {
            this.setTransferType(true);
            this.putFile(filename, byte_content, 0L);
        }
        finally {
            this.release();
        }
    }

    public byte[] getBinaryFile(String filename) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        return this.getBinaryFile(filename, 0L, null);
    }

    public byte[] getBinaryFile(String filename, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        return this.getBinaryFile(filename, 0L, observer);
    }

    public byte[] getBinaryFile(String filename, long restart) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        return this.getBinaryFile(filename, restart, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryFile(String filename, long restart, FtpObserver observer) throws IOException, FtpException {
        byte[] content;
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.setTransferType(false);
            content = this.getFile(filename, restart, observer);
        }
        finally {
            this.release();
        }
        return content;
    }

    public void getBinaryFile(String ftpfile, String localfile) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.getBinaryFile(ftpfile, localfile, 0L, null);
    }

    public void getBinaryFile(String ftpfile, String localfile, long restart) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.getBinaryFile(ftpfile, localfile, restart, null);
    }

    public void getBinaryFile(String ftpfile, String localfile, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.getBinaryFile(ftpfile, localfile, 0L, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBinaryFile(String ftpfile, String localfile, long restart, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.setTransferType(false);
            Socket sock = null;
            sock = this.getDataSocket(CMD_RETR, ftpfile, restart);
            BufferedInputStream reader = new BufferedInputStream(sock.getInputStream());
            RandomAccessFile out = new RandomAccessFile(localfile, "rw");
            out.seek(restart);
            this.readData(reader, out, observer);
            reader.close();
            out.close();
            sock.close();
            this.getRespond(CMD_RETR);
        }
        finally {
            this.release();
        }
    }

    public void putBinaryFile(String filename, byte[] content) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(filename, content, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBinaryFile(String filename, byte[] content, long restart) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.setTransferType(false);
            this.putFile(filename, content, restart);
        }
        finally {
            this.release();
        }
    }

    public void putBinaryFile(String local_file, String remote_file) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(local_file, remote_file, 0L, null);
    }

    public void putBinaryFile(String local_file, String remote_file, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(local_file, remote_file, 0L, observer);
    }

    public void putBinaryFile(String local_file, String remote_file, long restart) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.putBinaryFile(local_file, remote_file, restart, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBinaryFile(String local_file, String remote_file, long restart, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            Socket sock = null;
            this.setTransferType(false);
            RandomAccessFile fin = new RandomAccessFile(local_file, "r");
            sock = this.getDataSocket(CMD_STOR, remote_file, restart);
            if (restart > 0L) {
                fin.seek(restart);
            }
            DataOutputStream dout = new DataOutputStream(sock.getOutputStream());
            this.writeData(fin, dout, observer);
            fin.close();
            dout.close();
            this.getRespond(CMD_STOR);
        }
        finally {
            this.release();
        }
    }

    public void appendBinaryFile(String filename) throws IOException, FtpException {
        this.appendBinaryFile(filename, filename, null);
    }

    public void appendBinaryFile(String local_file, String remote_file) throws IOException, FtpException {
        this.appendBinaryFile(local_file, remote_file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendBinaryFile(String local_file, String remote_file, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            Socket sock = null;
            this.setTransferType(false);
            RandomAccessFile fin = new RandomAccessFile(local_file, "r");
            sock = this.getDataSocket(CMD_APPE, remote_file, 0L);
            DataOutputStream dout = new DataOutputStream(sock.getOutputStream());
            this.writeData(fin, dout, observer);
            fin.close();
            dout.close();
            this.getRespond(CMD_APPE);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectory() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_PWD);
        }
        finally {
            this.release();
        }
        int first = this.reply.indexOf("\"");
        int last = this.reply.lastIndexOf("\"");
        return this.reply.substring(first + 1, last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectory(String directory) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_CWD, directory);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toParentDirectory() throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_CDUP);
        }
        finally {
            this.release();
        }
    }

    public FtpListResult getDirectoryContent() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        String str_list = this.getDirectoryContentAsString();
        FtpListResult ftplist = new FtpListResult();
        ftplist.parseList(str_list, this.getSystemType());
        return ftplist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectoryContentAsString() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        StringBuffer list = new StringBuffer("");
        Socket sock = null;
        this.acquire();
        try {
            String line;
            sock = this.getDataSocket(CMD_LIST, 0L);
            BufferedReader listen = new BufferedReader(new InputStreamReader(sock.getInputStream(), "US-ASCII"));
            while ((line = listen.readLine()) != null) {
                list.append(line).append("\n");
            }
            listen.close();
            sock.close();
            this.getRespond(CMD_LIST);
        }
        finally {
            this.release();
        }
        return list.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDirectory(String directory) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_MKD, directory);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectory(String directory) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_RMD, directory);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String exec) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_SITE, exec);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemType() throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        this.acquire();
        try {
            this.ftpCommand(CMD_SYST);
        }
        finally {
            this.release();
        }
        return this.reply.substring(4);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.acquire();
        this.pcs.firePropertyChange("port", (Object)this.port, (Object)port);
        this.port = port;
        this.release();
    }

    public void setSocketTimeout(int timeout) throws SocketException {
        this.acquire();
        this.pcs.firePropertyChange("socketTimeout", (Object)this.timeout, (Object)timeout);
        this.timeout = timeout;
        this.release();
    }

    public int getSocketTimeout() throws SocketException {
        return this.timeout;
    }

    public String getAcctInfo() {
        return this.acctInfo;
    }

    public String getServerName() {
        return this.server;
    }

    public String getUserName() {
        return this.user;
    }

    public String getReply() {
        return this.reply;
    }

    public String getReplyMessage() {
        return this.replymessage;
    }

    public boolean isPassiveModeTransfer() {
        return this.passive;
    }

    public void setPassiveModeTransfer(boolean passive) {
        this.acquire();
        this.pcs.firePropertyChange("passiveModeTransfer", (Object)this.passive, (Object)passive);
        this.passive = passive;
        this.release();
    }

    private void closeSocket() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    private String getReplyType(String reply_code) {
        if (reply_code == null || reply_code.length() <= 0) {
            return REPLY_UNDEF;
        }
        String reply_type = reply_code.substring(0, 1);
        if (!(reply_type.equals(REPLY_POS_PRE) || reply_type.equals(REPLY_POS_CMP) || reply_type.equals(REPLY_POS_INT) || reply_type.equals(REPLY_TRA_NEG) || reply_type.equals(REPLY_PER_NEG))) {
            return REPLY_UNDEF;
        }
        return reply_type;
    }

    private void getRespond(String cmd) throws IOException, FtpException {
        String line = "";
        String replymessage = "";
        while (this.checkReply(line = this.in.readLine()) && !line.contains("Transfer complete")) {
            replymessage = replymessage.concat(line).concat("\n");
        }
        this.setReplyMessage(replymessage);
        this.setReply(line);
        String reply_type = this.getReplyType(this.reply);
        String[] valid_replies = null;
        try {
            valid_replies = this.ftpReplies.getStringArray(cmd);
        }
        catch (MissingResourceException e) {
            throw new FtpException("Valid reply for command '" + cmd + "' not found in reply resource bundle");
        }
        boolean valid = false;
        for (int i = 0; i < valid_replies.length; ++i) {
            if (!reply_type.equals(valid_replies[i])) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new FtpException(this.reply);
        }
    }

    private void ftpLogin(String user, String password, String acct) throws IOException, FtpException {
        this.ftpCommand(CMD_USER, user);
        if (this.getReplyType(this.reply).equals(REPLY_POS_CMP)) {
            return;
        }
        this.ftpCommand(CMD_PASS, password);
        if (this.getReplyType(this.reply).equals(REPLY_POS_CMP)) {
            return;
        }
        this.ftpCommand(CMD_ACCT, acct);
    }

    private void ftpCommand(String cmd) throws IOException, FtpException {
        this.ftpCommand(cmd, "");
    }

    private void ftpCommand(String cmd, String param) throws IOException, FtpException {
        if (this.out == null) {
            return;
        }
        this.out.print(cmd + param + "\r\n");
        this.out.flush();
        this.getRespond(cmd);
    }

    private byte[] getFile(String filename, long restart, FtpObserver observer) throws IOException, FtpException {
        if (this.out == null) {
            return null;
        }
        Socket sock = null;
        sock = this.getDataSocket(CMD_RETR, filename, restart);
        BufferedInputStream reader = new BufferedInputStream(sock.getInputStream());
        byte[] data = this.getBytes(reader, observer);
        reader.close();
        sock.close();
        this.getRespond(CMD_RETR);
        if (!this.reply.substring(0, 3).equals("226")) {
            throw new FtpException(this.reply);
        }
        return data;
    }

    private byte[] getBytes(BufferedInputStream reader, FtpObserver observer) throws IOException {
        int offset;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] data = new byte[1024];
        while ((offset = reader.read(data)) != -1) {
            out.write(data, 0, offset);
            if (observer == null) continue;
            observer.byteRead(offset);
        }
        return out.toByteArray();
    }

    private void appendFile(String filename, byte[] content) throws IOException, FtpException {
        Socket sock = null;
        sock = this.getDataSocket(CMD_APPE, filename, 0L);
        DataOutputStream writer = new DataOutputStream(sock.getOutputStream());
        writer.write(content, 0, content.length);
        writer.close();
        sock.close();
        this.getRespond(CMD_APPE);
    }

    private void putFile(String filename, byte[] content, long restart) throws IOException, FtpException {
        Socket sock = null;
        sock = this.getDataSocket(CMD_STOR, filename, restart);
        DataOutputStream writer = new DataOutputStream(sock.getOutputStream());
        writer.write(content, 0, content.length);
        writer.close();
        sock.close();
        this.getRespond(CMD_STOR);
    }

    private Socket getDataSocket(String command, long restart) throws IOException, FtpException {
        return this.getDataSocket(command, "", restart);
    }

    private Socket getDataSocket(String command, String param, long restart) throws IOException, FtpException {
        Socket sock = null;
        ServerSocket ssock = null;
        if (this.passive) {
            sock = this.getPassiveDataSocket();
        } else {
            ssock = this.getActiveDataSocket();
        }
        if (restart > 0L) {
            this.ftpCommand(CMD_REST, Long.toString(restart));
        }
        this.ftpCommand(command, param);
        if (!this.passive) {
            sock = ssock.accept();
            ssock.close();
        }
        return sock;
    }

    private Socket getPassiveDataSocket() throws IOException, FtpException {
        Socket sock = null;
        this.ftpCommand(CMD_PASV);
        String[] address = new String[6];
        this.reply = this.reply.substring(this.reply.indexOf(40) + 1, this.reply.indexOf(41));
        StringTokenizer t = new StringTokenizer(this.reply, ",");
        for (int i = 0; i < 6; ++i) {
            address[i] = t.nextToken();
        }
        String SRV_IP = address[0] + '.' + address[1] + '.' + address[2] + '.' + address[3];
        int NEW_PORT = (Integer.parseInt(address[4]) << 8) + Integer.parseInt(address[5]);
        sock = this.timeout == 0 ? new Socket(SRV_IP, NEW_PORT) : new SocketOpener(SRV_IP, NEW_PORT).makeSocket(this.timeout);
        return sock;
    }

    private ServerSocket getActiveDataSocket() throws IOException, FtpException {
        int[] port_numbers = new int[6];
        String local_address = this.socket.getLocalAddress().getHostAddress();
        StringTokenizer st = new StringTokenizer(local_address, ".");
        for (int i = 0; i < 4; ++i) {
            port_numbers[i] = Integer.parseInt(st.nextToken());
        }
        ServerSocket ssocket = new ServerSocket(0);
        int local_port = ssocket.getLocalPort();
        port_numbers[4] = (local_port & 0xFF00) >> 8;
        port_numbers[5] = local_port & 0xFF;
        String port_param = "";
        for (int i = 0; i < port_numbers.length; ++i) {
            port_param = port_param.concat(String.valueOf(port_numbers[i]));
            if (i >= port_numbers.length - 1) continue;
            port_param = port_param.concat(",");
        }
        this.ftpCommand(CMD_PORT, port_param);
        return ssocket;
    }

    private void setReply(String reply) {
        this.pcs.firePropertyChange("reply", this.reply, reply);
        this.reply = reply;
    }

    private void setReplyMessage(String replymessage) {
        this.pcs.firePropertyChange("replyMessage", this.replymessage, replymessage);
        this.replymessage = replymessage;
    }

    private void setAcctInfo(String acctInfo) {
        this.pcs.firePropertyChange("acctInfo", this.acctInfo, acctInfo);
        this.acctInfo = acctInfo;
    }

    private void setServerName(String server) {
        this.pcs.firePropertyChange("serverName", this.server, server);
        this.server = server;
    }

    private void setUserName(String user) {
        this.pcs.firePropertyChange("userName", this.user, user);
        this.user = user;
    }

    private void setTransferType(boolean ascii) throws IOException, FtpException {
        if (ascii) {
            this.ftpCommand(CMD_TYPE, "A");
        } else {
            this.ftpCommand(CMD_TYPE, "I");
        }
    }

    private String changeLineSeparator(String text, String old_separator, String new_separator) {
        int index;
        if (old_separator.equals(new_separator)) {
            return text;
        }
        StringBuffer content = new StringBuffer("");
        while ((index = text.indexOf(old_separator)) != -1) {
            content.append(text.substring(0, index)).append(new_separator);
            text = text.substring(index + old_separator.length());
        }
        if (text.length() > 0) {
            content.append(text);
        }
        return content.toString();
    }

    private boolean checkReply(String str) {
        if (str == null) {
            return true;
        }
        return str.length() <= 3 || str.charAt(3) != ' ' || !Character.isDigit(str.charAt(0)) || !Character.isDigit(str.charAt(1)) || !Character.isDigit(str.charAt(2));
    }

    private void readData(BufferedInputStream reader, RandomAccessFile out, FtpObserver observer) throws IOException {
        int offset;
        byte[] data = new byte[1024];
        while ((offset = reader.read(data)) != -1) {
            out.write(data, 0, offset);
            if (observer == null) continue;
            observer.byteRead(offset);
        }
    }

    private void writeData(RandomAccessFile din, DataOutputStream dout, FtpObserver observer) throws IOException {
        int offset;
        byte[] data = new byte[1024];
        while ((offset = din.read(data)) != -1) {
            dout.write(data, 0, offset);
            if (observer == null) continue;
            observer.byteWrite(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire() {
        Thread thread = Thread.currentThread();
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.thread_spool.addElement(thread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                while (this.acquired && !this.thread_spool.elementAt(0).equals(thread)) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            this.acquired = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.thread_spool.removeElementAt(0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.acquired = true;
            return;
        }
    }
}

