/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.aggregator;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.aggregator.AggregatingDataSource;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DefaultTimeSeriesBrowse;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingDataSourceFactory
implements DataSourceFactory {
    private DataSourceFactory delegateFactory = null;

    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        String suri = DataSetURI.fromUri(uri);
        if (suri.contains("&timerange") && !suri.contains("?")) {
            throw new IllegalArgumentException("data URI contains &timerange but no question mark.");
        }
        if (this.delegateFactory == null) {
            this.delegateFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(suri);
        }
        AggregatingDataSource ads = new AggregatingDataSource(uri, this.delegateFactory);
        String surl = DataSetURI.fromUri(uri);
        FileStorageModelNew fsm = AggregatingDataSourceFactory.getFileStorageModel(surl);
        ads.setFsm(fsm);
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        String stimeRange = (String)parms.get("timerange");
        stimeRange = stimeRange.replaceAll("\\+", " ");
        ads.setViewRange(DatumRangeUtil.parseTimeRange((String)stimeRange));
        parms.remove("timerange");
        if (parms.size() > 0) {
            ads.setParams(URISplit.formatParams(parms));
        }
        return ads;
    }

    private static int splitIndex(String surl) {
        int i1;
        int i0 = surl.indexOf("%Y");
        if (i0 == -1) {
            i0 = surl.indexOf("$Y");
        }
        if ((i1 = surl.indexOf("%y")) == -1) {
            i1 = surl.indexOf("$y");
        }
        if (i0 == -1) {
            i0 = Integer.MAX_VALUE;
        }
        if (i1 == -1) {
            i1 = Integer.MAX_VALUE;
        }
        int i = Math.min(i0, i1);
        i = surl.lastIndexOf(47, i);
        return i;
    }

    public static FileStorageModelNew getFileStorageModel(String suri) throws IOException {
        URISplit split = URISplit.parse(suri);
        String surl = split.surl;
        int i = surl.indexOf(63);
        String sansArgs = i == -1 ? surl : surl.substring(0, i);
        i = AggregatingDataSourceFactory.splitIndex(sansArgs);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(sansArgs.substring(0, i)));
        if (sansArgs.charAt(i) == '/') {
            ++i;
        }
        String spec = sansArgs.substring(i).replaceAll("\\$", "%");
        FileStorageModelNew fsm = FileStorageModelNew.create((FileSystem)fs, (String)spec);
        return fsm;
    }

    public static CompletionContext getDelegateDataSourceCompletionContext(CompletionContext cc) throws IOException {
        String surl = cc.surl;
        int carotPos = cc.surlpos;
        int urlLen = 0;
        FileStorageModelNew fsm = AggregatingDataSourceFactory.getFileStorageModel(surl = surl.replaceAll("%25", "%"));
        String delegateFile = fsm.getRepresentativeFile((ProgressMonitor)new NullProgressMonitor());
        if (delegateFile == null) {
            throw new IllegalArgumentException("unable to find any files");
        }
        URISplit split = URISplit.parse(surl);
        String delegateFfile = fsm.getFileSystem().getRootURI().resolve(delegateFile).toString();
        carotPos -= (urlLen += delegateFfile.length()) - delegateFfile.length();
        split.file = delegateFfile;
        int i = surl.lastIndexOf("timerange=", cc.surlpos);
        if (i != -1) {
            int i1 = surl.indexOf("&", i);
            carotPos -= i1 - i;
        }
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        parms.remove("timerange");
        split.params = URISplit.formatParams(parms);
        String delegateUrl = URISplit.format(split);
        CompletionContext delegatecc = new CompletionContext();
        delegatecc.surl = delegateUrl;
        delegatecc.surlpos = carotPos;
        delegatecc.context = cc.context;
        delegatecc.resourceURI = DataSetURI.toUri(delegateFfile);
        return delegatecc;
    }

    public static String getDelegateDataSourceFactoryUri(String suri) throws IOException, IllegalArgumentException {
        URISplit split = URISplit.parse(suri);
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        String timeRange = (String)parms.remove("timerange");
        if (timeRange != null) {
            timeRange = timeRange.replaceAll("\\+", " ");
        }
        split.params = URISplit.formatParams(parms);
        FileStorageModelNew fsm = AggregatingDataSourceFactory.getFileStorageModel(DataSetURI.fromUri(split.resourceUri));
        String file = null;
        if (timeRange != null && !timeRange.equals("")) {
            try {
                DatumRange timeRangeDatum = DatumRangeUtil.parseTimeRange((String)timeRange);
                String[] names = fsm.getBestNamesFor(timeRangeDatum, (ProgressMonitor)new NullProgressMonitor());
                if (names.length > 0) {
                    file = names[0];
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(AggregatingDataSourceFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (file == null) {
            file = fsm.getRepresentativeFile((ProgressMonitor)new NullProgressMonitor());
        }
        if (file == null) {
            throw new IllegalArgumentException("unable to find any files in " + fsm);
        }
        split.resourceUri = fsm.getFileSystem().getRootURI().resolve(file);
        String scompUrl = DataSetURI.fromUri(split.resourceUri);
        if (split.params.length() > 0) {
            scompUrl = scompUrl + "?" + split.params;
        }
        split.file = DataSetURI.fromUri(split.resourceUri);
        split.surl = scompUrl;
        return URISplit.format(split);
    }

    public static DataSourceFactory getDelegateDataSourceFactory(String surl) throws IOException, IllegalArgumentException {
        String delegateSurl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl);
        URISplit split = URISplit.parse(surl);
        URISplit delegateSplit = URISplit.parse(delegateSurl);
        delegateSplit.vapScheme = split.vapScheme;
        URI uri = DataSetURI.toUri(URISplit.format(delegateSplit));
        return DataSetURI.getDataSourceFactory(uri, (ProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        String paramName;
        if (this.delegateFactory == null) {
            this.delegateFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(cc.surl);
        }
        DataSourceFactory f = this.delegateFactory;
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        CompletionContext delegatecc = AggregatingDataSourceFactory.getDelegateDataSourceCompletionContext(cc);
        List<CompletionContext> delegateCompletions = f.getCompletions(delegatecc, mon);
        result.addAll(delegateCompletions);
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange="));
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE && (paramName = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc)).equals("timerange")) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<timerange>"));
        }
        return result;
    }

    @Override
    public boolean reject(String surl, ProgressMonitor mon) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> map = URISplit.parseParams(split.params);
        try {
            if (!map.containsKey("timerange")) {
                return true;
            }
            String timeRange = (String)map.get("timerange");
            if ((timeRange = timeRange.replaceAll("\\+", " ")).length() < 4) {
                return true;
            }
            try {
                DatumRange dr = DatumRangeUtil.parseTimeRange((String)timeRange);
            }
            catch (ParseException ex) {
                return true;
            }
            String delegateSurl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl);
            if (this.delegateFactory == null) {
                this.delegateFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(surl);
            }
            return this.delegateFactory.reject(delegateSurl, mon);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return true;
        }
    }

    public void setDelegateDataSourceFactory(DataSourceFactory delegateFactory) {
        this.delegateFactory = delegateFactory;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz.isInstance(TimeSeriesBrowse.class)) {
            return (T)new DefaultTimeSeriesBrowse();
        }
        return null;
    }
}

