/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.FilePollUpdating;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.Updating;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSource
implements DataSource {
    protected URI uri;
    protected URI resourceURI;
    protected Map<String, String> params;
    FilePollUpdating pollingUpdater;
    HashMap<Class, Object> capabilities = new HashMap();

    public AbstractDataSource(URI uri) {
        this.uri = uri;
        String s = DataSetURI.fromUri(uri);
        if (!s.startsWith("vap")) {
            Logger.getLogger("vap.abstractDataSource").fine("uri didn't start with vap!");
        }
        URISplit split = URISplit.parse(s);
        this.params = URISplit.parseParams(split.params);
        String f = split.file;
        if (split.scheme != null) {
            try {
                this.resourceURI = DataSetURI.toUri(f);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    protected String getExt(URL url) {
        try {
            return this.getExt(url.toURI());
        }
        catch (URISyntaxException e) {
            System.err.println("Failed to convert URL to URI.");
            e.printStackTrace();
            return "";
        }
    }

    protected String getExt(URI uri) {
        String s = uri.getPath();
        int i = s.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return s.substring(i).toLowerCase();
    }

    @Override
    public abstract QDataSet getDataSet(ProgressMonitor var1) throws Exception;

    @Override
    public boolean asynchronousLoad() {
        return true;
    }

    public String toString() {
        return DataSetURI.fromUri(this.uri);
    }

    @Override
    public String getURI() {
        return DataSetURI.fromUri(this.uri);
    }

    protected File getFile(ProgressMonitor mon) throws IOException {
        if (this.resourceURI == null || this.resourceURI.toString().equals("")) {
            throw new IllegalArgumentException("expected file but didn't find one, check URI for question mark");
        }
        return this.getFile(this.resourceURI, mon);
    }

    protected File getFile(URI uri, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile(uri, mon);
        if (this.params.containsKey("filePollUpdates")) {
            this.pollingUpdater = new FilePollUpdating();
            this.pollingUpdater.startPolling(f, (long)(1000.0 * Double.parseDouble(this.params.get("filePollUpdates"))));
            this.capabilities.put(Updating.class, this.pollingUpdater);
        }
        return f;
    }

    protected File getFile(URL url, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile(url, mon);
        if (this.params.containsKey("filePollUpdates")) {
            this.pollingUpdater = new FilePollUpdating();
            this.pollingUpdater.startPolling(f, (long)(1000.0 * Double.parseDouble(this.params.get("filePollUpdates"))));
            this.capabilities.put(Updating.class, this.pollingUpdater);
        }
        return f;
    }

    protected File getHtmlFile(URL url, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getHtmlFile(url, mon);
        if (this.params.containsKey("filePollUpdates")) {
            this.pollingUpdater = new FilePollUpdating();
            this.pollingUpdater.startPolling(f, (long)(1000.0 * Double.parseDouble(this.params.get("filePollUpdates"))));
            this.capabilities.put(Updating.class, this.pollingUpdater);
        }
        return f;
    }

    protected Map getParams() {
        return new LinkedHashMap<String, String>(this.params);
    }

    protected String getParam(String name, String dflt) {
        String result = this.params.get(name);
        if (result != null) {
            return result;
        }
        return dflt;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        return new HashMap<String, Object>();
    }

    @Override
    public MetadataModel getMetadataModel() {
        return MetadataModel.createNullModel();
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            Map<String, Object> meta = this.getMetadata((ProgressMonitor)new NullProgressMonitor());
            return this.getMetadataModel().properties(meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.singletonMap("Exception", e);
        }
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        return (T)this.capabilities.get(clazz);
    }

    public <T> void addCability(Class<T> clazz, T o) {
        this.capabilities.put(clazz, o);
    }
}

