/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionsDataSourceEditor
extends JPanel
implements DataSourceEditorPanel {
    String suri;
    List<JCheckBox> opsCbs;
    List<JComboBox> opsComboBoxes;
    private JLabel jLabel1;
    private JPanel optionsPanel;

    public CompletionsDataSourceEditor() {
        this.initComponents();
    }

    private CompletionContext prepareContext(String surl1, int carotPos) {
        CompletionContext cc = new CompletionContext();
        int qpos = surl1.lastIndexOf(63, carotPos);
        if (qpos == -1 && carotPos == surl1.length()) {
            surl1 = surl1 + "?";
            qpos = surl1.length() - 1;
            carotPos = surl1.length();
        }
        cc.surl = surl1;
        cc.surlpos = carotPos;
        if (qpos != -1 && qpos < carotPos) {
            if (qpos == -1) {
                qpos = surl1.length();
            }
            int eqpos = surl1.lastIndexOf(61, carotPos - 1);
            int amppos = surl1.lastIndexOf(38, carotPos - 1);
            if (amppos == -1) {
                amppos = qpos;
            }
            if (eqpos > amppos) {
                cc.context = CompletionContext.CONTEXT_PARAMETER_VALUE;
                cc.completable = surl1.substring(eqpos + 1, carotPos);
                cc.completablepos = carotPos - (eqpos + 1);
            } else {
                cc.context = CompletionContext.CONTEXT_PARAMETER_NAME;
                cc.completable = surl1.substring(amppos + 1, carotPos);
                cc.completablepos = carotPos - (amppos + 1);
                if (surl1.length() > carotPos && surl1.charAt(carotPos) != '&') {
                    surl1 = surl1.substring(0, carotPos) + '&' + surl1.substring(carotPos);
                }
            }
        } else {
            throw new IllegalArgumentException("we aren't in the query section");
        }
        return cc;
    }

    private List<CompletionContext> getCompletions(DataSourceFactory factory, String surl1, CompletionContext cc, ProgressMonitor mon) throws URISyntaxException, Exception {
        List<CompletionContext> result;
        URISplit split = URISplit.parse(surl1);
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            URI uri = DataSetURI.getURI(CompletionContext.get(CompletionContext.CONTEXT_FILE, cc));
            cc.resourceURI = DataSetURI.getResourceURI(uri);
            cc.params = split.params;
            result = factory.getCompletions(cc, mon);
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            URI uri = DataSetURI.getURI(CompletionContext.get(CompletionContext.CONTEXT_FILE, cc));
            cc.resourceURI = DataSetURI.getResourceURI(uri);
            cc.params = split.params;
            if (factory == null) {
                throw new IllegalArgumentException("unable to find data source factory");
            }
            result = factory.getCompletions(cc, mon);
        } else {
            throw new IllegalArgumentException("we aren't in the query section");
        }
        return result;
    }

    public void populateFromCompletions(DataSourceFactory dsf, ProgressMonitor mon) throws URISyntaxException, Exception {
        int i = this.suri.indexOf("?");
        i = i == -1 ? this.suri.length() : ++i;
        URISplit split = URISplit.parse(this.suri);
        LinkedHashMap<String, String> map = URISplit.parseParams(split.params);
        CompletionContext cc = this.prepareContext(this.suri, i);
        List<CompletionContext> first = this.getCompletions(dsf, this.suri, cc, mon);
        this.opsCbs = new ArrayList<JCheckBox>();
        this.opsComboBoxes = new ArrayList<JComboBox>();
        for (CompletionContext cc1 : first) {
            String val;
            int ii;
            String ss = CompletionContext.insert(cc, cc1);
            JPanel optPanel = new JPanel(new BorderLayout());
            JCheckBox jcheckBox = new JCheckBox(cc1.label);
            optPanel.add("West", jcheckBox);
            this.opsCbs.add(jcheckBox);
            int pos = ss.indexOf(cc1.completable);
            if (pos > -1) {
                pos += cc1.completable.length();
            }
            CompletionContext cc2 = this.prepareContext(ss, pos > -1 ? pos : ss.length());
            List<CompletionContext> second = this.getCompletions(dsf, ss, cc2, mon);
            ArrayList<String> options = new ArrayList<String>();
            String key = cc1.completable;
            if (key != null && (ii = key.indexOf("=")) > -1) {
                key = key.substring(0, ii);
            }
            if ((val = (String)map.get(key)) != null) {
                // empty if block
            }
            Object sel = null;
            int isel = -1;
            for (int ii2 = 0; ii2 < second.size(); ++ii2) {
                CompletionContext cc3 = second.get(ii2);
                String ss2 = CompletionContext.insert(cc2, cc3);
                if (cc3.completable.equals(val)) {
                    isel = ii2;
                }
                if (cc3.label.startsWith(cc3.completable + ":")) {
                    options.add(cc3.label);
                    continue;
                }
                options.add(cc3.completable + ": " + cc3.label);
            }
            JComboBox jopts = new JComboBox(new Vector(options));
            optPanel.add("Center", jopts);
            if (isel != -1) {
                jopts.setSelectedIndex(isel);
                jcheckBox.setSelected(true);
            }
            this.opsComboBoxes.add(jopts);
            optPanel.setMaximumSize(new Dimension(10000, 16));
            this.optionsPanel.add(optPanel);
            this.optionsPanel.add(Box.createVerticalStrut(8));
        }
        this.optionsPanel.add(Box.createGlue());
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setURI(String uri) {
        this.suri = uri;
        URISplit split = URISplit.parse(this.suri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        for (String s : params.keySet()) {
            String v = (String)params.get(s);
            for (int i = 0; i < this.opsCbs.size(); ++i) {
                if (!this.opsCbs.get(i).getText().equals(s + "=")) continue;
                this.opsCbs.get(i).setSelected(true);
                this.opsComboBoxes.get(i).setSelectedItem(v);
            }
        }
    }

    @Override
    public String getURI() {
        String base = this.suri;
        int j = base.indexOf("?");
        if (j != -1) {
            base = base.substring(0, j);
        }
        boolean amp = false;
        for (int i = 0; i < this.opsCbs.size(); ++i) {
            if (!this.opsCbs.get(i).isSelected()) continue;
            String paramName = this.opsCbs.get(i).getText();
            String paramValue = String.valueOf(this.opsComboBoxes.get(i).getSelectedItem());
            int icolon = paramValue.indexOf(":");
            if (icolon != -1) {
                paramValue = paramValue.substring(0, icolon);
            }
            if (amp) {
                base = base + "&";
            } else {
                base = base + "?";
                amp = true;
            }
            base = base + paramName;
            base = base + paramValue;
        }
        this.suri = base;
        return this.suri;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.suri = uri;
        DataSourceFactory dsf = DataSetURI.getDataSourceFactory(new URI(uri), mon);
        this.populateFromCompletions(dsf, mon);
        return true;
    }

    @Override
    public boolean reject(String uri) throws Exception {
        URISplit split = URISplit.parse(uri);
        return split.file == null || split.file.equals("file:///");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.optionsPanel = new JPanel();
        this.jLabel1.setText("Experimental editor based on completions");
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addContainerGap(130, Short.MAX_VALUE)).add((Component)this.optionsPanel, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.optionsPanel, -1, 277, Short.MAX_VALUE)));
    }
}

