/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.virbo.datasource.capability.Updating;

public class FilePollUpdating
implements Updating {
    File pollFile;
    long pollMtime;
    long pollMsize;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.pcs.hasListeners(null)) {
            this.stopPolling();
        }
    }

    public void startPolling(File file, final long pollCyclePeriodMillis) {
        this.pollMsize = file.length();
        this.pollMtime = file.lastModified();
        this.pollFile = file;
        Runnable run = new Runnable(){

            public void run() {
                while (FilePollUpdating.this.pollFile != null) {
                    File lpollFile = FilePollUpdating.this.pollFile;
                    if (lpollFile == null) continue;
                    try {
                        Thread.sleep(pollCyclePeriodMillis);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(FilePollUpdating.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (!lpollFile.exists() || lpollFile.length() == FilePollUpdating.this.pollMsize && lpollFile.lastModified() == FilePollUpdating.this.pollMtime) continue;
                    FilePollUpdating.this.pcs.firePropertyChange("dataSet", null, null);
                    FilePollUpdating.this.pollMsize = lpollFile.length();
                    FilePollUpdating.this.pollMtime = lpollFile.lastModified();
                }
            }
        };
        new Thread(run, "FillPollUpdating").start();
    }

    public void stopPolling() {
        this.pollFile = null;
    }
}

