/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.DefaultEditorKit;
import org.das2.DasApplication;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.DataSourceEditorPanelUtil;

public class TimeRangeEditor
extends JPanel {
    DatumRange range = DatumRangeUtil.parseTimeRangeValid((String)"2010-01-01");
    boolean useDoy = false;
    private String lastErrorText = null;
    private long lastErrorTime = 0L;
    DataSetSelector peer;
    private JButton browseButton;
    private JButton nextButton;
    private JButton prevButton;
    private JTextField timeRangeTextField;
    private String alternatePeer;
    private String alternatePeerCard;

    public TimeRangeEditor() {
        this.initComponents();
        this.addMousePopupListener();
    }

    public boolean isUseDoy() {
        return this.useDoy;
    }

    public void setUseDoy(boolean useDoy) {
        boolean old = this.useDoy;
        this.useDoy = useDoy;
        DatumRangeUtil.useDoy = useDoy;
        this.firePropertyChange("useDoy", old, useDoy);
    }

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(DatumRange value) {
        DatumRange oldValue = this.range;
        this.range = value;
        if (oldValue != value && oldValue != null && !oldValue.equals((Object)value)) {
            super.firePropertyChange("range", oldValue, value);
        }
        this.timeRangeTextField.setText(value.toString());
    }

    private void parseRange() {
        block5: {
            DatumRange value = this.range;
            String text = this.timeRangeTextField.getText();
            try {
                String rangeString = text;
                DatumRange dr = DatumRangeUtil.parseTimeRange((String)rangeString);
                this.setRange(dr);
            }
            catch (ParseException e) {
                this.timeRangeTextField.setText(this.range.toString());
                if (UnitsUtil.isTimeLocation((Units)value.getUnits())) {
                    this.showErrorUsage(text, "unable to parse time range");
                }
            }
            catch (IllegalArgumentException e) {
                if (value == null) break block5;
                this.setRange(value);
                if (e.getMessage().contains("min > max")) {
                    this.showErrorUsage(text, "min cannot be greater than max");
                }
                this.showErrorUsage(text, e.getMessage());
            }
        }
    }

    private void showErrorUsage(String text, String why) {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            if (text != null && text.equals(this.lastErrorText) && System.currentTimeMillis() - this.lastErrorTime < 5000L) {
                return;
            }
            if (why != null) {
                JOptionPane.showMessageDialog(this, "<html>Unable to accept \"" + text + "\"<br>" + why + "<html>");
            } else {
                JOptionPane.showMessageDialog(this, "<html>Unable to accept \"" + text + "\"</html>");
            }
            this.lastErrorText = text;
            this.lastErrorTime = System.currentTimeMillis();
        }
    }

    private void initComponents() {
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.timeRangeTextField = new JTextField();
        this.browseButton = new JButton();
        this.setPreferredSize(new Dimension(384, 39));
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/prevPrev.png")));
        this.prevButton.setToolTipText("Scan to the previous interval");
        this.prevButton.setMaximumSize(new Dimension(34, 20));
        this.prevButton.setMinimumSize(new Dimension(34, 20));
        this.prevButton.setPreferredSize(new Dimension(34, 20));
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.prevButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/nextNext.png")));
        this.nextButton.setToolTipText("Scan to the next interval");
        this.nextButton.setMaximumSize(new Dimension(34, 24));
        this.nextButton.setMinimumSize(new Dimension(34, 24));
        this.nextButton.setPreferredSize(new Dimension(34, 24));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.nextButtonActionPerformed(evt);
            }
        });
        this.timeRangeTextField.setText("2010-01-01");
        this.timeRangeTextField.setToolTipText("<html>Adjust Application Time Range<br>\nFor example:<br>\n2010:  the year 2010.<br>\n2010-01: the month 2010-Jan<br>\n2010-001 or 2010-01-01: Jan 1, 2010<br>\n2010-01-01 08:00 to 09:00<br>\n</html>");
        this.timeRangeTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.timeRangeTextFieldActionPerformed(evt);
            }
        });
        this.timeRangeTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TimeRangeEditor.this.timeRangeTextFieldFocusLost(evt);
            }
        });
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/org/virbo/datasource/fileMag.png")));
        this.browseButton.setToolTipText("Edit data source");
        this.browseButton.setEnabled(false);
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setMaximumSize(new Dimension(20, 20));
        this.browseButton.setMinimumSize(new Dimension(20, 20));
        this.browseButton.setPreferredSize(new Dimension(20, 20));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeRangeEditor.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.timeRangeTextField, -1, 256, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.prevButton, -2, 40, -2).addPreferredGap(0).add((Component)this.nextButton, -2, 34, -2).addPreferredGap(0).add((Component)this.browseButton, -2, 30, -2)));
        layout.linkSize(new Component[]{this.nextButton, this.prevButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3, false).add((Component)this.browseButton, -2, 27, -2).add((Component)this.nextButton, -2, -1, -2)).add((Component)this.prevButton, -2, -1, -2).add((Component)this.timeRangeTextField, -2, 27, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.browseButton, this.nextButton, this.prevButton, this.timeRangeTextField}, 2);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.setRange(this.range.next());
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.setRange(this.range.previous());
    }

    private void timeRangeTextFieldFocusLost(FocusEvent evt) {
        this.parseRange();
    }

    private void timeRangeTextFieldActionPerformed(ActionEvent evt) {
        this.parseRange();
    }

    public void setDataSetSelectorPeer(DataSetSelector peer) {
        this.peer = peer;
        this.browseButton.setEnabled(true);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (this.peer != null) {
            String surl = this.peer.getEditor().getText().trim();
            boolean wasRejected = false;
            DataSourceEditorPanel edit = null;
            try {
                edit = DataSourceEditorPanelUtil.getDataSourceEditorPanel(DataSetURI.getURIValid(surl));
                if (edit != null && edit.reject(surl)) {
                    edit = null;
                    wasRejected = true;
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                edit = null;
            }
            catch (Exception ex) {
                Logger.getLogger(DataSetSelector.class.getName()).log(Level.SEVERE, null, ex);
                edit = null;
            }
            if (edit == null) {
                JOptionPane.showMessageDialog(this.prevButton, "this type has no editor", "no editor", 0);
            } else {
                this.peer.browseSourceType();
            }
        }
    }

    public static void main(String[] args) {
        TimeRangeEditor p = new TimeRangeEditor();
        p.addPropertyChangeListener("range", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getOldValue() + " -> " + evt.getNewValue());
            }
        });
        JFrame f = new JFrame();
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public PropertyChangeListener getUriFocusListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TimeRangeEditor.this.browseButton.setToolTipText("<html>Edit data source<br>" + evt.getNewValue().toString() + "</html>");
            }
        };
    }

    public void setAlternatePeer(String label, String card) {
        this.alternatePeer = label;
        this.alternatePeerCard = card;
    }

    private void addMousePopupListener() {
        this.timeRangeTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimeRangeEditor.this.showPopup(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimeRangeEditor.this.showPopup(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimeRangeEditor.this.showPopup(e);
                }
            }
        });
    }

    private void showPopup(MouseEvent e) {
        this.getPopupMenu().show(this, e.getX(), e.getY());
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem cutItem = result.add(new DefaultEditorKit.CutAction());
        cutItem.setText("Cut");
        JMenuItem copyItem = result.add(new DefaultEditorKit.CopyAction());
        copyItem.setText("Copy");
        JMenuItem pasteItem = result.add(new DefaultEditorKit.PasteAction());
        pasteItem.setText("Paste");
        if (this.alternatePeerCard != null) {
            result.add(new JSeparator());
            result.add(new AbstractAction(this.alternatePeer){

                public void actionPerformed(ActionEvent ev) {
                    Container trp = TimeRangeEditor.this.getParent();
                    ((CardLayout)trp.getLayout()).show(trp, TimeRangeEditor.this.alternatePeerCard);
                }
            });
        }
        return result;
    }
}

