/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.idlsupport;

import java.net.URI;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.idlsupport.QDataSetBridge;

public class APDataSet
extends QDataSetBridge {
    private String surl;

    public APDataSet() {
        System.err.println("APDataSet v1.3.1");
    }

    public void setDataSetURL(String surl) {
        this.surl = surl;
        this.datasets.clear();
        this.names.clear();
    }

    public void setDataSetURI(String suri) {
        this.surl = suri;
        this.datasets.clear();
        this.names.clear();
    }

    protected QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        URI uri = DataSetURI.getURI((String)this.surl);
        DataSourceFactory f = DataSetURI.getDataSourceFactory((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        if (f.reject(this.surl, mon)) {
            throw new Exception("URI was rejected by the datasource: " + this.surl + " rejected by " + f);
        }
        DataSource dsource = f.getDataSource(uri);
        QDataSet result = dsource.getDataSet(mon);
        if (result == null) {
            throw new Exception("getDataSet did not result in dataset: " + this.surl);
        }
        return result;
    }

    public String toString() {
        QDataSet d = (QDataSet)this.datasets.get(this.name);
        StringBuilder s = new StringBuilder(this.surl);
        for (String name1 : this.datasets.keySet()) {
            QDataSet qds = (QDataSet)this.datasets.get(name1);
            s.append("\n").append(name1).append(": ").append(qds.toString());
            for (int i = 0; i < 4; ++i) {
                if (d.property("DEPEND_" + i) == qds) {
                    s.append(" (DEPEND_").append(i).append(")");
                }
                if (d.property("BUNDLE_" + i) != qds) continue;
                s.append(" (BUNDLE_").append(i).append(")");
            }
        }
        for (String n : this.sliceDep.keySet()) {
            QDataSet ds1 = (QDataSet)((QDataSet)this.datasets.get(this.name)).slice(0).property((String)this.sliceDep.get(n));
            s.append("\nvia slice(0): ").append(n).append(": ").append(ds1).append(" (").append((String)this.sliceDep.get(n)).append(")");
        }
        return s.toString();
    }

    public static void main(String[] args) {
        APDataSet qds = new APDataSet();
        qds.setDataSetURL("http://www.autoplot.org/data/autoplot.dat");
        qds.doGetDataSet((ProgressMonitor)new NullProgressMonitor());
        String n = qds.name();
        System.err.println(n);
    }
}

