/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.idlsupport;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.SemanticOps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QDataSetBridge {
    QDataSet ds;
    Exception exception;
    String name;
    Map<String, QDataSet> datasets = new LinkedHashMap<String, QDataSet>();
    Map<String, String> sliceDep;
    Map<QDataSet, String> names = new LinkedHashMap<QDataSet, String>();
    List<Units> prefUnits;
    double fill;
    boolean useFill = false;
    boolean debug = false;

    QDataSetBridge() {
        this.sliceDep = new LinkedHashMap<String, String>();
        this.prefUnits = new ArrayList<Units>();
        System.err.println("QDataSetBridge v1.8.01");
    }

    public synchronized void setPreferredUnits(String sunit) {
        Units unit = sunit.contains(" since ") ? SemanticOps.lookupUnits((String)sunit) : Units.getByName((String)sunit);
        boolean add = true;
        for (int i = 0; i < this.prefUnits.size(); ++i) {
            if (!this.prefUnits.get(i).isConvertableTo(unit)) continue;
            if (this.debug) {
                System.err.println("replacing preferred unit " + this.prefUnits.get(i) + " with " + unit);
            }
            this.prefUnits.set(i, unit);
            add = false;
        }
        if (add) {
            if (this.debug) {
                System.err.println("add preferred unit: " + unit);
            }
            this.prefUnits.add(unit);
        }
    }

    public synchronized void clearPreferredUnits() {
        this.prefUnits = new ArrayList<Units>();
    }

    public void setFillValue(double d) {
        this.fill = d;
        this.useFill = true;
    }

    public void setDebug(boolean debug) {
        System.err.println("setting debug=" + debug);
        this.debug = debug;
    }

    public void clearFillValue() {
        this.useFill = false;
    }

    public void doGetDataSet() {
        this.exception = null;
        try {
            this.ds = this.getDataSet((ProgressMonitor)new NullProgressMonitor());
            this.datasets.clear();
            this.name = this.nameFor(this.ds);
            this.datasets.put(this.name, this.ds);
            for (int i = 0; i < this.ds.rank(); ++i) {
                QDataSet depslice;
                QDataSet dep = (QDataSet)this.ds.property("DEPEND_" + i);
                if (dep != null) {
                    this.datasets.put(this.nameFor(dep), dep);
                }
                if ((depslice = (QDataSet)this.ds.property("DEPEND_" + i, 0)) == null) continue;
                this.sliceDep.put(this.nameFor(depslice), "DEPEND_" + i);
            }
        }
        catch (Exception ex) {
            this.exception = ex;
            ex.printStackTrace();
            return;
        }
    }

    public void doGetDataSet(final ProgressMonitor mon) {
        this.exception = null;
        Runnable run = new Runnable(){

            public void run() {
                QDataSetBridge.this.datasets.clear();
                QDataSetBridge.this.name = "";
                try {
                    QDataSetBridge.this.ds = QDataSetBridge.this.getDataSet(mon);
                    if (QDataSetBridge.this.ds == null) {
                        return;
                    }
                }
                catch (Exception ex) {
                    QDataSetBridge.this.exception = ex;
                    ex.printStackTrace();
                    mon.setProgressMessage("EXCEPTION");
                    mon.finished();
                    return;
                }
                QDataSetBridge.this.name = QDataSetBridge.this.nameFor(QDataSetBridge.this.ds);
                QDataSetBridge.this.datasets.put(QDataSetBridge.this.name, QDataSetBridge.this.ds);
                for (int i = 0; i < QDataSetBridge.this.ds.rank(); ++i) {
                    QDataSet depslice;
                    QDataSet dep = (QDataSet)QDataSetBridge.this.ds.property("DEPEND_" + i);
                    if (dep != null) {
                        QDataSetBridge.this.datasets.put(QDataSetBridge.this.nameFor(dep), dep);
                    }
                    if ((depslice = (QDataSet)QDataSetBridge.this.ds.property("DEPEND_" + i, 0)) == null) continue;
                    QDataSetBridge.this.sliceDep.put(QDataSetBridge.this.nameFor(depslice), "DEPEND_" + i);
                }
            }
        };
        new Thread(run).start();
    }

    public Exception getException() {
        return this.exception;
    }

    public int getStatus() {
        return this.exception == null ? 0 : 1;
    }

    public String getStatusMessage() {
        if (this.exception == null) {
            return "";
        }
        String s = this.exception.getMessage();
        if (s != null && s.length() > 0) {
            return s;
        }
        return this.exception.toString();
    }

    public synchronized String nameFor(QDataSet dep0) {
        String name1 = this.names.get(dep0);
        if (name1 == null) {
            name1 = (String)dep0.property("NAME");
        }
        if (name1 == null) {
            name1 = "ds_" + this.names.size();
        }
        this.names.put(dep0, name1);
        return name1;
    }

    abstract QDataSet getDataSet(ProgressMonitor var1) throws Exception;

    public ProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public void values(String name, double[] result) {
        if (this.debug) {
            System.err.println("reading " + name + " into double[" + result.length + "]");
        }
        QDataSet ds1 = this.datasets.get(name);
        this.copyValues(ds1, result);
    }

    public void values(String name, double[][] result) {
        if (this.debug) {
            System.err.println("reading " + name + " into double[" + result.length + "," + result[0].length + "]");
        }
        QDataSet ds1 = this.datasets.get(name);
        this.copyValues(ds1, result);
    }

    public void values(String name, double[][][] result) {
        if (this.debug) {
            System.err.println("reading " + name + " into double[" + result.length + "," + result[0].length + "," + result[0][0].length + "]");
        }
        QDataSet ds1 = this.datasets.get(name);
        this.copyValues(ds1, result);
    }

    public void values(String name, double[][][][] result) {
        if (this.debug) {
            System.err.println("reading " + name + " into double[" + result.length + "," + result[0].length + "," + result[0][0].length + "," + result[0][0][0].length + "]");
        }
        QDataSet ds1 = this.datasets.get(name);
        this.copyValues(ds1, result);
    }

    public void values(double[] result) {
        this.values(this.name(), result);
    }

    public void values(double[][] result) {
        this.values(this.name(), result);
    }

    public void values(double[][][] result) {
        this.values(this.name(), result);
    }

    public void values(double[][][][] result) {
        this.values(this.name(), result);
    }

    private UnitsConverter maybeGetConverter(QDataSet ds1) {
        Units u = SemanticOps.getUnits((QDataSet)ds1);
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (this.prefUnits != null) {
            for (Units prefUnit : this.prefUnits) {
                if (!prefUnit.isConvertableTo(u) || (uc = u.getConverter(prefUnit)) == UnitsConverter.IDENTITY || !this.debug) continue;
                System.err.println("Using units converter to get " + prefUnit);
            }
        }
        return uc;
    }

    private void copyValues(QDataSet ds1, double[] result) {
        UnitsConverter uc = this.maybeGetConverter(ds1);
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds1);
        if (this.debug) {
            System.err.println("copyValues rank1 into double using " + uc);
        }
        for (int i0 = 0; i0 < ds1.length(); ++i0) {
            result[i0] = this.useFill && wds.value(i0) == 0.0 ? this.fill : uc.convert(ds1.value(i0));
        }
    }

    private void copyValues(QDataSet ds1, double[][] result) {
        UnitsConverter uc = this.maybeGetConverter(ds1);
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds1);
        for (int i0 = 0; i0 < ds1.length(); ++i0) {
            for (int i1 = 0; i1 < ds1.length(i0); ++i1) {
                result[i0][i1] = this.useFill && wds.value(i0, i1) == 0.0 ? this.fill : uc.convert(ds1.value(i0, i1));
            }
        }
    }

    private void copyValues(QDataSet ds1, double[][][] result) {
        UnitsConverter uc = this.maybeGetConverter(ds1);
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds1);
        for (int i0 = 0; i0 < ds1.length(); ++i0) {
            for (int i1 = 0; i1 < ds1.length(i0); ++i1) {
                for (int i2 = 0; i2 < ds1.length(i0, i1); ++i2) {
                    result[i0][i1][i2] = this.useFill && wds.value(i0, i1, i2) == 0.0 ? this.fill : uc.convert(ds1.value(i0, i1, i2));
                }
            }
        }
    }

    private void copyValues(QDataSet ds1, double[][][][] result) {
        UnitsConverter uc = this.maybeGetConverter(ds1);
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)ds1);
        for (int i0 = 0; i0 < ds1.length(); ++i0) {
            for (int i1 = 0; i1 < ds1.length(i0); ++i1) {
                for (int i2 = 0; i2 < ds1.length(i0, i1); ++i2) {
                    int i3 = 0;
                    while (i3 < ds1.length(i0, i1, i2)) {
                        result[i0][i1][i2][i3] = this.useFill && wds.value(i0, i1, i2, i3) == 0.0 ? this.fill : uc.convert(ds1.value(i0, i1, i2, i3));
                        ++i2;
                    }
                }
            }
        }
    }

    public void slice(String name, int i, double[] result) {
        if (this.debug) {
            System.err.println("reading " + name + "[" + i + "] into double[" + result.length + "]");
        }
        if (this.datasets.get(name) == null) {
            throw new IllegalArgumentException("did not find dataset name=" + name);
        }
        QDataSet ds1 = this.datasets.get(name).slice(i);
        this.copyValues(ds1, result);
    }

    public void slice(String name, int i, double[][] result) {
        if (this.debug) {
            System.err.println("reading " + name + "[" + i + "] into double[" + result.length + "," + result[0].length + "]");
        }
        if (this.datasets.get(name) == null) {
            throw new IllegalArgumentException("did not find dataset name=" + name);
        }
        QDataSet ds1 = this.datasets.get(name).slice(i);
        this.copyValues(ds1, result);
    }

    public void slice(String name, int i, double[][][] result) {
        if (this.debug) {
            System.err.println("reading " + name + "[" + i + "] into double[" + result.length + "," + result[0].length + "," + result[0][0].length + "]");
        }
        if (this.datasets.get(name) == null) {
            throw new IllegalArgumentException("did not find dataset name=" + name);
        }
        QDataSet ds1 = this.datasets.get(name).slice(i);
        this.copyValues(ds1, result);
    }

    public void slice(int i, double[] result) {
        this.slice(this.name(), i, result);
    }

    public void slice(int i, double[][] result) {
        this.slice(this.name(), i, result);
    }

    public void slice(int i, double[][][] result) {
        this.slice(this.name(), i, result);
    }

    public Object values(String name) {
        QDataSet ds1;
        if (this.debug) {
            System.err.println("reading values for dataset " + name);
        }
        if ((ds1 = this.datasets.get(name)).rank() == 1) {
            double[] result = new double[ds1.length()];
            this.values(name, result);
            return result;
        }
        if (ds1.rank() == 2) {
            double[][] result = new double[ds1.length()][ds1.length(0)];
            this.values(name, result);
            return result;
        }
        if (ds1.rank() == 3) {
            double[][][] result = new double[ds1.length()][ds1.length(0)][ds1.length(0, 0)];
            this.values(name, result);
            return result;
        }
        if (ds1.rank() == 4) {
            double[][][][] result = new double[ds1.length()][ds1.length(0)][ds1.length(0, 0)][ds1.length(0, 0, 0)];
            this.values(name, result);
            return result;
        }
        throw new IllegalArgumentException("rank limit");
    }

    public Object slice(String name, int i) {
        QDataSet ds1;
        if (this.debug) {
            System.err.println("reading values for slice " + i + " of dataset " + name);
        }
        if ((ds1 = this.datasets.get(name)) == null && this.sliceDep.containsKey(name)) {
            return this.sliceDep(name, i);
        }
        if (ds1 == null) {
            throw new IllegalArgumentException("No such dataset: " + name);
        }
        if (ds1.rank() == 1) {
            throw new IllegalArgumentException("dataset is rank 1, slice not allowed");
        }
        if (ds1.rank() == 2) {
            double[] result = new double[ds1.length(i)];
            this.slice(name, i, result);
            return result;
        }
        if (ds1.rank() == 3) {
            double[][] result = new double[ds1.length(i)][ds1.length(i, 0)];
            this.slice(name, i, result);
            return result;
        }
        if (ds1.rank() == 4) {
            double[][][] result = new double[ds1.length(i)][ds1.length(i, 0)][ds1.length(i, 0, 0)];
            this.slice(name, i, result);
            return result;
        }
        throw new IllegalArgumentException("rank limit");
    }

    private Object sliceDep(String name, int i) {
        QDataSet ds1 = (QDataSet)this.datasets.get(this.name).slice(i).property(this.sliceDep.get(name));
        if (ds1.rank() == 1) {
            double[] result = new double[ds1.length()];
            this.copyValues(ds1, result);
            return result;
        }
        if (ds1.rank() == 2) {
            double[][] result = new double[ds1.length()][ds1.length(0)];
            this.copyValues(ds1, result);
            return result;
        }
        if (ds1.rank() == 3) {
            double[][][] result = new double[ds1.length()][ds1.length(0)][ds1.length(0, 0)];
            this.copyValues(ds1, result);
            return result;
        }
        throw new IllegalArgumentException("rank limit");
    }

    public Object values() {
        return this.values(this.name);
    }

    public Object slice(int i0) {
        return this.slice(this.name, i0);
    }

    public String depend(int dim) {
        QDataSet result = (QDataSet)this.ds.property("DEPEND_" + dim);
        if (result == null) {
            return "";
        }
        return this.nameFor(result);
    }

    public String plane(int iplane) {
        QDataSet result = (QDataSet)this.ds.property("PLANE_" + iplane);
        if (result == null) {
            return "";
        }
        return this.nameFor(result);
    }

    public String propertyAsString(String property) {
        Object result = this.ds.property(property);
        if (result == null) {
            return "";
        }
        return String.valueOf(result);
    }

    public double propertyAsDouble(String property) {
        Object result = this.ds.property(property);
        if (result == null) {
            return Double.NaN;
        }
        return ((Number)result).doubleValue();
    }

    public String propertyAsString(String name, String property) {
        Object result = this.datasets.get(name).property(property);
        if (result == null) {
            return "";
        }
        return String.valueOf(result);
    }

    public double propertyAsDouble(String name, String property) {
        Object result = this.datasets.get(name).property(property);
        if (result == null) {
            return Double.NaN;
        }
        return ((Number)result).doubleValue();
    }

    public void valuesAlias(String name, double[] result) {
        QDataSet ds1 = this.datasets.get(name);
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        int iele = 0;
        while (it.hasNext()) {
            it.next();
            result[iele] = it.getValue(ds1);
            ++iele;
        }
    }

    public void labelsAlias(String name, String[] result) {
        QDataSet ds1 = this.datasets.get(name);
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        int iele = 0;
        Units u = (Units)ds1.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        while (it.hasNext()) {
            it.next();
            result[iele] = u.createDatum(it.getValue(ds1)).toString();
            ++iele;
        }
    }

    public int[] lengths(String name) {
        return DataSetUtil.qubeDims((QDataSet)this.datasets.get(name));
    }

    public int[] lengths() {
        return DataSetUtil.qubeDims((QDataSet)this.datasets.get(this.name));
    }

    public int[] lengths(String name, int i) {
        QDataSet ds1 = this.datasets.get(name);
        if (ds1 == null && this.sliceDep.containsKey(name)) {
            ds1 = (QDataSet)this.datasets.get(this.name).slice(i).property(this.sliceDep.get(name));
            return DataSetUtil.qubeDims((QDataSet)ds1);
        }
        if (ds1 == null) {
            throw new IllegalArgumentException("No such dataset: " + name);
        }
        return DataSetUtil.qubeDims((QDataSet)ds1.slice(i));
    }

    public int[] lengths(int i) {
        return this.lengths(this.name, i);
    }

    public int length(String name) {
        QDataSet ds1 = this.datasets.get(name);
        if (ds1 == null) {
            throw new IllegalArgumentException("unable to get length for slice dataset, use lengths");
        }
        return ds1.length();
    }

    public int length() {
        return this.length(this.name);
    }

    public int rank(String name) {
        return this.datasets.get(name).rank();
    }

    public int rank() {
        return this.datasets.get(this.name).rank();
    }

    public boolean isQube() {
        return DataSetUtil.isQube((QDataSet)this.datasets.get(this.name));
    }

    public Object property(String name, String propname, int i) {
        Object prop = this.datasets.get(name).property(propname, i);
        if (prop instanceof QDataSet) {
            return this.nameFor((QDataSet)prop);
        }
        if (prop instanceof Units) {
            for (Units u : this.prefUnits) {
                if (!u.isConvertableTo(SemanticOps.getUnits((QDataSet)this.datasets.get(this.name)))) continue;
                return u.toString();
            }
            return prop.toString();
        }
        if (propname.equals("FILL_VALUE") && this.useFill) {
            return this.fill;
        }
        return prop;
    }

    public boolean hasProperty(String name, String propname, int i) {
        return this.datasets.get(name).property(propname, i) != null;
    }

    public Map<String, Object> properties(String name, int i) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(DataSetUtil.getProperties((QDataSet)this.datasets.get(name).slice(i)));
        for (String s : result.keySet()) {
            result.put(s, this.property(name, s, i));
        }
        return result;
    }

    public Object property(String name, String propname) {
        Object prop = this.datasets.get(name).property(propname);
        if (prop instanceof QDataSet) {
            return this.nameFor((QDataSet)prop);
        }
        if (prop instanceof Units) {
            Units dsu = SemanticOps.getUnits((QDataSet)this.datasets.get(name));
            for (Units u : this.prefUnits) {
                if (!u.isConvertableTo(dsu)) continue;
                return u.toString();
            }
            return prop.toString();
        }
        if (propname.equals("FILL_VALUE") && this.useFill) {
            return this.fill;
        }
        return prop;
    }

    public boolean hasProperty(String name, String propname) {
        return this.datasets.get(name).property(propname) != null;
    }

    public Map<String, Object> properties(String name) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(DataSetUtil.getProperties((QDataSet)this.datasets.get(name)));
        for (String s : result.keySet()) {
            result.put(s, this.property(name, s));
        }
        return result;
    }

    public Object property(String propname) {
        Object prop = this.datasets.get(this.name).property(propname);
        if (prop instanceof QDataSet) {
            return this.nameFor((QDataSet)prop);
        }
        if (prop instanceof Units) {
            return prop.toString();
        }
        return prop;
    }

    public boolean hasProperty(String propname) {
        return this.datasets.get(this.name).property(propname) != null;
    }

    public Map<String, Object> properties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(DataSetUtil.getProperties((QDataSet)this.datasets.get(this.name)));
        for (String s : result.keySet()) {
            result.put(s, this.property(this.name, s));
        }
        return result;
    }

    public Object property(String propname, int i) {
        Object prop = this.datasets.get(this.name).property(propname, i);
        if (prop instanceof QDataSet) {
            return this.nameFor((QDataSet)prop);
        }
        if (prop instanceof Units) {
            return prop.toString();
        }
        return prop;
    }

    public boolean hasProperty(String propname, int i) {
        return this.datasets.get(this.name).property(propname, i) != null;
    }

    public Map<String, Object> properties(int i) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(DataSetUtil.getProperties((QDataSet)this.datasets.get(this.name).slice(i)));
        return result;
    }

    public String[] names() {
        return this.datasets.keySet().toArray(new String[this.datasets.size()]);
    }

    public String name() {
        return this.name;
    }
}

