/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.CancelledOperationException;
import org.das2.datum.Datum;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.ByteBufferInputStream;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.ascii.MultiFieldTimeParser;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.AsciiParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableDataSource
extends AbstractDataSource {
    AsciiParser parser;
    File file;
    String column = null;
    String depend0 = null;
    private static final Logger logger = Logger.getLogger("vap.asciiTableDataSource");
    public static final String PARAM_INTERVAL_TAG = "intervalTag";
    TimeParser timeParser;
    int timeColumns = -1;
    String[] timeFormats;
    int timeColumn = -1;
    DDataSet ds = null;
    int[] rank2 = null;
    int[] bundle = null;
    int[] depend1Labels = null;
    String[] depend1Label = null;
    int[] depend1Values = null;
    private double validMin = Double.NEGATIVE_INFINITY;
    private double validMax = Double.POSITIVE_INFINITY;

    public AsciiTableDataSource(URI uri) throws FileNotFoundException, IOException {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws IOException, CancelledOperationException {
        int i;
        this.ds = this.doReadFile(mon);
        if (mon.isCancelled()) {
            throw new CancelledOperationException("cancelled data read");
        }
        if (this.timeColumns > 1) {
            TimeLocationUnits u = Units.t2000;
            int warnCount = 10;
            for (int i2 = 0; i2 < this.ds.length(); ++i2) {
                try {
                    this.timeParser.resetSeconds();
                    for (int j = 0; j < this.timeColumns; ++j) {
                        double d = this.ds.value(i2, this.timeColumn + j);
                        double fp = d - (double)((int)Math.floor(d));
                        if (fp == 0.0) {
                            this.timeParser.setDigit(this.timeFormats[j], (int)d);
                            continue;
                        }
                        this.timeParser.setDigit(this.timeFormats[j], d);
                    }
                    this.ds.putValue(i2, this.timeColumn, this.timeParser.getTime((Units)Units.t2000));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    if (warnCount > 0) {
                        new RuntimeException("failed to read time at record " + i2, ex).printStackTrace();
                        --warnCount;
                    }
                    this.ds.putValue(i2, this.timeColumn, Units.t2000.getFillDouble());
                }
            }
            this.parser.setUnits(this.timeColumn, (Units)Units.t2000);
        }
        ArrayDataSet vds = null;
        ArrayDataSet dep0 = null;
        if (this.column == null && this.timeColumn != -1) {
            this.column = this.parser.getFieldNames()[this.timeColumn];
        }
        QDataSet bundleDescriptor = (QDataSet)this.ds.property("BUNDLE_1");
        String group = this.getParam("group", null);
        if (group != null) {
            vds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (String)group));
        } else if (this.column != null) {
            if (bundleDescriptor != null) {
                vds = ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (String)this.column));
            } else {
                int icol = this.parser.getFieldIndex(this.column);
                if (icol == -1) {
                    throw new IllegalArgumentException("bad column parameter: " + this.column + ", should be field1, or 1, or <name>");
                }
                vds = ArrayDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
                vds.putProperty("UNITS", (Object)this.parser.getUnits(icol));
                if (this.column.length() > 1) {
                    vds.putProperty("NAME", (Object)this.column);
                }
                vds.putProperty("LABEL", (Object)this.parser.getFieldNames()[icol]);
            }
            if (this.validMax != Double.POSITIVE_INFINITY) {
                vds.putProperty("VALID_MAX", (Object)this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                vds.putProperty("VALID_MIN", (Object)this.validMin);
            }
        }
        if (this.depend0 != null) {
            Units xunits;
            RankZeroDataSet cadence;
            String intervalType;
            int icol = this.parser.getFieldIndex(this.depend0);
            if (icol == -1) {
                throw new IllegalArgumentException("bad depend0 parameter: " + this.depend0 + ", should be field1, or 1, or <name>");
            }
            dep0 = this.ds.property("BUNDLE_1") != null ? ArrayDataSet.copy((QDataSet)DataSetOps.unbundle((QDataSet)this.ds, (int)icol)) : ArrayDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
            dep0.putProperty("UNITS", (Object)this.parser.getUnits(icol));
            if (DataSetUtil.isMonotonic((QDataSet)dep0)) {
                dep0.putProperty("MONOTONIC", (Object)Boolean.TRUE);
            }
            if ((intervalType = (String)this.params.get(PARAM_INTERVAL_TAG)) != null && intervalType.equals("start") && (cadence = DataSetUtil.guessCadenceNew((QDataSet)dep0, null)) != null && !"log".equals(cadence.property("SCALE_TYPE"))) {
                double add = cadence.value() / 2.0;
                logger.fine("adding half-interval width to dep0 because of intervalTag: " + cadence);
                for (i = 0; i < dep0.length(); ++i) {
                    dep0.putValue(i, dep0.value(i) + add);
                }
            }
            if (this.depend0.length() > 1) {
                dep0.putProperty("NAME", (Object)this.depend0);
            }
            if ((xunits = (Units)dep0.property("UNITS")) == null || !UnitsUtil.isTimeLocation((Units)xunits)) {
                dep0.putProperty("LABEL", (Object)this.parser.getFieldNames()[icol]);
            }
        }
        if (this.bundle != null) {
            this.rank2 = this.bundle;
        }
        if (this.rank2 != null) {
            if (dep0 != null) {
                this.ds.putProperty("DEPEND_0", dep0);
            }
            if (this.rank2[0] == -1) {
                throw new IllegalArgumentException("bad parameter: rank2");
            }
            if (bundleDescriptor == null) {
                Units u = this.parser.getUnits(this.rank2[0]);
                for (int i3 = this.rank2[0]; i3 < this.rank2[1]; ++i3) {
                    if (u == this.parser.getUnits(i3)) continue;
                    u = null;
                }
                if (u != null) {
                    this.ds.putProperty("UNITS", (Object)u);
                }
                if (this.validMax != Double.POSITIVE_INFINITY) {
                    this.ds.putProperty("VALID_MAX", (Object)this.validMax);
                }
                if (this.validMin != Double.NEGATIVE_INFINITY) {
                    this.ds.putProperty("VALID_MIN", (Object)this.validMin);
                }
            } else {
                System.err.println("removing bundleDescriptor because of rank2");
            }
            Object mds = this.rank2[0] == 0 && this.rank2[1] == this.ds.length(0) ? this.ds : DataSetOps.leafTrim((QDataSet)this.ds, (int)this.rank2[0], (int)this.rank2[1]);
            if (this.bundle != null) {
                QDataSet labels = Ops.labels((String[])this.parser.getFieldLabels());
                labels = labels.trim(this.bundle[0], this.bundle[1]);
                mds.putProperty("DEPEND_1", (Object)labels);
            }
            if (this.depend1Label != null) {
                mds.putProperty("DEPEND_1", (Object)Ops.labels((String[])this.depend1Label));
            }
            if (this.depend1Labels != null) {
                QDataSet labels = Ops.labels((String[])this.parser.getFieldLabels());
                labels = labels.trim(this.depend1Labels[0], this.depend1Labels[1]);
                mds.putProperty("DEPEND_1", (Object)labels);
            }
            if (this.depend1Values != null) {
                String[] fieldNames = this.parser.getFieldNames();
                String[] fieldUnits = this.parser.getFieldUnits();
                DDataSet dep1 = DDataSet.createRank1((int)(this.depend1Values[1] - this.depend1Values[0]));
                boolean firstRecordIsDep1 = false;
                for (i = this.depend1Values[0]; i < this.depend1Values[1]; ++i) {
                    double d;
                    if (firstRecordIsDep1) {
                        d = mds.value(0, i - this.depend1Values[0]);
                    } else {
                        try {
                            d = Double.parseDouble(fieldNames[i]);
                        }
                        catch (NumberFormatException ex) {
                            try {
                                if (fieldUnits[i] != null) {
                                    d = Double.parseDouble(fieldUnits[i]);
                                } else {
                                    d = mds.value(0, i - this.depend1Values[0]);
                                    firstRecordIsDep1 = true;
                                }
                            }
                            catch (NumberFormatException ex2) {
                                d = i - this.depend1Values[0];
                            }
                        }
                    }
                    dep1.putValue(i - this.depend1Values[0], d);
                }
                mds.putProperty("DEPEND_1", (Object)dep1);
                if (firstRecordIsDep1) {
                    mds = (MutablePropertyDataSet)mds.trim(1, mds.length());
                }
            }
            return mds;
        }
        if (vds == null) {
            throw new IllegalArgumentException("didn't find column: " + this.column);
        }
        if (dep0 != null) {
            vds.putProperty("DEPEND_0", dep0);
        }
        return vds;
    }

    private DDataSet doReadFile(ProgressMonitor mon) throws NumberFormatException, IOException, FileNotFoundException {
        DDataSet ds1;
        String s;
        this.file = this.getFile(mon);
        if (this.file.isDirectory()) {
            throw new IOException("expected file but got directory");
        }
        this.parser = new AsciiParser();
        boolean fixedColumns = false;
        int columnCount = 0;
        String o = (String)this.params.get("skip");
        if (o != null) {
            this.parser.setSkipLines(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("skipLines")) != null) {
            this.parser.setSkipLines(Integer.parseInt(o));
        }
        if ((o = (String)this.params.get("recCount")) != null) {
            this.parser.setRecordCountLimit(Integer.parseInt(o));
        }
        this.parser.setKeepFileHeader(true);
        o = (String)this.params.get("comment");
        if (o != null) {
            if (o.equals("")) {
                this.parser.setCommentPrefix(null);
            } else {
                this.parser.setCommentPrefix(o);
            }
        }
        if ((o = (String)this.params.get("headerDelim")) != null) {
            this.parser.setHeaderDelimiter(o);
        }
        String delim = (String)this.params.get("delim");
        String sFixedColumns = (String)this.params.get("fixedColumns");
        if (sFixedColumns == null) {
            if (delim == null) {
                AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
                if (p == null) {
                    throw new IllegalArgumentException("no records found");
                }
                columnCount = p.fieldCount();
                delim = p.getDelim();
            } else {
                if (delim.equals(",")) {
                    delim = "COMMA";
                }
                delim = delim.replaceAll("WHITESPACE", "\\s+");
                delim = delim.replaceAll("SPACE", " ");
                delim = delim.replaceAll("COMMA", ",");
                delim = delim.replaceAll("COLON", ":");
                delim = delim.replaceAll("TAB", "\t");
                delim = delim.replaceAll("whitespace", "\\s+");
                delim = delim.replaceAll("space", " ");
                delim = delim.replaceAll("comma", ",");
                delim = delim.replaceAll("colon", ":");
                if ((delim = delim.replaceAll("tab", "\t")).equals("+")) {
                    delim = " ";
                }
                columnCount = this.parser.setDelimParser(this.file.toString(), delim).fieldCount();
            }
            this.parser.setPropertyPattern(AsciiParser.NAME_COLON_VALUE_PATTERN);
        } else {
            s = sFixedColumns;
            AsciiParser.FixedColumnsParser p = this.parser.setFixedColumnsParser(this.file.toString(), "\\s+");
            try {
                columnCount = Integer.parseInt(sFixedColumns);
            }
            catch (NumberFormatException ex) {
                if (sFixedColumns.equals("")) {
                    columnCount = p.fieldCount();
                }
                String[] ss = s.split(",");
                int[] starts = new int[ss.length];
                int[] widths = new int[ss.length];
                AsciiParser.FieldParser[] fparsers = new AsciiParser.FieldParser[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    String[] ss2 = ss[i].split("-");
                    starts[i] = Integer.parseInt(ss2[0]);
                    widths[i] = Integer.parseInt(ss2[1]) - starts[i] + 1;
                    fparsers[i] = AsciiParser.DOUBLE_PARSER;
                }
                p = this.parser.setFixedColumnsParser(starts, widths, fparsers);
                columnCount = p.fieldCount();
            }
            this.parser.setPropertyPattern(null);
            fixedColumns = true;
            delim = null;
        }
        o = (String)this.params.get("columnCount");
        if (columnCount == 0) {
            columnCount = o != null ? Integer.parseInt(o) : AsciiParser.guessFieldCount((String)this.file.toString());
        }
        if ((o = (String)this.params.get("fill")) != null) {
            this.parser.setFillValue(Double.parseDouble(o));
        }
        if ((o = (String)this.params.get("validMin")) != null) {
            this.validMin = Double.parseDouble(o);
        }
        if ((o = (String)this.params.get("validMax")) != null) {
            this.validMax = Double.parseDouble(o);
        }
        if ((o = (String)this.params.get("time")) != null) {
            int i = this.parser.getFieldIndex(o);
            if (i == -1) {
                throw new IllegalArgumentException("field not found for time in column named \"" + o + "\"");
            }
            this.parser.setFieldParser(i, this.parser.UNITS_PARSER);
            this.parser.setUnits(i, (Units)Units.t2000);
            this.depend0 = o;
            this.timeColumn = i;
        }
        if ((o = (String)this.params.get("timeFormat")) != null) {
            Object timeFieldParser;
            TimeLocationUnits u;
            String timeFormat = o.replaceAll("\\+", " ");
            timeFormat = timeFormat.replaceAll("\\$", "%");
            timeFormat = timeFormat.replaceAll("\\(", "{");
            timeFormat = timeFormat.replaceAll("\\)", "}");
            String timeColumnName = (String)this.params.get("time");
            this.timeColumn = timeColumnName == null ? 0 : this.parser.getFieldIndex(timeColumnName);
            String timeFormatDelim = delim;
            if (delim == null) {
                timeFormatDelim = " ";
            }
            this.timeFormats = timeFormat.split(timeFormatDelim, -2);
            if (this.timeFormats.length == 1) {
                timeFormatDelim = " ";
                this.timeFormats = timeFormat.split(timeFormatDelim, -2);
            }
            if (timeFormat.equals("ISO8601")) {
                String line = this.parser.readFirstParseableRecord(this.file.toString());
                if (line == null) {
                    throw new IllegalArgumentException("file contains no parseable records.");
                }
                String[] ss = new String[this.parser.getRecordParser().fieldCount()];
                this.parser.getRecordParser().splitRecord(line, ss);
                int i = this.timeColumn;
                if (i == -1) {
                    i = 0;
                }
                String atime = ss[i];
                timeFormat = TimeParser.iso8601String((String)atime.trim());
                this.timeParser = TimeParser.create((String)timeFormat);
                TimeLocationUnits u2 = Units.t2000;
                this.parser.setUnits(i, (Units)u2);
                AsciiParser.FieldParser timeFieldParser2 = new AsciiParser.FieldParser((Units)u2){
                    final /* synthetic */ Units val$u;
                    {
                        this.val$u = units;
                    }

                    public double parseField(String field, int fieldIndex) throws ParseException {
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(this.val$u);
                    }
                };
                this.parser.setFieldParser(i, timeFieldParser2);
            } else if (delim != null && this.timeFormats.length > 1) {
                this.timeParser = TimeParser.create((String)timeFormat);
                this.parser.setUnits(this.timeColumn, Units.dimensionless);
                u = Units.t2000;
                timeFieldParser = new MultiFieldTimeParser(this.timeColumn, this.timeFormats, this.timeParser, (Units)u);
                for (int i = this.timeColumn; i < this.timeColumn + this.timeFormats.length; ++i) {
                    this.parser.setFieldParser(i, timeFieldParser);
                    this.parser.setUnits(i, Units.dimensionless);
                }
                this.timeColumn = this.timeColumn + this.timeFormats.length - 1;
                if (this.params.get("time") != null) {
                    this.depend0 = this.parser.getFieldNames()[this.timeColumn];
                }
                this.parser.setUnits(this.timeColumn, (Units)u);
            } else {
                this.timeParser = TimeParser.create((String)timeFormat);
                u = Units.t2000;
                this.parser.setUnits(this.timeColumn, (Units)u);
                timeFieldParser = new AsciiParser.FieldParser((Units)u){
                    final /* synthetic */ Units val$u;
                    {
                        this.val$u = units;
                    }

                    public double parseField(String field, int fieldIndex) throws ParseException {
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(this.val$u);
                    }
                };
                this.parser.setFieldParser(this.timeColumn, timeFieldParser);
            }
        } else {
            this.timeParser = null;
        }
        o = (String)this.params.get("depend0");
        if (o != null) {
            this.depend0 = o;
        }
        if ((o = (String)this.params.get("column")) != null) {
            this.column = o;
        }
        if ((o = (String)this.params.get("rank2")) != null) {
            this.rank2 = this.parseRangeStr(o, columnCount);
            this.column = null;
        }
        if ((o = (String)this.params.get("bundle")) != null) {
            this.bundle = this.parseRangeStr(o, columnCount);
            this.column = null;
        }
        if ((o = (String)this.params.get("arg_0")) != null) {
            if (o.equals("rank2")) {
                this.rank2 = new int[]{0, columnCount};
                this.column = null;
            } else if (o.equals("bundle")) {
                this.bundle = new int[]{0, columnCount};
                this.column = null;
            }
        }
        if (this.column == null && this.depend0 == null && this.rank2 == null) {
            if (this.parser.getFieldNames().length == 2) {
                this.depend0 = this.parser.getFieldNames()[0];
                this.column = this.parser.getFieldNames()[1];
            } else {
                this.column = this.parser.getFieldNames()[0];
            }
        }
        if ((o = (String)this.params.get("depend1Labels")) != null) {
            if (o.contains(",")) {
                this.depend1Label = o.split(",");
            } else {
                this.depend1Labels = this.parseRangeStr(o, columnCount);
            }
        }
        if ((o = (String)this.params.get("depend1Values")) != null) {
            this.depend1Values = this.parseRangeStr(o, columnCount);
        }
        if (this.timeColumn == -1 && (s = this.parser.readFirstParseableRecord(this.file.toString())) != null) {
            int icol;
            String field;
            int idep0;
            String[] fields = new String[this.parser.getRecordParser().fieldCount()];
            this.parser.getRecordParser().splitRecord(s, fields);
            if (this.depend0 != null && (idep0 = this.parser.getFieldIndex(this.depend0)) != -1) {
                field = fields[idep0];
                try {
                    TimeUtil.parseTime((String)field);
                    if (new StringTokenizer(field, ":T-/").countTokens() > 1) {
                        this.parser.setUnits(idep0, (Units)Units.us2000);
                        this.parser.setFieldParser(idep0, this.parser.UNITS_PARSER);
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
            if (this.column != null && (icol = this.parser.getFieldIndex(this.column)) != -1) {
                field = fields[icol];
                try {
                    TimeUtil.parseTime((String)field);
                    if (new StringTokenizer(field, ":T-/").countTokens() > 1) {
                        this.parser.setUnits(icol, (Units)Units.us2000);
                        this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
                    }
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        if ((o = (String)this.params.get("units")) != null) {
            String sunits = o;
            Units u = SemanticOps.lookupUnits((String)sunits);
            if (this.column != null) {
                int icol = this.parser.getFieldIndex(this.column);
                this.parser.setUnits(icol, u);
                this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
            }
        }
        if ((o = (String)this.params.get("tail")) != null) {
            MappedByteBuffer buff = new FileInputStream(this.file).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length());
            int tailNum = Integer.parseInt(o);
            int tailCount = 0;
            int ipos = (int)this.file.length();
            boolean foundNonEOL = false;
            while (tailCount < tailNum && ipos > 0) {
                byte ch;
                if ((ch = buff.get(--ipos)) == 10) {
                    if (ipos > 1 && buff.get(ipos - 1) == 13) {
                        --ipos;
                    }
                    if (!foundNonEOL) continue;
                    ++tailCount;
                    continue;
                }
                if (ch == 13) {
                    if (!foundNonEOL) continue;
                    ++tailCount;
                    continue;
                }
                foundNonEOL = true;
            }
            ((ByteBuffer)buff).position(tailCount < tailNum ? 0 : ipos + 1);
            ByteBufferInputStream in = new ByteBufferInputStream((ByteBuffer)buff);
            ds1 = (DDataSet)this.parser.readStream((Reader)new InputStreamReader((InputStream)in), mon);
        } else {
            ds1 = (DDataSet)this.parser.readFile(this.file.toString(), mon);
        }
        return ds1;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String firstRecord;
        if (this.ds == null) {
            return new HashMap<String, Object>();
        }
        Map props = (Map)this.ds.property("USER_PROPERTIES");
        String header = (String)props.get("fileHeader");
        if (header != null) {
            header = header.replaceAll("\t", "\\\\t");
            props.put("fileHeader", header);
        }
        if ((firstRecord = (String)props.get("firstRecord")) != null) {
            firstRecord = firstRecord.replaceAll("\t", "\\\\t");
            props.put("firstRecord", firstRecord);
        }
        ArrayList<String> remove = new ArrayList<String>();
        for (Map.Entry e : props.entrySet()) {
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (v == null || v != null && (v instanceof Number || v instanceof String || v instanceof Datum)) continue;
            remove.add(k);
        }
        for (String k : remove) {
            props.remove(k);
        }
        return props;
    }

    private int columnIndex(String name, int count) {
        if (Pattern.matches("\\d+", name)) {
            return Integer.parseInt(name);
        }
        if (Pattern.matches("-\\d+", name)) {
            return count + Integer.parseInt(name);
        }
        if (Pattern.matches("field\\d+", name)) {
            return Integer.parseInt(name.substring(5));
        }
        int idx = this.parser.getFieldIndex(name);
        return idx;
    }

    private int[] parseRangeStr(String o, int columnCount) throws NumberFormatException {
        String s = o;
        int first = 0;
        int last = columnCount;
        if (s.contains(":")) {
            String[] ss = s.split(":", -2);
            if (ss[0].length() > 0) {
                first = this.columnIndex(ss[0], columnCount);
            }
            if (ss[1].length() > 0) {
                last = this.columnIndex(ss[1], columnCount);
            }
        } else if (s.contains("--")) {
            int isplit = s.indexOf("--", 1);
            if (isplit > 0) {
                first = this.columnIndex(s.substring(0, isplit), columnCount);
            }
            if (isplit < s.length() - 2) {
                last = 1 + this.columnIndex(s.substring(isplit + 1), columnCount);
            }
        } else if (s.contains("-")) {
            String[] ss = s.split("-", -2);
            if (ss[0].length() > 0) {
                first = this.columnIndex(ss[0], columnCount);
            }
            if (ss[1].length() > 0) {
                last = 1 + this.columnIndex(ss[1], columnCount);
            }
        }
        return new int[]{first, last};
    }
}

