/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.text.ParseException;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.virbo.dsutil.AsciiParser;

public class MultiFieldTimeParser
implements AsciiParser.FieldParser {
    StringBuilder agg;
    int firstColumn;
    int lastColumn;
    TimeParser parser;
    Units units;
    String lastDigitFormat;
    boolean[] isNumber;

    private boolean multiFieldAdjacent(String spec) {
        return spec.length() > 3 && spec.charAt(2) == '%' && spec.charAt(3) != '%';
    }

    private int fieldCount(String spec) {
        int count = 0;
        for (int i = 0; i < spec.length(); ++i) {
            if (spec.charAt(i) != '%' || spec.charAt(i + 1) == '%') continue;
            ++count;
        }
        return count;
    }

    private boolean isNumber(String spec) {
        if (spec.equals("%{ignore}")) {
            return false;
        }
        if (spec.equals("%b")) {
            return false;
        }
        return this.fieldCount(spec) == 1;
    }

    MultiFieldTimeParser(int firstColumn, String[] timeFormats, TimeParser parser, Units units) {
        this.firstColumn = firstColumn;
        this.lastColumn = firstColumn + timeFormats.length - 1;
        this.isNumber = new boolean[timeFormats.length];
        this.isNumber[0] = this.isNumber(timeFormats[0]);
        StringBuilder timeFormat = timeFormats[0].length() > 1 && timeFormats[0].charAt(1) != '(' ? (this.multiFieldAdjacent(timeFormats[0]) ? new StringBuilder(timeFormats[0]) : new StringBuilder("%-1").append(timeFormats[0].substring(1))) : new StringBuilder(timeFormats[0]);
        for (int i = 1; i < timeFormats.length - 1; ++i) {
            this.isNumber[i] = this.isNumber(timeFormats[i]);
            if (this.multiFieldAdjacent(timeFormats[i])) {
                timeFormat.append(" ").append(timeFormats[i]);
                continue;
            }
            timeFormat.append(" ").append("%-1").append(timeFormats[i].substring(1));
        }
        if (timeFormats.length > 1 && timeFormats[timeFormats.length - 1].length() < 3) {
            this.lastDigitFormat = timeFormats[timeFormats.length - 1];
            this.isNumber[timeFormats.length - 1] = true;
        } else {
            this.lastDigitFormat = null;
            timeFormat.append(" ").append(timeFormats[timeFormats.length - 1]);
            this.isNumber[timeFormats.length - 1] = false;
        }
        this.parser = TimeParser.create((String)timeFormat.toString());
        this.units = units;
    }

    public double parseField(String field, int columnIndex) throws ParseException {
        double d = -1.0E31;
        if (this.isNumber[columnIndex - this.firstColumn] && (d = Double.parseDouble(field)) - (double)((int)d) == 0.0) {
            field = "" + (int)d;
        }
        if (columnIndex == this.firstColumn) {
            this.agg = new StringBuilder(field);
            return 0.0;
        }
        if (columnIndex < this.lastColumn) {
            if (this.agg == null) {
                throw new ParseException("another field was not parseable", 0);
            }
            this.agg = this.agg.append(" ").append(field);
            return 0.0;
        }
        if (this.agg == null) {
            throw new ParseException("another field was not parseable", 0);
        }
        if (this.lastDigitFormat == null) {
            this.agg = this.agg.append(" ").append(field);
            return this.parser.parse(this.agg.toString()).getTime(this.units);
        }
        this.parser.parse(this.agg.toString());
        this.parser.setDigit(this.lastDigitFormat, Double.parseDouble(field));
        return this.parser.getTime(this.units);
    }
}

