/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.das2Stream;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamTool;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.HtmlResponseIOException;
import org.virbo.datasource.URISplit;
import org.virbo.qstream.QDataSetStreamHandler;
import org.virbo.qstream.StreamException;

public class Das2StreamDataSource
extends AbstractDataSource {
    public Das2StreamDataSource(URI uri) throws IOException {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws FileNotFoundException, org.das2.stream.StreamException, IOException, StreamException {
        InputStream in = DataSetURI.getInputStream((URI)this.uri, (ProgressMonitor)mon);
        ReadableByteChannel channel = Channels.newChannel(in);
        URISplit split = URISplit.parse((URI)this.uri);
        if (split.ext.equals(".qds")) {
            try {
                QDataSetStreamHandler h = new QDataSetStreamHandler();
                org.virbo.qstream.StreamTool.readStream((ReadableByteChannel)channel, (org.virbo.qstream.StreamHandler)h);
                if (this.params.get("arg_0") != null) {
                    return h.getDataSet((String)this.params.get("arg_0"));
                }
                return h.getDataSet();
            }
            catch (StreamException se) {
                String resp;
                int i;
                if (se.toString().contains("Expecting stream descriptor header") && (i = se.toString().indexOf("beginning \n'")) > 0 && se.toString().length() > i + 12 + 5 && DataSourceUtil.isHtmlStream((String)(resp = se.toString().substring(i + 12, i + 12 + 5)))) {
                    throw new HtmlResponseIOException("Expected QStream but got html: " + resp, DataSetURI.getWebURL((URI)this.uri));
                }
                throw se;
            }
        }
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("file", DataSetURI.fromUri((URI)this.uri));
            DataSetStreamHandler handler = new DataSetStreamHandler(props, mon);
            StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)handler);
            in.close();
            return DataSetAdapter.create((DataSet)handler.getDataSet());
        }
        catch (org.das2.stream.StreamException se) {
            String resp;
            int i;
            if (se.toString().contains("Expecting stream descriptor header") && (i = se.toString().indexOf("beginning \n'")) > 0 && se.toString().length() > i + 12 + 5 && DataSourceUtil.isHtmlStream((String)(resp = se.toString().substring(i + 12, i + 12 + 5)))) {
                throw new HtmlResponseIOException("Expected das2Stream but got html: " + resp, DataSetURI.getWebURL((URI)this.uri));
            }
            throw se;
        }
    }
}

