/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.spase;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.MetadataModel;
import org.virbo.metatree.SpaseMetadataModel;
import org.virbo.spase.DOMWalker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaseRecordDataSource
implements DataSource {
    URL url;
    Document document;
    DataSource delegate;

    public SpaseRecordDataSource(URI uri) throws IllegalArgumentException, IOException, SAXException, Exception {
        try {
            this.url = new URL(uri.getSchemeSpecificPart());
        }
        catch (MalformedURLException ex) {
            System.err.println("Failed to convert URI to URL");
            throw new RuntimeException(ex);
        }
        this.readXML();
        String surl = null;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            surl = this.findSurl();
            this.delegate = DataSetURI.getDataSource((URI)DataSetURI.getURIValid((String)surl));
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("unable to get /Spase/NumericalData/AccessInformation/AccessURL/URL(): " + ex.getMessage());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Spase record AccessURL is malformed: " + surl);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private String findSurl() {
        String[] lookFor = new String[]{"Spase", "NumericalData", "AccessInformation", "AccessURL", "URL"};
        NodeList list = this.document.getElementsByTagName(lookFor[0]);
        Element pos = (Element)list.item(0);
        if (pos == null) {
            throw new IllegalArgumentException("Unable to find node Space/NumericalData/AccessInformation/AccessURL/URL in " + this.url);
        }
        for (int i = 1; i < lookFor.length; ++i) {
            list = pos.getElementsByTagName(lookFor[i]);
            pos = (Element)list.item(0);
        }
        String result = null;
        list = pos.getChildNodes();
        for (int k = 0; k < list.getLength(); ++k) {
            Node child = list.item(k);
            if (child.getNodeType() != 3) continue;
            result = child.getNodeValue();
        }
        return result;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        return this.delegate.getDataSet(mon);
    }

    public boolean asynchronousLoad() {
        return this.delegate.asynchronousLoad();
    }

    private void readXML() throws IOException, SAXException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        InputSource source = new InputSource(this.url.openStream());
        this.document = builder.parse(source);
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        DocumentTraversal traversal = (DocumentTraversal)((Object)this.document);
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        int whatToShow = -129;
        Node root = this.document.getFirstChild();
        TreeWalker walker = traversal.createTreeWalker(root, whatToShow, filter, false);
        DOMWalker walk = new DOMWalker(walker);
        return walk.getAttributes(walk.getRoot());
    }

    public String getURI() {
        return this.url.toString();
    }

    public Map<String, Object> getProperties() {
        try {
            return new SpaseMetadataModel().properties(this.getMetadata((ProgressMonitor)new NullProgressMonitor()));
        }
        catch (Exception ex) {
            return Collections.singletonMap("Exception", ex);
        }
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    public MetadataModel getMetadataModel() {
        return new SpaseMetadataModel();
    }
}

