/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.csv;

import com.csvreader.CsvReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.csv.TableOps;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.DataSetBuilder;

public class CsvDataSource
extends AbstractDataSource {
    public CsvDataSource(URI uri) {
        super(uri);
    }

    QDataSet parseHeader(int icol, String header, String sval) {
        header = header.trim();
        DDataSet result = DDataSet.create((int[])new int[0]);
        Units u = CsvDataSource.guessUnits(sval);
        if (u != Units.dimensionless) {
            result.putProperty("UNITS", (Object)u);
        }
        if (UnitsUtil.isTimeLocation((Units)u)) {
            result.putProperty("NAME", (Object)"UTC");
        }
        if (header.length() == 0) {
            try {
                result.putValue(u.parse(sval).doubleValue(u));
            }
            catch (ParseException ex) {
                Logger.getLogger(CsvDataSource.class.getName()).log(Level.SEVERE, null, ex);
            }
            return result;
        }
        Pattern p = Pattern.compile("([a-zA-Z0-9\\-\\+ ]*)(\\(([a-zA-Z-0-9\\-\\+ ]*)\\))?");
        Matcher m = p.matcher(header);
        if (m.matches()) {
            String label = m.group(1).trim();
            String sunits = m.group(3);
            if (header.length() > 0) {
                result.putProperty("NAME", (Object)Ops.safeName((String)label));
            }
            result.putProperty("LABEL", (Object)label);
            if (sunits != null) {
                result.putProperty("UNITS", (Object)SemanticOps.lookupUnits((String)sunits.trim()));
            }
        }
        return result;
    }

    private static Units guessUnits(String sval) {
        try {
            Units.dimensionless.parse(sval);
            return Units.dimensionless;
        }
        catch (Exception ex) {
            try {
                Units.us2000.parse(sval);
                return Units.us2000;
            }
            catch (Exception exception) {
                return EnumerationUnits.create((Object)"enum");
            }
        }
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        int idep0column;
        int[] cols;
        int icolumn;
        String column;
        InputStream in = DataSetURI.getInputStream((URI)this.uri, (ProgressMonitor)mon);
        CsvReader reader = new CsvReader((Reader)new InputStreamReader(in));
        int ncol = -1;
        String[] headers = null;
        if (reader.readHeaders()) {
            ncol = reader.getHeaderCount();
            headers = reader.getHeaders();
        }
        if ((column = this.getParam("column", null)) == null) {
            icolumn = ncol == -1 ? -1 : ncol - 1;
        } else {
            icolumn = TableOps.columnIndex(column, headers);
            if (icolumn == -1) {
                throw new IllegalArgumentException("column not found: " + column);
            }
        }
        QDataSet icolumnDs = null;
        String bundle = this.getParam("bundle", null);
        if (bundle == null) {
            cols = null;
        } else {
            cols = TableOps.parseRangeStr(bundle, headers);
            icolumn = cols[0];
        }
        String dep0column = this.getParam("depend0", null);
        if (dep0column == null) {
            idep0column = -1;
        } else {
            idep0column = TableOps.columnIndex(dep0column, headers);
            if (idep0column == -1) {
                throw new IllegalArgumentException("column not found: " + dep0column);
            }
        }
        QDataSet dep0ds = null;
        Units dep0u = Units.dimensionless;
        Units u = Units.dimensionless;
        int hline = 2;
        double tb = 0.0;
        double cb = 0.0;
        double[] bundleb = null;
        if (cols != null) {
            bundleb = new double[cols[1] - cols[0]];
        }
        DataSetBuilder builder = bundleb != null ? new DataSetBuilder(2, 100, bundleb.length) : new DataSetBuilder(1, 100);
        DataSetBuilder tbuilder = new DataSetBuilder(1, 100);
        mon.setTaskSize(-1L);
        mon.started();
        int line = 0;
        while (reader.readRecord()) {
            mon.setProgressMessage("read line " + ++line);
            if (hline > 0) {
                if (icolumn == -1) {
                    icolumn = reader.getColumnCount() - 1;
                    headers = new String[reader.getColumnCount()];
                    for (int i = 0; i < reader.getColumnCount(); ++i) {
                        headers[i] = "column_" + i;
                    }
                }
                if (idep0column == -1 && reader.getColumnCount() == 2) {
                    idep0column = 0;
                }
                Units oldDep0u = dep0u;
                Units oldU = u;
                if (idep0column >= 0 && !(dep0u instanceof TimeLocationUnits)) {
                    dep0ds = this.parseHeader(idep0column, reader.getHeader(idep0column), reader.get(idep0column));
                    dep0u = SemanticOps.getUnits((QDataSet)dep0ds);
                }
                if (!(u instanceof TimeLocationUnits)) {
                    icolumnDs = this.parseHeader(icolumn, reader.getHeader(icolumn), reader.get(icolumn));
                    u = SemanticOps.getUnits((QDataSet)icolumnDs);
                }
                if (--hline == 0 && (oldDep0u != dep0u || oldU != u)) {
                    builder = bundleb != null ? new DataSetBuilder(2, 100, bundleb.length) : new DataSetBuilder(1, 100);
                    tbuilder = new DataSetBuilder(1, 100);
                }
            }
            try {
                if (idep0column >= 0) {
                    tb = dep0u instanceof EnumerationUnits ? ((EnumerationUnits)dep0u).createDatum((Object)reader.get(idep0column)).doubleValue(dep0u) : dep0u.parse(reader.get(idep0column)).doubleValue(dep0u);
                }
                if (bundleb != null) {
                    for (int j = 0; j < bundleb.length; ++j) {
                        bundleb[j] = u instanceof EnumerationUnits ? ((EnumerationUnits)u).createDatum((Object)reader.get(icolumn + j)).doubleValue(u) : u.parse(reader.get(icolumn + j)).doubleValue(u);
                    }
                } else {
                    cb = u instanceof EnumerationUnits ? ((EnumerationUnits)u).createDatum((Object)reader.get(icolumn)).doubleValue(u) : u.parse(reader.get(icolumn)).doubleValue(u);
                }
            }
            catch (ParseException ex) {
                System.err.println("skipping line: " + reader.getRawRecord());
                continue;
            }
            if (idep0column >= 0) {
                tbuilder.putValue(-1, tb);
                tbuilder.nextRecord();
            }
            if (bundleb != null) {
                for (int j = 0; j < bundleb.length; ++j) {
                    builder.putValue(-1, j, bundleb[j]);
                }
                builder.nextRecord();
            } else {
                builder.putValue(-1, cb);
                builder.nextRecord();
            }
            ++line;
        }
        mon.finished();
        DDataSet ds = builder.getDataSet();
        if (idep0column >= 0) {
            DDataSet tds = tbuilder.getDataSet();
            tds.putProperty("UNITS", (Object)dep0u);
            tds.putProperty("NAME", dep0ds.property("NAME"));
            tds.putProperty("LABEL", dep0ds.property("LABEL"));
            ds.putProperty("DEPEND_0", (Object)tds);
        }
        ds.putProperty("UNITS", (Object)u);
        ds.putProperty("NAME", icolumnDs.property("NAME"));
        ds.putProperty("LABEL", icolumnDs.property("LABEL"));
        return ds;
    }
}

