/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableMaker {
    DataSetBuilder builder = null;
    QDataSet desc = null;
    List<Units> units = null;
    List<String> labels = null;
    List<String> names = null;
    EnumerationUnits enumeration = EnumerationUnits.create((Object)"html");
    NumberFormat nf = DecimalFormat.getInstance(Locale.US);
    int fieldCount = -1;

    void addRecord(List<String> values) {
        if (this.fieldCount == -1) {
            return;
        }
        for (int i = 0; i < this.fieldCount; ++i) {
            String field = values.get(i);
            if (field.trim().length() == 0) {
                this.builder.putValue(-1, i, this.builder.getFillValue());
                continue;
            }
            try {
                double d = this.nf.parse(field).doubleValue();
                this.builder.putValue(-1, i, d);
                continue;
            }
            catch (ParseException ex) {
                try {
                    Date d = SimpleDateFormat.getDateInstance().parse(field);
                    this.builder.putValue(-1, i, (double)d.getTime());
                    this.units.set(i, (Units)Units.t1970);
                    continue;
                }
                catch (ParseException ex2) {
                    this.builder.putValue(-1, i, this.enumeration.createDatum((Object)field).doubleValue((Units)this.enumeration));
                    this.units.set(i, (Units)this.enumeration);
                }
            }
        }
        this.builder.nextRecord();
    }

    void initialize(List<String> values) {
        int i;
        this.fieldCount = values.size();
        this.builder = new DataSetBuilder(2, 100, this.fieldCount);
        this.units = new ArrayList<Units>(this.fieldCount);
        for (i = 0; i < this.fieldCount; ++i) {
            this.units.add(i, Units.dimensionless);
        }
        this.labels = new ArrayList<String>(this.fieldCount);
        this.names = new ArrayList<String>(this.fieldCount);
        if (this.labels.size() == 0) {
            for (i = 0; i < this.fieldCount; ++i) {
                this.labels.add(i, values.get(i));
                this.names.add(i, Ops.safeName((String)values.get(i)));
            }
        }
    }

    void addHeader(List<String> values) {
        if (this.fieldCount == -1) {
            this.initialize(values);
        }
    }

    void addUnits(List<String> units) {
    }

    void addUnits(int icol, String units) {
    }

    private QDataSet getBundleDescriptor() {
        return new AbstractDataSet(){

            public int rank() {
                return 2;
            }

            public Object property(String name, int i) {
                if (name.equals("LABEL")) {
                    return AsciiTableMaker.this.labels.get(i);
                }
                if (name.equals("NAME")) {
                    return AsciiTableMaker.this.names.get(i);
                }
                if (name.equals("UNITS")) {
                    return AsciiTableMaker.this.units.get(i);
                }
                return this.property(name);
            }

            public double value(int i0, int i1) {
                return 0.0;
            }

            public int length() {
                return AsciiTableMaker.this.labels.size();
            }

            public int length(int i) {
                return 0;
            }
        };
    }

    DDataSet getDataSet() {
        if (this.builder == null) {
            throw new IllegalArgumentException("no records found");
        }
        DDataSet result = this.builder.getDataSet();
        this.desc = this.getBundleDescriptor();
        result.putProperty("BUNDLE_1", (Object)this.desc);
        return result;
    }
}

