/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.virbo.ascii.AsciiTableTableModel;
import org.virbo.ascii.ColSpanTableCellRenderer;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.ui.TableRowHeader;
import org.virbo.dsutil.AsciiHeadersParser;
import org.virbo.dsutil.AsciiParser;
import org.virbo.dsutil.AutoHistogram;
import org.virbo.dsutil.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    AsciiTableTableModel model;
    Map<Integer, String> columns;
    AsciiParser parser;
    boolean focusDep0 = false;
    TableCellRenderer defaultCellRenderer;
    private static final String PARAMS_KEY_COMMENT = "comment";
    Tool currentTool = Tool.NONE;
    JToggleButton currentToolButton;
    URISplit split = null;
    Map<String, String> params;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected int skipLines = 0;
    public static final String PROP_FIRST_ROW = "skipLines";
    protected String column = "field0";
    public static final String PROP_COLUMN = "column";
    protected String dep0 = "";
    public static final String PROP_DEP0 = "dep0";
    public JCheckBox bundleCheckBox;
    public JComboBox columnsComboBox;
    public JComboBox commentComboBox;
    public JComboBox dep0Columns;
    public JCheckBox dep0timeCheckBox;
    public JTextField fillValueTextField;
    public JButton guessFillButton;
    public JToggleButton guessTimeFormatToggleButton;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JLabel jLabel8;
    public JLabel jLabel9;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel3;
    public JScrollPane jScrollPane1;
    public JSeparator jSeparator1;
    public JTabbedPane jTabbedPane1;
    public JTable jTable1;
    public JToggleButton jToggleButton1;
    public JToggleButton jToggleButton2;
    public JToggleButton jToggleButton3;
    public JToggleButton jToggleButton4;
    public JFormattedTextField skipLinesTextField;
    public JComboBox timeFormatFieldsComboBox;
    public JTextField timeFormatTextField;
    public JToggleButton timeFormatToggleButton;
    public JTextField validMaxTextField;
    public JTextField validMinTextField;

    Action createToolAction(String label, final Tool t) {
        return new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    if (AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().isSelectionEmpty()) {
                        AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        AsciiTableDataSourceEditorPanel.this.currentTool = t;
                    } else {
                        AsciiTableDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        AsciiTableDataSourceEditorPanel.this.currentTool = t;
                        AsciiTableDataSourceEditorPanel.this.doSelect(t);
                        AsciiTableDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        AsciiTableDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
            }
        };
    }

    private void doSelect(Tool tool) {
        switch (tool) {
            case SKIPLINES: {
                if (this.jTable1.getSelectedRow() == -1) break;
                this.setSkipLines(this.jTable1.getSelectedRow());
                this.clearTool();
            }
        }
        if (this.jTable1.getColumnModel().getSelectedColumnCount() != 0) {
            if (this.jTable1.getColumnModel().getSelectedColumnCount() == 1) {
                int col = this.jTable1.getColumnModel().getSelectedColumns()[0];
                String name = this.columns.get(col);
                if (name == null) {
                    name = "field" + col;
                }
                if (tool == Tool.DEPEND_0) {
                    this.setDep0(name);
                } else if (tool == Tool.COLUMN) {
                    this.setColumn(name);
                } else if (tool == Tool.TIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    String val = this.timeFormatTextField.getText() + (String)this.jTable1.getModel().getValueAt(row, col);
                    this.timeFormatTextField.setText(val);
                } else if (tool == Tool.GUESSTIMEFORMAT) {
                    int row = this.jTable1.getSelectedRow();
                    String val = (String)this.jTable1.getModel().getValueAt(row, col);
                    this.timeFormatTextField.setText(val);
                    this.guessTimeFormatButtonAP();
                } else if (tool == Tool.FILLVALUE) {
                    int row = this.jTable1.getSelectedRow();
                    String val = (String)this.jTable1.getModel().getValueAt(row, col);
                    if (val.contains("+")) {
                        val = "" + Double.parseDouble(val);
                    }
                    this.fillValueTextField.setText(val);
                }
            } else {
                int[] cols = this.jTable1.getColumnModel().getSelectedColumns();
                int first = cols[0];
                int last = cols[cols.length - 1];
                String sfirst = this.columns.get(first);
                if (sfirst == null) {
                    sfirst = "" + first;
                }
                boolean haveColumnNames = true;
                String slast = this.columns.get(last);
                if (slast == null) {
                    slast = "" + last;
                    haveColumnNames = false;
                }
                if (tool != Tool.DEPEND_0) {
                    if (tool == Tool.COLUMN) {
                        if (haveColumnNames) {
                            this.setColumn(sfirst + "-" + slast);
                        } else {
                            this.setColumn("" + first + ":" + (last + 1));
                        }
                    } else if (tool == Tool.TIMEFORMAT) {
                        int row = this.jTable1.getSelectedRow();
                        StringBuilder val = new StringBuilder(this.timeFormatTextField.getText());
                        val.append(this.jTable1.getModel().getValueAt(row, first));
                        for (int icol = first + 1; icol <= last; ++icol) {
                            val.append("+").append(this.jTable1.getModel().getValueAt(row, icol));
                        }
                        this.timeFormatTextField.setText(val.toString());
                        this.dep0timeCheckBox.setSelected(true);
                        this.setDep0(this.columns.get(first));
                    } else if (tool == Tool.GUESSTIMEFORMAT) {
                        int row = this.jTable1.getSelectedRow();
                        StringBuilder val = new StringBuilder();
                        val.append(this.jTable1.getModel().getValueAt(row, first));
                        for (int icol = first + 1; icol <= last; ++icol) {
                            val.append("+").append(this.jTable1.getModel().getValueAt(row, icol));
                        }
                        this.timeFormatTextField.setText(val.toString());
                        this.dep0timeCheckBox.setSelected(true);
                        this.setDep0(this.columns.get(first));
                        this.guessTimeFormatButtonAP();
                    }
                }
            }
        }
        Tool oldTool = tool;
        this.clearTool();
        if (oldTool != Tool.NONE) {
            this.jTable1.getSelectionModel().clearSelection();
            this.jTable1.getColumnModel().getSelectionModel().clearSelection();
        }
    }

    public AsciiTableDataSourceEditorPanel() {
        this.initComponents();
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "ascii_main");
        this.columnsComboBox.requestFocusInWindow();
        this.parser = new AsciiParser();
        this.model = new AsciiTableTableModel();
        this.model.setParser(this.parser);
        this.jTable1.setModel(this.model);
        this.defaultCellRenderer = this.jTable1.getDefaultRenderer(Object.class);
        this.jTable1.setDefaultRenderer(Object.class, new ColSpanTableCellRenderer());
        this.jScrollPane1.setRowHeaderView((Component)new TableRowHeader(this.jTable1));
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (AsciiTableDataSourceEditorPanel.this.columns != null) {
                    AsciiTableDataSourceEditorPanel.this.updateColumns();
                }
                AsciiTableDataSourceEditorPanel.this.jTable1.repaint();
            }
        });
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsciiTableDataSourceEditorPanel.this.doSelect(AsciiTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AsciiTableDataSourceEditorPanel.this.doSelect(AsciiTableDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                int i = AsciiTableDataSourceEditorPanel.this.jTable1.getTableHeader().columnAtPoint(e.getPoint());
                String name = AsciiTableDataSourceEditorPanel.this.columns.get(i);
                if (AsciiTableDataSourceEditorPanel.this.currentTool == Tool.DEPEND_0) {
                    AsciiTableDataSourceEditorPanel.this.setDep0(name);
                    AsciiTableDataSourceEditorPanel.this.clearTool();
                } else if (AsciiTableDataSourceEditorPanel.this.currentTool == Tool.COLUMN) {
                    AsciiTableDataSourceEditorPanel.this.setColumn(name);
                    AsciiTableDataSourceEditorPanel.this.clearTool();
                }
            }
        });
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_FIRST_ROW), (Object)this.skipLinesTextField, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_COLUMN), (Object)this.columnsComboBox, (Property)BeanProperty.create((String)"selectedItem")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)BeanProperty.create((String)PROP_DEP0), (Object)this.dep0Columns, (Property)BeanProperty.create((String)"selectedItem")));
        bc.bind();
    }

    private void clearTool() {
        if (this.currentTool != Tool.NONE) {
            this.currentTool = Tool.NONE;
            this.currentToolButton.setSelected(false);
            this.currentToolButton = null;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.skipLinesTextField = new JFormattedTextField();
        this.jToggleButton1 = new JToggleButton();
        this.jLabel5 = new JLabel();
        this.commentComboBox = new JComboBox();
        this.jPanel3 = new JPanel();
        this.timeFormatTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.timeFormatFieldsComboBox = new JComboBox();
        this.timeFormatToggleButton = new JToggleButton();
        this.jLabel9 = new JLabel();
        this.guessTimeFormatToggleButton = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dep0Columns = new JComboBox();
        this.columnsComboBox = new JComboBox();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.dep0timeCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fillValueTextField = new JTextField();
        this.validMinTextField = new JTextField();
        this.validMaxTextField = new JTextField();
        this.jToggleButton4 = new JToggleButton();
        this.guessFillButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.bundleCheckBox = new JCheckBox();
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("Skip Lines:");
        this.jLabel1.setToolTipText("Skip this many lines before attempting to parse data.  Note if the first line contains parsable column labels, they will be used to identify each column.\n");
        this.skipLinesTextField.setText("11");
        this.skipLinesTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.skipLinesTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.skipLinesTextFieldFocusLost(evt);
            }
        });
        this.jToggleButton1.setAction(this.createToolAction("skiplines", Tool.SKIPLINES));
        this.jToggleButton1.setText("Select");
        this.jToggleButton1.setToolTipText("Select the first row to parse as data or column headers.");
        this.jLabel5.setText("Comment Prefix:");
        this.jLabel5.setToolTipText("Select a character that is the beginning of records that can be ignored.  \n");
        this.commentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"# hash", "; semicolon", "none", ""}));
        this.commentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.commentComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.skipLinesTextField, -2, 47, -2).add(18, 18, 18).add((Component)this.jToggleButton1)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.commentComboBox, -2, 109, -2))).addContainerGap(528, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.skipLinesTextField, -2, -1, -2).add((Component)this.jToggleButton1).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.commentComboBox, -2, -1, -2).add((Component)this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("header", this.jPanel2);
        this.jLabel2.setText("Time Format:");
        this.jLabel2.setToolTipText("<html>Specify the format of time strings, such as \"%Y %m %d.\"<br>\nPluses join adjectent fields, and the droplist to the right<br>\ncan be used to select field types.  The Guess button attempts <br>\nto guess the format of selected fields.</html>\n");
        this.timeFormatFieldsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"select field type...", "$Y: four digit year", "$y: two digit year", "$m: two-digit month", "$b: month name", "$d: two-digit day of month", "$j: three-digit day of year", "$H: two-digit hour", "$M: two-digit minute", "$S: two-digit second", "$(milli): three-digit milliseconds", "$(micro): three-digit microseconds", "$(ignore): ignore this field", " "}));
        this.timeFormatFieldsComboBox.setToolTipText("Use this droplist to select a field type, and the Select button copies the field type to the Time Format text field.");
        this.timeFormatFieldsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.timeFormatFieldsComboBoxActionPerformed(evt);
            }
        });
        this.timeFormatToggleButton.setAction(this.createToolAction("timeFormat", Tool.TIMEFORMAT));
        this.timeFormatToggleButton.setText("Select");
        this.timeFormatToggleButton.setToolTipText("Select column or range of columns which contain the times.  These column values will be copied into the time format and you will have to create a template.");
        this.jLabel9.setText("<html><em>Specify time format (e.g. $Y$m+$d) when times are not iso8601 or span multiple fields.</em></html>");
        this.guessTimeFormatToggleButton.setAction(this.createToolAction("guessTimeFormat", Tool.GUESSTIMEFORMAT));
        this.guessTimeFormatToggleButton.setText("Guess");
        this.guessTimeFormatToggleButton.setToolTipText("<html>Scan the selected columns and try to identify field types.<br> This uses the number of digits in each field to identify the type<br> (e.g. 3 digits implies day of year), so select the cells accordingly.</html>");
        this.guessTimeFormatToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.guessTimeFormatToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel9, -2, -1, -2).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.timeFormatTextField, -2, 221, -2).addPreferredGap(0).add((Component)this.timeFormatFieldsComboBox, -2, 167, -2).addPreferredGap(0).add((Component)this.timeFormatToggleButton).addPreferredGap(0).add((Component)this.guessTimeFormatToggleButton))).addContainerGap(149, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel9, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.timeFormatTextField, -2, -1, -2).add((Component)this.timeFormatFieldsComboBox, -2, -1, -2).add((Component)this.timeFormatToggleButton).add((Component)this.jLabel2).add((Component)this.guessTimeFormatToggleButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("times", this.jPanel3);
        this.jLabel3.setText("Column(s):");
        this.jLabel3.setToolTipText("Select the column to plot.  Multiple, adjacent columns can be plotted as a spectrogram by using the colon or dash character\n");
        this.jLabel4.setText("Depends On:");
        this.jLabel4.setToolTipText("Select the variable that is the independent parameter that Columns depends on.  Note ISO8601 times are handled, or use the \"times\" tab to specify a time format.\n");
        this.dep0Columns.setEditable(true);
        this.dep0Columns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dep0Columns.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AsciiTableDataSourceEditorPanel.this.dep0ColumnsItemStateChanged(evt);
            }
        });
        this.dep0Columns.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.dep0ColumnsFocusGained(evt);
            }
        });
        this.columnsComboBox.setEditable(true);
        this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AsciiTableDataSourceEditorPanel.this.columnsComboBoxItemStateChanged(evt);
            }
        });
        this.columnsComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.columnsComboBoxFocusGained(evt);
            }
        });
        this.jToggleButton2.setAction(this.createToolAction(PROP_COLUMN, Tool.COLUMN));
        this.jToggleButton2.setText("Select");
        this.jToggleButton2.setToolTipText("Select column or range of columns");
        this.jToggleButton3.setAction(this.createToolAction("depend0", Tool.DEPEND_0));
        this.jToggleButton3.setText("Select");
        this.jToggleButton3.setToolTipText("Select the column that is the independent variable on which the data values depend.");
        this.dep0timeCheckBox.setText("time");
        this.dep0timeCheckBox.setToolTipText("If selected, then the field should be parsed as a time.\n");
        this.jLabel6.setText("Fill Value:");
        this.jLabel6.setToolTipText("This numeric value will be treated as fill.  Note non-numeric values are automatically handled as fill.\n");
        this.jLabel7.setText("Valid Min:");
        this.jLabel7.setToolTipText("Numbers below this value are treated as invalid.\n");
        this.jLabel8.setText("Valid Max:");
        this.jLabel8.setToolTipText("Numbers above this value are treated as invalid.");
        this.fillValueTextField.setText(" ");
        this.fillValueTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                AsciiTableDataSourceEditorPanel.this.fillValueTextFieldFocusLost(evt);
            }
        });
        this.validMinTextField.setText("   ");
        this.validMaxTextField.setText("    ");
        this.validMaxTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.validMaxTextFieldActionPerformed(evt);
            }
        });
        this.jToggleButton4.setAction(this.createToolAction("fillValue", Tool.FILLVALUE));
        this.jToggleButton4.setText("Select");
        this.jToggleButton4.setToolTipText("Click on a value to be treated as fill (invalid)");
        this.guessFillButton.setText("Guess");
        this.guessFillButton.setToolTipText("try to guess the fill value by looking for an outlier.");
        this.guessFillButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AsciiTableDataSourceEditorPanel.this.guessFillButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.bundleCheckBox.setText("bundle");
        this.bundleCheckBox.setToolTipText("<html>Range of columns should be treated as a bundle of parameters, like X, Y, Z.  When plotted, these will result in separate traces instead of a spectrogram.</html>");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.dep0Columns, 0, -1, Short.MAX_VALUE).add((Component)this.columnsComboBox, 0, 166, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.bundleCheckBox).addPreferredGap(0).add((Component)this.jToggleButton2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.dep0timeCheckBox).addPreferredGap(0).add((Component)this.jToggleButton3))).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jLabel6).add(18, 18, 18).add((Component)this.fillValueTextField, -2, 69, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.validMinTextField, -1, 69, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.validMaxTextField, -2, 68, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jToggleButton4).addPreferredGap(0).add((Component)this.guessFillButton))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.fillValueTextField, this.validMaxTextField, this.validMinTextField}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.columnsComboBox, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.dep0Columns, -2, -1, -2).add((Component)this.jLabel4))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jToggleButton4).add((Component)this.guessFillButton).add((Component)this.fillValueTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jLabel8).add((Component)this.validMinTextField, -2, -1, -2).add((Component)this.validMaxTextField, -2, -1, -2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jSeparator1, -2, 55, -2)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jToggleButton2).add((Component)this.bundleCheckBox)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.dep0timeCheckBox).add((Component)this.jToggleButton3)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("data", this.jPanel1);
        this.jTabbedPane1.setSelectedIndex(2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 780, Short.MAX_VALUE).add((Component)this.jTabbedPane1));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTabbedPane1, -2, 112, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 342, Short.MAX_VALUE)));
    }

    private void columnsComboBoxItemStateChanged(ItemEvent evt) {
        this.setColumn((String)this.columnsComboBox.getSelectedItem());
    }

    private void dep0ColumnsItemStateChanged(ItemEvent evt) {
        this.setDep0((String)this.dep0Columns.getSelectedItem());
    }

    private void columnsComboBoxFocusGained(FocusEvent evt) {
        this.focusDep0 = false;
    }

    private void dep0ColumnsFocusGained(FocusEvent evt) {
        this.focusDep0 = true;
    }

    private void skipLinesTextFieldFocusGained(FocusEvent evt) {
    }

    private void skipLinesTextFieldFocusLost(FocusEvent evt) {
    }

    private void timeFormatFieldsComboBoxActionPerformed(ActionEvent evt) {
        String s = (String)this.timeFormatFieldsComboBox.getSelectedItem();
        int i = s.indexOf(":");
        String insert = s.substring(0, i);
        int i0 = this.timeFormatTextField.getCaret().getDot();
        int i1 = this.timeFormatTextField.getCaret().getMark();
        if (i1 < i0) {
            int t = i0;
            i0 = i1;
            i1 = t;
        }
        String text = this.timeFormatTextField.getText();
        String n = text.substring(0, i0) + insert + text.substring(i1);
        this.timeFormatTextField.setText(n);
        this.timeFormatFieldsComboBox.setSelectedIndex(0);
    }

    private void commentComboBoxActionPerformed(ActionEvent evt) {
        String value = (String)this.commentComboBox.getSelectedItem();
        if (value.equals("# hash")) {
            this.params.remove(PARAMS_KEY_COMMENT);
            this.parser.setCommentPrefix("#");
            this.update();
        } else if (value.equals("none") || value.trim().equals("")) {
            this.params.put(PARAMS_KEY_COMMENT, "");
            this.parser.setCommentPrefix(null);
            this.update();
        } else {
            int i = value.indexOf(" ");
            String prefix = i == -1 ? value : value.substring(0, i);
            this.params.put(PARAMS_KEY_COMMENT, prefix);
            this.parser.setCommentPrefix(prefix);
            this.update();
        }
    }

    private int[] getDataColumns() {
        int[] result = new int[2];
        String scol = this.column;
        String ecol = this.column;
        if (this.column.contains("-")) {
            int i = this.column.indexOf("-");
            ecol = this.column.substring(i + 1);
        }
        for (Map.Entry<Integer, String> e : this.columns.entrySet()) {
            if (e.getValue().equals(scol)) {
                result[0] = e.getKey();
            }
            if (!e.getValue().equals(ecol)) continue;
            result[1] = e.getKey();
        }
        return result;
    }

    private void guessFillButtonActionPerformed(ActionEvent evt) {
        this.fillValueTextField.setText("moment...");
        this.guessFillButton.setEnabled(false);
        Runnable run = new Runnable(){

            public void run() {
                NullProgressMonitor mon = null;
                try {
                    DataSetBuilder builder = new DataSetBuilder(1, 100);
                    int[] cols = AsciiTableDataSourceEditorPanel.this.getDataColumns();
                    mon = new NullProgressMonitor();
                    mon.setTaskSize((long)AsciiTableDataSourceEditorPanel.this.model.getRowCount());
                    mon.started();
                    for (int i = 0; i < AsciiTableDataSourceEditorPanel.this.model.getRowCount(); ++i) {
                        mon.setTaskProgress((long)i);
                        for (int j = cols[0]; j <= cols[1]; ++j) {
                            try {
                                builder.putValue(-1, Double.parseDouble(String.valueOf(AsciiTableDataSourceEditorPanel.this.model.getValueAt(i, j))));
                                builder.nextRecord();
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    mon.finished();
                    AutoHistogram ah = new AutoHistogram();
                    QDataSet hist = ah.doit((QDataSet)builder.getDataSet());
                    Map outliers = (Map)DataSetUtil.getUserProperty((QDataSet)hist, (String)"outliers");
                    if (outliers != null && outliers.size() == 1) {
                        AsciiTableDataSourceEditorPanel.this.fillValueTextField.setText(String.valueOf(outliers.keySet().iterator().next()));
                    } else {
                        AsciiTableDataSourceEditorPanel.this.fillValueTextField.setText("");
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    if (mon != null) {
                        mon.finished();
                    }
                    AsciiTableDataSourceEditorPanel.this.guessFillButton.setEnabled(true);
                }
            }
        };
        new Thread(run).start();
    }

    private void validMaxTextFieldActionPerformed(ActionEvent evt) {
    }

    private void guessTimeFormatButtonAP() {
        String text = this.timeFormatTextField.getText().trim();
        String[] ss = text.split("\\+");
        int curr = 1;
        StringBuilder template = new StringBuilder();
        boolean giveUp = false;
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i];
            boolean isInt = true;
            int intVal = -1;
            try {
                intVal = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                isInt = false;
            }
            int slen = s.length();
            int ocurr = curr;
            if (s.startsWith("$")) {
                giveUp = true;
            }
            if (!giveUp) {
                if (curr == 1) {
                    if (slen == 4) {
                        template.append("$Y");
                        curr = 2;
                    } else if (slen == 2) {
                        template.append("$y");
                        curr = 2;
                    } else if (slen == 8) {
                        template.append("$Y$m$d");
                        curr = 4;
                    } else if (slen == 7) {
                        template.append("$Y$j");
                        curr = 4;
                    }
                } else if (curr == 2) {
                    if (slen <= 2 && isInt && intVal <= 12) {
                        template.append("$m");
                        curr = 3;
                    } else if (slen == 3) {
                        if (Character.isDigit(s.charAt(0))) {
                            template.append("$j");
                            curr = 4;
                        } else {
                            template.append("$b");
                            curr = 3;
                        }
                    } else if (isInt && intVal > 12) {
                        template.append("$j");
                        curr = 4;
                    }
                } else if (curr == 3) {
                    if (slen <= 2) {
                        template.append("$d");
                        curr = 4;
                    }
                } else if (curr == 4) {
                    if (slen <= 2) {
                        template.append("$H");
                        curr = 5;
                    }
                } else if (curr == 5) {
                    if (slen <= 2) {
                        template.append("$M");
                        curr = 6;
                    }
                } else if (curr == 6) {
                    template.append("$S");
                    curr = 7;
                }
            }
            if (curr == ocurr) {
                template.append(s);
                giveUp = true;
            }
            if (i >= ss.length - 1) continue;
            template.append("+");
        }
        this.timeFormatTextField.setText(template.toString());
    }

    private void fillValueTextFieldFocusLost(FocusEvent evt) {
        String val = this.fillValueTextField.getText();
        if (val.trim().length() > 0) {
            try {
                double d = Double.parseDouble(val);
                if (val.contains("+")) {
                    this.fillValueTextField.setText(String.valueOf(d));
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Only enter numbers here.  Non-numbers are treated as fill.");
            }
        }
    }

    private void guessTimeFormatToggleButtonActionPerformed(ActionEvent evt) {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.model.setFile(file);
    }

    public Map<Integer, String> getColumnNames() throws IOException {
        String[] lcolumns = this.parser.getFieldNames();
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < lcolumns.length; ++i) {
            result.put(i, lcolumns[i]);
        }
        return result;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(int row) {
        int oldRow = this.skipLines;
        this.skipLines = row;
        Rectangle rect = this.jTable1.getCellRect(Math.max(0, this.getSkipLines() - 3), 0, true);
        this.parser.setSkipLines(this.skipLines);
        this.update();
        this.jTable1.scrollRectToVisible(rect);
        this.firePropertyChange(PROP_FIRST_ROW, oldRow, row);
    }

    public String getColumn() {
        int i = this.column.indexOf(": ");
        if (i > -1) {
            return this.column.substring(0, i);
        }
        return this.column;
    }

    public void setColumn(String column) {
        String oldColumn = this.column;
        this.column = column;
        this.firePropertyChange(PROP_COLUMN, oldColumn, column);
    }

    public String getDep0() {
        return this.dep0;
    }

    public void setDep0(String dep0) {
        String oldDep0 = this.dep0;
        this.dep0 = dep0;
        this.firePropertyChange(PROP_DEP0, oldDep0, dep0);
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri((String)this.split.path));
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)url);
        DataSetURI.getFile((URI)DataSetURI.toUri((String)this.split.file), (ProgressMonitor)mon);
        return true;
    }

    public void setURI(String url) {
        try {
            String arg0;
            this.split = URISplit.parse((String)url);
            this.params = URISplit.parseParams((String)this.split.params);
            File f = DataSetURI.getFile((URI)DataSetURI.toUri((String)this.split.file), (ProgressMonitor)new NullProgressMonitor());
            this.setFile(f);
            int tab = 2;
            if (this.params.containsKey(PROP_FIRST_ROW)) {
                this.setSkipLines(Integer.parseInt(this.params.get(PROP_FIRST_ROW)));
            }
            if (this.params.containsKey("skip")) {
                this.setSkipLines(Integer.parseInt(this.params.get("skip")));
            }
            if (this.params.containsKey(PROP_COLUMN)) {
                this.setColumn(this.params.get(PROP_COLUMN));
            }
            if (this.params.containsKey("rank2")) {
                this.setColumn(this.params.get("rank2"));
            }
            if (this.params.containsKey("bundle")) {
                this.setColumn(this.params.get("bundle"));
                this.bundleCheckBox.setSelected(true);
            }
            if ((arg0 = this.params.get("arg_0")) != null) {
                String col = ":";
                if (arg0.equals("rank2")) {
                    this.setColumn(col);
                } else if (arg0.equals("bundle")) {
                    this.setColumn(col);
                    this.bundleCheckBox.setSelected(true);
                }
            }
            if (this.params.containsKey("depend0")) {
                this.setDep0(this.params.get("depend0"));
            }
            if (this.params.containsKey("time")) {
                this.setDep0(this.params.get("time"));
                this.dep0timeCheckBox.setSelected(true);
            }
            if (this.params.containsKey("timeFormat")) {
                this.timeFormatTextField.setText(this.params.get("timeFormat"));
            }
            this.fillValueTextField.setText(this.getParam(this.params, "fill"));
            this.validMinTextField.setText(this.getParam(this.params, "validMin"));
            this.validMaxTextField.setText(this.getParam(this.params, "validMax"));
            this.jTabbedPane1.setSelectedIndex(tab);
            this.update();
            this.checkHeaders();
        }
        catch (IOException ex) {
            Logger.getLogger(AsciiTableDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private String getParam(Map<String, String> params, String name) {
        String result = params.get(name);
        if (result == null) {
            return "";
        }
        return result;
    }

    private void setParam(Map<String, String> params, String name, String s) {
        if ((s = s.trim()).length() > 0) {
            params.put(name, s);
        } else {
            params.remove(name);
        }
    }

    public String getURI() {
        if (this.skipLines > 0) {
            this.params.put(PROP_FIRST_ROW, "" + this.skipLines);
        } else {
            this.params.remove(PROP_FIRST_ROW);
        }
        this.params.remove("skip");
        if (!this.getDep0().equals("")) {
            if (this.dep0timeCheckBox.isSelected()) {
                this.params.put("time", this.getDep0());
                this.params.remove("depend0");
            } else {
                this.params.put("depend0", this.getDep0());
                this.params.remove("time");
            }
        } else {
            this.params.remove("time");
            this.params.remove("depend0");
        }
        this.params.remove("arg_0");
        if (this.getColumn().contains(":") || this.getColumn().contains("-")) {
            this.params.remove(PROP_COLUMN);
            if (this.bundleCheckBox.isSelected()) {
                this.params.put("bundle", this.getColumn());
            } else {
                this.params.put("rank2", this.getColumn());
            }
        } else {
            this.params.put(PROP_COLUMN, this.getColumn());
            this.params.remove("rank2");
            this.params.remove("bundle");
        }
        this.params.remove("group");
        this.setParam(this.params, "timeFormat", this.timeFormatTextField.getText());
        this.setParam(this.params, "fill", this.fillValueTextField.getText());
        this.setParam(this.params, "validMin", this.validMinTextField.getText());
        this.setParam(this.params, "validMax", this.validMaxTextField.getText());
        this.split.params = URISplit.formatParams(this.params);
        return URISplit.format((URISplit)this.split);
    }

    private void updateColumns() {
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            String label = i < this.columns.size() ? this.columns.get(i) : "x";
            this.jTable1.getColumnModel().getColumn(i).setHeaderValue(label);
            int nrow = this.jTable1.getRowCount();
            Object o = this.jTable1.getValueAt(nrow - 1, i);
            String s = String.valueOf(o);
            if (s.length() > 16) {
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(150);
                continue;
            }
            if (s.length() >= 5) continue;
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(50);
        }
        this.jTable1.getTableHeader().repaint();
    }

    private void checkHeaders() {
        try {
            AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
            if (p == null) {
                return;
            }
            this.model.setRecParser((AsciiParser.RecordParser)p);
            this.columns = this.getColumnNames();
            Throwable richHeaderWarn = null;
            boolean isRichHeader = AsciiParser.isRichHeader((String)p.header);
            if (isRichHeader) {
                try {
                    String[] columns1 = new String[p.fieldCount()];
                    for (int i = 0; i < columns1.length; ++i) {
                        columns1[i] = "";
                    }
                    AsciiHeadersParser.parseMetadata((String)p.header, (String[])columns1, (String[])columns1);
                }
                catch (ParseException ex) {
                    Logger.getLogger(AsciiTableDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    richHeaderWarn = ex;
                }
            }
            if (richHeaderWarn != null) {
                JOptionPane.showMessageDialog(this.jTable1, "<html>Rich headers are JSON headers that provide additional information about the parameters in the text file.<br>There was an error when parsing the headers.<br><br>" + richHeaderWarn.toString() + "</html>", "Rich Headers parser error detected", 0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AsciiTableDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void update() {
        try {
            AsciiParser.DelimParser p = this.parser.guessSkipAndDelimParser(this.file.toString());
            if (p == null) {
                return;
            }
            this.model.setRecParser((AsciiParser.RecordParser)p);
            LinkedHashMap<Integer, Object> list = new LinkedHashMap<Integer, Object>();
            this.columns = this.getColumnNames();
            Map xx = this.parser.getRichFields();
            int ij = this.columns.size();
            for (Map.Entry s : xx.entrySet()) {
                list.put(ij, s.getKey());
                ++ij;
            }
            list.putAll(this.columns);
            this.updateColumns();
            String lcol = this.getColumn();
            int icol = this.jTable1.getSelectedColumn();
            this.columnsComboBox.setModel(new DefaultComboBoxModel<Object>(list.values().toArray()));
            this.columnsComboBox.setSelectedItem(this.getColumn());
            if (icol != -1) {
                this.setColumn(this.columns.get(icol));
            } else {
                this.setColumn(lcol);
            }
            ArrayList dep0Values = new ArrayList(list.values());
            String ldep0 = this.getDep0();
            dep0Values.add(0, "");
            this.dep0Columns.setModel(new DefaultComboBoxModel<Object>(dep0Values.toArray()));
            this.dep0Columns.setSelectedItem(ldep0);
            String comment = "#";
            if (this.params.containsKey(PARAMS_KEY_COMMENT) && (comment = this.params.get(PARAMS_KEY_COMMENT)).trim().length() == 0) {
                comment = "none";
            }
            ComboBoxModel model1 = this.commentComboBox.getModel();
            for (int i = 0; i < model1.getSize(); ++i) {
                if (!((String)model1.getElementAt(i)).startsWith(comment)) continue;
                this.commentComboBox.setSelectedIndex(i);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(AsciiTableDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Tool {
        NONE,
        SKIPLINES,
        COLUMN,
        DEPEND_0,
        TIMEFORMAT,
        GUESSTIMEFORMAT,
        FILLVALUE;

    }
}

