/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.das2Stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.das2Stream.Das2StreamDataSource;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.qstream.QDataSetStreamHandler;
import org.virbo.qstream.StreamException;
import org.virbo.qstream.StreamHandler;
import org.virbo.qstream.StreamTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Das2StreamDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws IOException {
        return new Das2StreamDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException, StreamException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME && DataSetURI.fromUri((URI)cc.resourceURI).endsWith(".qds")) {
            List<String> params = this.getNames(cc, mon);
            for (String s : params) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, s));
            }
        }
        return result;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        return false;
    }

    private List<String> getNames(CompletionContext cc, ProgressMonitor mon) throws IOException, StreamException {
        LinkedHashMap params = URISplit.parseParams((String)cc.params);
        File file = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
        QDataSetStreamHandler h = new QDataSetStreamHandler();
        h.setReadPackets(false);
        StreamTool.readStream((ReadableByteChannel)Channels.newChannel(new FileInputStream(file)), (StreamHandler)h);
        return h.getDataSetNames();
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }
}

