/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.das2Stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.dataset.VectorUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.URISplit;
import org.virbo.qstream.SimpleStreamFormatter;

public class Das2StreamDataSourceFormat
implements DataSourceFormat {
    public void formatData(String url, QDataSet data, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)url.toString());
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        boolean binary = "binary".equals(params.get("type"));
        if (split.ext.equals(".qds")) {
            FileOutputStream fo = new FileOutputStream(new File(split.resourceUri));
            if (binary) {
                new SimpleStreamFormatter().format(data, (OutputStream)fo, false);
            } else {
                new SimpleStreamFormatter().format(data, (OutputStream)fo, true);
            }
            fo.close();
        } else if (data.rank() == 3) {
            TableDataSet tds = TableDataSetAdapter.create((QDataSet)data);
            FileOutputStream fo = new FileOutputStream(new File(split.resourceUri));
            if (binary) {
                TableUtil.dumpToBinaryStream((TableDataSet)tds, (OutputStream)fo);
            } else {
                TableUtil.dumpToAsciiStream((TableDataSet)tds, (OutputStream)fo);
            }
            fo.close();
        } else if (data.rank() == 2) {
            TableDataSet tds = TableDataSetAdapter.create((QDataSet)data);
            FileOutputStream fo = new FileOutputStream(new File(split.resourceUri));
            if (binary) {
                TableUtil.dumpToBinaryStream((TableDataSet)tds, (OutputStream)fo);
            } else {
                TableUtil.dumpToAsciiStream((TableDataSet)tds, (OutputStream)fo);
            }
            fo.close();
        } else if (data.rank() == 1) {
            VectorDataSet vds = VectorDataSetAdapter.create((QDataSet)data);
            FileOutputStream fo = new FileOutputStream(new File(split.resourceUri));
            if (binary) {
                VectorUtil.dumpToBinaryStream((VectorDataSet)vds, (OutputStream)fo);
            } else {
                VectorUtil.dumpToAsciiStream((VectorDataSet)vds, (OutputStream)fo);
            }
            fo.close();
        }
    }
}

