/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.spase;

import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.virbo.metatree.NameValueTreeModel;
import org.virbo.spase.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMWalker {
    TreeWalker walker;

    public DOMWalker(TreeWalker walker) {
        this.walker = walker;
    }

    public DOMWalker(Document document) {
        DocumentTraversal dt = (DocumentTraversal)((Object)document);
        this.walker = dt.createTreeWalker(document, -1, null, false);
    }

    public DOMWalker(Element element) {
        DocumentTraversal dt = (DocumentTraversal)((Object)element.getOwnerDocument());
        this.walker = dt.createTreeWalker(element, -1, null, false);
    }

    boolean isLeaf(Node domNode) {
        return domNode.getChildNodes().getLength() == 1 && domNode.getFirstChild().getNodeType() == 3;
    }

    public Map<String, Object> getAttributes(Node node) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.walker.setCurrentNode(node);
        Node child = this.walker.firstChild();
        while (child != null) {
            if (!this.isLeaf(child)) {
                result.put(child.getNodeName(), child);
            } else {
                result.put(child.getNodeName(), child.getFirstChild().getNodeValue());
            }
            child = this.walker.nextSibling();
        }
        for (String key : result.keySet()) {
            Object o = result.get(key);
            if (!(o instanceof Node)) continue;
            result.put(key, this.getAttributes((Node)o));
        }
        return result;
    }

    public Node getRoot() {
        return this.walker.getRoot();
    }

    public int getChildCount(Object node) {
        this.walker.setCurrentNode(((TreeNode)node).getDomNode());
        int numkids = 0;
        Node child = this.walker.firstChild();
        while (child != null) {
            ++numkids;
            child = this.walker.nextSibling();
        }
        return numkids;
    }

    public Object getChild(Object parent, int index) {
        this.walker.setCurrentNode(((TreeNode)parent).getDomNode());
        Node child = this.walker.firstChild();
        while (index-- > 0) {
            child = this.walker.nextSibling();
        }
        return new TreeNode(child);
    }

    public int getIndexOfChild(Object parent, Object child) {
        this.walker.setCurrentNode(((TreeNode)parent).getDomNode());
        int index = 0;
        Node c = this.walker.firstChild();
        while (c != child && c != null) {
            ++index;
            c = this.walker.nextSibling();
        }
        return index;
    }

    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource source = new InputSource(new FileReader(args[0]));
        Document document = builder.parse(source);
        DocumentTraversal traversal = (DocumentTraversal)((Object)document);
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        int whatToShow = -129;
        TreeWalker walker = traversal.createTreeWalker(document, whatToShow, filter, false);
        DOMWalker walk = new DOMWalker(walker);
        Map<String, Object> map = walk.getAttributes(walk.getRoot());
        JTree tree = new JTree((TreeModel)NameValueTreeModel.create((Object)"TEST", map));
        JFrame frame = new JFrame("DOMTreeWalkerTreeModel Demo");
        frame.getContentPane().add(new JScrollPane(tree));
        frame.setSize(500, 250);
        frame.setVisible(true);
    }
}

