/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.DasProgressMonitorReadableByteChannel;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cefdatasource.Cef;
import org.virbo.cefdatasource.CefMetadataModel;
import org.virbo.cefdatasource.CefReaderData;
import org.virbo.cefdatasource.CefReaderHeader;
import org.virbo.cefdatasource.ReformDataSet;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.dsutil.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CefDataSource
extends AbstractDataSource {
    Cef cef;
    String dsid;

    public CefDataSource(URI uri) {
        super(uri);
        URISplit split = URISplit.parse((String)DataSetURI.fromUri((URI)uri));
        String file = split.file.substring(split.path.length());
        int i = file.indexOf("__");
        this.dsid = i != -1 ? file.substring(0, i) : null;
    }

    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File f = DataSetURI.getFile((URI)this.uri, (ProgressMonitor)new NullProgressMonitor());
        ReadableByteChannel c = Channels.newChannel(new FileInputStream(f));
        DasProgressMonitorReadableByteChannel cmon = new DasProgressMonitorReadableByteChannel(c, mon);
        cmon.setStreamLength(f.length());
        CefReaderHeader readerh = new CefReaderHeader();
        this.cef = readerh.read((ReadableByteChannel)cmon);
        String var = (String)this.getParams().get("arg_0");
        MutablePropertyDataSet ds = null;
        MutablePropertyDataSet dsvar = this.createDataSet(var, ds, cmon);
        cmon.close();
        return dsvar;
    }

    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String var = (String)this.getParams().get("arg_0");
        CefReaderHeader.ParamStruct param = this.cef.parameters.get(var);
        return this.getMetaData(param, mon);
    }

    public synchronized Map<String, Object> getMetaData(CefReaderHeader.ParamStruct param, ProgressMonitor mon) throws Exception {
        LinkedHashMap<String, Object> entries = new LinkedHashMap<String, Object>();
        for (int i = 0; i < 4; ++i) {
            String dep = (String)param.entries.get("DEPEND_" + i);
            if (dep == null || dep.equals("")) continue;
            Map<String, Object> depMeta = this.getMetaData(this.cef.parameters.get(dep), (ProgressMonitor)new NullProgressMonitor());
            entries.put("DEPEND_" + i, depMeta);
        }
        entries.putAll(param.entries);
        HashMap<String, String> restEntries = new HashMap<String, String>();
        for (String key : this.cef.parameters.keySet()) {
            CefReaderHeader.ParamStruct parm = this.cef.parameters.get(key);
            if (parm.sizes.length == 1 && parm.sizes[0] == 1) {
                restEntries.put(key, "[*] " + parm.entries.get("CATDESC"));
                continue;
            }
            String s = Arrays.toString(parm.sizes);
            s = s.substring(1, s.length() - 1);
            restEntries.put(key, "[*," + s + "] " + parm.entries.get("CATDESC"));
        }
        return entries;
    }

    private MutablePropertyDataSet createDataSet(String var, MutablePropertyDataSet tds, DasProgressMonitorReadableByteChannel cmon) throws IOException, NumberFormatException, ParseException {
        int i;
        int rank0;
        Object ds;
        CefReaderHeader.ParamStruct param = this.cef.parameters.get(var);
        if (param == null) {
            throw new IllegalArgumentException("no such dataset: " + var);
        }
        int collapseDim = 999;
        Units u = Units.dimensionless;
        double fill = u.getFillDouble();
        String sceffill = (String)param.entries.get("FILLVAL");
        double ceffill = !param.entries.get("VALUE_TYPE").equals("ISO_TIME") ? (sceffill != null ? Double.parseDouble(sceffill) : fill) : fill;
        if (param.cefFieldPos[0] == -1) {
            String[] data = (String[])param.entries.get("DATA");
            double[] ddata = new double[data.length];
            for (int i2 = 0; i2 < data.length; ++i2) {
                try {
                    ddata[i2] = Double.parseDouble(data[i2]);
                    if (ddata[i2] != ceffill) continue;
                    ddata[i2] = fill;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("format error in data of param.name=" + param.name + ": " + data[i2]);
                }
            }
            ds = DDataSet.wrap((double[])ddata);
            this.setDsName(var, (MutablePropertyDataSet)ds);
            rank0 = ds.rank();
        } else {
            ArrayDataSet dds;
            int i3;
            if (tds == null) {
                CefReaderData readerd = new CefReaderData();
                for (i3 = 0; i3 < 40000; ++i3) {
                    readerd.skipParse(i3);
                }
                this.setParseFlags(this.cef, var, readerd);
                tds = readerd.cefReadData((ReadableByteChannel)cmon, this.cef);
            }
            if (param.sizes.length > 1 || param.sizes[0] > 1) {
                if (tds == null) {
                    DataSetBuilder result = new DataSetBuilder(2, 0, param.cefFieldPos[1] - param.cefFieldPos[0] + 1, 1);
                    ds = result.getDataSet();
                } else {
                    ds = DataSetOps.leafTrim((QDataSet)tds, (int)param.cefFieldPos[0], (int)(param.cefFieldPos[1] + 1));
                }
                dds = ArrayDataSet.copy((QDataSet)ds);
                dds.putProperty("UNITS", (Object)u);
                for (i3 = 0; i3 < dds.length(); ++i3) {
                    for (int j = 0; j < dds.length(i3); ++j) {
                        if (dds.value(i3, j) != ceffill) continue;
                        dds.putValue(i3, j, fill);
                    }
                }
                ds = dds;
                this.setDsName(var, (MutablePropertyDataSet)ds);
                if (param.sizes.length > 2) {
                    int[] sizes = new int[param.sizes.length + 1];
                    sizes[0] = ds.length();
                    int ndim = sizes.length;
                    for (i = 1; i < sizes.length; ++i) {
                        sizes[i] = param.sizes[ndim - i - 1];
                    }
                    ds = new ReformDataSet((QDataSet)ds, sizes);
                    rank0 = ds.rank();
                } else {
                    rank0 = ds.rank();
                }
            } else {
                ds = tds == null ? DDataSet.createRank1((int)0) : DataSetOps.slice1((QDataSet)tds, (int)param.cefFieldPos[0]);
                rank0 = ds.rank();
                dds = ArrayDataSet.copy((QDataSet)ds);
                dds.putProperty("UNITS", (Object)u);
                dds.putProperty("FILL_VALUE", (Object)ceffill);
                ds = dds;
                this.setDsName(var, (MutablePropertyDataSet)ds);
            }
        }
        if (param.entries.get("VALUE_TYPE").equals("ISO_TIME")) {
            ds.putProperty("UNITS", (Object)Units.us2000);
            if (DataSetUtil.isMonotonic((QDataSet)ds)) {
                ds.putProperty("MONOTONIC", (Object)Boolean.TRUE);
            }
        }
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        boolean doDeps = true;
        if (doDeps) {
            for (i = 0; i < rank0; ++i) {
                String s = (String)param.entries.get("DEPEND_" + i);
                if (s == null) continue;
                int newDim = i;
                if (i > collapseDim) {
                    newDim = i - 1;
                } else {
                    if (i >= collapseDim) continue;
                    newDim = i;
                }
                MutablePropertyDataSet dep0ds = this.createDataSet(s, tds, cmon);
                if (dep0ds.rank() > 1) {
                    QDataSet dp01 = (QDataSet)dep0ds.property("DEPEND_0");
                    QDataSet dp02 = (QDataSet)ds.property("DEPEND_0");
                    if (dp01 != null && dp02 != null && dp01.length() == dp02.length()) {
                        dep0ds = DataSetOps.slice0((QDataSet)dep0ds, (int)0);
                        dep0ds.putProperty("CONTEXT_0", null);
                        if (dep0ds.length() > qube[newDim]) {
                            dep0ds = DataSetOps.trim((QDataSet)dep0ds, (int)0, (int)qube[newDim]);
                        }
                    }
                }
                ds.putProperty("DEPEND_" + newDim, (Object)dep0ds);
            }
        }
        if (param.entries.containsKey("COORDINATE_SYSTEM") && ds.length(0) == 3) {
            String type = (String)param.entries.get("COORDINATE_SYSTEM");
            int size = 3;
            if (size == 3) {
                EnumerationUnits units = EnumerationUnits.create((Object)type);
                DDataSet dep1 = DDataSet.createRank1((int)3);
                dep1.putValue(0, units.createDatum((Object)"X").doubleValue((Units)units));
                dep1.putValue(1, units.createDatum((Object)"Y").doubleValue((Units)units));
                dep1.putValue(2, units.createDatum((Object)"Z").doubleValue((Units)units));
                dep1.putProperty("UNITS", (Object)units);
                dep1.putProperty("COORDINATE_FRAME", (Object)type);
                ds.putProperty("DEPEND_1", (Object)dep1);
            }
        }
        try {
            Map<String, Object> m = this.getMetadata((ProgressMonitor)new NullProgressMonitor());
            Map<String, Object> props = new CefMetadataModel().properties(m);
            DataSetUtil.putProperties(props, (MutablePropertyDataSet)ds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    private MutablePropertyDataSet makeMonotonic(MutablePropertyDataSet ds, int idim, QDataSet sort) {
        DDataSet cds;
        block15: {
            int[] qube;
            block16: {
                block14: {
                    if (idim > 2) {
                        throw new IllegalArgumentException("idim must be <=2 ");
                    }
                    if (ds.rank() > 3) {
                        throw new IllegalArgumentException("rank limit");
                    }
                    qube = DataSetUtil.qubeDims((QDataSet)ds);
                    qube[idim] = sort.length();
                    cds = DDataSet.create((int[])qube);
                    DataSetUtil.putProperties((Map)DataSetUtil.getProperties((QDataSet)ds), (MutablePropertyDataSet)cds);
                    if (idim != 0) break block14;
                    for (int i = 0; i < qube[0]; ++i) {
                        if (ds.rank() > 1) {
                            for (int j = 0; j < qube[1]; ++j) {
                                if (ds.rank() > 2) {
                                    for (int k = 0; k < qube[2]; ++k) {
                                        double d = ds.value((int)sort.value(i), j, k);
                                        cds.putValue(i, j, k, d);
                                    }
                                    continue;
                                }
                                double d = ds.value((int)sort.value(i), j);
                                cds.putValue(i, j, d);
                            }
                            continue;
                        }
                        double d = ds.value((int)sort.value(i));
                        cds.putValue(i, d);
                    }
                    break block15;
                }
                if (idim != 1) break block16;
                for (int i = 0; i < qube[0]; ++i) {
                    for (int j = 0; j < qube[1]; ++j) {
                        if (ds.rank() > 2) {
                            for (int k = 0; k < qube[2]; ++k) {
                                double d = ds.value(i, (int)sort.value(j), k);
                                cds.putValue(i, j, k, d);
                            }
                            continue;
                        }
                        double d = ds.value(i, (int)sort.value(j));
                        cds.putValue(i, j, d);
                    }
                }
                break block15;
            }
            if (idim != 2) break block15;
            for (int i = 0; i < qube[0]; ++i) {
                for (int j = 0; j < qube[1]; ++j) {
                    for (int k = 0; k < qube[2]; ++k) {
                        double d = ds.value(i, j, (int)sort.value(k));
                        cds.putValue(i, j, k, d);
                    }
                }
            }
        }
        return cds;
    }

    private void setDsName(String var, MutablePropertyDataSet ds) {
        if (this.dsid != null && var.endsWith("__" + this.dsid)) {
            ds.putProperty("NAME", (Object)var.substring(0, var.length() - (this.dsid.length() + 2)));
        } else {
            ds.putProperty("NAME", (Object)var);
        }
    }

    private void setParseFlags(Cef cef, String var, CefReaderData readerd) {
        CefReaderHeader.ParamStruct param = cef.parameters.get(var);
        if (param.cefFieldPos[0] != -1) {
            for (int i = param.cefFieldPos[0]; i < param.cefFieldPos[1] + 1; ++i) {
                readerd.doParse(i);
            }
        }
        for (int i = 0; i < 4; ++i) {
            String s = (String)param.entries.get("DEPEND_" + i);
            if (s == null) continue;
            this.setParseFlags(cef, s, readerd);
        }
    }

    public MetadataModel getMetadataModel() {
        return new CefMetadataModel();
    }
}

