/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.virbo.datasource.MetadataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CefMetadataModel
extends MetadataModel {
    private Double doubleValue(Object o, Units units) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (double)((Double)o);
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            try {
                return units.parse((String)o).doubleValue(units);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("unable to parse " + o);
            }
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    private DatumRange getValidRange(Map attrs, Units units) {
        Double max = this.doubleValue(attrs.get("VALIDMAX"), units);
        Double min = this.doubleValue(attrs.get("VALIDMIN"), units);
        if (max == null || min == null) {
            return null;
        }
        return DatumRange.newDatumRange((double)min, (double)max, (Units)units);
    }

    private DatumRange getRange(Map attrs, Units units) {
        double min = 0.0;
        double max = 0.0;
        if (attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX")) {
            max = this.doubleValue(attrs.get("SCALEMAX"), units);
            min = this.doubleValue(attrs.get("SCALEMIN"), units);
        } else if (attrs.containsKey("SCALEMAX")) {
            max = this.doubleValue(attrs.get("SCALEMAX"), units);
            min = 0.0;
        } else if (attrs.containsKey("VALIDMAX")) {
            max = this.doubleValue(attrs.get("VALIDMAX"), units);
            min = this.doubleValue(attrs.get("VALIDMIN"), units);
        }
        if (this.getScaleType(attrs).equals("log") && min <= 0.0) {
            min = max / 10000.0;
        }
        if (min == max && max == 0.0) {
            return null;
        }
        DatumRange range = new DatumRange(min, max, units);
        return range;
    }

    private String getScaleType(Map attrs) {
        String type = "linear";
        if (attrs.containsKey("SCALETYP")) {
            type = (String)attrs.get("SCALETYP");
        }
        return type.toLowerCase();
    }

    public Map<String, Object> properties(Map<String, Object> attrs) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (attrs.containsKey("LABLAXIS")) {
            properties.put("LABEL", attrs.get("LABLAXIS"));
        }
        if (attrs.containsKey("CATDESC")) {
            properties.put("TITLE", attrs.get("CATDESC"));
        }
        if (attrs.containsKey("DISPLAY_TYPE")) {
            String type = (String)attrs.get("DISPLAY_TYPE");
            properties.put("RENDER_TYPE", type);
        }
        Units units = Units.dimensionless;
        try {
            DatumRange range = this.getRange(attrs, units);
            if (range != null) {
                properties.put("TYPICAL_MIN", range.min().doubleValue(units));
                properties.put("TYPICAL_MAX", range.max().doubleValue(units));
            }
            if ((range = this.getValidRange(attrs, units)) != null) {
                properties.put("VALID_MIN", range.min().doubleValue(units));
                properties.put("VALID_MAX", range.max().doubleValue(units));
            }
            properties.put("SCALE_TYPE", this.getScaleType(attrs));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return properties;
    }

    public String getLabel() {
        return "CEF";
    }
}

