/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.GZIPInputStream;

public class FileSystemUtil {
    public static void dumpToFile(InputStream in, File f) throws FileNotFoundException, IOException {
        ReadableByteChannel ic = Channels.newChannel(in);
        FileChannel oc = new FileOutputStream(f).getChannel();
        if (ic instanceof FileChannel) {
            FileChannel fic = (FileChannel)ic;
            fic.transferTo(0L, fic.size(), oc);
            fic.close();
            oc.close();
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(16384);
            while (ic.read(buf) >= 0 || buf.position() != 0) {
                buf.flip();
                oc.write(buf);
                buf.compact();
            }
        }
    }

    public static void unzip(File fz, File file) throws IOException {
        int len;
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(fz));
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }
}

