/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.CDFImpl;
import gov.nasa.gsfc.voyager.cdf.DataTypes;
import gov.nasa.gsfc.voyager.cdf.Stride;
import gov.nasa.gsfc.voyager.cdf.TimeSeries;
import gov.nasa.gsfc.voyager.cdf.TimeSpec;
import gov.nasa.gsfc.voyager.cdf.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;
import java.util.Vector;

public class Extractor {
    static int MAX_ARRAY = 3;
    static String[] functions = new String[]{"Series", "Element", "Point", "Range", "Elements", "RangeForElements", "RangeForElement", "TimeSeries", "SampledTimeSeries", "TimeSeriesObject"};
    static Method[][][] methods = new Method[functions.length][MAX_ARRAY + 1][2];
    static Class[][][] args = new Class[functions.length][MAX_ARRAY + 1][];

    public static Method getMethod(Variable var, String func) throws IllegalAccessException, InvocationTargetException {
        int rank = var.getEffectiveRank();
        int index = -1;
        for (int i = 0; i < functions.length; ++i) {
            if (!func.equals(functions[i])) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return null;
        }
        if (DataTypes.isStringType(var.getType())) {
            return methods[index][rank][1];
        }
        return methods[index][rank][0];
    }

    static int[] getRecordRange(CDF thisCDF, Variable var, double[] timeRange) {
        try {
            int i;
            double[] times = ((CDFImpl)((Object)thisCDF)).getTimes(var, false);
            double start = timeRange[0];
            double stop = timeRange[1];
            for (i = 0; i < times.length && start > times[i]; ++i) {
            }
            if (i == times.length) {
                return null;
            }
            int low = i;
            while (i < times.length && !(stop <= times[i])) {
                ++i;
            }
            if (i == 0) {
                return null;
            }
            return new int[]{low, i - 1};
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object getSeries0(CDF thisCDF, Variable var) throws IllegalAccessException, InvocationTargetException {
        int numberOfValues = var.getNumberOfValues();
        if (numberOfValues == 0) {
            return null;
        }
        int type = var.getType();
        long[] ldata = null;
        double[] data = null;
        boolean longType = false;
        if (DataTypes.typeCategory[type] == 5) {
            ldata = new long[numberOfValues];
            longType = true;
        } else {
            data = new double[numberOfValues];
        }
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block7: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (int n = first; n <= last; ++n) {
                        data[n] = bvf.get();
                    }
                    continue block7;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    for (int n = first; n <= last; ++n) {
                        data[n] = bvd.get();
                    }
                    continue block7;
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    for (int n = first; n <= last; ++n) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        data[n] = num.doubleValue();
                    }
                    continue block7;
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    for (int n = first; n <= last; ++n) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        data[n] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                    }
                    continue block7;
                }
                case 5: {
                    LongBuffer bvl = bv.asLongBuffer();
                    for (int n = first; n <= last; ++n) {
                        ldata[n] = bvl.get();
                    }
                    continue block7;
                }
            }
        }
        if (!var.recordVariance()) {
            int i;
            if (!longType) {
                for (i = 1; i < numberOfValues; ++i) {
                    data[i] = data[0];
                }
            } else {
                for (i = 1; i < numberOfValues; ++i) {
                    ldata[i] = ldata[0];
                }
            }
        }
        if (longType) {
            return ldata;
        }
        return data;
    }

    public static double[][] getTimeSeries0(CDF thisCDF, Variable var, Boolean ignoreFill, double[] timeRange) throws Throwable {
        return Extractor.getTimeSeries(thisCDF, var, null, ignoreFill, timeRange);
    }

    public static double[][] getTimeSeries1(CDF thisCDF, Variable var, Integer which, Boolean ignoreFill, double[] timeRange) throws Throwable {
        return Extractor.getTimeSeries(thisCDF, var, which, ignoreFill, timeRange);
    }

    static double[] castToDouble(Object o, boolean longType) {
        double[] vdata;
        if (!longType) {
            vdata = (double[])o;
        } else {
            long[] ldata = (long[])o;
            vdata = new double[ldata.length];
            for (int i = 0; i < ldata.length; ++i) {
                vdata[i] = ldata[i];
            }
        }
        return vdata;
    }

    public static double[][] getTimeSeries(CDF thisCDF, Variable var, Integer which, Boolean ignoreFill, double[] timeRange) throws Throwable {
        int first;
        if (var.getNumberOfValues() == 0) {
            return null;
        }
        boolean ignore = ignoreFill;
        int[] recordRange = null;
        double[] times = ((CDFImpl)((Object)thisCDF)).getTimes(var, false);
        if (times == null) {
            return null;
        }
        boolean longType = false;
        int type = var.getType();
        if (DataTypes.typeCategory[type] == 5) {
            longType = true;
        }
        Object o = null;
        if (timeRange == null) {
            o = which == null ? Extractor.getSeries0(thisCDF, var) : Extractor.getElement1(thisCDF, var, which);
        } else {
            recordRange = Extractor.getRecordRange(thisCDF, var, timeRange);
            if (recordRange == null) {
                return null;
            }
            o = which == null ? Extractor.getRange0(thisCDF, var, recordRange[0], recordRange[1]) : Extractor.getRangeForElement1(thisCDF, var, recordRange[0], recordRange[1], which);
        }
        double[] vdata = Extractor.castToDouble(o, longType);
        if (!ignore) {
            if (timeRange == null) {
                return new double[][]{times, vdata};
            }
            double[] stimes = new double[vdata.length];
            System.arraycopy(times, recordRange[0], stimes, 0, vdata.length);
            return new double[][]{stimes, vdata};
        }
        double[] fill = Extractor.getFillValue(thisCDF, var);
        int n = first = timeRange != null ? recordRange[0] : 0;
        if (fill[0] != 0.0) {
            double[] stimes = new double[vdata.length];
            System.arraycopy(times, first, stimes, 0, vdata.length);
            return new double[][]{stimes, vdata};
        }
        return Extractor.filterFill(times, vdata, fill[1], first);
    }

    public static double[] getFillValue(CDF thisCDF, Variable var) {
        Vector fill = (Vector)thisCDF.getAttribute(var.getName(), "FILLVAL");
        if (fill.size() != 0) {
            return new double[]{0.0, ((double[])fill.elementAt(0))[0]};
        }
        return new double[]{Double.NEGATIVE_INFINITY, 0.0};
    }

    public static double[][] filterFill(double[] times, double[] vdata, double fill, int first) {
        int count = 0;
        for (int i = 0; i < vdata.length; ++i) {
            if (vdata[i] == fill) continue;
            ++count;
        }
        double[][] series = new double[2][count];
        int n = 0;
        for (int i = 0; i < vdata.length; ++i) {
            if (vdata[i] == fill) continue;
            series[0][n] = times[i + first];
            series[1][n] = vdata[i];
            ++n;
        }
        return series;
    }

    public static double[][] getSeries1(CDF thisCDF, Variable var) throws IllegalAccessException, InvocationTargetException {
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        int elements = (Integer)Extractor.elementCount(var).elementAt(0);
        double[][] data = new double[nv][elements];
        int type = var.getType();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block6: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (int n = first; n <= last; ++n) {
                        for (int m = 0; m < elements; ++m) {
                            data[n][m] = bvf.get();
                        }
                    }
                    continue block6;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    for (int n = first; n <= last; ++n) {
                        for (int m = 0; m < elements; ++m) {
                            data[n][m] = bvd.get();
                        }
                    }
                    continue block6;
                }
                case 2: {
                    Extractor.doSignedInteger(bv, type, first, last, elements, data);
                    continue block6;
                }
                case 3: {
                    Extractor.doUnsignedInteger(bv, type, first, last, elements, data);
                }
            }
        }
        return data;
    }

    static void doSignedInteger(ByteBuffer bv, int type, int first, int last, int count, double[][] data) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        for (int n = first; n <= last; ++n) {
            for (int e = 0; e < count; ++e) {
                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                data[n][e] = num.doubleValue();
            }
        }
    }

    static void doSignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        bv.position(pos);
        for (int n = first; n <= last; ++n) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            data[n] = num.doubleValue();
            bv.position(pos += size);
        }
    }

    static int doSignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data, int index) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        bv.position(pos);
        for (int n = first; n <= last; ++n) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            data[index++] = num.doubleValue();
            bv.position(pos += size);
        }
        return index;
    }

    static void doSignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, int[] offsets, double[][] data) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        bv.position(pos);
        int ne = offsets.length;
        for (int n = first; n <= last; ++n) {
            for (int e = 0; e < ne; ++e) {
                bv.position(pos + offsets[e]);
                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                data[n][e] = num.doubleValue();
            }
            pos += size;
        }
    }

    static int doSignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, int[] offsets, double[][] data, int index) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        bv.position(pos);
        int ne = offsets.length;
        for (int n = first; n <= last; ++n) {
            for (int e = 0; e < ne; ++e) {
                bv.position(pos + offsets[e]);
                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                data[index][e] = num.doubleValue();
            }
            pos += size;
            ++index;
        }
        return index;
    }

    static void doUnsignedInteger(ByteBuffer bv, int type, int first, int last, int count, double[][] data) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        for (int n = first; n <= last; ++n) {
            for (int e = 0; e < count; ++e) {
                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                int x = num.intValue();
                data[n][e] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            }
        }
    }

    static void doUnsignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        bv.position(pos);
        for (int n = first; n <= last; ++n) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            int x = num.intValue();
            data[n] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            bv.position(pos += size);
        }
    }

    static int doUnsignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data, int index) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        bv.position(pos);
        for (int n = first; n <= last; ++n) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            int x = num.intValue();
            data[index++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            bv.position(pos += size);
        }
        return index;
    }

    static void doUnsignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, int[] offsets, double[][] data) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        bv.position(pos);
        int ne = offsets.length;
        for (int n = first; n <= last; ++n) {
            for (int e = 0; e < ne; ++e) {
                bv.position(pos + offsets[e]);
                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                int x = num.intValue();
                data[n][e] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            }
            pos += size;
        }
    }

    static int doUnsignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, int[] offsets, double[][] data, int index) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        bv.position(pos);
        int ne = offsets.length;
        for (int n = first; n <= last; ++n) {
            for (int e = 0; e < ne; ++e) {
                bv.position(pos + offsets[e]);
                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                int x = num.intValue();
                data[index][e] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            }
            pos += size;
            ++index;
        }
        return index;
    }

    public static Object getElement1(CDF thisCDF, Variable var, Integer idx) throws Throwable {
        int element = idx;
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        if (!Extractor.validElement(var, new int[]{element})) {
            return null;
        }
        int size = var.getDataItemSize();
        int type = var.getType();
        long[] ldata = null;
        double[] data = null;
        boolean longType = false;
        if (DataTypes.typeCategory[type] == 5) {
            ldata = new long[nv];
            longType = true;
        } else {
            data = new double[nv];
        }
        int loff = element * DataTypes.size[type];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block7: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            int pos = bv.position() + loff;
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int n;
                    for (n = first; n <= last; ++n) {
                        data[n] = bv.getFloat(pos);
                        pos += size;
                    }
                    continue block7;
                }
                case 1: {
                    int n;
                    for (n = first; n <= last; ++n) {
                        data[n] = bv.getDouble(pos);
                        pos += size;
                    }
                    continue block7;
                }
                case 2: {
                    Extractor.doSignedInteger(bv, pos, type, size, first, last, data);
                    continue block7;
                }
                case 3: {
                    Extractor.doUnsignedInteger(bv, pos, type, size, first, last, data);
                    continue block7;
                }
                case 5: {
                    int n;
                    for (n = first; n <= last; ++n) {
                        ldata[n] = bv.getLong(pos);
                        pos += size;
                    }
                    continue block7;
                }
                default: {
                    throw new Throwable(var.getName() + " has unsupported type " + "in this context.");
                }
            }
        }
        if (longType) {
            return ldata;
        }
        return data;
    }

    public static double[][] getElements1(CDF thisCDF, Variable var, int[] idx) throws Throwable {
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        if (!Extractor.validElement(var, idx)) {
            return null;
        }
        int ne = idx.length;
        double[][] data = new double[nv][ne];
        int size = var.getDataItemSize();
        int type = var.getType();
        int[] loff = new int[ne];
        for (int i = 0; i < ne; ++i) {
            loff[i] = idx[i] * DataTypes.size[type];
        }
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block7: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            int pos = bv.position();
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int e;
                    int n;
                    for (n = first; n <= last; ++n) {
                        for (e = 0; e < ne; ++e) {
                            data[n][e] = bv.getFloat(pos + loff[e]);
                        }
                        pos += size;
                    }
                    continue block7;
                }
                case 1: {
                    int e;
                    int n;
                    for (n = first; n <= last; ++n) {
                        for (e = 0; e < ne; ++e) {
                            data[n][e] = bv.getDouble(pos + loff[e]);
                        }
                        pos += size;
                    }
                    continue block7;
                }
                case 2: {
                    Extractor.doSignedInteger(bv, pos, type, size, first, last, loff, data);
                    continue block7;
                }
                case 3: {
                    Extractor.doUnsignedInteger(bv, pos, type, size, first, last, loff, data);
                }
            }
        }
        return data;
    }

    public static double[][][] getSeries2(CDF thisCDF, Variable var) {
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        int n0 = (Integer)Extractor.elementCount(var).elementAt(0);
        int n1 = (Integer)Extractor.elementCount(var).elementAt(1);
        double[][][] data = new double[nv][n0][n1];
        int type = var.getType();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block4: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int l;
                    int m;
                    FloatBuffer bvf = bv.asFloatBuffer();
                    if (var.rowMajority()) {
                        for (int n = first; n <= last; ++n) {
                            for (m = 0; m < n0; ++m) {
                                for (l = 0; l < n1; ++l) {
                                    data[n][m][l] = bvf.get();
                                }
                            }
                        }
                        continue block4;
                    }
                    for (int n = first; n <= last; ++n) {
                        for (m = 0; m < n1; ++m) {
                            for (l = 0; l < n0; ++l) {
                                data[n][l][m] = bvf.get();
                            }
                        }
                    }
                    continue block4;
                }
                case 1: {
                    int l;
                    int m;
                    int n;
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    if (var.rowMajority()) {
                        for (n = first; n <= last; ++n) {
                            for (m = 0; m < n0; ++m) {
                                for (l = 0; l < n1; ++l) {
                                    data[n][m][l] = bvd.get();
                                }
                            }
                        }
                        continue block4;
                    }
                    for (n = first; n <= last; ++n) {
                        for (m = 0; m < n1; ++m) {
                            for (l = 0; l < n0; ++l) {
                                data[n][l][m] = bvd.get();
                            }
                        }
                    }
                    continue block4;
                }
            }
        }
        return data;
    }

    public static Double getPoint0(CDF thisCDF, Variable var, Integer pt) throws Throwable {
        int point = pt;
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            if (loc[1] < point) continue;
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], loc[1] - loc[0] + 1);
            int pos = bv.position() + (point - loc[0]) * itemSize;
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    return new Double(bv.getFloat(pos));
                }
                case 1: {
                    return new Double(bv.getDouble(pos));
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                    return new Double(num.doubleValue());
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                    int x = num.intValue();
                    double d = x >= 0 ? (double)x : (double)(longInt + (long)x);
                    return new Double(d);
                }
            }
        }
        return null;
    }

    public static double[] getPoint1(CDF thisCDF, Variable var, Integer pt) throws Throwable {
        int point = pt;
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block6: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            if (loc[1] < point) continue;
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], loc[1] - loc[0] + 1);
            int pos = bv.position() + (point - loc[0]) * itemSize;
            bv.position(pos);
            int n = (Integer)Extractor.elementCount(var).elementAt(0);
            double[] da = new double[n];
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (int i = 0; i < n; ++i) {
                        da[i] = bvf.get();
                    }
                    return da;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    for (int i = 0; i < n; ++i) {
                        da[i] = bvd.get();
                    }
                    return da;
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    for (int i = 0; i < n; ++i) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        da[n] = num.doubleValue();
                    }
                    continue block6;
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    for (int i = 0; i < n; ++i) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        da[n] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                    }
                    continue block6;
                }
            }
        }
        return null;
    }

    public static double[][] getPoint2(CDF thisCDF, Variable var, Integer pt) throws Throwable {
        int point = pt;
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            if (loc[1] < point) continue;
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], loc[1] - loc[0] + 1);
            int pos = bv.position() + (point - loc[0]) * itemSize;
            bv.position(pos);
            int n0 = (Integer)Extractor.elementCount(var).elementAt(0);
            int n1 = (Integer)Extractor.elementCount(var).elementAt(1);
            double[][] da = new double[n0][n1];
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                da[i][j] = bvf.get();
                            }
                        }
                    } else {
                        for (int i = 0; i < n1; ++i) {
                            for (int j = 0; j < n0; ++j) {
                                da[j][i] = bvf.get();
                            }
                        }
                    }
                    return da;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                da[i][j] = bvd.get();
                            }
                        }
                    } else {
                        for (int i = 0; i < n1; ++i) {
                            for (int j = 0; j < n0; ++j) {
                                da[j][i] = bvd.get();
                            }
                        }
                    }
                    return da;
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                da[i][j] = num.doubleValue();
                            }
                        }
                    } else {
                        for (int i = 0; i < n1; ++i) {
                            for (int j = 0; j < n0; ++j) {
                                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                da[j][i] = num.doubleValue();
                            }
                        }
                    }
                    return da;
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                double d;
                                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                int x = num.intValue();
                                da[i][j] = d = x >= 0 ? (double)x : (double)(longInt + (long)x);
                            }
                        }
                    } else {
                        for (int i = 0; i < n1; ++i) {
                            for (int j = 0; j < n0; ++j) {
                                double d;
                                Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                int x = num.intValue();
                                da[j][i] = d = x >= 0 ? (double)x : (double)(longInt + (long)x);
                            }
                        }
                    }
                    return da;
                }
            }
        }
        return null;
    }

    public static double[] getElement2(CDF thisCDF, Variable var, Integer pt1, Integer pt2) {
        return null;
    }

    public static Object getRange0(CDF thisCDF, Variable var, Integer istart, Integer iend) throws Throwable {
        int start = istart;
        int end = iend;
        int type = var.getType();
        long[] ldata = null;
        double[] data = null;
        boolean longType = false;
        if (DataTypes.typeCategory[type] == 5) {
            ldata = new long[end - start + 1];
            longType = true;
        } else {
            data = new double[end - start + 1];
        }
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] blks = Extractor.getBlockRange(locations, var.recordVariance(), start, end);
        int firstBlock = blks[0];
        int lastBlock = blks[1];
        int index = 0;
        block7: for (int blk = firstBlock; blk <= lastBlock; ++blk) {
            Object[] oa = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, blks, blk, start, end);
            ByteBuffer bv = (ByteBuffer)oa[0];
            int first = (Integer)oa[1];
            int last = (Integer)oa[2];
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (int n = first; n <= last; ++n) {
                        data[index++] = bvf.get();
                    }
                    continue block7;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    for (int n = first; n <= last; ++n) {
                        data[index++] = bvd.get();
                    }
                    continue block7;
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    for (int n = first; n <= last; ++n) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        data[index++] = num.doubleValue();
                    }
                    continue block7;
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    for (int n = first; n <= last; ++n) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        data[index++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                    }
                }
                case 5: {
                    LongBuffer bvl = bv.asLongBuffer();
                    for (int n = first; n <= last; ++n) {
                        ldata[index++] = bvl.get();
                    }
                    continue block7;
                }
            }
        }
        if (!var.recordVariance()) {
            int i;
            if (!longType) {
                for (i = start; i <= end; ++i) {
                    data[i] = data[0];
                }
            } else {
                for (i = start; i <= end; ++i) {
                    ldata[i] = ldata[0];
                }
            }
        }
        if (longType) {
            return ldata;
        }
        return data;
    }

    public static double[][] getRange1(CDF thisCDF, Variable var, Integer istart, Integer iend) throws Throwable {
        int start = istart;
        int end = iend;
        int elements = (Integer)Extractor.elementCount(var).elementAt(0);
        double[][] data = new double[end - start + 1][elements];
        int type = var.getType();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] blks = Extractor.getBlockRange(locations, var.recordVariance(), start, end);
        int firstBlock = blks[0];
        int lastBlock = blks[1];
        int index = 0;
        block6: for (int blk = firstBlock; blk <= lastBlock; ++blk) {
            Object[] oa = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, blks, blk, start, end);
            ByteBuffer bv = (ByteBuffer)oa[0];
            int first = (Integer)oa[1];
            int last = (Integer)oa[2];
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (int n = first; n <= last; ++n) {
                        for (int m = 0; m < elements; ++m) {
                            data[index][m] = bvf.get();
                        }
                        ++index;
                    }
                    continue block6;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    for (int n = first; n <= last; ++n) {
                        for (int m = 0; m < elements; ++m) {
                            data[index][m] = bvd.get();
                        }
                        ++index;
                    }
                    continue block6;
                }
                case 2: {
                    Extractor.doSignedInteger(bv, type, first, last, elements, data);
                    continue block6;
                }
                case 3: {
                    Extractor.doUnsignedInteger(bv, type, first, last, elements, data);
                }
            }
        }
        if (!var.recordVariance()) {
            for (int i = start; i <= end; ++i) {
                for (int m = 0; m < elements; ++m) {
                    data[i - start][m] = data[0][m];
                }
            }
        }
        return data;
    }

    static Vector elementCount(Variable var) {
        int[] dimensions = var.getDimensions();
        Vector<Integer> ecount = new Vector<Integer>();
        for (int i = 0; i < dimensions.length; ++i) {
            if (!var.getVarys()[i]) continue;
            ecount.add(dimensions[i]);
        }
        return ecount;
    }

    static boolean validElement(Variable var, int[] idx) {
        int elements = (Integer)Extractor.elementCount(var).elementAt(0);
        for (int i = 0; i < idx.length; ++i) {
            if (idx[i] >= 0 && idx[i] < elements) continue;
            return false;
        }
        return true;
    }

    public static Object getRangeForElement1(CDF thisCDF, Variable var, Integer istart, Integer iend, Integer ielement) throws Throwable {
        int element = ielement;
        if (!Extractor.validElement(var, new int[]{element})) {
            return null;
        }
        int start = istart;
        int end = iend;
        int size = var.getDataItemSize();
        int type = var.getType();
        long[] ldata = null;
        double[] data = null;
        boolean longType = false;
        if (DataTypes.typeCategory[type] == 5) {
            ldata = new long[end - start + 1];
            longType = true;
        } else {
            data = new double[end - start + 1];
        }
        int loff = element * DataTypes.size[type];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] blks = Extractor.getBlockRange(locations, var.recordVariance(), start, end);
        int firstBlock = blks[0];
        int lastBlock = blks[1];
        int index = 0;
        block7: for (int blk = firstBlock; blk <= lastBlock; ++blk) {
            Object[] oa = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, blks, blk, start, end);
            ByteBuffer bv = (ByteBuffer)oa[0];
            int first = (Integer)oa[1];
            int last = (Integer)oa[2];
            int pos = bv.position() + loff;
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int n;
                    for (n = first; n <= last; ++n) {
                        data[index++] = bv.getFloat(pos);
                        pos += size;
                    }
                    continue block7;
                }
                case 1: {
                    int n;
                    for (n = first; n <= last; ++n) {
                        data[index++] = bv.getDouble(pos);
                        pos += size;
                    }
                    continue block7;
                }
                case 2: {
                    index = Extractor.doSignedInteger(bv, pos, type, size, first, last, data, index);
                    continue block7;
                }
                case 3: {
                    index = Extractor.doUnsignedInteger(bv, pos, type, size, first, last, data, index);
                    continue block7;
                }
                case 5: {
                    int n;
                    for (n = first; n <= last; ++n) {
                        ldata[index++] = bv.getLong(pos);
                        pos += size;
                    }
                    continue block7;
                }
            }
        }
        if (!var.recordVariance()) {
            int i;
            if (!longType) {
                for (i = start; i <= end; ++i) {
                    data[i - start] = data[0];
                }
            } else {
                for (i = start; i <= end; ++i) {
                    ldata[i - start] = ldata[0];
                }
            }
        }
        if (longType) {
            return ldata;
        }
        return data;
    }

    public static Object getRangeForElements1(CDF thisCDF, Variable var, Integer istart, Integer iend, int[] idx) throws Throwable {
        if (!Extractor.validElement(var, idx)) {
            return null;
        }
        int start = istart;
        int end = iend;
        int size = var.getDataItemSize();
        int ne = idx.length;
        int type = var.getType();
        long[][] ldata = null;
        double[][] data = null;
        boolean longType = false;
        if (DataTypes.typeCategory[type] == 5) {
            ldata = new long[end - start + 1][ne];
            longType = true;
        } else {
            data = new double[end - start + 1][ne];
        }
        int[] loff = new int[ne];
        for (int i = 0; i < ne; ++i) {
            loff[i] = idx[i] * DataTypes.size[type];
        }
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] blks = Extractor.getBlockRange(locations, var.recordVariance(), start, end);
        int firstBlock = blks[0];
        int lastBlock = blks[1];
        int index = 0;
        block8: for (int blk = firstBlock; blk <= lastBlock; ++blk) {
            Object[] oa = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, blks, blk, start, end);
            ByteBuffer bv = (ByteBuffer)oa[0];
            int first = (Integer)oa[1];
            int last = (Integer)oa[2];
            int pos = bv.position();
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int e;
                    int n;
                    for (n = first; n <= last; ++n) {
                        for (e = 0; e < ne; ++e) {
                            data[index][e] = bv.getFloat(pos + loff[e]);
                        }
                        pos += size;
                        ++index;
                    }
                    continue block8;
                }
                case 1: {
                    int e;
                    int n;
                    for (n = first; n <= last; ++n) {
                        for (e = 0; e < ne; ++e) {
                            data[index][e] = bv.getDouble(pos + loff[e]);
                        }
                        pos += size;
                        ++index;
                    }
                    continue block8;
                }
                case 2: {
                    index = Extractor.doSignedInteger(bv, pos, type, size, first, last, loff, data, index);
                    continue block8;
                }
                case 3: {
                    index = Extractor.doUnsignedInteger(bv, pos, type, size, first, last, loff, data, index);
                    continue block8;
                }
                case 5: {
                    int e;
                    int n;
                    for (n = first; n <= last; ++n) {
                        for (e = 0; e < ne; ++e) {
                            ldata[index][e] = bv.getLong(pos + loff[e]);
                        }
                        pos += size;
                        ++index;
                    }
                    continue block8;
                }
            }
        }
        if (!var.recordVariance()) {
            int i;
            if (!longType) {
                for (i = start; i <= end; ++i) {
                    for (int e = 0; e < ne; ++e) {
                        data[i - start][e] = data[0][e];
                    }
                }
            } else {
                for (i = start; i <= end; ++i) {
                    for (int e = 0; e < ne; ++e) {
                        ldata[i - start][e] = ldata[0][e];
                    }
                }
            }
        }
        if (longType) {
            return ldata;
        }
        return data;
    }

    public static double[][][] getRange2(CDF thisCDF, Variable var, Integer istart, Integer iend) {
        return null;
    }

    public static String getStringValue(ByteBuffer bv, int size) {
        int i;
        byte[] ba = new byte[size];
        for (i = 0; i < size; ++i) {
            ba[i] = bv.get();
            if (ba[i] == 0) break;
        }
        return new String(ba, 0, i);
    }

    public static String[] getStringSeries0(CDF thisCDF, Variable var) {
        int numberOfValues = var.getNumberOfValues();
        String[] data = new String[numberOfValues];
        int len = var.getNumberOfElements();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], loc[1] - loc[0] + 1);
            int pos = bv.position();
            for (int n = loc[0]; n <= loc[1]; ++n) {
                data[n] = Extractor.getStringValue(bv, len);
                bv.position(pos += len);
            }
        }
        if (!var.recordVariance()) {
            for (int i = 1; i < numberOfValues; ++i) {
                data[i] = data[0];
            }
        }
        return data;
    }

    public static String[][] getStringSeries1(CDF thisCDF, Variable var) {
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        int elements = (Integer)Extractor.elementCount(var).elementAt(0);
        String[][] data = new String[nv][elements];
        int len = var.getNumberOfElements();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], loc[1] - loc[0] + 1);
            int pos = bv.position();
            for (int n = loc[0]; n <= loc[1]; ++n) {
                for (int m = 0; m < elements; ++m) {
                    data[n][m] = Extractor.getStringValue(bv, len);
                    bv.position(pos += len);
                }
            }
        }
        return data;
    }

    public static String[][][] getStringSeries2(CDF thisCDF, Variable var) {
        return null;
    }

    static int[] getBlockRange(Vector locations, boolean recordVariance, int start, int end) {
        int lastBlock;
        int firstBlock;
        if (recordVariance) {
            int[] loc;
            int blk;
            firstBlock = -1;
            for (blk = 0; blk < locations.size(); ++blk) {
                loc = (int[])locations.elementAt(blk);
                if (start > loc[1]) continue;
                firstBlock = blk;
                break;
            }
            if (firstBlock < 0) {
                return null;
            }
            lastBlock = locations.size() - 1;
            for (blk = firstBlock; blk < locations.size(); ++blk) {
                loc = (int[])locations.elementAt(blk);
                if (end > loc[1]) continue;
                lastBlock = blk;
                break;
            }
        } else {
            firstBlock = 0;
            lastBlock = 0;
        }
        return new int[]{firstBlock, lastBlock};
    }

    static ByteBuffer positionBuffer(CDFImpl impl, Variable var, int offset, int count) {
        ByteBuffer bv;
        if (!var.isCompressed()) {
            bv = impl.getValueBuffer(offset);
        } else {
            int size = var.getDataItemSize();
            bv = impl.getValueBuffer(offset, size, count);
        }
        bv.order(impl.getByteOrder());
        return bv;
    }

    static Object[] positionBuffer(CDFImpl impl, Variable var, int[] blockRange, int blk, int start, int end) {
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] loc = (int[])locations.elementAt(blk);
        int first = loc[0];
        int last = loc[1];
        ByteBuffer bv = Extractor.positionBuffer(impl, var, loc[2], last - first + 1);
        if (var.recordVariance()) {
            if (blk == blockRange[0]) {
                int size = var.getDataItemSize();
                bv.position(bv.position() + size * (start - first));
                first = start;
            }
            if (blk == blockRange[1]) {
                last = end;
            }
        }
        return new Object[]{bv, first, last};
    }

    public static double[][][][] getSeries3(CDF thisCDF, Variable var) throws Throwable {
        int type = var.getType();
        int cat = DataTypes.typeCategory[type];
        if (cat > 1) {
            throw new Throwable("Type category " + cat + " not supported in this context");
        }
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        int n0 = (Integer)Extractor.elementCount(var).elementAt(0);
        int n1 = (Integer)Extractor.elementCount(var).elementAt(1);
        int n2 = (Integer)Extractor.elementCount(var).elementAt(2);
        double[][][][] data = new double[nv][n0][n1][n2];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        block4: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int k;
                    int l;
                    int m;
                    FloatBuffer bvf = bv.asFloatBuffer();
                    if (var.rowMajority()) {
                        for (int n = first; n <= last; ++n) {
                            for (m = 0; m < n0; ++m) {
                                for (l = 0; l < n1; ++l) {
                                    for (k = 0; k < n2; ++k) {
                                        data[n][m][l][k] = bvf.get();
                                    }
                                }
                            }
                        }
                        continue block4;
                    }
                    for (int n = first; n <= last; ++n) {
                        for (m = 0; m < n2; ++m) {
                            for (l = 0; l < n1; ++l) {
                                for (k = 0; k < n0; ++k) {
                                    data[n][k][l][m] = bvf.get();
                                }
                            }
                        }
                    }
                    continue block4;
                }
                case 1: {
                    int k;
                    int l;
                    int m;
                    int n;
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    if (var.rowMajority()) {
                        for (n = first; n <= last; ++n) {
                            for (m = 0; m < n0; ++m) {
                                for (l = 0; l < n1; ++l) {
                                    for (k = 0; k < n2; ++k) {
                                        data[n][m][l][k] = bvd.get();
                                    }
                                }
                            }
                        }
                        continue block4;
                    }
                    for (n = first; n <= last; ++n) {
                        for (m = 0; m < n2; ++m) {
                            for (l = 0; l < n1; ++l) {
                                for (k = 0; k < n0; ++k) {
                                    data[n][k][l][m] = bvd.get();
                                }
                            }
                        }
                    }
                    continue block4;
                }
            }
        }
        return data;
    }

    public static double[][][] getPoint3(CDF thisCDF, Variable var, Integer pt) throws Throwable {
        int point = pt;
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            if (loc[1] < point) continue;
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], loc[1] - loc[0] + 1);
            int pos = bv.position() + (point - loc[0]) * itemSize;
            bv.position(pos);
            int n0 = (Integer)Extractor.elementCount(var).elementAt(0);
            int n1 = (Integer)Extractor.elementCount(var).elementAt(1);
            int n2 = (Integer)Extractor.elementCount(var).elementAt(2);
            double[][][] da = new double[n0][n1][n2];
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n2; ++k) {
                                    da[i][j][k] = bvf.get();
                                }
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n0; ++k) {
                                    da[k][j][i] = bvf.get();
                                }
                            }
                        }
                    }
                    return da;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n2; ++k) {
                                    da[i][j][k] = bvd.get();
                                }
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n0; ++k) {
                                    da[k][j][i] = bvd.get();
                                }
                            }
                        }
                    }
                    return da;
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n2; ++k) {
                                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                    da[i][j][k] = num.doubleValue();
                                }
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n0; ++k) {
                                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                    da[k][j][i] = num.doubleValue();
                                }
                            }
                        }
                    }
                    return da;
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    if (var.rowMajority()) {
                        for (int i = 0; i < n0; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n2; ++k) {
                                    double d;
                                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                    int x = num.intValue();
                                    da[i][j][k] = d = x >= 0 ? (double)x : (double)(longInt + (long)x);
                                }
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n1; ++j) {
                                for (int k = 0; k < n0; ++k) {
                                    double d;
                                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                                    int x = num.intValue();
                                    da[k][j][i] = d = x >= 0 ? (double)x : (double)(longInt + (long)x);
                                }
                            }
                        }
                    }
                    return da;
                }
            }
        }
        return null;
    }

    public static double[] get1DSeries(CDF thisCDF, Variable var, int[] pt) throws IllegalAccessException, InvocationTargetException {
        return (double[])Extractor.get1DSeries(thisCDF, var, pt, false);
    }

    public static Object get1DSeries(CDF thisCDF, Variable var, int[] pt, boolean preserve) throws IllegalAccessException, InvocationTargetException {
        int end = -1;
        int begin = 0;
        int nv = 0;
        if (pt != null) {
            if (var.recordVariance()) {
                begin = pt[0];
                nv = 1;
                if (pt.length > 1) {
                    end = pt[1];
                    nv = end - begin + 1;
                }
            }
        } else {
            nv = var.getNumberOfValues();
            if (nv == 0) {
                return null;
            }
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        long[] ldata = null;
        double[] data = null;
        boolean longType = false;
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        int elements = itemSize / DataTypes.size[type];
        if (DataTypes.typeCategory[type] == 5) {
            if (preserve) {
                ldata = new long[nv * elements];
            }
            if (!preserve) {
                data = new double[nv * elements];
            }
            longType = true;
        } else if (!preserve || DataTypes.typeCategory[type] != 0) {
            data = new double[nv * elements];
        }
        Object[] temp = null;
        if (DataTypes.typeCategory[type] == 0) {
            temp = new float[nv * elements];
        }
        if (longType && !preserve) {
            temp = new long[nv * elements];
        }
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int blk = 0;
        int offset = 0;
        if (pt == null) {
            begin = ((int[])locations.elementAt(0))[0];
            end = ((int[])locations.elementAt(locations.size() - 1))[1];
        }
        while (blk < locations.size()) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            if (last >= begin) {
                int count = last - first + 1;
                ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], count);
                if (begin > first) {
                    int pos = bv.position() + (begin - first) * itemSize;
                    bv.position(pos);
                }
                if (end < 0) {
                    if (longType && preserve) {
                        Extractor.do1D(bv, type, temp, ldata, 0, elements, preserve);
                    } else {
                        Extractor.do1D(bv, type, temp, data, 0, elements);
                    }
                    offset += elements;
                } else {
                    int term = end <= last ? end : last;
                    int init = begin > first ? begin : first;
                    count = term - init + 1;
                    if (longType && preserve) {
                        Extractor.do1D(bv, type, temp, ldata, offset, count * elements, preserve);
                    } else {
                        Extractor.do1D(bv, type, temp, data, offset, count * elements, preserve);
                    }
                    offset += count * elements;
                }
                if (end <= last) break;
            }
            ++blk;
        }
        if (offset == 0) {
            return null;
        }
        if (longType && preserve) {
            return ldata;
        }
        if (DataTypes.typeCategory[type] == 0 && preserve) {
            return temp;
        }
        return data;
    }

    static void do1D(ByteBuffer bv, int type, Object temp, Object result, int offset, int number) throws IllegalAccessException, InvocationTargetException {
        Extractor.do1D(bv, type, temp, result, offset, number, false);
    }

    static void do1D(ByteBuffer bv, int type, Object temp, Object result, int offset, int number, boolean preserve) throws IllegalAccessException, InvocationTargetException {
        double[] data = null;
        if (DataTypes.typeCategory[type] != 5) {
            data = (double[])result;
        }
        switch (DataTypes.typeCategory[type]) {
            case 0: {
                float[] tf = (float[])temp;
                FloatBuffer bvf = bv.asFloatBuffer();
                bvf.get(tf, offset, number);
                if (preserve) break;
                for (int n = 0; n < number; ++n) {
                    data[offset + n] = tf[n + offset];
                }
                break;
            }
            case 1: {
                DoubleBuffer bvd = bv.asDoubleBuffer();
                bvd.get(data, offset, number);
                break;
            }
            case 2: {
                Method method = DataTypes.method[type];
                for (int e = 0; e < number; ++e) {
                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                    data[offset + e] = num.doubleValue();
                }
                break;
            }
            case 3: {
                Method method = DataTypes.method[type];
                long longInt = DataTypes.longInt[type];
                for (int e = 0; e < number; ++e) {
                    Number num = (Number)method.invoke((Object)bv, new Object[0]);
                    int x = num.intValue();
                    data[offset + e] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                }
                break;
            }
            case 5: {
                LongBuffer bvl = bv.asLongBuffer();
                if (!preserve) {
                    long[] tl = (long[])temp;
                    data = (double[])result;
                    bvl.get(tl, offset, number);
                    for (int n = 0; n < number; ++n) {
                        data[offset + n] = tl[n];
                    }
                    break;
                }
                long[] ldata = (long[])result;
                bvl.get(ldata, offset, number);
            }
        }
    }

    public static double[] get1DSeries(CDF thisCDF, Variable var, int[] pt, int[] stride) throws IllegalAccessException, InvocationTargetException, Throwable {
        Stride strideObject;
        int _stride;
        int end = -1;
        int begin = 0;
        int nv = 0;
        if (pt != null) {
            if (var.recordVariance()) {
                begin = pt[0];
                nv = 1;
                if (pt.length > 1) {
                    end = pt[1];
                    nv = end - begin + 1;
                }
            }
        } else {
            nv = var.getNumberOfValues();
        }
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        if ((_stride = (strideObject = new Stride(stride)).getStride(nv)) > 1 && (nv /= _stride) % _stride != 0) {
            ++nv;
        }
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        int elements = itemSize / DataTypes.size[type];
        double[] data = new double[nv * elements];
        float[] tf = null;
        if (_stride == 1 && DataTypes.typeCategory[type] == 0) {
            tf = new float[nv * elements];
        }
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int blk = 0;
        int offset = 0;
        if (pt == null) {
            begin = ((int[])locations.elementAt(0))[0];
            end = ((int[])locations.elementAt(locations.size() - 1))[1];
        }
        boolean index = false;
        while (blk < locations.size()) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            if (last >= begin) {
                int init;
                int count = last - first + 1;
                ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], count);
                int pos = 0;
                if (begin > first) {
                    init = begin;
                } else {
                    int elapsed;
                    init = first;
                    if (_stride > 1 && (elapsed = first - begin) % _stride != 0) {
                        init = first - elapsed % _stride + _stride;
                    }
                }
                pos = bv.position() + (init - first) * itemSize;
                bv.position(pos);
                if (end < 0) {
                    Extractor.do1D(bv, type, tf, data, 0, elements);
                    offset += elements;
                } else {
                    int term;
                    int n = term = end <= last ? end : last;
                    if (_stride == 1) {
                        count = term - init + 1;
                        Extractor.do1D(bv, type, tf, data, offset, count * elements);
                    } else {
                        count = (term - init) / _stride;
                        if (count * _stride < term - init) {
                            ++count;
                        }
                        if (DataTypes.typeCategory[type] == 0) {
                            tf = new float[count * elements];
                        }
                        Extractor.do1D(bv, type, tf, data, offset, count, elements, _stride);
                    }
                    offset += count * elements;
                }
                if (end <= last) break;
            }
            ++blk;
        }
        if (offset == 0) {
            return null;
        }
        return data;
    }

    static void do1D(ByteBuffer bv, int type, float[] tf, double[] data, int offset, int count, int elements, int _stride) throws IllegalAccessException, InvocationTargetException, Throwable {
        int span = _stride * elements;
        int pos = bv.position();
        switch (DataTypes.typeCategory[type]) {
            case 0: {
                int n;
                FloatBuffer bvf = bv.asFloatBuffer();
                for (n = 0; n < count; ++n) {
                    bvf.position(n * span);
                    bvf.get(tf, n * elements, elements);
                }
                for (n = 0; n < count * elements; ++n) {
                    data[offset + n] = tf[n];
                }
                break;
            }
            case 1: {
                DoubleBuffer bvd = bv.asDoubleBuffer();
                for (int n = 0; n < count; ++n) {
                    bvd.position(n * span);
                    bvd.get(data, offset, elements);
                    offset += elements;
                }
                break;
            }
            case 2: {
                Method method = DataTypes.method[type];
                for (int n = 0; n < count; ++n) {
                    bv.position(pos + n * span);
                    for (int e = 0; e < elements; ++e) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        data[offset++] = num.doubleValue();
                    }
                }
                break;
            }
            case 3: {
                Method method = DataTypes.method[type];
                long longInt = DataTypes.longInt[type];
                for (int n = 0; n < count; ++n) {
                    bv.position(n * span);
                    for (int e = 0; e < elements; ++e) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        data[offset++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                    }
                }
                break;
            }
            default: {
                throw new Throwable("Unsupported data type for this context");
            }
        }
    }

    public static double[][] getSampledTimeSeries0(CDF thisCDF, Variable var, Boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        return Extractor.getSampledTimeSeries(thisCDF, var, null, ignoreFill, timeRange, stride);
    }

    public static double[][] getSampledTimeSeries1(CDF thisCDF, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        return Extractor.getSampledTimeSeries(thisCDF, var, which, ignoreFill, timeRange, stride);
    }

    public static double[][] getSampledTimeSeries(CDF thisCDF, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        double[] vdata;
        if (var.getNumberOfValues() == 0) {
            return null;
        }
        boolean ignore = ignoreFill;
        int[] recordRange = null;
        double[] times = null;
        times = ((CDFImpl)((Object)thisCDF)).getTimes(var, false);
        if (times == null) {
            return null;
        }
        Stride strideObject = new Stride(stride);
        if (timeRange == null) {
            vdata = which == null ? Extractor.getSeries0(thisCDF, var, strideObject) : Extractor.getElement1(thisCDF, var, which, strideObject);
        } else {
            recordRange = Extractor.getRecordRange(thisCDF, var, timeRange);
            if (recordRange == null) {
                return null;
            }
            vdata = which == null ? Extractor.getRange0(thisCDF, var, recordRange[0], recordRange[1], strideObject) : Extractor.getRangeForElement1(thisCDF, var, recordRange[0], recordRange[1], which, strideObject);
        }
        int _stride = strideObject.getStride();
        double[] fill = Extractor.getFillValue(thisCDF, var);
        if (!ignore || fill[0] != 0.0) {
            if (timeRange == null) {
                if (_stride == 1) {
                    return new double[][]{times, vdata};
                }
                double[] stimes = new double[vdata.length];
                for (int i = 0; i < vdata.length; ++i) {
                    stimes[i] = times[i * _stride];
                }
                return new double[][]{stimes, vdata};
            }
            double[] stimes = new double[vdata.length];
            if (_stride == 1) {
                System.arraycopy(times, recordRange[0], stimes, 0, vdata.length);
                return new double[][]{stimes, vdata};
            }
            int srec = recordRange[0];
            for (int i = 0; i < vdata.length; ++i) {
                stimes[i] = times[srec + i * _stride];
            }
            return new double[][]{stimes, vdata};
        }
        if (timeRange == null) {
            if (_stride == 1) {
                return Extractor.filterFill(times, vdata, fill[1], 0);
            }
            double[] stimes = new double[vdata.length];
            for (int i = 0; i < vdata.length; ++i) {
                stimes[i] = times[i * _stride];
            }
            return Extractor.filterFill(stimes, vdata, fill[1], 0);
        }
        double[] stimes = new double[vdata.length];
        if (_stride == 1) {
            System.arraycopy(times, recordRange[0], stimes, 0, vdata.length);
            return Extractor.filterFill(stimes, vdata, fill[1], 0);
        }
        int srec = recordRange[0];
        for (int i = 0; i < vdata.length; ++i) {
            stimes[i] = times[srec + i * _stride];
        }
        return Extractor.filterFill(stimes, vdata, fill[1], 0);
    }

    public static double[] getSeries0(CDF thisCDF, Variable var, Stride strideObject) throws IllegalAccessException, InvocationTargetException, Throwable {
        int numpt;
        int numberOfValues = var.getNumberOfValues();
        if (numberOfValues == 0) {
            return null;
        }
        int type = var.getType();
        int _stride = strideObject.getStride(numberOfValues);
        if (_stride == 1) {
            numpt = numberOfValues;
        } else {
            int cat = DataTypes.typeCategory[type];
            if (cat > 1) {
                throw new Throwable("Type category " + cat + " not supported in this context");
            }
            numpt = numberOfValues / _stride;
            if (numpt * _stride < numberOfValues) {
                ++numpt;
            }
        }
        double[] data = new double[numpt];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int next = 0;
        block6: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    int pos;
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (pos = n - first; pos <= last; pos += _stride) {
                        data[next++] = bvf.get(pos);
                    }
                    continue block6;
                }
                case 1: {
                    int pos;
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    while (pos <= last) {
                        data[next++] = bvd.get(pos);
                        pos += _stride;
                    }
                    continue block6;
                }
                case 2: {
                    int n;
                    Method method = DataTypes.method[type];
                    for (n = (n = first % _stride) == 0 ? first : first - n + _stride; n <= last; n += _stride) {
                        bv.position(4 * n);
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        data[next++] = num.doubleValue();
                    }
                    continue block6;
                }
                case 3: {
                    int n;
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    while (n <= last) {
                        bv.position(4 * n);
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        data[next++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                        n += _stride;
                    }
                    continue block6;
                }
            }
        }
        if (!var.recordVariance()) {
            for (int i = 1; i < numpt; ++i) {
                data[i] = data[0];
            }
        }
        return data;
    }

    public static double[] getElement1(CDF thisCDF, Variable var, Integer idx, Stride strideObject) throws Throwable {
        int element = idx;
        int nv = var.getNumberOfValues();
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        if (!Extractor.validElement(var, new int[]{element})) {
            return null;
        }
        int type = var.getType();
        int numpt = nv;
        int _stride = strideObject.getStride(nv);
        if (_stride != 1) {
            int cat = DataTypes.typeCategory[type];
            if (cat > 1) {
                throw new Throwable("Type category " + cat + " not supported in this context");
            }
            numpt = nv / _stride;
            if (numpt * _stride < nv) {
                ++numpt;
            }
        }
        double[] data = new double[numpt];
        int size = var.getDataItemSize();
        int advance = size * _stride;
        int loff = element * DataTypes.size[type];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int point = 0;
        block6: for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, loc[2], last - first + 1);
            int n = first % _stride;
            n = n == 0 ? first : first - n + _stride;
            int pos = bv.position() + (n - first) * size + loff;
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    while (n <= last) {
                        data[point++] = bv.getFloat(pos);
                        n += _stride;
                        pos += advance;
                    }
                    continue block6;
                }
                case 1: {
                    while (n <= last) {
                        data[point++] = bv.getDouble(pos);
                        n += _stride;
                        pos += advance;
                    }
                    continue block6;
                }
                case 2: {
                    int res;
                    point = res = Extractor.doSignedInteger(bv, pos, type, size, n, last, data, new int[]{_stride}, point);
                    continue block6;
                }
                case 3: {
                    int res;
                    point = res = Extractor.doUnsignedInteger(bv, pos, type, size, n, last, data, new int[]{_stride}, point);
                }
            }
        }
        return data;
    }

    static int doSignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data, int[] stride, int point) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        int index = point;
        bv.position(pos);
        int _stride = stride[0];
        int advance = _stride * size;
        for (int n = first; n <= last; n += _stride) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            data[index++] = num.doubleValue();
            bv.position(pos += advance);
        }
        return index;
    }

    static int doUnsignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data, int[] stride, int point) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        int index = point;
        bv.position(pos);
        int _stride = stride[0];
        int advance = _stride * size;
        for (int n = first; n <= last; n += _stride) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            int x = num.intValue();
            data[index++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            bv.position(pos += advance);
        }
        return index;
    }

    public static double[] getRange0(CDF thisCDF, Variable var, Integer istart, Integer iend, Stride strideObject) throws Throwable {
        int _stride;
        int nv;
        int begin = istart;
        if (begin < 0) {
            throw new Throwable("getRange0 start < 0");
        }
        int end = iend;
        if (end > (nv = var.getNumberOfValues())) {
            throw new Throwable("getRange0 end > available " + nv);
        }
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        if ((_stride = strideObject.getStride(nv = end - begin + 1)) > 1) {
            int numpt = nv / _stride;
            if (numpt * _stride < nv) {
                ++numpt;
            }
            nv = numpt;
        }
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        double[] data = new double[nv];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] blks = Extractor.getBlockRange(locations, var.recordVariance(), begin, end);
        int firstBlock = blks[0];
        int lastBlock = blks[1];
        int index = 0;
        block6: for (int blk = firstBlock; blk <= lastBlock; ++blk) {
            int n;
            int elapsed;
            Object[] oa = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, blks, blk, begin, end);
            ByteBuffer bv = (ByteBuffer)oa[0];
            int first = (Integer)oa[1];
            int last = (Integer)oa[2] - first;
            if (_stride > 1 && blk > firstBlock && (elapsed = first - begin) % _stride > 0) {
                n = _stride - (first - begin) % _stride;
                int pos = bv.position() + n * itemSize;
                bv.position(pos);
                last -= n;
            }
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    FloatBuffer bvf = bv.asFloatBuffer();
                    for (n = 0; n <= last; n += _stride) {
                        data[index++] = bvf.get(n);
                    }
                    continue block6;
                }
                case 1: {
                    DoubleBuffer bvd = bv.asDoubleBuffer();
                    while (n <= last) {
                        data[index++] = bvd.get();
                        n += _stride;
                    }
                    continue block6;
                }
                case 2: {
                    Method method = DataTypes.method[type];
                    while (n <= last) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        data[index++] = num.doubleValue();
                        n += _stride;
                    }
                    continue block6;
                }
                case 3: {
                    Method method = DataTypes.method[type];
                    long longInt = DataTypes.longInt[type];
                    while (n <= last) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        data[index++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
                        n += _stride;
                    }
                    continue block6;
                }
            }
        }
        if (!var.recordVariance()) {
            for (int i = begin; i <= end; i += _stride) {
                data[i - begin] = data[0];
            }
        }
        return data;
    }

    public static double[] getRangeForElement1(CDF thisCDF, Variable var, Integer istart, Integer iend, Integer ielement, Stride strideObject) throws Throwable {
        int _stride;
        int nv;
        int element = ielement;
        if (!Extractor.validElement(var, new int[]{element})) {
            return null;
        }
        int begin = istart;
        int end = iend;
        if (end > (nv = var.getNumberOfValues())) {
            throw new Throwable("getRange0 end > available " + nv);
        }
        if (nv == 0) {
            return null;
        }
        if (!var.recordVariance()) {
            nv = 1;
        }
        if ((_stride = strideObject.getStride(nv = end - begin + 1)) > 1) {
            int numpt = nv / _stride;
            if (numpt * _stride < nv) {
                ++numpt;
            }
            nv = numpt;
        }
        int type = var.getType();
        int itemSize = var.getDataItemSize();
        int advance = itemSize * _stride;
        double[] data = new double[nv];
        int loff = element * DataTypes.size[type];
        Vector locations = ((CDFImpl.DataLocator)var.getLocator()).locations;
        int[] blks = Extractor.getBlockRange(locations, var.recordVariance(), begin, end);
        int firstBlock = blks[0];
        int lastBlock = blks[1];
        int index = 0;
        block6: for (int blk = firstBlock; blk <= lastBlock; ++blk) {
            int elapsed;
            Object[] oa = Extractor.positionBuffer((CDFImpl)((Object)thisCDF), var, blks, blk, begin, end);
            ByteBuffer bv = (ByteBuffer)oa[0];
            int first = (Integer)oa[1];
            int last = (Integer)oa[2];
            int pos = bv.position() + loff;
            int n = first;
            if (_stride > 1 && blk > firstBlock && (elapsed = first - begin) % _stride != 0) {
                n = first + _stride - elapsed % _stride;
                pos += (n - first) * itemSize;
            }
            switch (DataTypes.typeCategory[type]) {
                case 0: {
                    while (n <= last) {
                        data[index++] = bv.getFloat(pos);
                        pos += advance;
                        n += _stride;
                    }
                    continue block6;
                }
                case 1: {
                    while (n <= last) {
                        data[index++] = bv.getDouble(pos);
                        pos += advance;
                        n += _stride;
                    }
                    continue block6;
                }
                case 2: {
                    index = Extractor.doSignedInteger(bv, pos, type, itemSize, n, last, data, index, new int[]{_stride});
                    continue block6;
                }
                case 3: {
                    index = Extractor.doUnsignedInteger(bv, pos, type, itemSize, n, last, data, index, new int[]{_stride});
                }
            }
        }
        if (!var.recordVariance()) {
            int n = 0;
            for (int i = begin; i <= end; i += _stride) {
                data[n++] = data[0];
            }
        }
        return data;
    }

    static int doSignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data, int index, int[] stride) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        bv.position(pos);
        for (int n = first; n <= last; n += stride[0]) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            data[index++] = num.doubleValue();
            bv.position(pos += size);
        }
        return index;
    }

    static int doUnsignedInteger(ByteBuffer bv, int pos, int type, int size, int first, int last, double[] data, int index, int[] stride) throws IllegalAccessException, InvocationTargetException {
        Method method = DataTypes.method[type];
        long longInt = DataTypes.longInt[type];
        bv.position(pos);
        for (int n = first; n <= last; n += stride[0]) {
            Number num = (Number)method.invoke((Object)bv, new Object[0]);
            int x = num.intValue();
            data[index++] = x >= 0 ? (double)x : (double)(longInt + (long)x);
            bv.position(pos += size);
        }
        return index;
    }

    public static TimeSeries getTimeSeriesObject0(CDF thisCDF, Variable var, Boolean ignoreFill, double[] timeRange, TimeSpec ts) throws Throwable {
        return new GeneralTimeSeries(thisCDF, var, null, ignoreFill, timeRange, ts);
    }

    public static TimeSeries getTimeSeriesObject1(CDF thisCDF, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, TimeSpec ts) throws Throwable {
        return new GeneralTimeSeries(thisCDF, var, which, ignoreFill, timeRange, ts);
    }

    static {
        try {
            Class<?> variableClass = Class.forName("gov.nasa.gsfc.voyager.cdf.Variable");
            Class<?> cdfClass = Class.forName("gov.nasa.gsfc.voyager.cdf.CDF");
            Class<?> timeSpecClass = Class.forName("gov.nasa.gsfc.voyager.cdf.TimeSpec");
            int[] ia = new int[]{};
            double[] da = new double[]{};
            Extractor.args[0][0] = new Class[]{cdfClass, variableClass};
            Extractor.args[0][1] = args[0][0];
            Extractor.args[0][2] = args[0][0];
            Extractor.args[0][3] = args[0][0];
            Extractor.args[1][0] = null;
            Extractor.args[1][1] = new Class[]{cdfClass, variableClass, Integer.class};
            Extractor.args[1][2] = new Class[]{cdfClass, variableClass, Integer.class, Integer.class};
            Extractor.args[2][0] = new Class[]{cdfClass, variableClass, Integer.class};
            Extractor.args[2][1] = args[2][0];
            Extractor.args[2][2] = args[2][0];
            Extractor.args[2][3] = args[2][0];
            Extractor.args[3][0] = new Class[]{cdfClass, variableClass, Integer.class, Integer.class};
            Extractor.args[3][1] = args[3][0];
            Extractor.args[3][2] = args[3][0];
            Extractor.args[4][0] = null;
            Extractor.args[4][1] = new Class[]{cdfClass, variableClass, ia.getClass()};
            Extractor.args[4][2] = null;
            Extractor.args[5][0] = null;
            Extractor.args[5][1] = new Class[]{cdfClass, variableClass, Integer.class, Integer.class, ia.getClass()};
            Extractor.args[5][2] = null;
            Extractor.args[6][0] = null;
            Extractor.args[6][1] = new Class[]{cdfClass, variableClass, Integer.class, Integer.class, Integer.class};
            Extractor.args[6][2] = null;
            Extractor.args[7][0] = new Class[]{cdfClass, variableClass, Boolean.class, da.getClass()};
            Extractor.args[7][1] = new Class[]{cdfClass, variableClass, Integer.class, Boolean.class, da.getClass()};
            Extractor.args[7][2] = null;
            Extractor.args[8][0] = new Class[]{cdfClass, variableClass, Boolean.class, da.getClass(), ia.getClass()};
            Extractor.args[8][1] = new Class[]{cdfClass, variableClass, Integer.class, Boolean.class, da.getClass(), ia.getClass()};
            Extractor.args[8][2] = null;
            Extractor.args[9][0] = new Class[]{cdfClass, variableClass, Boolean.class, da.getClass(), timeSpecClass};
            Extractor.args[9][1] = new Class[]{cdfClass, variableClass, Integer.class, Boolean.class, da.getClass(), timeSpecClass};
            Extractor.args[9][2] = null;
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        for (int i = 0; i < functions.length; ++i) {
            for (int j = 0; j <= MAX_ARRAY; ++j) {
                for (int k = 0; k < 2; ++k) {
                    Extractor.methods[i][j][k] = null;
                }
            }
        }
        try {
            Class<?> cl = Class.forName("gov.nasa.gsfc.voyager.cdf.Extractor");
            for (int i = 0; i < functions.length; ++i) {
                for (int j = 0; j <= MAX_ARRAY; ++j) {
                    if (args[i][j] == null) continue;
                    Extractor.methods[i][j][0] = cl.getMethod("get" + functions[i] + j, args[i][j]);
                }
            }
            Extractor.methods[0][0][1] = cl.getMethod("getStringSeries0", args[0][0]);
            Extractor.methods[0][1][1] = cl.getMethod("getStringSeries1", args[0][0]);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static class GeneralTimeSeries
    implements TimeSeries {
        double[] vdata;
        double[] times;
        TimeSpec tspec;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeneralTimeSeries(CDF thisCDF, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, TimeSpec ts) throws Throwable {
            double[] stimes;
            boolean ignore = ignoreFill;
            int[] recordRange = null;
            if (ts != null) {
                TimeSpec timeSpec = ts;
                synchronized (timeSpec) {
                    this.tspec = (TimeSpec)ts.clone();
                }
            } else {
                this.tspec = null;
            }
            this.times = ((CDFImpl)((Object)thisCDF)).getTimes(var, this.tspec, false);
            if (this.times == null) {
                throw new Throwable("times not available for " + var.getName());
            }
            boolean longType = false;
            int type = var.getType();
            if (DataTypes.typeCategory[type] == 5) {
                longType = true;
            }
            Object o = null;
            if (timeRange == null) {
                o = which == null ? Extractor.getSeries0(thisCDF, var) : Extractor.getElement1(thisCDF, var, which);
            } else {
                recordRange = Extractor.getRecordRange(thisCDF, var, timeRange);
                if (recordRange == null) {
                    throw new Throwable("no record range");
                }
                o = which == null ? Extractor.getRange0(thisCDF, var, recordRange[0], recordRange[1]) : Extractor.getRangeForElement1(thisCDF, var, recordRange[0], recordRange[1], which);
            }
            this.vdata = Extractor.castToDouble(o, longType);
            if (!ignore) {
                if (timeRange != null) {
                    stimes = new double[this.vdata.length];
                    System.arraycopy(this.times, recordRange[0], stimes, 0, this.vdata.length);
                    this.times = stimes;
                }
            } else {
                int first;
                double[] fill = Extractor.getFillValue(thisCDF, var);
                int n = first = timeRange != null ? recordRange[0] : 0;
                if (fill[0] != 0.0) {
                    stimes = new double[this.vdata.length];
                    System.arraycopy(this.times, first, stimes, 0, this.vdata.length);
                    this.times = stimes;
                } else {
                    Extractor.filterFill(this.times, this.vdata, fill[1], first);
                }
            }
        }

        public double[] getTimes() {
            return this.times;
        }

        public double[] getValues() {
            return this.vdata;
        }

        public TimeSpec getTimeSpec() {
            return this.tspec;
        }
    }
}

