/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdf;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

public class SegmentedBufferDataSet
extends AbstractDataSet {
    private final int rank;
    private final int[] segStart;
    private final int[] segStop;
    private int currentSegment = 0;
    private QDataSet[] segments;

    protected SegmentedBufferDataSet(int rank, QDataSet[] segments) {
        this.rank = rank;
        this.segStart = new int[segments.length];
        this.segStop = new int[segments.length];
        this.segStart[0] = 0;
        int[] tqube = null;
        for (int i = 0; i < segments.length; ++i) {
            if (i == 0) {
                tqube = DataSetUtil.qubeDims(segments[i]);
            } else {
                this.segStart[i] = this.segStart[i - 1];
                if (tqube != null) {
                    int[] qube = DataSetUtil.qubeDims(segments[i]);
                    if (qube == null) {
                        tqube = null;
                    } else {
                        for (int j = 1; j < qube.length; ++j) {
                            if (qube[j] == tqube[j]) continue;
                            tqube = null;
                            break;
                        }
                    }
                }
            }
            this.segStop[i] = this.segStart[i] + segments[i].length();
        }
        if (tqube != null) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    public int rank() {
        return this.rank;
    }

    protected synchronized int segmentFor(int idx0) {
        if (this.segStart[this.currentSegment] <= idx0 && this.segStop[this.currentSegment] < idx0) {
            return this.currentSegment;
        }
        while (this.currentSegment < this.segStart.length && idx0 >= this.segStop[this.currentSegment]) {
            ++this.currentSegment;
        }
        if (this.currentSegment == this.segStart.length) {
            this.currentSegment = 0;
            throw new IndexOutOfBoundsException(String.format("%d is too high", idx0));
        }
        while (this.currentSegment > 0 && idx0 < this.segStart[this.currentSegment]) {
            --this.currentSegment;
        }
        if (this.currentSegment < 0) {
            this.currentSegment = 0;
            throw new IndexOutOfBoundsException(String.format("%d is too high", idx0));
        }
        return this.currentSegment;
    }

    public int length(int idx0) {
        int ids = this.segmentFor(idx0);
        int i = idx0 - this.segStart[ids];
        return this.segments[ids].length(i);
    }

    public int length(int idx0, int j) {
        int ids = this.segmentFor(idx0);
        int i = idx0 - this.segStart[ids];
        return this.segments[ids].length(i, j);
    }

    public int length(int idx0, int j, int k) {
        int ids = this.segmentFor(idx0);
        int i = idx0 - this.segStart[ids];
        return this.segments[ids].length(i, j, k);
    }

    public QDataSet slice(int idx0) {
        int ids = this.segmentFor(idx0);
        int i = idx0 - this.segStart[ids];
        return this.segments[ids].slice(i);
    }

    public QDataSet trim(int start, int stop) {
        int ids1;
        int ids0 = this.segmentFor(start);
        if (ids0 == (ids1 = this.segmentFor(stop))) {
            int off = this.segStart[ids0];
            return this.segments[ids0].trim(start - off, stop - off);
        }
        return DataSetOps.trim(this, start, stop);
    }

    public double value(int i0) {
        int ids = this.segmentFor(i0);
        return this.segments[ids].value(i0 - this.segStart[ids]);
    }

    public double value(int i0, int i1) {
        int ids = this.segmentFor(i0);
        return this.segments[ids].value(i0 - this.segStart[ids], i1);
    }

    public double value(int i0, int i1, int i2) {
        int ids = this.segmentFor(i0);
        return this.segments[ids].value(i0 - this.segStart[ids], i1, i2);
    }

    public double value(int i0, int i1, int i2, int i3) {
        int ids = this.segmentFor(i0);
        return this.segments[ids].value(i0 - this.segStart[ids], i1, i2, i3);
    }
}

