/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdf;

import java.lang.reflect.Array;
import org.virbo.cdf.TrDDataSet;
import org.virbo.cdf.TrFDataSet;
import org.virbo.dataset.AbstractDataSet;

public abstract class TrArrayDataSet
extends AbstractDataSet {
    float fill = Float.NaN;
    double dfill = Double.NaN;

    public static TrArrayDataSet wrap(Object array, int[] qube, boolean copy) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("input must be an array");
        }
        Class<?> c = array.getClass().getComponentType();
        if (c.isArray()) {
            throw new IllegalArgumentException("input must be 1-D array");
        }
        if (copy) {
            Object arr = Array.newInstance(c, Array.getLength(array));
            System.arraycopy(array, 0, arr, 0, Array.getLength(array));
        } else {
            Object arr = array;
        }
        if (c == Double.TYPE) {
            return TrDDataSet.wrap((double[])array, qube);
        }
        if (c == Float.TYPE) {
            return TrFDataSet.wrap((float[])array, qube);
        }
        throw new IllegalArgumentException("component type not supported: " + c);
    }

    public Class getComponentType() {
        return this.getBack().getClass().getComponentType();
    }

    protected abstract Object getBack();

    public int jvmMemory() {
        int sizePer;
        Class component = this.getComponentType();
        if (component == Double.TYPE) {
            sizePer = 8;
        } else if (component == Float.TYPE) {
            sizePer = 4;
        } else if (component == Long.TYPE) {
            sizePer = 8;
        } else if (component == Integer.TYPE) {
            sizePer = 4;
        } else if (component == Short.TYPE) {
            sizePer = 2;
        } else if (component == Byte.TYPE) {
            sizePer = 1;
        } else {
            throw new IllegalArgumentException("not supported " + component);
        }
        return Array.getLength(this.getBack()) * sizePer;
    }

    protected void checkFill() {
        Number f = (Number)this.properties.get("FILL_VALUE");
        if (f != null) {
            this.fill = f.floatValue();
            this.dfill = f.doubleValue();
        } else {
            this.fill = Float.NaN;
            this.dfill = Double.NaN;
        }
    }
}

