/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdf;

import java.util.HashMap;
import java.util.Map;
import org.virbo.cdf.TrArrayDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.WritableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrDDataSet
extends TrArrayDataSet
implements WritableDataSet,
RankZeroDataSet {
    double[] back;
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    private static final boolean RANGE_CHECK = false;
    public static final String version = "20090605";

    public static TrDDataSet createRank1(int len0) {
        return new TrDDataSet(1, len0, 1, 1, 1);
    }

    public static TrDDataSet createRank2(int len0, int len1) {
        return new TrDDataSet(2, len0, len1, 1, 1);
    }

    public static TrDDataSet createRank3(int len0, int len1, int len2) {
        return new TrDDataSet(3, len0, len1, len2, 1);
    }

    public static TrDDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new TrDDataSet(4, len0, len1, len2, len3);
    }

    public static TrDDataSet create(int[] qube) {
        if (qube.length == 0) {
            return new TrDDataSet(0, 1, 1, 1, 1);
        }
        if (qube.length == 1) {
            return TrDDataSet.createRank1(qube[0]);
        }
        if (qube.length == 2) {
            return TrDDataSet.createRank2(qube[0], qube[1]);
        }
        if (qube.length == 3) {
            return TrDDataSet.createRank3(qube[0], qube[1], qube[2]);
        }
        if (qube.length == 4) {
            return TrDDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static TrDDataSet wrap(double[] data, int[] qube) {
        if (qube.length == 0) {
            return new TrDDataSet(1, 1, 1, 1, 1, data);
        }
        if (qube.length == 1) {
            return new TrDDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new TrDDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new TrDDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new TrDDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    private TrDDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new double[len0 * len1 * len2 * len3]);
    }

    private TrDDataSet(int rank, int len0, int len1, int len2, int len3, double[] back) {
        if (back == null) {
            throw new NullPointerException("back was null");
        }
        if (back.length < len0 * len1 * len2 * len3) {
            throw new IllegalArgumentException("back.length < len0 * len1 * len2 * len3 in TrDDataSet.");
        }
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        DataSetUtil.addQube(this);
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public int length() {
        return this.len0;
    }

    @Override
    public int length(int i) {
        return this.len1;
    }

    @Override
    public int length(int i0, int i1) {
        return this.len2;
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.len3;
    }

    @Override
    public double value() {
        return this.back[0];
    }

    @Override
    public double value(int i0) {
        return this.back[i0];
    }

    @Override
    public double value(int i0, int i1) {
        return this.back[i0 * this.len1 + i1];
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.back[i0 * this.len1 * this.len2 + i2 * this.len1 + i1];
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.back[i0 * this.len1 * this.len2 * this.len3 + i3 * this.len2 * this.len1 + i2 * this.len1 + i1];
    }

    @Override
    public void putValue(double value) {
        this.back[0] = value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.back[i0] = value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i2 * this.len1 + i1] = value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.back[i0 * this.len1 * this.len2 * this.len3 + i3 * this.len1 * this.len2 + i2 * this.len1 + i1] = value;
    }

    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    @Override
    public String toString() {
        return DataSetUtil.toString(this);
    }

    protected static Map copyProperties(QDataSet ds) {
        QDataSet plane0;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> srcProps = DataSetUtil.getProperties(ds);
        result.putAll(srcProps);
        for (i = 0; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == ds) {
                throw new IllegalArgumentException("dataset is dependent on itsself!");
            }
            if (dep == null) continue;
            result.put("DEPEND_" + i, TrDDataSet.copy(dep));
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, TrDDataSet.copy(plane0));
        }
        return result;
    }

    private static TrDDataSet ddcopy(TrDDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        double[] newback = new double[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        TrDDataSet result = new TrDDataSet(ds.rank, ds.len0, ds.len1, ds.len2, ds.len3, newback);
        result.properties.putAll(TrDDataSet.copyProperties(ds));
        return result;
    }

    public static TrDDataSet maybeCopy(QDataSet ds) {
        if (ds instanceof TrDDataSet) {
            return (TrDDataSet)ds;
        }
        return TrDDataSet.copy(ds);
    }

    public static TrDDataSet copy(QDataSet ds) {
        TrDDataSet result;
        if (ds instanceof TrDDataSet) {
            return TrDDataSet.ddcopy((TrDDataSet)ds);
        }
        int rank = ds.rank();
        if (!DataSetUtil.isQube(ds)) {
            System.err.println("copy of non-qube to DDataSet, which must be qube");
        }
        switch (rank) {
            case 0: {
                result = TrDDataSet.createRank1(1);
                result.rank = 0;
                result.putValue(ds.value());
                break;
            }
            case 1: {
                result = TrDDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                result = TrDDataSet.createRank2(ds.length(), len1);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                int len2 = len1 == 0 ? 0 : ds.length(0, 0);
                result = TrDDataSet.createRank3(ds.length(), len1, len2);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                int len2 = len1 == 0 ? 0 : ds.length(0, 0);
                int len3 = len2 == 0 ? 0 : ds.length(0, 0, 0);
                result = TrDDataSet.createRank4(ds.length(), len1, len2, len3);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(TrDDataSet.copyProperties(ds));
        return result;
    }

    public static TrDDataSet wrap(double[] back) {
        return new TrDDataSet(1, back.length, 1, 1, 1, back);
    }

    public static TrDDataSet wrapRank2(double[] back, int n1) {
        return new TrDDataSet(2, back.length / n1, n1, 1, 1, back);
    }

    public static TrDDataSet wrapRank3(double[] back, int n1, int n2) {
        return new TrDDataSet(3, back.length / (n1 * n2), n1, n2, 1, back);
    }

    public static TrDDataSet wrap(double[] back, int nx, int ny) {
        return new TrDDataSet(2, nx, ny, 1, 1, back);
    }

    public static TrDDataSet wrap(double[] back, int rank, int len0, int len1, int len2) {
        return new TrDDataSet(rank, len0, len1, len2, 1, back);
    }

    public static TrDDataSet wrap(double[] back, int rank, int len0, int len1, int len2, int len3) {
        return new TrDDataSet(rank, len0, len1, len2, len3, back);
    }

    private void joinProperties(TrDDataSet ds) {
        TrDDataSet djoin;
        QDataSet dep0;
        QDataSet dep1;
        int i;
        HashMap<String, TrDDataSet> result = new HashMap<String, TrDDataSet>();
        for (i = 0; i < 1; ++i) {
            dep1 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            dep0 = (QDataSet)this.property("DEPEND_" + i);
            djoin = TrDDataSet.copy(dep0);
            TrDDataSet ddep1 = dep1 instanceof TrDDataSet ? (TrDDataSet)dep1 : TrDDataSet.copy(dep1);
            djoin.append(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        for (i = 0; i < 50 && (dep1 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            dep0 = (QDataSet)this.property("PLANE_" + i);
            djoin = TrDDataSet.copy(dep0);
            TrDDataSet dd1 = dep1 instanceof TrDDataSet ? (TrDDataSet)dep1 : TrDDataSet.copy(dep1);
            djoin.append(dd1);
            result.put("PLANE_" + i, djoin);
        }
        this.properties.putAll(result);
    }

    public static void copyElements(TrDDataSet src, int srcpos, TrDDataSet dest, int destpos, int len) {
        if (src.len1 != dest.len1 || src.len2 != dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        TrDDataSet.copyElements(src, srcpos, dest, destpos, len * src.len1 * src.len2, false);
    }

    public static void copyElements(TrDDataSet src, int srcpos, TrDDataSet dest, int destpos, int len, boolean checkAlias) {
        if (checkAlias && src.len1 * src.len2 != dest.len1 * dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        int srcpos1 = srcpos * src.len1 * src.len2;
        int destpos1 = destpos * dest.len1 * dest.len2;
        int len1 = len;
        System.arraycopy(src.back, srcpos1, dest.back, destpos1, len1);
    }

    public void join(TrDDataSet ds) {
        this.append(ds);
    }

    public void append(TrDDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        double[] newback = new double[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }

    @Override
    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        double[] newback = new double[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        TrDDataSet result = new TrDDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        DataSetUtil.putProperties(DataSetUtil.getProperties(this), result);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", dep0.trim(start, end));
        }
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)this;
        }
        return super.capability(clazz);
    }
}

