/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.parser.ParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Units;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.dods.DodsAdapter;
import org.virbo.dods.MyDASParser;
import org.virbo.dods.MyDDSParser;
import org.virbo.metatree.IstpMetadataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DodsDataSource
extends AbstractDataSource {
    DodsAdapter adapter;
    String variable;
    String sMyUrl;
    String constraint;
    Map<String, Object> metadata;
    DAS das;
    private static final Logger logger = Logger.getLogger("autoplot.dodsdatasource");

    public DodsDataSource(URI uri) throws IOException {
        super(uri);
        String surl = uri.getRawSchemeSpecificPart();
        int k = surl.lastIndexOf("?");
        int i = k == -1 ? surl.lastIndexOf(46) : surl.lastIndexOf(46, k);
        this.sMyUrl = surl.substring(0, i);
        i = surl.indexOf(63);
        String variableConstraint = null;
        if (i != -1) {
            String s = surl.substring(i + 1);
            s = DataSetURI.maybePlusToSpace((String)s);
            variableConstraint = URISplit.uriDecode((String)s);
            StringTokenizer tok = new StringTokenizer(variableConstraint, "[<>", true);
            String name = tok.nextToken();
            if (tok.hasMoreTokens()) {
                String delim = tok.nextToken();
                if (delim.equals("[")) {
                    this.variable = name;
                }
                this.constraint = "?" + variableConstraint;
            } else {
                this.variable = name;
            }
        }
        try {
            URL myUrl = new URL(this.sMyUrl);
            this.adapter = new DodsAdapter(myUrl, this.variable);
            if (this.constraint != null) {
                this.adapter.setConstraint(this.constraint);
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getIstpConstraint(DodsAdapter da, Map meta, MyDDSParser parser, String variable) throws DDSException {
        int i;
        StringBuilder constraint1 = new StringBuilder("?");
        constraint1.append(variable);
        String dimsStr = null;
        if (da.getConstraint() != null) {
            i = da.getConstraint().indexOf(91);
            if (i != -1) {
                dimsStr = da.getConstraint().substring(i);
                constraint1.append(dimsStr);
            }
        } else {
            int[] ii = parser.getRecDims(variable);
            if (ii != null) {
                for (int i2 = 0; i2 < ii.length; ++i2) {
                    dimsStr = "";
                    constraint1.append(dimsStr);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            String dkey = "DEPEND_" + i;
            if (!meta.containsKey(dkey)) continue;
            Map val = (Map)meta.get(dkey);
            String var = (String)val.get("NAME");
            constraint1.append(",").append(var);
            if (dimsStr != null) {
                constraint1.append(dimsStr);
            }
            da.setDependName(i, var);
            Map<String, Object> depMeta = this.getMetaData(var);
            Map m = new IstpMetadataModel().properties(depMeta);
            if (m.containsKey("UNITS")) {
                da.setDimUnits(i, (Units)m.get("UNITS"));
            }
            da.setDimProperties(i, m);
        }
        da.setConstraint(constraint1.toString());
        return constraint1.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet(ProgressMonitor mon) throws FileNotFoundException, MalformedURLException, IOException, ParseException, DDSException, DODSException, CancelledOperationException {
        CharSequence constraint1;
        mon.setTaskSize(-1L);
        mon.started();
        MyDDSParser parser = new MyDDSParser();
        parser.parse(new URL(this.adapter.getSource().toString() + ".dds").openStream());
        this.getMetadata(mon);
        Map interpretedMetadata = null;
        boolean isIstp = this.adapter.getSource().toString().endsWith(".cdf");
        if (isIstp) {
            Map m;
            interpretedMetadata = m = new IstpMetadataModel().properties(this.metadata);
        }
        if (isIstp) {
            constraint1 = this.getIstpConstraint(this.adapter, this.metadata, parser, this.variable);
            this.adapter.setConstraint((String)constraint1);
        } else if (this.constraint == null && this.adapter.getVariable() != null) {
            int[] ii;
            constraint1 = new StringBuilder("?");
            ((StringBuilder)constraint1).append(this.adapter.getVariable());
            if (!this.adapter.getVariable().contains("[") && (ii = parser.getRecDims(this.adapter.getVariable())) != null) {
                for (int i = 0; i < ii.length; ++i) {
                    ((StringBuilder)constraint1).append("[0:1:").append(ii[i]).append("]");
                }
            }
            this.adapter.setConstraint(((StringBuilder)constraint1).toString());
        }
        this.adapter.loadDataset(mon, this.metadata);
        MutablePropertyDataSet ds = (MutablePropertyDataSet)this.adapter.getDataSet(this.metadata);
        if (isIstp) {
            interpretedMetadata.remove("DEPEND_0");
            interpretedMetadata.remove("DEPEND_1");
            interpretedMetadata.remove("DEPEND_2");
            DataSetUtil.putProperties((Map)interpretedMetadata, (MutablePropertyDataSet)ds);
        }
        mon.finished();
        DodsDataSource dodsDataSource = this;
        synchronized (dodsDataSource) {
            AttributeTable at = this.das.getAttributeTable(this.variable);
            ds.putProperty("METADATA", (Object)at);
        }
        if (DataSetURI.fromUri((URI)this.uri).contains(".cdf.dds")) {
            ds.putProperty("METADATA_MODEL", (Object)"ISTP-CDF");
        }
        return ds;
    }

    public MetadataModel getMetadataModel() {
        if (DataSetURI.fromUri((URI)this.uri).contains(".cdf.dds")) {
            return new IstpMetadataModel();
        }
        return super.getMetadataModel();
    }

    private synchronized Map<String, Object> getMetaData(String variable) {
        AttributeTable at = this.das.getAttributeTable(variable);
        return this.getMetaData(at);
    }

    private Map<String, Object> getMetaData(AttributeTable at) {
        if (at == null) {
            return new HashMap<String, Object>();
        }
        Pattern p = Pattern.compile("DEPEND_[0-9]");
        Pattern p2 = Pattern.compile("LABL_PTR_([0-9])");
        Enumeration n = at.getNames();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (n.hasMoreElements()) {
            Object key = n.nextElement();
            Attribute att = at.getAttribute((String)key);
            Matcher m = null;
            try {
                Map<String, Object> newVal;
                Object name;
                Object val;
                int type = att.getType();
                if (type == 2) {
                    val = this.getMetaData(att.getContainer());
                    result.put(att.getName(), val);
                    continue;
                }
                val = att.getValueAt(0);
                val = DataSourceUtil.unquote((String)val);
                if (p.matcher(att.getName()).matches()) {
                    name = val;
                    newVal = this.getMetaData((String)name);
                    newVal.put("NAME", name);
                    result.put(att.getName(), newVal);
                    continue;
                }
                m = p2.matcher(att.getName());
                if (m.matches()) {
                    name = val;
                    newVal = this.getMetaData((String)name);
                    newVal.put("NAME", name);
                    result.put("DEPEND_" + m.group(1), newVal);
                    continue;
                }
                if (((String)val).length() > 0) {
                    result.put(att.getName(), val);
                    continue;
                }
                logger.fine("skipping " + att.getName() + "  because length=0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws IOException, DASException, ParseException {
        if (this.metadata == null) {
            MyDASParser parser = new MyDASParser();
            URL url = new URL(this.adapter.getSource().toString() + ".das");
            parser.parse(url.openStream());
            this.das = parser.getDAS();
            if (this.variable == null) {
                this.variable = (String)this.das.getNames().nextElement();
                this.adapter.setVariable(this.variable);
            }
            this.metadata = this.getMetaData(this.variable);
        }
        return this.metadata;
    }
}

