/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cefdatasource.Cef;
import org.virbo.cefdatasource.CefDataSource;
import org.virbo.cefdatasource.CefReaderHeader;
import org.virbo.datasource.AbstractDataSourceFactory;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CefDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new CefDataSource(uri);
    }

    private List<String> getPlottable(URI uri, ProgressMonitor mon) throws IOException {
        File f = DataSetURI.getFile((URI)uri, (ProgressMonitor)mon);
        ReadableByteChannel in = Channels.newChannel(new FileInputStream(f));
        CefReaderHeader reader = new CefReaderHeader();
        Cef cef = reader.read(in);
        Map<String, CefReaderHeader.ParamStruct> h = cef.parameters;
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(h.keySet());
        return result;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            try {
                String surl = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                List<String> plottable = this.getPlottable(DataSetURI.getResourceURI((String)surl), mon);
                for (String s : plottable) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, s, (DataSourceFactory)this, "arg_0", null, null, true));
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        return !surl.contains("?") || surl.indexOf("?") == surl.length() - 1;
    }
}

