/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankNDataSet;

public class ReformDataSet
extends AbstractDataSet
implements RankNDataSet {
    int dsLen1;
    int n0;
    int n1;
    int n2;
    int n3;
    int[] sizes;
    int offset;
    final int rank;
    final QDataSet ds;

    public ReformDataSet(QDataSet ds, int[] sizes) {
        this(ds, 0, sizes);
    }

    public ReformDataSet(QDataSet ds, int offset, int[] sizes) {
        QDataSet dep0;
        this.ds = ds;
        this.dsLen1 = ds.length(0);
        this.offset = offset;
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("input rank must==2");
        }
        if (!Boolean.TRUE.equals(ds.property("QUBE"))) {
            throw new IllegalArgumentException("dataset must be marked as QUBE");
        }
        this.rank = sizes.length;
        this.sizes = sizes;
        if (this.rank > 4) {
            throw new IllegalArgumentException("sizes imply dataset with rank " + this.rank + ", too high");
        }
        this.n0 = sizes[0];
        if (this.rank > 1) {
            this.n1 = sizes[1];
        }
        if (this.rank > 2) {
            this.n2 = sizes[2];
        }
        if (this.rank > 3) {
            this.n3 = sizes[3];
        }
        if ((dep0 = (QDataSet)ds.property("DEPEND_0")) != null && sizes[0] == ds.length()) {
            this.putProperty("DEPEND_0", dep0);
        }
        DataSetUtil.putProperties((Map)DataSetUtil.getProperties((QDataSet)ds), (MutablePropertyDataSet)this);
        this.putProperty("DEPEND_1", null);
    }

    public int rank() {
        return this.rank;
    }

    public double value(int i) {
        return this.ds.value(i % this.dsLen1, i / this.dsLen1);
    }

    public double value(int i0, int i1) {
        int i = this.offset + i0 * this.n1 + i1;
        return this.ds.value(i / this.dsLen1, i % this.dsLen1);
    }

    public double value(int i0, int i1, int i2) {
        int i = this.offset + i0 * this.n1 * this.n2 + i1 * this.n2 + i2;
        return this.ds.value(i / this.dsLen1, i % this.dsLen1);
    }

    public double value(int i0, int i1, int i2, int i3) {
        int i = this.offset + i0 * this.n1 * this.n2 * this.n3 + i1 * this.n2 * this.n3 + i2 * this.n3 + i3;
        return this.ds.value(i / this.dsLen1, i % this.dsLen1);
    }

    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.ds.property(name);
    }

    public int length() {
        return this.n0;
    }

    public int length(int i) {
        return this.n1;
    }

    public int length(int i, int j) {
        return this.n2;
    }

    public int length(int i, int j, int k) {
        return this.n3;
    }

    public QDataSet slice(int dim) {
        int[] newSizes = new int[this.rank - 1];
        this.offset = dim;
        for (int i = 0; i < this.rank - 1; ++i) {
            newSizes[i] = this.sizes[i + 1];
            this.offset *= this.sizes[i + 1];
        }
        return new ReformDataSet(this.ds, this.offset, newSizes);
    }

    public String toString() {
        String u;
        int[] qube;
        String name = (String)this.ds.property("NAME");
        if (name == null) {
            name = "dataSet";
        }
        String qubeStr = (qube = DataSetUtil.qubeDims((QDataSet)this)) == null ? "*" : "";
        StringBuffer dimStr = new StringBuffer("" + this.length());
        if (qube != null) {
            for (int i = 1; i < qube.length; ++i) {
                dimStr.append("," + qube[i]);
            }
        } else {
            if (this.rank() > 1) {
                dimStr.append("," + this.length(0) + qubeStr);
            }
            if (this.rank() > 2) {
                dimStr.append("," + this.length(0, 0) + qubeStr);
            }
        }
        if ((u = String.valueOf(this.ds.property("UNITS"))).equals("null") || u.equals("")) {
            u = "dimensionless";
        }
        return name + "[" + dimStr.toString() + "] (" + u + ")";
    }
}

