/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import gov.nasa.gsfc.voyager.cdf.CDF2;
import gov.nasa.gsfc.voyager.cdf.CDFImpl;
import gov.nasa.gsfc.voyager.cdf.DataTypes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class CDF2Impl
extends CDFImpl
implements CDF2,
Serializable {
    public int GDROffset;
    public int VAR_OFFSET_NAME;
    public int OFFSET_zNumDims;
    public int VAR_OFFSET_NUM_ELEMENTS;
    public int OFFSET_NUM;

    public CDF2Impl(ByteBuffer buf, int release) throws Throwable {
        super(buf);
        if (release < 5) {
            this.VAR_OFFSET_NAME = 192;
            this.VAR_OFFSET_NUM_ELEMENTS = 176;
            this.OFFSET_NUM = 180;
        } else {
            this.VAR_OFFSET_NAME = 64;
            this.VAR_OFFSET_NUM_ELEMENTS = 48;
            this.OFFSET_NUM = 52;
        }
        this.OFFSET_zNumDims = this.VAR_OFFSET_NAME + 64;
        this.setOffsets();
        this.thisCDF = this;
        IntBuffer ibuf = buf.asIntBuffer();
        ByteBuffer _buf = this.getRecord(0);
        ibuf.position(2);
        ibuf.get();
        ibuf.position(3);
        ibuf.get();
        this.GDROffset = ibuf.get();
        this.version = ibuf.get();
        if (this.version != 2) {
            throw new Throwable("Version " + this.version + "is not accepted by this reader.");
        }
        ibuf.get();
        this.encoding = ibuf.get();
        this.byteOrder = DataTypes.getByteOrder(this.encoding);
        this.setByteOrder(this.byteOrder);
        this.flags = ibuf.get();
        ibuf.get();
        ibuf.get();
        this.increment = ibuf.get();
        int pos = this.GDROffset + 4;
        buf.position(pos);
        int x = buf.getInt();
        if (x != 2) {
            throw new Throwable("Bad GDR type " + x);
        }
        this.rVDRHead = buf.getInt();
        this.zVDRHead = buf.getInt();
        this.ADRHead = buf.getInt();
        buf.getInt();
        this.numberOfRVariables = buf.getInt();
        this.numberOfAttributes = buf.getInt();
        buf.getInt();
        int numberOfRDims = buf.getInt();
        this.numberOfZVariables = buf.getInt();
        buf.getInt();
        this.rDimSizes = new int[numberOfRDims];
        if (numberOfRDims > 0) {
            buf.getInt();
            buf.getInt();
            buf.getInt();
            for (int i = 0; i < this.rDimSizes.length; ++i) {
                this.rDimSizes[i] = buf.getInt();
            }
        }
        buf.position(0);
        this.variableTable = this.variables();
        this.attributeTable = this.attributes();
    }

    void setOffsets() {
        this.offset_NEXT_VDR = 8;
        this.offset_NEXT_ADR = 8;
        this.offset_ATTR_NAME = 52;
        this.offset_SCOPE = 16;
        this.offset_AgrEDRHead = 12;
        this.offset_AzEDRHead = 36;
        this.offset_NEXT_AEDR = 8;
        this.offset_ENTRYNUM = 20;
        this.offset_ATTR_DATATYPE = 16;
        this.offset_ATTR_NUM_ELEMENTS = 24;
        this.offset_VALUE = 48;
        this.offset_VAR_NAME = this.VAR_OFFSET_NAME;
        this.offset_VAR_NUM_ELEMENTS = this.VAR_OFFSET_NUM_ELEMENTS;
        this.offset_NUM = this.OFFSET_NUM;
        this.offset_FLAGS = 28;
        this.offset_BLOCKING_FACTOR = 60;
        this.offset_VAR_DATATYPE = 12;
        this.offset_zNumDims = this.OFFSET_zNumDims;
        this.offset_FIRST_VXR = 20;
        this.offset_NEXT_VXR = 8;
        this.offset_NENTRIES = 12;
        this.offset_NUSED = 16;
        this.offset_FIRST = 20;
        this.offset_RECORD_TYPE = 4;
        this.offset_RECORDS = 8;
        this.offset_CSIZE = 12;
        this.offset_CDATA = 16;
    }

    public String getString(int offset) {
        return this.getString(offset, 64);
    }

    public int lowOrderInt(ByteBuffer buf) {
        return buf.getInt();
    }

    public int lowOrderInt(ByteBuffer buf, int offset) {
        return buf.getInt(offset);
    }
}

