/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import gov.nasa.gsfc.voyager.cdf.CDF3;
import gov.nasa.gsfc.voyager.cdf.CDFImpl;
import gov.nasa.gsfc.voyager.cdf.DataTypes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class CDF3Impl
extends CDFImpl
implements CDF3,
Serializable {
    public long GDROffset;

    public CDF3Impl(ByteBuffer buf) throws Throwable {
        super(buf);
        this.setOffsets();
        this.thisCDF = this;
        IntBuffer ibuf = buf.asIntBuffer();
        this.getRecord(0);
        ibuf.position(2);
        ibuf.get();
        ibuf.get();
        ibuf.get();
        this.GDROffset = ibuf.get();
        this.GDROffset = (this.GDROffset << 32) + (long)ibuf.get();
        this.version = ibuf.get();
        if (this.version != 3) {
            throw new Throwable("Version " + this.version + "is not accepted by this reader.");
        }
        this.release = ibuf.get();
        this.encoding = ibuf.get();
        this.byteOrder = DataTypes.getByteOrder(this.encoding);
        this.setByteOrder(this.byteOrder);
        this.flags = ibuf.get();
        ibuf.get();
        ibuf.get();
        this.increment = ibuf.get();
        int pos = (int)this.GDROffset + 8;
        buf.position(pos);
        int x = buf.getInt();
        if (x != 2) {
            throw new Throwable("Bad GDR type " + x);
        }
        this.rVDRHead = buf.getLong();
        this.zVDRHead = buf.getLong();
        this.ADRHead = buf.getLong();
        long CDFSize = buf.getLong();
        this.numberOfRVariables = buf.getInt();
        this.numberOfAttributes = buf.getInt();
        buf.getInt();
        int numberOfRDims = buf.getInt();
        this.numberOfZVariables = buf.getInt();
        buf.getInt();
        buf.getInt();
        this.rDimSizes = new int[numberOfRDims];
        if (numberOfRDims > 0) {
            buf.getInt();
            buf.getInt();
            buf.getInt();
            for (int i = 0; i < this.rDimSizes.length; ++i) {
                this.rDimSizes[i] = buf.getInt();
            }
        }
        buf.position(0);
        this.variableTable = this.variables();
        this.attributeTable = this.attributes();
    }

    void setOffsets() {
        this.offset_NEXT_VDR = 12;
        this.offset_NEXT_ADR = 12;
        this.offset_ATTR_NAME = 68;
        this.offset_SCOPE = 28;
        this.offset_AgrEDRHead = 20;
        this.offset_AzEDRHead = 48;
        this.offset_NEXT_AEDR = 12;
        this.offset_ENTRYNUM = 28;
        this.offset_ATTR_DATATYPE = 24;
        this.offset_ATTR_NUM_ELEMENTS = 32;
        this.offset_VALUE = 56;
        this.offset_VAR_NAME = 84;
        this.offset_VAR_NUM_ELEMENTS = 64;
        this.offset_NUM = 68;
        this.offset_FLAGS = 44;
        this.offset_BLOCKING_FACTOR = 80;
        this.offset_VAR_DATATYPE = 20;
        this.offset_zNumDims = 340;
        this.offset_FIRST_VXR = 28;
        this.offset_NEXT_VXR = 12;
        this.offset_NENTRIES = 20;
        this.offset_NUSED = 24;
        this.offset_FIRST = 28;
        this.offset_RECORD_TYPE = 8;
        this.offset_RECORDS = 12;
        this.offset_CSIZE = 16;
        this.offset_CDATA = 24;
    }

    public String getString(int offset) {
        return this.getString(offset, 256);
    }

    public int lowOrderInt(ByteBuffer buf) {
        return (int)buf.getLong();
    }

    public int lowOrderInt(ByteBuffer buf, int offset) {
        return (int)buf.getLong(offset);
    }
}

