/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.CDF2Impl;
import gov.nasa.gsfc.voyager.cdf.CDF3Impl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPInputStream;

public class CDFFactory {
    public static final long CDF3_MAGIC = -3606538872298602497L;
    public static final long CDF3_COMPRESSED_MAGIC = -3606538873157713919L;
    public static final long CDF2_MAGIC = -3606820347275313153L;
    public static final long CDF2_MAGIC_DOT5 = 0xFFFF0000FFFFL;

    private CDFFactory() {
    }

    public static CDF getCDF(byte[] ba) throws Throwable {
        ByteBuffer buf = ByteBuffer.wrap(ba);
        return CDFFactory.getVersion(buf);
    }

    public static CDF getCDF(ByteBuffer buf) throws Throwable {
        return CDFFactory.getVersion(buf);
    }

    private static CDF getVersion(ByteBuffer buf) throws Throwable {
        LongBuffer lbuf = buf.asLongBuffer();
        long magic = lbuf.get();
        if (magic == -3606538872298602497L) {
            return new CDF3Impl(buf);
        }
        if (magic == -3606538873157713919L) {
            ByteBuffer mbuf = CDFFactory.uncompressed(buf, 3);
            return new CDF3Impl(mbuf);
        }
        if (magic == 0xFFFF0000FFFFL) {
            int release = buf.getInt(24);
            return new CDF2Impl(buf, release);
        }
        ShortBuffer sbuf = buf.asShortBuffer();
        if (sbuf.get() == -12814 && sbuf.get() == 24578) {
            short x = sbuf.get();
            if (x == 0) {
                if (sbuf.get() == -1) {
                    return new CDF2Impl(buf, 6);
                }
            } else if (x == -13108 && sbuf.get() == 1) {
                ByteBuffer mbuf = CDFFactory.uncompressed(buf, 2);
                return new CDF2Impl(mbuf, 6);
            }
        }
        return null;
    }

    public static CDF getCDF(String fname) throws Throwable {
        File file = new File(fname);
        FileInputStream fis = new FileInputStream(file);
        FileChannel ch = fis.getChannel();
        MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size());
        return CDFFactory.getVersion(buf);
    }

    public static CDF getCDF(URL url) throws Throwable {
        int got;
        int remaining;
        URLConnection con = url.openConnection();
        InputStream is = con.getInputStream();
        byte[] ba = new byte[remaining];
        int offset = 0;
        for (remaining = con.getContentLength(); remaining > 0; remaining -= got) {
            got = is.read(ba, offset, remaining);
            offset += got;
        }
        return CDFFactory.getCDF(ba);
    }

    static ByteBuffer uncompressed(ByteBuffer buf, int version) {
        int offset;
        byte[] ba;
        int DATA_OFFSET = 28;
        if (version == 3) {
            DATA_OFFSET = 40;
        }
        int len = buf.getInt(8) - 20;
        if (version == 3) {
            len = (int)(buf.getLong(8) - 32L);
        }
        int ulen = buf.getInt(20);
        if (version == 3) {
            ulen = (int)buf.getLong(28);
        }
        byte[] udata = new byte[ulen + 8];
        buf.get(udata, 0, 8);
        if (!buf.hasArray()) {
            ba = new byte[len];
            buf.position(DATA_OFFSET);
            buf.get(ba);
            offset = 0;
        } else {
            ba = buf.array();
            offset = DATA_OFFSET;
        }
        int n = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(ba, offset, len);
            GZIPInputStream gz = new GZIPInputStream(bais);
            int off = 8;
            for (int toRead = udata.length - 8; toRead > 0 && (n = gz.read(udata, off, toRead)) != -1; toRead -= n) {
                off += n;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            return null;
        }
        if (n < 0) {
            return null;
        }
        return ByteBuffer.wrap(udata);
    }
}

