/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import gov.nasa.gsfc.voyager.cdf.Attribute;
import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.DataTypes;
import gov.nasa.gsfc.voyager.cdf.Extractor;
import gov.nasa.gsfc.voyager.cdf.Stride;
import gov.nasa.gsfc.voyager.cdf.TimeSeries;
import gov.nasa.gsfc.voyager.cdf.TimeSpec;
import gov.nasa.gsfc.voyager.cdf.TimeVariable;
import gov.nasa.gsfc.voyager.cdf.Variable;
import gov.nasa.gsfc.voyager.cdf.VariableDataBuffer;
import gov.nasa.gsfc.voyager.cdf.VariableDataLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public abstract class CDFImpl
implements Serializable {
    static final double JANUARY_1_1970;
    static final double JANUARY_1_1970_TT;
    static final double JANUARY_1_1970_SECONDS;
    static final long JANUARY_1_1970_LONG;
    static final long TT2000_DATE;
    public static final int GDR_RECORD = 2;
    public static final int FLAGS_MAJORITY_MASK = 1;
    public static final int ROW_MAJOR = 1;
    public static final int VXR_RECORD_TYPE = 6;
    public static final int VVR_RECORD_TYPE = 7;
    public static final int CVVR_RECORD_TYPE = 13;
    int offset_NEXT_VDR;
    int offset_NEXT_ADR;
    int offset_ATTR_NAME;
    int offset_SCOPE;
    int offset_AgrEDRHead;
    int offset_AzEDRHead;
    int offset_NEXT_AEDR;
    int offset_ENTRYNUM;
    int offset_ATTR_DATATYPE;
    int offset_ATTR_NUM_ELEMENTS;
    int offset_VALUE;
    int offset_VAR_NAME;
    int offset_VAR_NUM_ELEMENTS;
    int offset_NUM;
    int offset_FLAGS;
    int offset_BLOCKING_FACTOR;
    int offset_VAR_DATATYPE;
    int offset_zNumDims;
    int offset_FIRST_VXR;
    int offset_NEXT_VXR;
    int offset_NENTRIES;
    int offset_NUSED;
    int offset_FIRST;
    int offset_RECORD_TYPE;
    int offset_RECORDS;
    int offset_CSIZE;
    int offset_CDATA;
    int version;
    int release;
    int encoding;
    int flags;
    int increment;
    transient ByteOrder byteOrder;
    boolean bigEndian;
    long GDROffset;
    long rVDRHead;
    long zVDRHead;
    long ADRHead;
    int numberOfRVariables;
    int numberOfAttributes;
    int numberOfZVariables;
    int[] rDimSizes;
    transient ByteBuffer buf;
    protected String[] varNames;
    protected Hashtable variableTable;
    Hashtable attributeTable;
    protected CDF thisCDF;
    protected Hashtable timesMap = new Hashtable();
    protected Hashtable extendedPrecisionTimesMap = new Hashtable();
    protected Hashtable timeVariableMap = new Hashtable();
    public static final int MILLISECOND_PRECISION = 0;
    public static final int MICROSECOND_PRECISION = 1;
    public static final int NANOSECOND_PRECISION = 2;
    public static final int PICOSECOND_PRECISION = 3;

    protected CDFImpl(ByteBuffer buf) {
        this.buf = buf;
    }

    protected ByteBuffer getRecord(int offset) {
        ByteBuffer _buf = this.buf.duplicate();
        _buf.position(offset);
        return _buf.slice();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean rowMajority() {
        return (this.flags & 1) == 1;
    }

    protected Hashtable variables() {
        if (this.variableTable != null) {
            return this.variableTable;
        }
        int[] offsets = new int[]{(int)this.zVDRHead, (int)this.rVDRHead};
        String[] vtypes = new String[]{"z", "r"};
        Hashtable<String, CDFVariable> table = new Hashtable<String, CDFVariable>();
        Vector<String> v = new Vector<String>();
        block0: for (int vtype = 0; vtype < 2; ++vtype) {
            int offset = offsets[vtype];
            if (offset == 0) continue;
            ByteBuffer _buf = this.getRecord(offset);
            while (true) {
                _buf.position(this.offset_NEXT_VDR);
                int next = this.lowOrderInt(_buf);
                CDFVariable cdfv = new CDFVariable(offset, vtypes[vtype]);
                String name = cdfv.getName();
                v.add(name);
                table.put(name, cdfv);
                if (next == 0) continue block0;
                offset = next;
                _buf = this.getRecord(offset);
            }
        }
        this.varNames = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.varNames[i] = (String)v.elementAt(i);
        }
        this.variableTable = table;
        return table;
    }

    public String[] getVariableNames() {
        String[] sa = new String[this.varNames.length];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = this.varNames[i];
        }
        return sa;
    }

    public Variable getVariable(String name) {
        return (Variable)this.variableTable.get(name);
    }

    public String[] getVariableNames(String type) {
        Vector<String> vars = new Vector<String>();
        for (int i = 0; i < this.varNames.length; ++i) {
            String s;
            Vector v = (Vector)this.getAttribute(this.varNames[i], "VAR_TYPE");
            if (v == null || v.size() == 0 || !(s = (String)v.elementAt(0)).equals(type)) continue;
            vars.add(this.varNames[i]);
        }
        String[] sa = new String[vars.size()];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = (String)vars.elementAt(i);
        }
        return sa;
    }

    public String[] globalAttributeNames() {
        Vector<String> vec = new Vector<String>();
        if (this.attributeTable == null) {
            return new String[0];
        }
        Set set = this.attributeTable.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            CDFAttribute attr = (CDFAttribute)this.attributeTable.get(iter.next());
            if (!attr.isGlobal()) continue;
            vec.add(attr.name);
        }
        String[] sa = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            sa[i] = (String)vec.elementAt(i);
        }
        return sa;
    }

    public String[] variableAttributeNames(String name) {
        CDFVariable var = (CDFVariable)this.variableTable.get(name);
        if (var == null) {
            return null;
        }
        String[] sa = new String[var.attributes.size()];
        for (int i = 0; i < sa.length; ++i) {
            AttributeEntry ae = (AttributeEntry)var.attributes.elementAt(i);
            sa[i] = ae.attribute;
        }
        return sa;
    }

    public Object getAttribute(String atr) {
        CDFAttribute a = (CDFAttribute)this.attributeTable.get(atr);
        if (a == null) {
            return null;
        }
        if (!a.isGlobal()) {
            return null;
        }
        if (a.gEntries.size() == 0) {
            return null;
        }
        AttributeEntry ae = (AttributeEntry)a.gEntries.elementAt(0);
        if (ae.stringValue != null) {
            String[] sa = new String[a.gEntries.size()];
            for (int i = 0; i < a.gEntries.size(); ++i) {
                ae = (AttributeEntry)a.gEntries.elementAt(i);
                sa[i] = ae.stringValue;
            }
            return sa;
        }
        return ae.value;
    }

    public Object getAttribute(String var, String atr) {
        CDFVariable c = (CDFVariable)this.variableTable.get(var);
        if (c == null) {
            return null;
        }
        Vector attrs = c.attributes;
        Vector<Object> values = new Vector<Object>();
        for (int i = 0; i < attrs.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)attrs.elementAt(i);
            if (!ae.attribute.equals(atr)) continue;
            if (ae.stringValue != null) {
                values.add(ae.stringValue);
            }
            if (ae.stringValue != null) continue;
            values.add(ae.value);
        }
        return values;
    }

    Variable getCDFVariable(String vtype, int number) {
        Set set = this.variableTable.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            CDFVariable var = (CDFVariable)this.variableTable.get(iter.next());
            if (!var.vtype.equals(vtype) || var.number != number) continue;
            return var;
        }
        return null;
    }

    Hashtable attributes() {
        if (this.attributeTable != null) {
            return this.attributeTable;
        }
        int offset = (int)this.ADRHead;
        if (offset == 0) {
            return null;
        }
        Hashtable<String, CDFAttribute> table = new Hashtable<String, CDFAttribute>();
        ByteBuffer _buf = this.getRecord(offset);
        while (true) {
            _buf.position(this.offset_NEXT_ADR);
            int next = this.lowOrderInt(_buf);
            CDFAttribute cdfa = new CDFAttribute(offset);
            table.put(cdfa.getName(), cdfa);
            if (next == 0) break;
            offset = next;
            _buf = this.getRecord(offset);
        }
        this.attributeTable = table;
        return table;
    }

    ByteBuffer getValueBuffer(int offset) {
        ByteBuffer bv = this.getRecord(offset);
        bv.position(this.offset_RECORDS);
        return bv;
    }

    ByteBuffer getValueBuffer(int offset, int size, int number) {
        ByteBuffer bv = this.getRecord(offset);
        if (bv.getInt(this.offset_RECORD_TYPE) == 7) {
            System.out.println("Encountered uncompressed instead of  compressed at offset " + offset);
            bv.position(this.offset_RECORDS);
            return bv;
        }
        int clen = this.lowOrderInt(bv, this.offset_CSIZE);
        byte[] work = new byte[clen];
        bv.position(this.offset_CDATA);
        bv.get(work);
        byte[] udata = new byte[size * number];
        int n = 0;
        try {
            GZIPInputStream gz = new GZIPInputStream(new ByteArrayInputStream(work));
            int off = 0;
            for (int toRead = udata.length; toRead > 0 && (n = gz.read(udata, off, toRead)) != -1; toRead -= n) {
                off += n;
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString() + " at offset " + offset);
            System.out.println("Trying to get data as uncompressed");
            return this.getValueBuffer(offset);
        }
        if (n < 0) {
            return null;
        }
        return ByteBuffer.wrap(udata);
    }

    public Object get(String varName) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "Series");
        if (method == null) {
            throw new Throwable("getSeries not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var);
    }

    public Object get(String varName, int index) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "Element");
        if (method == null) {
            throw new Throwable("getElement not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index);
    }

    public Object get(String varName, int[] elements) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "Elements");
        if (method == null) {
            throw new Throwable("getElements not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, elements);
    }

    public Object get(String varName, int index1, int index2) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "Element");
        if (method == null) {
            throw new Throwable("getElement(i, j) not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index1, index2);
    }

    public Object get(String varName, int index1, int index2, int element) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "RangeForElement");
        if (method == null) {
            throw new Throwable("getRangeForElement not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index1, index2, element);
    }

    public Object get(String varName, int index1, int index2, int[] elements) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "RangeForElements");
        if (method == null) {
            throw new Throwable("getRangeForElements not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index1, index2, elements);
    }

    public Object getPoint(String varName, int index) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "Point");
        if (method == null) {
            throw new Throwable("getPoint not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index);
    }

    public Object getRange(String varName, int index1, int index2) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "Range");
        if (method == null) {
            throw new Throwable("getRange not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index1, index2);
    }

    public Object getRange(String varName, int index1, int index2, int element) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "RangeElement");
        if (method == null) {
            throw new Throwable("getRangeElement not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index1, index2, element);
    }

    public Object getRange(String varName, int index1, int index2, int[] elements) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "RangeElements");
        if (method == null) {
            throw new Throwable("getRangeElements not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, index1, index2, elements);
    }

    public double[] get1D(String varName) throws Throwable {
        return (double[])this.get1D(varName, false);
    }

    public Object get1D(String varName, boolean preserve) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        return Extractor.get1DSeries(this.thisCDF, var, null, preserve);
    }

    public double[] get1D(String varName, int point) throws Throwable {
        return (double[])this.get1D(varName, point, false);
    }

    public Object get1D(String varName, int point, boolean preserve) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        return Extractor.get1DSeries(this.thisCDF, var, new int[]{point}, preserve);
    }

    public double[] get1D(String varName, int first, int last) throws Throwable {
        return (double[])this.get1D(varName, first, last, false);
    }

    public Object get1D(String varName, int first, int last, boolean preserve) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        return Extractor.get1DSeries(this.thisCDF, var, new int[]{first, last}, preserve);
    }

    public Object getTimeSeries(String varName) throws Throwable {
        return this.getTimeSeries(varName, true, null);
    }

    public Object getTimeSeries(String varName, int element) throws Throwable {
        return this.getTimeSeries(varName, element, true, null);
    }

    public Object getTimeSeries(String varName, boolean ignoreFill) throws Throwable {
        return this.getTimeSeries(varName, ignoreFill, null);
    }

    public Object getTimeSeries(String varName, int element, boolean ignoreFill) throws Throwable {
        return this.getTimeSeries(varName, element, true, null);
    }

    public Object getTimeSeries(String varName, boolean ignoreFill, double[] timeRange) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "TimeSeries");
        if (method == null) {
            throw new Throwable("getTimeSeries not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, new Boolean(ignoreFill), timeRange);
    }

    public TimeSeries getTimeSeriesObject(String varName, boolean ignoreFill, double[] timeRange, TimeSpec ts) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "TimeSeriesObject");
        if (method == null) {
            throw new Throwable("getTimeSeriesObject not implemented for " + varName);
        }
        return (TimeSeries)method.invoke(null, this.thisCDF, var, new Boolean(ignoreFill), timeRange, ts);
    }

    public Object getTimeSeries(String vname, boolean ignoreFill, double startTime, double stopTime) throws Throwable {
        return this.getTimeSeries(vname, ignoreFill, new double[]{startTime, stopTime});
    }

    public Object getTimeSeries(String vname, boolean ignoreFill, Date startDate, Date stopDate) throws Throwable {
        long l1 = startDate.getTime();
        long l2 = stopDate.getTime();
        return this.getTimeSeries(vname, ignoreFill, new double[]{l1, l2});
    }

    public Object getTimeSeries(String varName, int element, boolean ignoreFill, double[] timeRange) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "TimeSeries");
        if (method == null) {
            throw new Throwable("getTimeSeries not implemented for " + varName);
        }
        return method.invoke(null, this.thisCDF, var, element, ignoreFill, timeRange);
    }

    public TimeSeries getTimeSeriesObject(String varName, int element, boolean ignoreFill, double[] timeRange, TimeSpec ts) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        Method method = Extractor.getMethod(var, "TimeSeriesObject");
        if (method == null) {
            throw new Throwable("getTimeSeriesObject not implemented for " + varName);
        }
        return (TimeSeries)method.invoke(null, this.thisCDF, var, element, ignoreFill, timeRange, ts);
    }

    public Object getTimeSeries(String vname, int element, boolean ignoreFill, double startTime, double stopTime) throws Throwable {
        return this.getTimeSeries(vname, element, ignoreFill, new double[]{startTime, stopTime});
    }

    public Object getTimeSeries(String vname, int element, boolean ignoreFill, Date startDate, Date stopDate) throws Throwable {
        long l1 = startDate.getTime();
        long l2 = stopDate.getTime();
        return this.getTimeSeries(vname, element, ignoreFill, new double[]{l1, l2});
    }

    public int[] variableDimensions(String name) {
        Variable var = (Variable)this.variableTable.get(name);
        if (var == null) {
            return null;
        }
        int[] dims = var.getDimensions();
        int[] ia = new int[dims.length];
        System.arraycopy(ia, 0, dims, 0, dims.length);
        return ia;
    }

    protected abstract int lowOrderInt(ByteBuffer var1);

    protected abstract int lowOrderInt(ByteBuffer var1, int var2);

    protected abstract String getString(int var1);

    protected String getString(int offset, int max) {
        return this.getString(this.getRecord(offset), max);
    }

    protected String getString(ByteBuffer _buf, int max) {
        int i;
        byte[] ba = new byte[max];
        for (i = 0; i < max; ++i) {
            ba[i] = _buf.get();
            if (ba[i] == 0) break;
        }
        return new String(ba, 0, i);
    }

    public static Object getNumberAttribute(int type, int nelement, ByteBuffer vbuf, ByteOrder byteOrder) {
        ByteBuffer vbufLocal = vbuf.duplicate();
        vbufLocal.order(byteOrder);
        int ne = nelement;
        if (type == 32) {
            ne = 2 * nelement;
        }
        long[] lvalue = null;
        double[] value = null;
        long longInt = DataTypes.longInt[type];
        boolean longType = false;
        try {
            if (type > 20 || type < 10) {
                if (DataTypes.typeCategory[type] == 5) {
                    lvalue = new long[ne];
                    longType = true;
                } else {
                    value = new double[ne];
                }
                for (int i = 0; i < ne; ++i) {
                    Number num = (Number)DataTypes.method[type].invoke((Object)vbufLocal, new Object[0]);
                    if (!longType) {
                        value[i] = num.doubleValue();
                    }
                    if (!longType) continue;
                    lvalue[i] = num.longValue();
                }
            } else {
                value = new double[ne];
                for (int i = 0; i < nelement; ++i) {
                    Number num = (Number)DataTypes.method[type].invoke((Object)vbufLocal, new Object[0]);
                    int n = num.intValue();
                    value[i] = n >= 0 ? (double)n : (double)(longInt + (long)n);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("getNumberAttribute: " + vbuf);
            ex.printStackTrace();
            return null;
        }
        if (longType) {
            return lvalue;
        }
        return value;
    }

    public TimeVariable getCDFTimeVariable(String vname) throws Throwable {
        TimeVariable tvar;
        Variable tvar2;
        Variable var = (Variable)this.variableTable.get(vname);
        int precision = -1;
        String tname = null;
        if (var == null) {
            throw new Throwable("Bad variable name " + vname);
        }
        Vector v = (Vector)this.getAttribute(var.getName(), "DEPEND_0");
        if (v.size() > 0) {
            tname = (String)v.elementAt(0);
        }
        if (tname == null) {
            tname = "Epoch";
        }
        if ((tvar2 = (Variable)this.variableTable.get(tname)) == null) {
            throw new Throwable("Time variable not found for " + vname);
        }
        if (tvar2.getType() == 32 && tvar2.getNumberOfValues() > 0) {
            precision = 3;
        }
        if (tvar2.getType() == 33 && tvar2.getNumberOfValues() > 0) {
            precision = 2;
        }
        if (precision < 0) {
            precision = 0;
            if (tvar2.getNumberOfValues() == 0) {
                v = (Vector)this.getAttribute(var.getName(), "DEPEND_TIME");
                tname = (String)v.elementAt(0);
                precision = 1;
            }
        }
        if ((tvar = (TimeVariable)this.timeVariableMap.get(tname)) == null) {
            tvar = new CDFTimeVariableX(tname, precision);
            this.timeVariableMap.put(tname, tvar);
        }
        return tvar;
    }

    public double[] getTimes(String vname) throws Throwable {
        return this.getCDFTimeVariable(vname).getTimes();
    }

    protected double[] getTimes(Variable var, boolean copy) throws Throwable {
        String vname = var.getName();
        if (!copy) {
            return ((CDFTimeVariable)((Object)this.getCDFTimeVariable((String)vname))).times;
        }
        return this.getCDFTimeVariable(vname).getTimes();
    }

    protected double[] getTimes(Variable var, TimeSpec ts, boolean copy) throws Throwable {
        String vname = var.getName();
        TimeVariable tvar = this.getCDFTimeVariable(vname);
        return tvar.getTimes(ts);
    }

    public double[] getTimes(String vname, int[] recordRange) throws Throwable {
        return this.getCDFTimeVariable(vname).getTimes(recordRange);
    }

    public double[] getTimes(String vname, int[] recordRange, int[] stride) throws Throwable {
        double[] times = ((CDFTimeVariable)((Object)this.getCDFTimeVariable((String)vname))).times;
        Stride strideObject = new Stride(stride);
        int nv = recordRange[1] - recordRange[0] + 1;
        int _stride = strideObject.getStride(nv);
        if (_stride > 1) {
            int numpt = nv / _stride;
            if (numpt * _stride < nv) {
                ++numpt;
            }
            nv = numpt;
        }
        double[] stimes = new double[nv];
        int n = recordRange[0];
        for (int i = 0; i < nv; ++i) {
            stimes[i] = times[n];
            n += _stride;
        }
        return stimes;
    }

    public double[] getTimes(String vname, int firstRecord, int lastRecord) throws Throwable {
        return this.getTimes(vname, new int[]{firstRecord, lastRecord});
    }

    public double[] getAvailableTimeRange(String vname, TimeSpec ts) throws Throwable {
        CDFTimeVariableX tv = (CDFTimeVariableX)this.getCDFTimeVariable(vname);
        double[] times = tv.getTimes(ts);
        return new double[]{times[0], times[times.length - 1]};
    }

    public double[] getAvailableTimeRange(String vname) throws Throwable {
        CDFTimeVariableX tv = (CDFTimeVariableX)this.getCDFTimeVariable(vname);
        double[] times = tv.getTimes();
        return new double[]{times[0], times[times.length - 1]};
    }

    public int[] getRecordRange(String vname, double[] timeRange) throws Throwable {
        return this.getRecordRange(vname, timeRange, null);
    }

    public int[] getRecordRange(String vname, double[] timeRange, TimeSpec tspec) throws Throwable {
        return this.getCDFTimeVariable(vname).getRecordRange(timeRange, tspec);
    }

    public int[] getRecordRange(String vname, double startTime, double stopTime) throws Throwable {
        return this.getRecordRange(vname, new double[]{startTime, stopTime});
    }

    public int[] getRecordRange(String vname, Date startDate, Date stopDate) throws Throwable {
        long l1 = startDate.getTime();
        long l2 = stopDate.getTime();
        return this.getRecordRange(vname, new double[]{l1, l2});
    }

    void setByteOrder(ByteOrder bo) {
        this.bigEndian = bo.equals(ByteOrder.BIG_ENDIAN);
    }

    public void setByteOrder(boolean _bigEndian) {
        this.byteOrder = _bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.setByteOrder(this.byteOrder);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBuffer(ByteBuffer b) {
        this.buf = b;
    }

    public void extractBytes(int bufOffset, byte[] ba, int offset, int len) {
        ((ByteBuffer)this.buf.duplicate().position(bufOffset)).get(ba, offset, len);
    }

    protected int getRecordOffset() {
        return this.offset_RECORDS;
    }

    public Object getTimeSeries(String vname, boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        Variable var = (Variable)this.variableTable.get(vname);
        if (var == null) {
            throw new Throwable("No such variable " + vname);
        }
        Method method = Extractor.getMethod(var, "SampledTimeSeries");
        if (method == null) {
            throw new Throwable("getSampledTimeSeries not implemented for " + vname);
        }
        return method.invoke(null, this.thisCDF, var, ignoreFill, timeRange, stride);
    }

    public Object getTimeSeries(String vname, int element, boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        Variable var = (Variable)this.variableTable.get(vname);
        if (var == null) {
            throw new Throwable("No such variable " + vname);
        }
        Method method = Extractor.getMethod(var, "SampledTimeSeries");
        if (method == null) {
            throw new Throwable("getSampledTimeSeries not implemented for " + vname);
        }
        return method.invoke(null, this.thisCDF, var, element, ignoreFill, timeRange, stride);
    }

    public double[] get1D(String varName, int first, int last, int[] stride) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable("No such variable " + varName);
        }
        return Extractor.get1DSeries(this.thisCDF, var, new int[]{first, last}, stride);
    }

    public double[] UTC(String varName) throws Throwable {
        Variable var = (Variable)this.variableTable.get(varName);
        if (var == null) {
            throw new Throwable(varName + " not found");
        }
        int numberOfValues = var.getNumberOfValues();
        if (numberOfValues == 0) {
            return null;
        }
        double[] data = new double[numberOfValues];
        Vector locations = ((DataLocator)var.getLocator()).locations;
        for (int blk = 0; blk < locations.size(); ++blk) {
            int[] loc = (int[])locations.elementAt(blk);
            int first = loc[0];
            int last = loc[1];
            ByteBuffer bv = Extractor.positionBuffer(this, var, loc[2], last - first + 1);
            LongBuffer bvl = bv.asLongBuffer();
            for (int n = first; n <= last; ++n) {
                data[n] = (double)(bvl.get() / 1000000L) - JANUARY_1_1970_TT;
            }
        }
        return data;
    }

    public TimeSpec getDefaultTimeSpec() {
        return new DefaultTimeSpecImpl();
    }

    public TimeVariable getXVar(String s, int p) throws Throwable {
        return new CDFTimeVariableX(s, p);
    }

    static {
        int days;
        int year;
        int offset = 0;
        for (year = 0; year < 1970; ++year) {
            days = 365;
            if (year % 4 == 0) {
                ++days;
                if (year % 100 == 0) {
                    --days;
                    if (year % 400 == 0) {
                        ++days;
                    }
                }
            }
            offset += days;
        }
        JANUARY_1_1970 = (double)offset * 8.64E7;
        JANUARY_1_1970_SECONDS = (double)offset * 86400.0;
        offset = 0;
        for (year = 1999; year >= 1970; --year) {
            days = 365;
            if (year % 4 == 0) {
                ++days;
                if (year % 100 == 0) {
                    --days;
                    if (year % 400 == 0) {
                        ++days;
                    }
                }
            }
            offset -= days;
        }
        JANUARY_1_1970_TT = ((double)offset - 0.5) * 8.64E7;
        JANUARY_1_1970_LONG = (long)JANUARY_1_1970;
        TT2000_DATE = JANUARY_1_1970_LONG + Date.UTC(100, 0, 1, 12, 0, 0) - 41184L;
    }

    public class CDFTimeVariableX
    extends CDFTimeVariable
    implements TimeVariable,
    Serializable {
        protected double[] timesx;
        protected double[] pico;
        protected long[] nano;
        long offset;
        double firstTime;
        int recordCount;

        public CDFTimeVariableX(String tname, int precision) throws Throwable {
            this.name = tname;
            this.precision = precision;
            if (precision == 0) {
                this.timesx = (double[])CDFImpl.this.get(tname);
                this.firstTime = this.timesx[0];
                this.recordCount = this.timesx.length;
            }
            if (precision == 1) {
                this.timesx = (double[])CDFImpl.this.get(tname);
                this.firstTime = (long)(1000.0 * this.timesx[0]) + JANUARY_1_1970_LONG;
                this.recordCount = this.timesx.length;
            }
            if (precision == 3) {
                this.timesx = (double[])CDFImpl.this.get(tname, 0);
                this.pico = (double[])CDFImpl.this.get(tname, 1);
                this.firstTime = (long)(1000.0 * this.timesx[0] + this.pico[0] / 1.0E9);
                this.recordCount = this.timesx.length;
            }
            if (precision == 2) {
                this.nano = (long[])CDFImpl.this.get(tname);
                this.firstTime = this.nano[0] / 1000000L + TT2000_DATE;
                this.recordCount = this.nano.length;
            }
        }

        public double[] getTimes(int first, int last, TimeSpec ts) {
            double[] da;
            block25: {
                long base;
                int offsetUnits;
                block27: {
                    block26: {
                        long micro;
                        long milli;
                        int i;
                        offsetUnits = 0;
                        base = JANUARY_1_1970_LONG;
                        if (ts != null) {
                            base = (long)ts.getBaseTime();
                            offsetUnits = ts.getOffsetUnits();
                        }
                        da = new double[last - first + 1];
                        if (this.precision == 0) {
                            for (i = first; i <= last; ++i) {
                                da[i - first] = this.timesx[i] - (double)base;
                            }
                        }
                        if (this.precision == 1) {
                            if (offsetUnits == 0) {
                                if (base == JANUARY_1_1970_LONG) {
                                    for (i = first; i <= last; ++i) {
                                        da[i - first] = this.timesx[i] * 1000.0;
                                    }
                                } else {
                                    this.offset = base - JANUARY_1_1970_LONG;
                                    for (i = first; i <= last; ++i) {
                                        milli = (long)this.timesx[i] * 1000L - this.offset;
                                        da[i - first] = milli;
                                    }
                                }
                            } else if ((double)base == JANUARY_1_1970) {
                                for (i = first; i <= last; ++i) {
                                    da[i - first] = this.timesx[i] * 1000000.0;
                                }
                            } else {
                                this.offset = 1000L * (base - JANUARY_1_1970_LONG);
                                for (i = first; i <= last; ++i) {
                                    micro = (long)this.timesx[i] * 1000000L - this.offset;
                                    da[i - first] = micro;
                                }
                            }
                        }
                        if (this.precision == 2) {
                            double rem;
                            if (offsetUnits == 0) {
                                this.offset = base - TT2000_DATE;
                                for (i = first; i <= last; ++i) {
                                    milli = this.nano[i] / 1000000L - this.offset;
                                    rem = (double)(this.nano[i] % 1000000L) / 1000000.0;
                                    da[i - first] = (double)milli + rem;
                                }
                            } else if (offsetUnits == 1) {
                                this.offset = 1000L * (base - TT2000_DATE);
                                for (i = first; i <= last; ++i) {
                                    micro = this.nano[i] / 1000L - this.offset;
                                    rem = (double)(this.nano[i] % 1000L) / 1000.0;
                                    da[i - first] = (double)micro + rem;
                                }
                            } else {
                                this.offset = 1000000L * (base - TT2000_DATE);
                                for (i = first; i <= last; ++i) {
                                    da[i - first] = this.nano[i] - this.offset;
                                }
                            }
                        }
                        if (this.precision != 3) break block25;
                        if (offsetUnits != 0) break block26;
                        long mul = 1000L;
                        for (int i2 = first; i2 <= last; ++i2) {
                            double d = (long)this.timesx[i2] * mul - base;
                            da[i2 - first] = d + this.pico[i2] / 1.0E9;
                        }
                        break block25;
                    }
                    if (offsetUnits != 1) break block27;
                    this.offset = 1000L * base;
                    long mul = 1000000L;
                    for (int i = first; i <= last; ++i) {
                        double d = (long)this.timesx[i] * mul - this.offset;
                        da[i - first] = d + this.pico[i] / 1000000.0;
                    }
                    break block25;
                }
                if (offsetUnits != 2) break block25;
                this.offset = 1000000L * base;
                long mul = 1000000000L;
                for (int i = first; i <= last; ++i) {
                    double d = (long)this.timesx[i] * mul - this.offset;
                    da[i - first] = d + this.pico[i] / 1000.0;
                }
            }
            return da;
        }

        public double[] getTimes(int[] recordRange) {
            return this.getTimes(recordRange, (TimeSpec)null);
        }

        public double[] getTimes(int[] recordRange, TimeSpec ts) {
            return this.getTimes(recordRange[0], recordRange[1], ts);
        }

        public double[] getTimes(TimeSpec ts) {
            return this.getTimes(0, this.recordCount - 1, ts);
        }

        public double[] getTimes() {
            return this.getTimes(0, this.recordCount - 1, null);
        }

        public int[] getRecordRange(double[] timeRange, TimeSpec ts) {
            int i;
            double[] temp = this.getTimes(0, this.recordCount - 1, ts);
            double start = timeRange[0];
            double stop = timeRange[1];
            for (i = 0; i < temp.length && start > temp[i]; ++i) {
            }
            if (i == temp.length) {
                return null;
            }
            int low = i;
            while (i < temp.length && !(stop <= temp[i])) {
                ++i;
            }
            if (i == 0) {
                return null;
            }
            return new int[]{low, i - 1};
        }

        public int[] getRecordRange(double[] timeRange) {
            return this.getRecordRange(timeRange, null);
        }

        public double[] getTimes(double[] timeRange) {
            return this.getTimes(timeRange, null);
        }

        public double[] getTimes(double[] timeRange, TimeSpec ts) {
            int[] rr = this.getRecordRange(timeRange, ts);
            if (rr == null) {
                return null;
            }
            return this.getTimes(rr[0], rr[1], ts);
        }

        public double getFirstTime() {
            return this.firstTime;
        }
    }

    public class DefaultTimeSpecImpl
    implements TimeSpec {
        double baseTime = JANUARY_1_1970;
        int baseTimeUnits = 0;
        int offsetUnits = 0;

        public double getBaseTime() {
            return this.baseTime;
        }

        public int getBaseTimeUnits() {
            return this.baseTimeUnits;
        }

        public int getOffsetUnits() {
            return this.offsetUnits;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public class CDFTimeVariable
    implements Serializable {
        protected double[] times;
        protected double[] savedTimes;
        double[][] epoch16;
        int precision;
        String name;

        public CDFTimeVariable() {
        }

        public CDFTimeVariable(String tname, int precision) throws Throwable {
            int i;
            this.name = tname;
            this.precision = precision;
            if (precision == 0) {
                double[] epoch = (double[])CDFImpl.this.get(tname);
                this.times = new double[epoch.length];
                for (i = 0; i < epoch.length; ++i) {
                    this.times[i] = epoch[i] - JANUARY_1_1970;
                    if (!(this.times[i] < 0.0)) continue;
                    throw new Throwable("Times before January 1, 1970 are not supported.");
                }
            }
            if (precision == 1) {
                this.times = (double[])CDFImpl.this.get(tname);
                int i2 = 0;
                while (i2 < this.times.length) {
                    int n = i2++;
                    this.times[n] = this.times[n] * 1000.0;
                }
            }
            if (precision == 3) {
                this.times = (double[])CDFImpl.this.get(tname, 0);
                double[] pico = (double[])CDFImpl.this.get(tname, 1);
                for (i = 0; i < this.times.length; ++i) {
                    this.times[i] = 1000.0 * (this.times[i] - JANUARY_1_1970_SECONDS) + pico[i] / 1.0E9;
                }
            }
            if (precision == 2) {
                this.times = CDFImpl.this.UTC(tname);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getPrecision() {
            return this.precision;
        }

        protected synchronized void setTimes(double[] modTimes) {
            this.savedTimes = this.times;
            this.times = modTimes;
        }

        protected synchronized void restoreTimes() {
            this.times = this.savedTimes;
        }

        public double[] getTimes() {
            double[] da = new double[this.times.length];
            System.arraycopy(this.times, 0, da, 0, this.times.length);
            return da;
        }

        public double[] getTimes(int[] recordRange) {
            double[] stimes = new double[recordRange[1] - recordRange[0] + 1];
            System.arraycopy(this.times, recordRange[0], stimes, 0, stimes.length);
            return stimes;
        }

        public double[][] getExtendedPrecisionTimes() throws Throwable {
            if (this.precision == 3) {
                return (double[][])CDFImpl.this.get(this.name);
            }
            return null;
        }

        public double[][] getExtendedPrecisionTimes(int[] recordRange) throws Throwable {
            if (this.precision != 3) {
                return null;
            }
            return (double[][])CDFImpl.this.getRange(this.name, recordRange[0], recordRange[1]);
        }

        public int[] getRecordRange(double[] timeRange) {
            int i;
            double start = timeRange[0];
            double stop = timeRange[1];
            for (i = 0; i < this.times.length && start > this.times[i]; ++i) {
            }
            if (i == this.times.length) {
                return null;
            }
            int low = i;
            while (i < this.times.length && !(stop <= this.times[i])) {
                ++i;
            }
            if (i == 0) {
                return null;
            }
            return new int[]{low, i - 1};
        }

        public double[] getTimes(double[] timeRange) {
            int[] rr = this.getRecordRange(timeRange);
            if (rr == null) {
                return null;
            }
            return this.getTimes(rr);
        }

        public double[] getTimes(TimeSpec tspec) throws Throwable {
            if (this.isValid(tspec)) {
                return this.getTimes();
            }
            throw new Throwable("Inconsistent unit spec");
        }

        public boolean isValid(TimeSpec tspec) {
            return true;
        }
    }

    public class DataLocator
    implements VariableDataLocator,
    Serializable {
        private transient ByteBuffer _buf;
        private int numberOfValues;
        private boolean compressed;
        protected Vector locations = new Vector();

        protected DataLocator(ByteBuffer b, int n, boolean compr) {
            this._buf = b;
            this.numberOfValues = n;
            this.compressed = compr;
            this._buf.position(CDFImpl.this.offset_FIRST_VXR);
            int offset = CDFImpl.this.lowOrderInt(this._buf);
            ByteBuffer bx = CDFImpl.this.getRecord(offset);
            Vector v = this._getLocations(bx);
            this.registerNodes(bx, v);
        }

        public boolean isReallyCompressed() {
            return this.compressed;
        }

        public int[][] getLocations() {
            int[][] loc = new int[this.locations.size()][3];
            for (int i = 0; i < this.locations.size(); ++i) {
                int[] ia = (int[])this.locations.elementAt(i);
                loc[i][0] = ia[0];
                loc[i][1] = ia[1];
                loc[i][2] = ia[2];
            }
            return loc;
        }

        Vector _getLocations(ByteBuffer bx) {
            Vector<int[]> locations = new Vector<int[]>();
            while (true) {
                bx.position(CDFImpl.this.offset_NEXT_VXR);
                int next = CDFImpl.this.lowOrderInt(bx);
                bx.position(CDFImpl.this.offset_NENTRIES);
                int nentries = bx.getInt();
                bx.position(CDFImpl.this.offset_NUSED);
                int nused = bx.getInt();
                bx.position(CDFImpl.this.offset_FIRST);
                ByteBuffer bf = bx.slice();
                bx.position(CDFImpl.this.offset_FIRST + nentries * 4);
                ByteBuffer bl = bx.slice();
                bx.position(CDFImpl.this.offset_FIRST + 2 * nentries * 4);
                ByteBuffer bo = bx.slice();
                for (int entry = 0; entry < nused; ++entry) {
                    int first = bf.getInt();
                    int last = bl.getInt();
                    if (last > this.numberOfValues - 1) {
                        last = this.numberOfValues - 1;
                    }
                    int off = CDFImpl.this.lowOrderInt(bo);
                    locations.add(new int[]{first, last, off});
                }
                if (next == 0) break;
                bx = CDFImpl.this.getRecord(next);
            }
            return locations;
        }

        void registerNodes(ByteBuffer bx, Vector v) {
            int vrtype = 7;
            if (this.compressed) {
                vrtype = 13;
            }
            for (int i = 0; i < v.size(); ++i) {
                int[] loc = (int[])v.elementAt(i);
                ByteBuffer bb = CDFImpl.this.getRecord(loc[2]);
                if (bb.getInt(CDFImpl.this.offset_RECORD_TYPE) == 6) {
                    Vector vin = this._getLocations(bb);
                    this.registerNodes(bb, vin);
                    continue;
                }
                this.locations.add(loc);
            }
        }
    }

    public class CDFVariable
    implements Serializable,
    Variable {
        int DIMENSION_VARIES = -1;
        public Vector attributes = new Vector();
        String name;
        public int number;
        String vtype;
        int flags;
        int type;
        int numberOfElements;
        protected int numberOfValues;
        public int[] dimensions;
        public boolean[] varies;
        public Object padValue;
        int offset;
        transient ByteBuffer _buf;
        int dataItemSize;
        int blockingFactor;
        DataLocator locator;

        public CDFVariable(int offset, String vtype) {
            int i;
            this.offset = offset;
            this.vtype = vtype;
            this._buf = CDFImpl.this.getRecord(offset);
            this.name = CDFImpl.this.getString(offset + CDFImpl.this.offset_VAR_NAME);
            this._buf.position(CDFImpl.this.offset_VAR_NUM_ELEMENTS);
            this.numberOfElements = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_NUM);
            this.number = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_FLAGS);
            this.flags = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_BLOCKING_FACTOR);
            this.blockingFactor = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_VAR_DATATYPE);
            this.type = this._buf.getInt();
            this.numberOfValues = this._buf.getInt() + 1;
            this._buf.position(CDFImpl.this.offset_zNumDims);
            if (vtype.equals("r")) {
                this.dimensions = CDFImpl.this.rDimSizes;
            }
            if (vtype.equals("z")) {
                this.dimensions = new int[this._buf.getInt()];
                for (i = 0; i < this.dimensions.length; ++i) {
                    this.dimensions[i] = this._buf.getInt();
                }
            }
            if (this.type == 32) {
                this.dimensions = new int[]{2};
            }
            this.varies = new boolean[this.dimensions.length];
            for (i = 0; i < this.dimensions.length; ++i) {
                this.varies[i] = this._buf.getInt() == this.DIMENSION_VARIES;
            }
            if (this.type == 32) {
                this.varies = new boolean[]{true};
            }
            this.dataItemSize = DataTypes.size[this.type];
            if (this.padValueSpecified()) {
                int padValueSize = this.getDataItemSize() / this.dataItemSize;
                this.padValue = DataTypes.method[this.type] == null ? null : CDFImpl.getNumberAttribute(this.type, padValueSize, this._buf, CDFImpl.this.byteOrder);
            }
            if (DataTypes.isStringType(this.type)) {
                this.dataItemSize *= this.numberOfElements;
            }
            if (this.numberOfValues == 0) {
                return;
            }
            this.locator = new DataLocator(this._buf, this.numberOfValues, (this.flags & 4) != 0);
        }

        public VariableDataLocator getLocator() {
            return this.locator;
        }

        public VariableDataBuffer[] getDataBuffers() throws Throwable {
            if ((this.flags & 4) != 0) {
                throw new Throwable("Function not supported for compressed variables ");
            }
            int[][] locations = this.locator.getLocations();
            Vector<VariableDataBuffer> dbufs = new Vector<VariableDataBuffer>();
            int size = this.getDataItemSize();
            for (int i = 0; i < locations.length; ++i) {
                int first = locations[i][0];
                int last = locations[i][1];
                ByteBuffer bv = CDFImpl.this.getValueBuffer(locations[i][2]);
                ByteBuffer bbuf = bv.slice();
                bbuf.order(CDFImpl.this.getByteOrder());
                bbuf.limit((last - first + 1) * size);
                dbufs.add(new VariableDataBuffer(first, last, bbuf));
            }
            VariableDataBuffer[] vdbuf = new VariableDataBuffer[dbufs.size()];
            dbufs.toArray(vdbuf);
            return vdbuf;
        }

        public ByteBuffer getBuffer() {
            ByteBuffer result = CDFImpl.this.buf.duplicate();
            return result.asReadOnlyBuffer();
        }

        public boolean rowMajority() {
            return CDFImpl.this.rowMajority();
        }

        public boolean recordVariance() {
            return (this.flags & 1) != 0;
        }

        public boolean padValueSpecified() {
            return (this.flags & 2) != 0;
        }

        public boolean isCompressed() {
            return this.locator.isReallyCompressed();
        }

        public double[] getPadValue() {
            return (double[])this.getPadValue(false);
        }

        public Object getPadValue(boolean preservePrecision) {
            if (this.padValue == null) {
                return null;
            }
            if (this.padValue.getClass().getComponentType() == Long.TYPE && preservePrecision) {
                long[] ltemp = (long[])this.padValue;
                long[] la = new long[ltemp.length];
                System.arraycopy(ltemp, 0, la, 0, ltemp.length);
                return la;
            }
            double[] dtemp = (double[])this.padValue;
            double[] da = new double[dtemp.length];
            System.arraycopy(dtemp, 0, da, 0, dtemp.length);
            return da;
        }

        public int getType() {
            return this.type;
        }

        public int getBlockingFactor() {
            return this.blockingFactor;
        }

        public int getEffectiveRank() {
            int rank = 0;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i] || this.dimensions[i] == 1) continue;
                ++rank;
            }
            return rank;
        }

        public int getDataItemSize() {
            int size = this.dataItemSize;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i]) continue;
                size *= this.dimensions[i];
            }
            return size;
        }

        public int getNumberOfElements() {
            return this.numberOfElements;
        }

        public int getNumberOfValues() {
            return this.numberOfValues;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public int getDataType() {
            return this.type;
        }

        public int[] getDimensions() {
            int[] ia = new int[this.dimensions.length];
            System.arraycopy(this.dimensions, 0, ia, 0, this.dimensions.length);
            return ia;
        }

        public boolean[] getVarys() {
            boolean[] ba = new boolean[this.varies.length];
            System.arraycopy(this.varies, 0, ba, 0, this.varies.length);
            return ba;
        }

        public String toString() {
            StringBuilder dimString = new StringBuilder(this.getName()).append("[").append(this.numberOfValues);
            int[] dims = this.getDimensions();
            for (int i = 0; i < dims.length; ++i) {
                dimString.append(",").append(dims[i]);
            }
            dimString.append("]");
            return dimString.toString();
        }
    }

    public class AttributeEntry
    implements Serializable {
        transient ByteBuffer _buf;
        int variableNumber;
        int type;
        int nelement;
        String attribute;
        String stringValue;
        Object value;

        public AttributeEntry(ByteBuffer buf, String name) {
            this.attribute = name;
            this._buf = buf.duplicate();
            this._buf.position(CDFImpl.this.offset_ENTRYNUM);
            this.variableNumber = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_ATTR_DATATYPE);
            this.type = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_ATTR_NUM_ELEMENTS);
            this.nelement = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_VALUE);
            if (this.type > 50) {
                int i;
                byte[] ba = new byte[this.nelement];
                for (i = 0; i < this.nelement; ++i) {
                    ba[i] = this._buf.get();
                    if (ba[i] == 0) break;
                }
                this.stringValue = new String(ba, 0, i);
            } else {
                this.value = CDFImpl.getNumberAttribute(this.type, this.nelement, this._buf, CDFImpl.this.byteOrder);
            }
        }

        public boolean isLongType() {
            return DataTypes.typeCategory[this.type] == 5;
        }
    }

    public class CDFAttribute
    implements Serializable,
    Attribute {
        String name;
        int scope;
        Vector zEntries = new Vector();
        Vector gEntries = new Vector();

        public CDFAttribute(int offset) {
            this.name = CDFImpl.this.getString(offset + CDFImpl.this.offset_ATTR_NAME);
            ByteBuffer _buf = CDFImpl.this.getRecord(offset);
            _buf.position(CDFImpl.this.offset_SCOPE);
            this.scope = _buf.getInt();
            _buf.position(CDFImpl.this.offset_AgrEDRHead);
            int n = CDFImpl.this.lowOrderInt(_buf);
            if (n > 0) {
                this.gEntries = this.getAttributeEntries(n);
                if (this.scope == 2 || this.scope == 4) {
                    this.linkToVariables(this.gEntries, "r");
                }
            }
            _buf.position(CDFImpl.this.offset_AzEDRHead);
            n = CDFImpl.this.lowOrderInt(_buf);
            if (n > 0) {
                this.zEntries = this.getAttributeEntries(n);
                this.linkToVariables(this.zEntries, "z");
            }
        }

        public String getName() {
            return this.name;
        }

        public Vector getAttributeEntries(int offset) {
            if (offset == 0) {
                return null;
            }
            Vector<AttributeEntry> list = new Vector<AttributeEntry>();
            ByteBuffer _buf = CDFImpl.this.getRecord(offset);
            while (true) {
                _buf.position(CDFImpl.this.offset_NEXT_AEDR);
                int next = CDFImpl.this.lowOrderInt(_buf);
                _buf.position(0);
                AttributeEntry ae = new AttributeEntry(_buf, this.name);
                list.add(ae);
                if (next == 0) break;
                _buf = CDFImpl.this.getRecord(next);
            }
            return list;
        }

        public void linkToVariables(Vector entries, String type) {
            for (int e = 0; e < entries.size(); ++e) {
                AttributeEntry ae = (AttributeEntry)entries.elementAt(e);
                CDFVariable var = (CDFVariable)CDFImpl.this.getCDFVariable(type, ae.variableNumber);
                if (var == null) continue;
                var.attributes.add(ae);
            }
        }

        public boolean isGlobal() {
            return this.scope != 2 && this.scope != 4;
        }
    }
}

