/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.CDFImpl;
import gov.nasa.gsfc.voyager.cdf.Variable;
import gov.nasa.gsfc.voyager.cdf.VariableDataLocator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Vector;

public class CDFSubset
implements Serializable {
    CDF cdf;
    double[] times;
    byte[] values;
    Hashtable offsets = new Hashtable();
    String[] vnames;
    int numpt;
    CDFImpl impl;

    public CDFSubset(CDF cdf, double start, double stop, String[] vnames) throws Throwable {
        int size;
        Variable v;
        int i;
        int[] rr;
        this.cdf = cdf;
        this.impl = (CDFImpl)((Object)cdf);
        int rheader = this.impl.getRecordOffset();
        this.vnames = vnames;
        try {
            rr = cdf.getRecordRange(vnames[0], new double[]{start, stop});
            this.times = cdf.getTimes(vnames[0], rr);
        }
        catch (Throwable th) {
            throw new Throwable("subset for " + vnames[0]);
        }
        this.numpt = rr[1] - rr[0] + 1;
        int offset = 0;
        for (i = 0; i < vnames.length; ++i) {
            v = cdf.getVariable(vnames[i]);
            size = v.getDataItemSize();
            this.offsets.put(vnames[i], new Integer(offset));
            offset += rheader + size * this.numpt;
        }
        this.values = new byte[offset];
        block3: for (i = 0; i < vnames.length; ++i) {
            int e;
            offset = (Integer)this.offsets.get(vnames[i]) + rheader;
            v = cdf.getVariable(vnames[i]);
            size = v.getDataItemSize();
            VariableDataLocator locator = v.getLocator();
            int[][] locations = locator.getLocations();
            for (e = 0; e < locations.length && rr[0] > locations[e][1]; ++e) {
            }
            if (e == locations.length) continue;
            int begin = rr[0] - locations[e][0];
            if (begin < 0) {
                begin = 0;
            }
            while (e < locations.length) {
                boolean last;
                int bufOffset = locations[e][2] + begin * size + rheader;
                int end = locations[e][1];
                boolean bl = last = rr[1] <= locations[e][1];
                if (last) {
                    end = rr[1];
                }
                int len = size * (1 + end - (locations[e][0] + begin));
                ((CDFImpl)((Object)cdf)).extractBytes(bufOffset, this.values, offset, len);
                if (last) continue block3;
                offset += len;
                begin = 0;
                ++e;
            }
        }
    }

    public CDF getCDF() {
        return this.cdf;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        CDFImpl.CDFTimeVariable tvar;
        Hashtable<String, Vector> locators = new Hashtable<String, Vector>();
        Hashtable _variableTable = new Hashtable();
        Hashtable savedVariableTable = this.impl.variableTable;
        String[] savedVarNames = this.impl.varNames;
        int _numberOfValues = 0;
        try {
            tvar = (CDFImpl.CDFTimeVariable)((Object)this.impl.getCDFTimeVariable(this.vnames[0]));
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new IOException("could not get time variable");
        }
        double[] _times = tvar.times;
        tvar.times = this.times;
        _variableTable.put(tvar.getName(), this.impl.variableTable.get(tvar.getName()));
        for (i = 0; i < this.vnames.length; ++i) {
            String s = this.vnames[i];
            CDFImpl.CDFVariable var = (CDFImpl.CDFVariable)this.cdf.getVariable(s);
            _numberOfValues = var.numberOfValues;
            var.numberOfValues = this.numpt;
            CDFImpl.DataLocator locator = (CDFImpl.DataLocator)var.getLocator();
            locators.put(s, locator.locations);
            Vector<int[]> locvec = new Vector<int[]>();
            int offset = (Integer)this.offsets.get(s);
            locvec.add(new int[]{0, this.numpt - 1, offset});
            locator.locations = locvec;
            _variableTable.put(s, this.impl.variableTable.get(s));
        }
        this.impl.varNames = this.vnames;
        this.impl.variableTable = _variableTable;
        out.defaultWriteObject();
        for (i = 0; i < this.vnames.length; ++i) {
            CDFImpl.CDFVariable var = (CDFImpl.CDFVariable)this.cdf.getVariable(this.vnames[i]);
            var.numberOfValues = _numberOfValues;
            CDFImpl.DataLocator locator = (CDFImpl.DataLocator)var.getLocator();
            locator.locations = (Vector)locators.get(this.vnames[i]);
        }
        tvar.times = _times;
        this.impl.variableTable = savedVariableTable;
        this.impl.varNames = savedVarNames;
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        ((CDFImpl)((Object)this.cdf)).setBuffer(ByteBuffer.wrap(this.values));
        ((CDFImpl)((Object)this.cdf)).setByteOrder(((CDFImpl)((Object)this.cdf)).isBigEndian());
    }
}

