/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdf;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfVirtualVars {
    public static QDataSet execute(Map<String, Object> metadata, String function, List<QDataSet> args, ProgressMonitor mon) {
        if (function.equalsIgnoreCase("compute_magnitude")) {
            return CdfVirtualVars.computeMagnitude(args.get(0));
        }
        if (function.equalsIgnoreCase("convert_log10")) {
            return CdfVirtualVars.convertLog10(args.get(0));
        }
        if (function.equalsIgnoreCase("fftPower512")) {
            return Ops.fftPower((QDataSet)args.get(0), (int)512, (ProgressMonitor)mon);
        }
        if (function.equalsIgnoreCase("fftPower")) {
            QDataSet size = args.get(1);
            while (size.rank() > 0) {
                size = size.slice(0);
            }
            QDataSet hanningSet = Ops.fftFilter((QDataSet)args.get(0), (int)((int)size.value()), (Ops.FFTFilterType)Ops.FFTFilterType.Hanning);
            return Ops.fftPower((QDataSet)hanningSet, (int)((int)size.value()), (ProgressMonitor)new NullProgressMonitor());
        }
        if (function.equalsIgnoreCase("fftPowerDelta512")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT, (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)512, (ProgressMonitor)mon);
            return pow;
        }
        if (function.equals("fftPowerDelta2048")) {
            QDataSet deltaT = args.get(1);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            while (deltaT.rank() > 0) {
                deltaT = deltaT.slice(0);
            }
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT, (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)2048, (ProgressMonitor)mon);
            return pow;
        }
        if (function.equals("fftPowerDeltaTranslation512")) {
            QDataSet deltaT = args.get(1);
            QDataSet translation = args.get(2);
            MutablePropertyDataSet waves = DataSetOps.makePropertiesMutable((QDataSet)args.get(0));
            waves.putProperty("DEPEND_1", (Object)Ops.multiply((QDataSet)deltaT.slice(0), (QDataSet)Ops.findgen((int)waves.length(0))));
            QDataSet pow = Ops.fftPower((QDataSet)waves, (int)512, (ProgressMonitor)mon);
            MutablePropertyDataSet poww = DataSetOps.makePropertiesMutable((QDataSet)pow);
            QDataSet trs1 = Ops.add((QDataSet)((QDataSet)pow.property("DEPEND_1")), (QDataSet)translation.slice(0));
            poww.putProperty("DEPEND_1", (Object)trs1);
            throw new IllegalArgumentException("fftPowerDeltaTranslation512 is untested");
        }
        if (function.equalsIgnoreCase("calc_p")) {
            return CdfVirtualVars.calcP(args);
        }
        if (function.equalsIgnoreCase("conv_pos1")) {
            return CdfVirtualVars.convPos(args, "ANG-GSE");
        }
        if (function.equalsIgnoreCase("alternate_view")) {
            return args.get(0);
        }
        if (function.equalsIgnoreCase("region_filt")) {
            ArrayDataSet real_data = ArrayDataSet.copy((QDataSet)args.get(0));
            QDataSet region_data = args.get(1);
            Double fill = (Double)metadata.get("FILL_VALUE");
            if (fill == null) {
                fill = Double.NaN;
            }
            for (int i = 0; i < real_data.length(); ++i) {
                if (region_data.value(i) == 1.0) continue;
                real_data.putValue(i, fill.doubleValue());
            }
            return real_data;
        }
        if (function.equalsIgnoreCase("apply_esa_qflag")) {
            ArrayDataSet esa_data = ArrayDataSet.copy((QDataSet)args.get(0));
            QDataSet quality_data = args.get(1);
            Double fill = (Double)metadata.get("FILL_VALUE");
            if (fill == null) {
                fill = Double.NaN;
            }
            int n = DataSetUtil.product((int[])DataSetUtil.qubeDims((QDataSet)esa_data.slice(0)));
            for (int i = 0; i < quality_data.length(); ++i) {
                if (!(quality_data.value(i) > 0.0)) continue;
                if (esa_data.rank() == 1) {
                    esa_data.putValue(i, fill.doubleValue());
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    esa_data.putValue(i, j, fill.doubleValue());
                }
            }
            return esa_data;
        }
        throw new IllegalArgumentException("unimplemented function: " + function);
    }

    protected static QDataSet calcP(List<QDataSet> args) {
        DRank0DataSet coefficient = DataSetUtil.asDataSet((double)1.6726E-6);
        QDataSet V_GSE_p = args.get(0);
        QDataSet np = args.get(1);
        QDataSet pressure = Ops.multiply((QDataSet)Ops.multiply((QDataSet)coefficient, (QDataSet)np), (QDataSet)Ops.pow((QDataSet)DataSetOps.slice1((QDataSet)V_GSE_p, (int)0), (double)2.0));
        return pressure;
    }

    public static QDataSet convPos(List<QDataSet> args, String coordSys) {
        throw new IllegalArgumentException("not implemented");
    }

    protected static QDataSet alternateView(QDataSet burley) {
        return burley;
    }

    protected static QDataSet computeMagnitude(QDataSet burley) {
        return Ops.magnitude((QDataSet)burley);
    }

    protected static QDataSet convertLog10(QDataSet burley) {
        return Ops.log10((QDataSet)burley);
    }

    protected static QDataSet addSeconds(QDataSet burley, double seconds) {
        QDataSet dep0 = (QDataSet)burley.property("DEPEND_0");
        if (dep0 == null) {
            throw new IllegalArgumentException("DEPEND_0 not found");
        }
        dep0 = Ops.add((QDataSet)dep0, (QDataSet)DataSetUtil.asDataSet((double)seconds, (Units)Units.seconds));
        ArrayDataSet result = ArrayDataSet.maybeCopy((QDataSet)burley);
        result.putProperty("DEPEND_0", (Object)dep0);
        return result;
    }

    public static boolean isSupported(String function) {
        List<String> functions = Arrays.asList("compute_magnitude", "convert_log10", "fftpowerdelta512", "fftpowerdelta2048", "fftpower", "fftpowerdeltatranslation512", "alternate_view", "calc_p", "region_filt", "apply_esa_qflag");
        return functions.contains(function.toLowerCase());
    }
}

