/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import org.das2.datum.Basis;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dsops.CoerceUtil;
import org.virbo.dsops.Ops;

public class CdfDataSetUtil {
    static boolean equalGeom(QDataSet ds1, QDataSet ds2) {
        int[] qube1 = DataSetUtil.qubeDims((QDataSet)ds1);
        int[] qube2 = DataSetUtil.qubeDims((QDataSet)ds2);
        for (int i = 0; i < qube2.length; ++i) {
            if (qube1[i] == qube2[i]) continue;
            return false;
        }
        return true;
    }

    public static int validCount(QDataSet ds1, int limit) {
        QDataSet weights = DataSetUtil.weightsDataSet((QDataSet)ds1);
        QubeDataSetIterator iter = new QubeDataSetIterator(weights);
        int validCount = 0;
        while (validCount < limit && iter.hasNext()) {
            iter.next();
            if (!(iter.getValue(weights) > 0.0)) continue;
            ++validCount;
        }
        return validCount;
    }

    public static MutablePropertyDataSet add(QDataSet ds1, QDataSet ds2) {
        MutablePropertyDataSet result;
        Units newUnits;
        QDataSet[] operands = new QDataSet[2];
        CoerceUtil.coerce((QDataSet)ds1, (QDataSet)ds2, (boolean)false, (QDataSet[])operands);
        Units u1 = (Units)ds1.property("UNITS");
        Units u2 = (Units)ds2.property("UNITS");
        Basis b1 = u1.getBasis();
        Basis b2 = u2.getBasis();
        if (b1 == Basis.physicalZero) {
            newUnits = u2;
            final UnitsConverter uc = Units.getConverter((Units)u1.getOffsetUnits(), (Units)u2.getOffsetUnits());
            result = Ops.applyBinaryOp((QDataSet)operands[0], (QDataSet)operands[1], (Ops.BinaryOp)new Ops.BinaryOp(){

                public double op(double d1, double d2) {
                    return uc.convert(d1) + d2;
                }
            });
        } else if (b2 == Basis.physicalZero) {
            newUnits = u1;
            final UnitsConverter uc = Units.getConverter((Units)u2.getOffsetUnits(), (Units)u1.getOffsetUnits());
            result = Ops.applyBinaryOp((QDataSet)operands[0], (QDataSet)operands[1], (Ops.BinaryOp)new Ops.BinaryOp(){

                public double op(double d1, double d2) {
                    return d1 + uc.convert(d2);
                }
            });
        } else {
            throw new IllegalArgumentException("units cannot be added: " + u1 + "+" + u2);
        }
        result.putProperty("UNITS", (Object)newUnits);
        return result;
    }
}

