/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFException;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.cdfdatasource.CdfFileDataSourceFactory;
import org.virbo.cdfdatasource.CdfUtil;
import org.virbo.datasource.DataSetSelector;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;

public class CdfDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger(CdfDataSourceEditorPanel.class.getCanonicalName());
    private JLabel interpretMetadataLabel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JCheckBox noDep;
    private JCheckBox noInterpMeta;
    private JLabel paramInfo;
    private JList parameterList;
    private JCheckBox showAllVarTypeCB;
    private JComboBox subsetComboBox;
    JComponent delegateComponent = null;
    DataSetSelector delegateDataSetSelector = null;
    DataSourceEditorPanel delegateEditorPanel = null;
    URISplit split;
    Map<String, String> params;
    Map<String, String> parameterDescriptions;
    Map<String, String> parameterInfo;
    String parameter;
    long subsetMaxRec = -1L;
    File cdfFile;

    public CdfDataSourceEditorPanel() {
        this.initComponents();
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "cdf_main");
        this.parameterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.parameterList = new JList();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.subsetComboBox = new JComboBox();
        this.interpretMetadataLabel = new JLabel();
        this.noInterpMeta = new JCheckBox();
        this.noDep = new JCheckBox();
        this.showAllVarTypeCB = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.paramInfo = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Select CDF Variable:");
        this.parameterList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.parameterList.setSelectionMode(0);
        this.parameterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CdfDataSourceEditorPanel.this.parameterListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.parameterList);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Advanced"));
        this.jLabel3.setText("Load subset of the data:");
        this.jLabel3.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.subsetComboBox.setEditable(true);
        this.subsetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "::10", "0:100", "-100:", "0:10000:5"}));
        this.subsetComboBox.setToolTipText("<html>Load a subset of the data records, for example:<br>[0:100]  first 100 records<br> [-100:] last 100 records<br> [::10] every tenth record<br> </html>");
        this.interpretMetadataLabel.setText("Interpret Metadata:");
        this.noInterpMeta.setText("no ISTP");
        this.noInterpMeta.setToolTipText("Don't interpret metadata to get titles and units.");
        this.noDep.setText("no dependencies");
        this.noDep.setToolTipText("Ignore connections between variables like \"DEPEND_0\"\n");
        this.showAllVarTypeCB.setText("show all");
        this.showAllVarTypeCB.setToolTipText("show all parameters, even if ISTP VAR_TYPE is not \"data\"");
        this.showAllVarTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CdfDataSourceEditorPanel.this.showAllVarTypeCBActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.interpretMetadataLabel).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.noDep).add((Component)this.noInterpMeta).add((Component)this.showAllVarTypeCB))).add((Component)this.jLabel3).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.subsetComboBox, -2, 160, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.subsetComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.interpretMetadataLabel).addPreferredGap(0).add((Component)this.noInterpMeta).addPreferredGap(0).add((Component)this.noDep).addPreferredGap(0).add((Component)this.showAllVarTypeCB).addContainerGap(45, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1, -2, 193, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jScrollPane1, -1, 379, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 229, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.paramInfo.setText("Variable");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.paramInfo, -1, 611, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.paramInfo).addContainerGap(70, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void parameterListValueChanged(ListSelectionEvent evt) {
        this.parameter = (String)this.parameterList.getSelectedValue();
        this.updateMetadata();
    }

    private void showAllVarTypeCBActionPerformed(ActionEvent evt) {
        this.setURI(this.getURI());
    }

    private void updateMetadata() {
        String longName = this.parameterInfo.get(this.parameter);
        this.paramInfo.setText(longName);
    }

    public JPanel getPanel() {
        return this;
    }

    public void setShowAdvancedSubpanel(boolean v) {
        this.interpretMetadataLabel.setVisible(v);
        this.noDep.setVisible(v);
        this.noInterpMeta.setVisible(v);
    }

    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)this.split.path)).toURI());
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String url, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)url);
        this.cdfFile = DataSetURI.getFile((URL)this.split.resourceUri.toURL(), (ProgressMonitor)mon);
        return true;
    }

    public void setURI(String url) {
        this.split = URISplit.parse((String)url);
        this.params = URISplit.parseParams((String)this.split.params);
        try {
            this.cdfFile = DataSetURI.getFile((URL)this.split.resourceUri.toURL(), (ProgressMonitor)new NullProgressMonitor());
            String fileName = this.cdfFile.toString();
            logger.fine("opening cdf file " + fileName);
            CDF cdf = CdfFileDataSourceFactory.getCDFFile(fileName);
            logger.finest("inspect cdf for plottable parameters");
            this.parameterDescriptions = CdfUtil.getPlottable(cdf, !this.showAllVarTypeCB.isSelected(), 4, false);
            this.parameterInfo = CdfUtil.getPlottable(cdf, !this.showAllVarTypeCB.isSelected(), 4, true);
            if (this.parameterDescriptions.isEmpty()) {
                throw new IllegalArgumentException("no plottable parameters in cdf file!");
            }
            logger.finest("close cdf");
            CdfFileDataSourceFactory.closeCDF(cdf);
            DefaultListModel<String> model = new DefaultListModel<String>();
            DefaultComboBoxModel<String> cbmodel = new DefaultComboBoxModel<String>();
            for (String p : this.parameterDescriptions.keySet()) {
                model.addElement(p);
                cbmodel.addElement(p);
            }
            this.parameterList.setModel(model);
            String param = this.params.get("arg_0");
            if (param != null) {
                int i = param.indexOf("[");
                if (i != -1) {
                    this.subsetComboBox.setSelectedItem(param.substring(i));
                    param = param.substring(0, i);
                } else {
                    this.subsetComboBox.setSelectedItem("");
                }
                this.parameterList.setSelectedValue(param, true);
            } else {
                this.parameter = this.parameterDescriptions.entrySet().iterator().next().getKey();
                this.parameterList.setSelectedValue(this.parameter, true);
                this.subsetComboBox.setSelectedItem("");
                param = this.parameter;
            }
            this.parameter = param.replaceAll("%3D", "=");
            if ("no".equals(this.params.get("interpMeta"))) {
                this.noInterpMeta.setSelected(true);
            }
            if ("no".equals(this.params.get("doDep"))) {
                this.noDep.setSelected(true);
            }
        }
        catch (CDFException ex) {
            DasExceptionHandler.handle((Throwable)ex);
        }
        catch (IOException ex) {
            DasExceptionHandler.handle((Throwable)ex);
            Logger.getLogger(CdfDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            DasExceptionHandler.handle((Throwable)ex);
            Logger.getLogger(CdfDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getURI() {
        String p;
        String slice = this.subsetComboBox.getSelectedItem().toString().trim();
        if (slice.length() > 0 && slice.charAt(0) != '[') {
            slice = "[" + slice + "]";
        }
        if ((p = this.parameter) != null) {
            p = p.replaceAll("=", "%3D");
            this.params.put("arg_0", p + (slice == null ? "" : slice));
        } else {
            System.err.println("param was null");
        }
        if (this.noDep.isSelected()) {
            this.params.put("doDep", "no");
        } else {
            this.params.remove("doDep");
        }
        if (this.noInterpMeta.isSelected()) {
            this.params.put("interpMeta", "no");
        } else {
            this.params.remove("interpMeta");
        }
        this.split.params = URISplit.formatParams(this.params);
        return URISplit.format((URISplit)this.split);
    }
}

