/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfDataSourceFormat
implements DataSourceFormat {
    CDF cdf;
    Attribute depend_0;
    Attribute depend_1;
    Attribute depend_2;
    Attribute unitsAttr;
    Attribute lablAxisAttr;
    Attribute catdescAttr;
    Attribute validmaxAttr;
    Attribute validminAttr;
    Attribute fillvalAttr;
    Attribute scalemaxAttr;
    Attribute scaleminAttr;
    Attribute formatAttr;
    Attribute displayTypeAttr;
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();

    private synchronized String nameFor(QDataSet dep0) {
        String name = this.names.get(dep0);
        if (name == null) {
            name = (String)dep0.property("NAME");
        }
        Units units = (Units)dep0.property("UNITS");
        if (name == null) {
            name = units != null && UnitsUtil.isTimeLocation((Units)units) ? "Epoch" : "Variable_" + this.names.size();
        }
        this.names.put(dep0, name);
        return name;
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException, CDFException {
        QDataSet dep2;
        QDataSet dep1;
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        File file = new File(split.resourceUri);
        if (file.exists() && !file.delete()) {
            throw new IllegalArgumentException("Unable to delete file" + file);
        }
        this.cdf = CDF.create((String)file.toString());
        this.nameFor(data);
        this.unitsAttr = Attribute.create((CDF)this.cdf, (String)"UNITS", (long)2L);
        this.lablAxisAttr = Attribute.create((CDF)this.cdf, (String)"LABLAXIS", (long)2L);
        this.catdescAttr = Attribute.create((CDF)this.cdf, (String)"CATDESC", (long)2L);
        this.displayTypeAttr = Attribute.create((CDF)this.cdf, (String)"DISPLAY_TYPE", (long)2L);
        this.validmaxAttr = Attribute.create((CDF)this.cdf, (String)"VALIDMAX", (long)2L);
        this.validminAttr = Attribute.create((CDF)this.cdf, (String)"VALIDMIN", (long)2L);
        this.fillvalAttr = Attribute.create((CDF)this.cdf, (String)"FILLVAL", (long)2L);
        this.scalemaxAttr = Attribute.create((CDF)this.cdf, (String)"SCALEMAX", (long)2L);
        this.scaleminAttr = Attribute.create((CDF)this.cdf, (String)"SCALEMIN", (long)2L);
        this.formatAttr = Attribute.create((CDF)this.cdf, (String)"FORMAT", (long)2L);
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null) {
            String name = this.nameFor(dep0);
            this.addVariableRankN(dep0, name, new HashMap<String, String>(), mon);
            this.depend_0 = Attribute.create((CDF)this.cdf, (String)"DEPEND_0", (long)2L);
        }
        if ((dep1 = (QDataSet)data.property("DEPEND_1")) != null) {
            String name = this.nameFor(dep1);
            this.addVariableRank1NoVary(dep1, name, new HashMap<String, String>(), (ProgressMonitor)new NullProgressMonitor());
            this.depend_1 = Attribute.create((CDF)this.cdf, (String)"DEPEND_1", (long)2L);
        }
        if ((dep2 = (QDataSet)data.property("DEPEND_2")) != null) {
            String name = this.nameFor(dep2);
            this.addVariableRank1NoVary(dep2, name, new HashMap<String, String>(), (ProgressMonitor)new NullProgressMonitor());
            this.depend_2 = Attribute.create((CDF)this.cdf, (String)"DEPEND_2", (long)2L);
        }
        Variable var = this.addVariableRankN(data, this.nameFor(data), params, mon);
        if (dep0 != null) {
            Entry.create((Attribute)this.depend_0, (long)var.getID(), (long)51L, (Object)this.nameFor(dep0));
        }
        if (dep1 != null) {
            Entry.create((Attribute)this.depend_1, (long)var.getID(), (long)51L, (Object)this.nameFor(dep1));
        }
        if (dep2 != null) {
            Entry.create((Attribute)this.depend_2, (long)var.getID(), (long)51L, (Object)this.nameFor(dep2));
        }
        this.cdf.close();
    }

    private Variable addVariableRank1NoVary(QDataSet ds, String name, Map<String, String> params, ProgressMonitor mon) throws CDFException {
        double[][] dexport;
        Variable var;
        Units units = (Units)ds.property("UNITS");
        long type = 45L;
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            type = 31L;
            uc = units.getConverter((Units)Units.cdfEpoch);
        }
        if (ds.rank() == 1) {
            var = Variable.create((CDF)this.cdf, (String)name, (long)type, (long)1L, (long)1L, (long[])new long[]{ds.length()}, (long)0L, (long[])new long[]{-1L});
            dexport = new double[][]{new double[ds.length()]};
            for (int j = 0; j < ds.length(); ++j) {
                dexport[0][j] = uc.convert(ds.value(j));
            }
        } else {
            throw new IllegalArgumentException("not supported!");
        }
        var.putHyperData(0L, 1L, 1L, new long[]{0L}, new long[]{ds.length()}, new long[]{1L}, (Object)dexport);
        this.copyMetadata(units, var, ds);
        return var;
    }

    private Object doIt1(QDataSet ds, UnitsConverter uc, long type) {
        Object[] export;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        if (type == 45L || type == 31L) {
            double[] dexport = new double[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                dexport[i++] = uc.convert(iter.getValue(ds));
            }
            export = dexport;
        } else if (type == 44L) {
            float[] fexport = new float[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                fexport[i++] = (float)uc.convert(iter.getValue(ds));
            }
            export = fexport;
        } else if (type == 41L) {
            byte[] bexport = new byte[ds.length()];
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                bexport[i++] = (byte)uc.convert(iter.getValue(ds));
            }
            export = bexport;
        } else {
            throw new IllegalArgumentException("not supported: " + type);
        }
        return export;
    }

    private Object dataSetToArray(QDataSet ds, UnitsConverter uc, long type, ProgressMonitor mon) {
        if (ds.rank() == 1) {
            return this.doIt1(ds, uc, type);
        }
        if (ds.rank() == 2) {
            Object oexport;
            if (type == 45L) {
                oexport = new double[ds.length()][];
            } else if (type == 44L) {
                oexport = new float[ds.length()][];
            } else if (type == 41L) {
                oexport = new byte[ds.length()][];
            } else {
                throw new IllegalArgumentException("type not supported" + type);
            }
            for (int i = 0; i < ds.length(); ++i) {
                Array.set(oexport, i, this.dataSetToArray(ds.slice(i), uc, type, mon));
            }
            return oexport;
        }
        if (ds.rank() == 3) {
            Object oexport;
            if (type == 45L) {
                oexport = new double[ds.length()][][];
            } else if (type == 44L) {
                oexport = new float[ds.length()][][];
            } else if (type == 41L) {
                oexport = new byte[ds.length()][][];
            } else {
                throw new IllegalArgumentException("type not supported" + type);
            }
            for (int i = 0; i < ds.length(); ++i) {
                Array.set(oexport, i, this.dataSetToArray(ds.slice(i), uc, type, mon));
            }
            return oexport;
        }
        if (ds.rank() == 4) {
            Object oexport;
            if (type == 45L) {
                oexport = new double[ds.length()][][][];
            } else if (type == 44L) {
                oexport = new float[ds.length()][][][];
            } else if (type == 41L) {
                oexport = new byte[ds.length()][][][];
            } else {
                throw new IllegalArgumentException("type not supported" + type);
            }
            for (int i = 0; i < ds.length(); ++i) {
                Array.set(oexport, i, this.dataSetToArray(ds.slice(i), uc, type, mon));
            }
            return oexport;
        }
        throw new IllegalArgumentException("rank 0 not supported");
    }

    private Variable addVariableRankN(QDataSet ds, String name, Map<String, String> params, ProgressMonitor mon) throws CDFException {
        Variable var;
        Units units = (Units)ds.property("UNITS");
        long type = 45L;
        String t = params.get("type");
        if (t != null) {
            if (t.equals("float")) {
                type = 44L;
            } else if (t.equals("byte")) {
                type = 41L;
            } else if (t.equals("double")) {
                type = 45L;
            }
        } else {
            type = ds.rank() < 3 ? 45L : 44L;
        }
        UnitsConverter uc = UnitsConverter.IDENTITY;
        if (units != null && UnitsUtil.isTimeLocation((Units)units)) {
            type = 31L;
            uc = units.getConverter((Units)Units.cdfEpoch);
            units = Units.cdfEpoch;
        }
        if (ds.rank() == 1) {
            var = Variable.create((CDF)this.cdf, (String)name, (long)type, (long)1L, (long)0L, (long[])new long[]{1L}, (long)-1L, (long[])new long[]{0L});
            Object oexport = this.dataSetToArray(ds, uc, type, mon);
            var.putHyperData(0L, (long)ds.length(), 1L, new long[0], new long[0], new long[0], oexport);
        } else if (ds.rank() == 2) {
            var = Variable.create((CDF)this.cdf, (String)name, (long)type, (long)1L, (long)1L, (long[])new long[]{ds.length(0)}, (long)-1L, (long[])new long[]{-1L});
            Object oexport = this.dataSetToArray(ds, uc, type, mon);
            var.putHyperData(0L, (long)ds.length(), 1L, new long[]{0L}, new long[]{ds.length(0)}, new long[]{1L}, oexport);
        } else if (ds.rank() == 3) {
            var = Variable.create((CDF)this.cdf, (String)name, (long)type, (long)1L, (long)2L, (long[])new long[]{ds.length(0), ds.length(0, 0)}, (long)-1L, (long[])new long[]{-1L, -1L});
            mon.setTaskSize((long)ds.length());
            mon.started();
            for (int i = 0; i < ds.length(); ++i) {
                Object oexport = this.dataSetToArray(ds.slice(i), uc, type, mon);
                var.putHyperData((long)i, 1L, 1L, new long[]{0L, 0L}, new long[]{ds.length(0), ds.length(0, 0)}, new long[]{1L, 1L}, oexport);
                mon.setTaskProgress((long)i);
            }
            mon.finished();
        } else if (ds.rank() == 4) {
            var = Variable.create((CDF)this.cdf, (String)name, (long)type, (long)1L, (long)3L, (long[])new long[]{ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)}, (long)-1L, (long[])new long[]{-1L, -1L, -1L});
            mon.setTaskSize((long)ds.length());
            mon.started();
            for (int i = 0; i < ds.length(); ++i) {
                Object oexport = this.dataSetToArray(ds.slice(i), uc, type, mon);
                var.putHyperData((long)i, 1L, 1L, new long[]{0L, 0L, 0L}, new long[]{ds.length(0), ds.length(0, 0), ds.length(0, 0, 0)}, new long[]{1L, 1L, 1L}, oexport);
                mon.setTaskProgress((long)i);
            }
            mon.finished();
        } else {
            throw new IllegalArgumentException("rank limit");
        }
        this.copyMetadata(units, var, ds);
        return var;
    }

    private void copyMetadata(Units units, Variable var, QDataSet ds) throws CDFException {
        String displayType;
        String format;
        Number fillval;
        String title;
        String label;
        if (units != null) {
            if (units != Units.cdfEpoch) {
                var.putEntry(this.unitsAttr, 51L, (Object)units.toString());
            } else {
                var.putEntry(this.unitsAttr, 51L, (Object)"ms");
            }
        }
        if ((label = (String)ds.property("LABEL")) != null && label.length() > 0) {
            if (label.endsWith("(" + units + ")")) {
                label = label.substring(0, label.length() - units.toString().length() - 2);
            }
            var.putEntry(this.lablAxisAttr, 51L, (Object)label);
        }
        if ((title = (String)ds.property("TITLE")) != null && title.length() > 0) {
            var.putEntry(this.catdescAttr, 51L, (Object)title);
        }
        Number vmax = (Number)ds.property("VALID_MAX");
        Number vmin = (Number)ds.property("VALID_MIN");
        if (vmax != null || vmin != null) {
            if (units == Units.cdfEpoch) {
                UnitsConverter uc = ((Units)ds.property("UNITS")).getConverter(units);
                vmax = vmax == null ? (Number)1.0E38 : (Number)uc.convert(vmax);
                vmin = vmin == null ? (Number)-1.0E38 : (Number)uc.convert(vmin);
                var.putEntry(this.validminAttr, 45L, (Object)vmin.doubleValue());
                var.putEntry(this.validmaxAttr, 45L, (Object)vmax.doubleValue());
            } else {
                if (vmax == null) {
                    vmax = 1.0E38;
                }
                if (vmin == null) {
                    vmin = -1.0E38;
                }
                var.putEntry(this.validminAttr, 45L, (Object)vmin.doubleValue());
                var.putEntry(this.validmaxAttr, 45L, (Object)vmax.doubleValue());
            }
        }
        if ((fillval = (Number)ds.property("FILL_VALUE")) != null) {
            var.putEntry(this.fillvalAttr, 45L, (Object)fillval.doubleValue());
        } else {
            var.putEntry(this.fillvalAttr, 45L, (Object)-1.0E31);
        }
        Number smax = (Number)ds.property("TYPICAL_MAX");
        Number smin = (Number)ds.property("TYPICAL_MIN");
        if (smax != null || smin != null) {
            if (units == Units.cdfEpoch) {
                UnitsConverter uc = ((Units)ds.property("UNITS")).getConverter(units);
                smax = smax == null ? (Number)1.0E38 : (Number)uc.convert(smax);
                smin = smin == null ? (Number)-1.0E38 : (Number)uc.convert(smin);
                var.putEntry(this.scaleminAttr, 45L, (Object)smin.doubleValue());
                var.putEntry(this.scalemaxAttr, 45L, (Object)smax.doubleValue());
            } else {
                if (smax == null) {
                    smax = 1.0E38;
                }
                if (smin == null) {
                    smin = -1.0E38;
                }
                var.putEntry(this.scaleminAttr, 45L, (Object)smin.doubleValue());
                var.putEntry(this.scalemaxAttr, 45L, (Object)smax.doubleValue());
            }
        }
        if ((format = (String)ds.property("FORMAT")) != null) {
            var.putEntry(this.formatAttr, 51L, (Object)format);
        }
        if ((displayType = (String)ds.property("RENDER_TYPE")) == null || displayType.length() == 0) {
            displayType = DataSourceUtil.guessRenderType((QDataSet)ds);
        }
        if (displayType.equals("nnSpectrogram") || displayType.equals("spectrogram")) {
            displayType = "spectrogram";
        } else if (displayType.equals("image")) {
            displayType = "image";
        } else if (displayType.equals("series") || displayType.equals("scatter") || displayType.equals("hugeScatter")) {
            displayType = "time_series";
        }
        var.putEntry(this.displayTypeAttr, 51L, (Object)displayType);
    }
}

