/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cdfdatasource.CdfVirtualVars;
import org.virbo.dataset.BDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.LDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.SDataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.dsops.Ops;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfUtil {
    private static final String VAR_TYPE_DATA = "data";
    private static final Logger logger = Logger.getLogger("virbo.cdfdatasource");

    private static void flatten(double[][] data, double[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            double[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(float[][] data, float[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            float[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(long[][] data, long[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            long[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(int[][] data, int[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            int[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(short[][] data, short[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            short[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(byte[][] data, byte[] back, int offset, int nx, int ny) {
        for (int i = 0; i < nx; ++i) {
            byte[] dd = data[i];
            System.arraycopy(dd, 0, back, offset + i * ny, ny);
        }
    }

    private static void flatten(double[][][] data, double[] back, int offset, int nx, int ny, int nz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            double[][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz);
            offset += ny * nz;
        }
    }

    private static void flatten(float[][][] data, float[] back, int offset, int nx, int ny, int nz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            float[][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz);
            offset += ny * nz;
        }
    }

    private static void flatten(long[][][] data, long[] back, int offset, int nx, int ny, int nz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            long[][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz);
            offset += ny * nz;
        }
    }

    private static void flatten(int[][][] data, int[] back, int offset, int nx, int ny, int nz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            int[][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz);
            offset += ny * nz;
        }
    }

    private static void flatten(short[][][] data, short[] back, int offset, int nx, int ny, int nz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            short[][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz);
            offset += ny * nz;
        }
    }

    private static void flatten(byte[][][] data, byte[] back, int offset, int nx, int ny, int nz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            byte[][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz);
            offset += ny * nz;
        }
    }

    private static void flatten(double[][][][] data, double[] back, int offset, int nx, int ny, int nz, int nzz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            double[][][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz, nzz);
            offset += ny * nz;
        }
    }

    private static void flatten(float[][][][] data, float[] back, int offset, int nx, int ny, int nz, int nzz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            float[][][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz, nzz);
            offset += ny * nz;
        }
    }

    private static void flatten(long[][][][] data, long[] back, int offset, int nx, int ny, int nz, int nzz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            long[][][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz, nzz);
            offset += ny * nz;
        }
    }

    private static void flatten(int[][][][] data, int[] back, int offset, int nx, int ny, int nz, int nzz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            int[][][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz, nzz);
            offset += ny * nz;
        }
    }

    private static void flatten(short[][][][] data, short[] back, int offset, int nx, int ny, int nz, int nzz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            short[][][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz, nzz);
            offset += ny * nz;
        }
    }

    private static void flatten(byte[][][][] data, byte[] back, int offset, int nx, int ny, int nz, int nzz) {
        offset = 0;
        for (int i = 0; i < nx; ++i) {
            byte[][][] ff = data[i];
            CdfUtil.flatten(ff, back, offset, ny, nz, nzz);
            offset += ny * nz;
        }
    }

    private static WritableDataSet wrapRank2(long varType, Object odata, Variable variable) throws RuntimeException {
        DDataSet result;
        if (varType == 21L || varType == 44L) {
            float[][] data = (float[][])odata;
            int nx = data.length;
            int ny = data[0].length;
            float[] back = new float[nx * ny];
            CdfUtil.flatten(data, back, 0, nx, ny);
            result = FDataSet.wrap((float[])back, (int)nx, (int)ny);
        } else if (varType == 22L || varType == 45L) {
            double[][] data = (double[][])odata;
            int nx = data.length;
            int ny = data[0].length;
            double[] back = new double[nx * ny];
            CdfUtil.flatten(data, back, 0, nx, ny);
            result = DDataSet.wrap((double[])back, (int)nx, (int)ny);
        } else if (varType == 31L) {
            double[] data = (double[])odata;
            result = DDataSet.wrap((double[])data);
        } else if (varType == 14L) {
            long[][] data = (long[][])odata;
            int nx = data.length;
            int ny = data[0].length;
            long[] back = new long[nx * ny];
            CdfUtil.flatten(data, back, 0, nx, ny);
            result = LDataSet.wrap((long[])back, (int)nx, (int)ny);
        } else if (varType == 4L || varType == 12L) {
            int[][] data = (int[][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int[] back = new int[nx * ny];
            CdfUtil.flatten(data, back, 0, nx, ny);
            result = IDataSet.wrap((int[])back, (int)nx, (int)ny);
        } else if (varType == 2L || varType == 11L) {
            short[][] data = (short[][])odata;
            int nx = data.length;
            int ny = data[0].length;
            short[] back = new short[nx * ny];
            CdfUtil.flatten(data, back, 0, nx, ny);
            result = SDataSet.wrap((short[])back, (int)nx, (int)ny);
        } else if (varType == 1L || varType == 41L) {
            byte[][] data = (byte[][])odata;
            int nx = data.length;
            int ny = data[0].length;
            byte[] back = new byte[nx * ny];
            CdfUtil.flatten(data, back, 0, nx, ny);
            result = BDataSet.wrap((byte[])back, (int)nx, (int)ny);
        } else if (varType == 51L || varType == 52L) {
            EnumerationUnits units = EnumerationUnits.create((Object)variable.getName());
            String[] sdata = (String[])odata;
            double[] back = new double[sdata.length];
            for (int i = 0; i < sdata.length; ++i) {
                back[i] = units.createDatum((Object)sdata[i]).doubleValue((Units)units);
            }
            result = DDataSet.wrap((double[])back);
            result.putProperty("UNITS", (Object)units);
        } else {
            throw new RuntimeException("Unsupported Data Type " + variable.getDataType() + " java type " + odata.getClass());
        }
        return result;
    }

    private static WritableDataSet wrapRank3(long varType, Object odata, Variable variable) throws RuntimeException {
        FDataSet result;
        if (varType == 22L || varType == 45L) {
            double[][][] data = (double[][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            double[] back = new double[nx * ny * nz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz);
            result = DDataSet.wrap((double[])back, (int[])new int[]{nx, ny, nz});
        } else if (varType == 21L || varType == 44L) {
            float[][][] data = (float[][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            float[] back = new float[nx * ny * nz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz);
            result = FDataSet.wrap((float[])back, (int)nx, (int)ny, (int)nz);
        } else if (varType == 14L) {
            long[][][] data = (long[][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            long[] back = new long[nx * ny * nz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz);
            result = LDataSet.wrap((long[])back, (int)nx, (int)ny, (int)nz);
        } else if (varType == 4L || varType == 12L) {
            int[][][] data = (int[][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int[] back = new int[nx * ny * nz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz);
            result = IDataSet.wrap((int[])back, (int)nx, (int)ny, (int)nz);
        } else if (varType == 2L || varType == 12L || varType == 11L) {
            short[][][] data = (short[][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            short[] back = new short[nx * ny * nz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz);
            result = SDataSet.wrap((short[])back, (int)nx, (int)ny, (int)nz);
        } else if (varType == 1L || varType == 41L) {
            byte[][][] data = (byte[][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            byte[] back = new byte[nx * ny * nz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz);
            result = BDataSet.wrap((byte[])back, (int)nx, (int)ny, (int)nz);
        } else {
            throw new RuntimeException("Unsupported Data Type " + variable.getDataType() + " java type " + odata.getClass());
        }
        return result;
    }

    private static WritableDataSet wrapRank4(long varType, Object odata, Variable variable) throws RuntimeException {
        DDataSet result;
        if (varType == 22L || varType == 45L) {
            double[][][][] data = (double[][][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int nzz = data[0][0][0].length;
            double[] back = new double[nx * ny * nz * nzz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz, nzz);
            result = DDataSet.wrap((double[])back, (int[])new int[]{nx, ny, nz, nzz});
        } else if (varType == 21L || varType == 44L) {
            float[][][][] data = (float[][][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int nzz = data[0][0][0].length;
            float[] back = new float[nx * ny * nz * nzz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz, nzz);
            result = FDataSet.wrap((float[])back, (int[])new int[]{nx, ny, nz, nzz});
        } else if (varType == 14L) {
            long[][][][] data = (long[][][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int nzz = data[0][0][0].length;
            long[] back = new long[nx * ny * nz * nzz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz, nzz);
            result = LDataSet.wrap((long[])back, (int[])new int[]{nx, ny, nz, nzz});
        } else if (varType == 4L || varType == 12L) {
            int[][][][] data = (int[][][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int nzz = data[0][0][0].length;
            int[] back = new int[nx * ny * nz * nzz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz, nzz);
            result = IDataSet.wrap((int[])back, (int[])new int[]{nx, ny, nz, nzz});
        } else if (varType == 2L || varType == 11L) {
            short[][][][] data = (short[][][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int nzz = data[0][0][0].length;
            short[] back = new short[nx * ny * nz * nzz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz, nzz);
            result = SDataSet.wrap((short[])back, (int[])new int[]{nx, ny, nz, nzz});
        } else if (varType == 1L || varType == 41L) {
            byte[][][][] data = (byte[][][][])odata;
            int nx = data.length;
            int ny = data[0].length;
            int nz = data[0][0].length;
            int nzz = data[0][0][0].length;
            byte[] back = new byte[nx * ny * nz * nzz];
            CdfUtil.flatten(data, back, 0, nx, ny, nz, nzz);
            result = BDataSet.wrap((byte[])back, (int[])new int[]{nx, ny, nz, nzz});
        } else {
            throw new RuntimeException("Unsupported Data Type " + variable.getDataType() + " java type " + odata.getClass());
        }
        return result;
    }

    private static double doubleValue(Object o) {
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    public static DatumRange getRange(HashMap attrs) {
        DatumRange range = attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX") ? new DatumRange(CdfUtil.doubleValue(attrs.get("SCALEMIN")), CdfUtil.doubleValue(attrs.get("SCALEMAX")), Units.dimensionless) : new DatumRange(CdfUtil.doubleValue(attrs.get("VALIDMIN")), CdfUtil.doubleValue(attrs.get("VALIDMAX")), Units.dimensionless);
        return range;
    }

    public static String getScaleType(HashMap attrs) {
        String type = "linear";
        if (attrs.containsKey("SCALETYP")) {
            type = (String)attrs.get("SCALETYP");
        }
        return type;
    }

    private static WritableDataSet wrapSingle(long varType, String name, Object o) {
        DDataSet result;
        if (varType == 31L) {
            result = DDataSet.wrap((double[])new double[]{(Double)o});
            result.putProperty("UNITS", (Object)Units.cdfEpoch);
            result.putProperty("VALID_MIN", (Object)1.0);
        } else {
            if (varType == 32L) {
                throw new UnsupportedOperationException("single Epoch16 not supported, send us the file");
            }
            if (o instanceof Number) {
                result = DDataSet.wrap((double[])new double[]{((Number)o).doubleValue()});
            } else if (varType == 51L || varType == 52L) {
                EnumerationUnits units = EnumerationUnits.create((Object)name);
                String sdata = (String)o;
                double[] back = new double[]{units.createDatum((Object)sdata).doubleValue((Units)units)};
                result = DDataSet.wrap((double[])back);
                result.putProperty("UNITS", (Object)units);
            } else {
                throw new RuntimeException("Unsupported Data Type " + varType + " java type " + o.getClass());
            }
        }
        return result;
    }

    public static MutablePropertyDataSet wrapCdfHyperDataHacked(Variable variable, long recStart, long recCount, long recInterval, ProgressMonitor mon) throws CDFException {
        FDataSet result;
        int i;
        int[] qube;
        Object odata;
        boolean breakUp;
        long[] dimIntervals;
        long[] dimCounts;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        long varType = variable.getDataType();
        long[] dimIndeces = new long[]{0L};
        long[] dimSizes = variable.getDimSizes();
        int dims = dimSizes == null ? 0 : dimSizes.length;
        if (dims == 0) {
            dimCounts = new long[]{0L};
            dimIntervals = new long[]{0L};
        } else if (dims == 1) {
            dimCounts = new long[]{dimSizes[0]};
            dimIntervals = new long[]{1L};
        } else if (dims == 2) {
            dimIndeces = new long[]{0L, 0L};
            dimCounts = new long[]{dimSizes[0], dimSizes[1]};
            dimIntervals = new long[]{1L, 1L};
        } else if (dims == 3) {
            dimIndeces = new long[]{0L, 0L, 0L};
            dimCounts = new long[]{dimSizes[0], dimSizes[1], dimSizes[2]};
            dimIntervals = new long[]{1L, 1L, 1L};
        } else {
            if (recCount != -1L) {
                throw new IllegalArgumentException("rank 5 not implemented");
            }
            dimCounts = new long[]{dimSizes[0]};
            dimIntervals = new long[]{1L};
        }
        int recSizeCount = 1;
        if (dimSizes != null) {
            for (int i2 = 0; i2 < dimSizes.length; ++i2) {
                recSizeCount = (int)((long)recSizeCount * dimSizes[i2]);
            }
        }
        if (recCount == -1L && recStart > 0L && variable.getMaxWrittenRecord() == 0L) {
            recStart = 0L;
        }
        long rc = Math.max(1L, recCount);
        boolean bl = breakUp = (varType == 21L || varType == 44L) && recCount * (long)recSizeCount > 10000000L && recInterval == 1L;
        if (breakUp) {
            logger.info("breaking up into smaller reads to save memory");
            odata = new float[(int)((long)recSizeCount * rc)];
            long blockSize = Math.max(20, 10000000 / recSizeCount);
            int nread = (int)(rc / blockSize);
            mon.started();
            mon.setTaskSize((long)(nread + 1));
            for (int i3 = 0; i3 < nread; ++i3) {
                mon.setTaskProgress((long)i3);
                CDFData cdfData = variable.getHyperDataObject(recStart + (long)i3 * blockSize, blockSize, recInterval, dimIndeces, dimCounts, dimIntervals);
                float[] odata1 = (float[])cdfData.getRawData();
                System.arraycopy(odata1, 0, (float[])odata, (int)((long)(recSizeCount * i3) * blockSize), (int)((long)recSizeCount * blockSize));
            }
            long nremain = rc - (recStart + (long)nread * blockSize);
            if (nremain > 0L) {
                mon.setTaskProgress((long)nread);
                CDFData cdfData = variable.getHyperDataObject(recStart + (long)nread * blockSize, nremain, recInterval, dimIndeces, dimCounts, dimIntervals);
                float[] odata1 = (float[])cdfData.getRawData();
                System.arraycopy(odata1, 0, (float[])odata, (int)((long)(recSizeCount * nread) * blockSize), (int)((long)recSizeCount * nremain));
            }
            mon.finished();
        } else {
            CDFData cdfData = variable.getHyperDataObject(recStart, rc, recInterval, dimIndeces, dimCounts, dimIntervals);
            odata = cdfData.getRawData();
            if (!odata.getClass().isArray()) {
                Object o2 = null;
                if (odata.getClass() == Double.class) {
                    o2 = Array.newInstance(Double.TYPE, 1);
                } else if (odata.getClass() == Float.class) {
                    o2 = Array.newInstance(Float.TYPE, 1);
                } else if (odata.getClass() == Long.class) {
                    o2 = Array.newInstance(Long.TYPE, 1);
                } else if (odata.getClass() == Integer.class) {
                    o2 = Array.newInstance(Integer.TYPE, 1);
                } else if (odata.getClass() == Short.class) {
                    o2 = Array.newInstance(Short.TYPE, 1);
                } else if (odata.getClass() == Byte.class) {
                    o2 = Array.newInstance(Byte.TYPE, 1);
                }
                if (o2 != null) {
                    System.err.println("handling rank 0 value by making 1-element array");
                    System.err.println("  in " + variable);
                    Array.set(o2, 0, odata);
                    odata = o2;
                }
            }
        }
        if (dims == 0) {
            dimSizes = new long[]{};
        }
        if (recCount == -1L) {
            qube = new int[dimSizes.length];
            for (i = 0; i < dimSizes.length; ++i) {
                qube[i] = (int)dimSizes[i];
            }
        } else {
            qube = new int[1 + dimSizes.length];
            for (i = 0; i < dimSizes.length; ++i) {
                qube[1 + i] = (int)dimSizes[i];
            }
            qube[0] = (int)recCount;
        }
        if (varType == 21L || varType == 44L) {
            result = FDataSet.wrap((float[])((float[])odata), (int[])qube);
        } else if (varType == 22L || varType == 45L) {
            result = DDataSet.wrap((double[])((double[])odata), (int[])qube);
        } else if (varType == 14L) {
            result = LDataSet.wrap((long[])((long[])odata), (int[])qube);
        } else if (varType == 4L || varType == 12L) {
            result = IDataSet.wrap((int[])((int[])odata), (int[])qube);
        } else if (varType == 2L || varType == 11L) {
            result = SDataSet.wrap((short[])((short[])odata), (int[])qube);
        } else if (varType == 1L || varType == 41L) {
            result = BDataSet.wrap((byte[])((byte[])odata), (int[])qube);
        } else if (varType == 51L || varType == 52L) {
            EnumerationUnits units = EnumerationUnits.create((Object)variable.getName());
            String[] sdata = (String[])odata;
            double[] back = new double[sdata.length];
            for (int i4 = 0; i4 < sdata.length; ++i4) {
                back[i4] = units.createDatum((Object)sdata[i4]).doubleValue((Units)units);
            }
            result = DDataSet.wrap((double[])back, (int[])qube);
            result.putProperty("UNITS", (Object)units);
        } else if (varType == 31L) {
            if (qube.length == 2 && qube[1] == 1) {
                qube = new int[]{qube[0]};
            }
            result = DDataSet.wrap((double[])((double[])odata), (int[])qube);
            result.putProperty("UNITS", (Object)Units.cdfEpoch);
            result.putProperty("VALID_MIN", (Object)5.68025568E13);
            result.putProperty("VALID_MAX", (Object)6.94253376E13);
        } else if (varType == 32L) {
            double[] data = (double[])odata;
            double[] dresult = new double[data.length / 2];
            for (int i5 = 0; i5 < dresult.length; ++i5) {
                double t2000 = data[i5 * 2] - 6.3113904E10;
                dresult[i5] = t2000 * 1000000.0 + data[i5 * 2 + 1] / 1000000.0;
            }
            result = DDataSet.wrap((double[])dresult, (int[])qube);
            result.putProperty("UNITS", (Object)Units.us2000);
        } else {
            throw new RuntimeException("Unsupported Data Type " + variable.getDataType() + " java type " + odata.getClass());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MutablePropertyDataSet wrapCdfHyperData(Variable variable, long recStart, long recCount, long recInterval) throws CDFException {
        WritableDataSet result2;
        long[] dimIntervals;
        long[] dimCounts;
        long varType = variable.getDataType();
        long[] dimIndeces = new long[]{0L};
        long[] dimSizes = variable.getDimSizes();
        int dims = dimSizes == null ? 0 : dimSizes.length;
        if (dims == 0) {
            dimCounts = new long[]{0L};
            dimIntervals = new long[]{0L};
        } else if (dims == 1) {
            dimCounts = new long[]{dimSizes[0]};
            dimIntervals = new long[]{1L};
        } else if (dims == 2) {
            dimIndeces = new long[]{0L, 0L};
            dimCounts = new long[]{dimSizes[0], dimSizes[1]};
            dimIntervals = new long[]{1L, 1L};
        } else if (dims == 3) {
            dimIndeces = new long[]{0L, 0L, 0L};
            dimCounts = new long[]{dimSizes[0], dimSizes[1], dimSizes[2]};
            dimIntervals = new long[]{1L, 1L, 1L};
        } else {
            if (recCount != -1L) {
                throw new IllegalArgumentException("rank 5 not implemented");
            }
            dimCounts = new long[]{dimSizes[0]};
            dimIntervals = new long[]{1L};
        }
        Object odata = variable.getHyperData(recStart, Math.max(1L, recCount), recInterval, dimIndeces, dimCounts, dimIntervals);
        int rank = 1;
        if (!odata.getClass().isArray() && recCount == -1L) {
            rank = 0;
            DRank0DataSet result2 = DataSetUtil.asDataSet((double)((Number)odata).doubleValue());
            if (varType != 31L) return result2;
            result2.putProperty("UNITS", (Object)Units.cdfEpoch);
            result2.putProperty("VALID_MIN", (Object)1.0);
            return result2;
        }
        Object element = Array.get(odata, 0);
        if (element.getClass().isArray()) {
            Object element3;
            Object element2 = Array.get(element, 0);
            rank = element2.getClass().isArray() ? ((element3 = Array.get(element2, 0)).getClass().isArray() ? 4 : 3) : 2;
        }
        if (recCount == -1L && rank == 4) {
            result2 = CdfUtil.wrapRank4(varType, Array.get(odata, 0), variable);
        }
        if ((recCount == 1L || recCount == -1L && rank == 2) && !odata.getClass().isArray()) {
            return CdfUtil.wrapSingle(varType, variable.getName(), odata);
        }
        if (rank == 1) {
            if (varType == 21L) return FDataSet.wrap((float[])((float[])odata));
            if (varType == 44L) {
                return FDataSet.wrap((float[])((float[])odata));
            }
            if (varType == 22L) return DDataSet.wrap((double[])((double[])odata));
            if (varType == 45L) {
                return DDataSet.wrap((double[])((double[])odata));
            }
            if (varType == 14L) {
                return LDataSet.wrap((long[])((long[])odata));
            }
            if (varType == 4L) return IDataSet.wrap((int[])((int[])odata));
            if (varType == 12L) {
                return IDataSet.wrap((int[])((int[])odata));
            }
            if (varType == 2L) return SDataSet.wrap((short[])((short[])odata));
            if (varType == 11L) {
                return SDataSet.wrap((short[])((short[])odata));
            }
            if (varType == 1L) return BDataSet.wrap((byte[])((byte[])odata));
            if (varType == 41L) {
                return BDataSet.wrap((byte[])((byte[])odata));
            }
            if (varType == 51L || varType == 52L) {
                EnumerationUnits units = EnumerationUnits.create((Object)variable.getName());
                String[] sdata = (String[])odata;
                double[] back = new double[sdata.length];
                for (int i = 0; i < sdata.length; ++i) {
                    back[i] = units.createDatum((Object)Ops.saferName((String)sdata[i])).doubleValue((Units)units);
                }
                result2 = DDataSet.wrap((double[])back);
                result2.putProperty("UNITS", (Object)units);
                return result2;
            } else if (varType == 31L) {
                result2 = DDataSet.wrap((double[])((double[])odata));
                result2.putProperty("UNITS", (Object)Units.cdfEpoch);
                result2.putProperty("VALID_MIN", (Object)1.0);
                return result2;
            } else {
                if (varType != 32L) throw new RuntimeException("Unsupported Data Type " + variable.getDataType() + " java type " + odata.getClass());
                double[] data = (double[])odata;
                double[] dresult = new double[data.length / 2];
                for (int i = 0; i < dresult.length; ++i) {
                    double t2000 = data[i * 2] - 6.3113904E10;
                    dresult[i] = t2000 * 1000000.0 + data[i * 2 + 1] / 1000000.0;
                }
                result2 = DDataSet.wrap((double[])dresult);
                result2.putProperty("UNITS", (Object)Units.us2000);
            }
            return result2;
        } else {
            if (rank == 2) {
                return CdfUtil.wrapRank2(varType, odata, variable);
            }
            if (rank != 3) return CdfUtil.wrapRank4(varType, odata, variable);
            return CdfUtil.wrapRank3(varType, odata, variable);
        }
    }

    public static Map<String, String> getPlottable(CDF cdf, boolean dataOnly, int rankLimit) throws CDFException {
        return CdfUtil.getPlottable(cdf, dataOnly, rankLimit, false);
    }

    public static boolean hasEntry(Attribute bAttr, Variable var) {
        try {
            bAttr.getEntry(var);
            return true;
        }
        catch (CDFException ex) {
            return false;
        }
    }

    public static Map<String, String> getPlottable(CDF cdf, boolean dataOnly, int rankLimit, boolean deep) throws CDFException {
        Variable var;
        int i;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> dependent = new LinkedHashMap<String, String>();
        boolean isMaster = cdf.getName().contains("MASTERS");
        logger.fine("getting CDF variables");
        Vector v = cdf.getVariables();
        logger.log(Level.FINE, "got {0} variables", v.size());
        Attribute aAttr = null;
        Attribute bAttr = null;
        Attribute cAttr = null;
        Attribute dAttr = null;
        Attribute blAttr = null;
        Attribute clAttr = null;
        Attribute dlAttr = null;
        Attribute catDesc = null;
        Attribute varNotes = null;
        Attribute virtual = null;
        Attribute function = null;
        Attribute varType = null;
        logger.fine("getting CDF attributes");
        try {
            aAttr = cdf.getAttribute("DEPEND_0");
        }
        catch (CDFException ex) {
            // empty catch block
        }
        try {
            bAttr = cdf.getAttribute("DEPEND_1");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            cAttr = cdf.getAttribute("DEPEND_2");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            dAttr = cdf.getAttribute("DEPEND_3");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            blAttr = cdf.getAttribute("LABL_PTR_1");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            clAttr = cdf.getAttribute("LABL_PTR_2");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            dlAttr = cdf.getAttribute("LABL_PTR_3");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            catDesc = cdf.getAttribute("CATDESC");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            varNotes = cdf.getAttribute("VAR_NOTES");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            virtual = cdf.getAttribute("VIRTUAL");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            function = cdf.getAttribute("FUNCTION");
        }
        catch (CDFException e) {
            // empty catch block
        }
        try {
            varType = cdf.getAttribute("VAR_TYPE");
        }
        catch (CDFException e) {
            // empty catch block
        }
        int skipCount = 0;
        for (i = 0; i < v.size(); ++i) {
            Entry varTypeEntry;
            var = (Variable)v.get(i);
            if (!dataOnly) continue;
            if (varType == null) {
                ++skipCount;
                continue;
            }
            if (!CdfUtil.hasEntry(varType, var) || String.valueOf((varTypeEntry = varType.getEntry(var)).getData()).equals(VAR_TYPE_DATA)) continue;
            ++skipCount;
        }
        if (skipCount == v.size()) {
            System.err.println("turning off dataOnly because it rejects everything");
            dataOnly = false;
        }
        for (i = 0; i < v.size(); ++i) {
            Entry zEntry;
            Entry yEntry;
            Entry entry;
            Entry varTypeEntry;
            var = (Variable)v.get(i);
            if (var.getDataType() == 51L || var.getDataType() == 52L) continue;
            ArrayList<String> warn = new ArrayList<String>();
            long maxRec = var.getMaxWrittenRecord();
            long[] dims = var.getDimSizes();
            int rank = dims == null ? 1 : dims.length + 1;
            if (rank > rankLimit) continue;
            boolean isVirtual = false;
            if (virtual != null) {
                try {
                    Entry entry2 = virtual.getEntry(var);
                    if (String.valueOf(entry2.getData()).equals("TRUE")) {
                        if (function != null) {
                            String sfunction = String.valueOf(function.getEntry(var).getData());
                            if (CdfVirtualVars.isSupported(sfunction)) {
                                isVirtual = true;
                            }
                        } else {
                            isVirtual = false;
                        }
                    }
                }
                catch (CDFException ex) {
                    // empty catch block
                }
            }
            if (var.getName().equals("Time_PB5")) {
                logger.log(Level.FINE, "skipping {0} because we always skip Time_PB5", var.getName());
                continue;
            }
            if (dataOnly && varType != null && CdfUtil.hasEntry(varType, var) && !String.valueOf((varTypeEntry = varType.getEntry(var)).getData()).equals(VAR_TYPE_DATA)) continue;
            Variable xDependVariable = null;
            long xMaxRec = -1L;
            Variable yDependVariable = null;
            long yMaxRec = -1L;
            Variable zDependVariable = null;
            long zMaxRec = -1L;
            Variable z1DependVariable = null;
            long z1MaxRec = -1L;
            String scatDesc = null;
            String svarNotes = null;
            try {
                if (virtual != null) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{virtual.getName(), var.getName()});
                    entry = virtual.getEntry(var);
                    if (String.valueOf(entry.getData()).equals("TRUE") && !isVirtual) {
                        continue;
                    }
                }
            }
            catch (CDFException e) {
                // empty catch block
            }
            try {
                if (aAttr != null) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{aAttr.getName(), var.getName()});
                    Entry xEntry = aAttr.getEntry(var);
                    xDependVariable = cdf.getVariable(String.valueOf(xEntry.getData()));
                    xMaxRec = xDependVariable.getMaxWrittenRecord();
                    if (xMaxRec != maxRec) {
                        if (maxRec == -1L) {
                            ++maxRec;
                        }
                        warn.add("depend0 length is inconsistent with length (" + (maxRec + 1L) + ")");
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + aAttr.getName() + ": " + e.getMessage());
            }
            try {
                if (bAttr != null && rank > 1 && CdfUtil.hasEntry(bAttr, var)) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{bAttr.getName(), var.getName()});
                    yEntry = bAttr.getEntry(var);
                    yDependVariable = cdf.getVariable(String.valueOf(yEntry.getData()));
                    yMaxRec = yDependVariable.getMaxWrittenRecord();
                    if (yMaxRec == 0L) {
                        yMaxRec = yDependVariable.getDimSizes()[0] - 1L;
                    }
                    if (!yDependVariable.getRecVariance() && dims.length > 0 && yMaxRec + 1L != dims[0]) {
                        warn.add("depend1 length is inconsistent with length (" + dims[0] + ")");
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + bAttr.getName() + ": " + e.getMessage());
            }
            try {
                if (yMaxRec == -1L && blAttr != null && rank > 1 && CdfUtil.hasEntry(blAttr, var)) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{blAttr.getName(), var.getName()});
                    yEntry = blAttr.getEntry(var);
                    yDependVariable = cdf.getVariable(String.valueOf(yEntry.getData()));
                    yMaxRec = yDependVariable.getMaxWrittenRecord();
                    if (yMaxRec == 0L) {
                        yMaxRec = yDependVariable.getDimSizes()[0] - 1L;
                    }
                    if (!yDependVariable.getRecVariance() && dims.length > 0 && yMaxRec + 1L != dims[0]) {
                        warn.add("LABL_PTR_1 length is inconsistent with length (" + dims[0] + ")");
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + blAttr.getName() + ": " + e.getMessage());
            }
            try {
                if (cAttr != null && rank > 2 && CdfUtil.hasEntry(cAttr, var)) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{cAttr.getName(), var.getName()});
                    zEntry = cAttr.getEntry(var);
                    zDependVariable = cdf.getVariable(String.valueOf(zEntry.getData()));
                    zMaxRec = zDependVariable.getMaxWrittenRecord();
                    if (zMaxRec == 0L) {
                        zMaxRec = zDependVariable.getDimSizes()[0] - 1L;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + cAttr.getName() + ": " + e.getMessage());
            }
            try {
                if (zMaxRec == -1L && clAttr != null && rank > 2 && CdfUtil.hasEntry(clAttr, var)) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{clAttr.getName(), var.getName()});
                    zEntry = clAttr.getEntry(var);
                    zDependVariable = cdf.getVariable(String.valueOf(zEntry.getData()));
                    zMaxRec = zDependVariable.getMaxWrittenRecord();
                    if (zMaxRec == 0L) {
                        zMaxRec = zDependVariable.getDimSizes()[0] - 1L;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + clAttr.getName() + ": " + e.getMessage());
            }
            try {
                if (dAttr != null && rank > 3 && CdfUtil.hasEntry(dAttr, var)) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{dAttr.getName(), var.getName()});
                    zEntry = dAttr.getEntry(var);
                    z1DependVariable = cdf.getVariable(String.valueOf(zEntry.getData()));
                    z1MaxRec = z1DependVariable.getMaxWrittenRecord();
                    if (z1MaxRec == 0L) {
                        z1MaxRec = z1DependVariable.getDimSizes()[0] - 1L;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + dAttr.getName() + ": " + e.getMessage());
            }
            try {
                if (z1MaxRec == -1L && dlAttr != null && rank > 3 && CdfUtil.hasEntry(dlAttr, var)) {
                    logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{dlAttr.getName(), var.getName()});
                    zEntry = dlAttr.getEntry(var);
                    z1DependVariable = cdf.getVariable(String.valueOf(zEntry.getData()));
                    z1MaxRec = z1DependVariable.getMaxWrittenRecord();
                    if (z1MaxRec == 0L) {
                        z1MaxRec = z1DependVariable.getDimSizes()[0] - 1L;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with " + dlAttr.getName() + ": " + e.getMessage());
            }
            if (deep) {
                try {
                    if (catDesc != null) {
                        logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{catDesc.getName(), var.getName()});
                        if (CdfUtil.hasEntry(catDesc, var)) {
                            entry = catDesc.getEntry(var);
                            scatDesc = String.valueOf(entry.getData());
                        } else {
                            scatDesc = "";
                        }
                    }
                    if (varNotes != null) {
                        logger.log(Level.FINE, "get attribute {0} entry for {1}", new Object[]{varNotes.getName(), var.getName()});
                        if (CdfUtil.hasEntry(varNotes, var)) {
                            entry = varNotes.getEntry(var);
                            svarNotes = String.valueOf(entry.getData());
                        } else {
                            svarNotes = "";
                        }
                    }
                }
                catch (CDFException e) {
                    warn.add(e.getMessage());
                }
            }
            String desc = "" + var.getName();
            if (xDependVariable != null) {
                desc = desc + "(" + xDependVariable.getName();
                if (xMaxRec >= 0L || !isMaster) {
                    desc = desc + "=" + (xMaxRec + 1L);
                }
                if (yDependVariable != null) {
                    desc = desc + "," + yDependVariable.getName() + "=" + (yMaxRec + 1L);
                    if (zDependVariable != null) {
                        desc = desc + "," + zDependVariable.getName() + "=" + (zMaxRec + 1L);
                        if (z1DependVariable != null) {
                            desc = desc + "," + z1DependVariable.getName() + "=" + (z1MaxRec + 1L);
                        }
                    }
                } else if (rank > 1) {
                    desc = desc + "," + DataSourceUtil.strjoin((long[])dims, (String)",");
                }
                desc = desc + ")";
            }
            if (deep) {
                StringBuilder descbuf = new StringBuilder("<html><b>" + desc + "</b><br>");
                StringBuilder sdims = new StringBuilder();
                String recDesc = CDFUtils.getStringDataType((Variable)var);
                if (dims != null) {
                    recDesc = recDesc + "[" + DataSourceUtil.strjoin((long[])dims, (String)",") + "]";
                }
                if (maxRec != xMaxRec) {
                    descbuf.append("").append(maxRec + 1L).append(" records of ").append(recDesc).append("<br>");
                }
                if (scatDesc != null) {
                    descbuf.append("").append(scatDesc).append("<br>");
                }
                if (svarNotes != null) {
                    descbuf.append("<br><p><small>").append(svarNotes).append("<small></p>");
                }
                for (String s : warn) {
                    descbuf.append("<br>WARNING: ").append(s);
                }
                descbuf.append("</html>");
                if (xDependVariable != null) {
                    dependent.put(var.getName(), descbuf.toString());
                    continue;
                }
                result.put(var.getName(), descbuf.toString());
                continue;
            }
            if (xDependVariable != null) {
                dependent.put(var.getName(), desc);
                continue;
            }
            result.put(var.getName(), desc);
        }
        logger.fine("done, get plottable ");
        dependent.putAll(result);
        return dependent;
    }
}

