/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdfdatasource;

import gsfc.nssdc.cdf.CDF;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public class Main {
    private static boolean cdfLoaded = false;

    private static void dumpProperties() {
        Properties p = System.getProperties();
        for (Object k : p.keySet()) {
            System.err.println(k + "=" + p.get(k));
        }
    }

    private static void loadCdfLibraries() {
        String cdfLib1 = System.getProperty("cdfLib1");
        String cdfLib2 = System.getProperty("cdfLib2");
        if (cdfLib1 == null && cdfLib2 == null) {
            System.err.println("System properties for cdfLib not set, setting up for debugging");
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                cdfLib1 = "dllcdf";
                cdfLib2 = "cdfNativeLibrary";
            } else {
                cdfLib2 = "cdfNativeLibrary";
            }
        }
        if (cdfLib1 != null) {
            System.loadLibrary(cdfLib1);
        }
        if (cdfLib2 != null) {
            System.loadLibrary(cdfLib2);
        }
    }

    public static void main(String[] args) throws Exception {
        String file;
        System.err.println("java.library.path=" + System.getProperty("java.library.path"));
        Logger logger = Logger.getLogger("virbo.cdfdatasource");
        if (args.length == 0) {
            file = "C:/Documents and Settings/jbf/autoplot_data/ftp/cdaweb.gsfc.nasa.gov/pub/istp/polar/mfe/1996/po_k0_mfe_19960316_v02.cdf";
            file = "c:/po_k0_mfe_19960317_v02.cdf";
        } else {
            file = args[0];
        }
        System.err.println(Arrays.asList(new File("c:/").list()));
        System.err.println("File: " + file);
        System.err.println("File exists: " + new File(file).exists());
        System.err.println("CDF version= " + CDF.getLibraryVersion());
        CDF cdf = CDF.open((String)file, (long)0L);
        System.err.println("cdf.getNumVars()=" + cdf.getNumVars());
        LinkedHashMap vars = new LinkedHashMap();
        Vector v = cdf.getVariables();
        System.err.println("plottable vars= " + v.size());
        System.err.println("cdf.getNumAttrs()=" + cdf.getNumAttrs());
        cdf.close();
    }

    static {
        System.err.println("java.library.path=" + System.getProperty("java.library.path"));
        try {
            System.err.println("" + new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Main.dumpProperties();
        if (!cdfLoaded) {
            Main.loadCdfLibraries();
        }
    }
}

