/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.BaseType;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DConnect;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DODSException;
import dods.dap.DSequence;
import dods.dap.DStructure;
import dods.dap.Float32PrimitiveVector;
import dods.dap.Float64PrimitiveVector;
import dods.dap.NoSuchVariableException;
import dods.dap.PrimitiveVector;
import dods.dap.StatusUI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Units;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dods.ArrayUtil;
import org.virbo.dods.DodsVarDataSet;
import org.virbo.dsops.Ops;
import org.virbo.metatree.MetadataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DodsAdapter {
    private URL source;
    private String variable;
    private String constraint;
    private DDS dds;
    private HashMap properties;
    int sliceIndex = 0;
    private String depend0Name;
    private String depend1Name;
    private double addOffset = 0.0;
    private double scaleFactor = 1.0;
    private Units[] dimUnits = new Units[8];
    private HashMap[] dimProperties = new HashMap[8];
    private Units units;
    private String[] dependName = new String[8];

    public DodsAdapter(URL source, String variable) {
        this.source = source;
        this.variable = variable;
        this.properties = new HashMap();
    }

    void setVariable(String variable) {
        this.variable = variable;
    }

    public void setConstraint(String c) {
        if (!c.startsWith("?")) {
            throw new IllegalArgumentException("constraint must start with question mark(?)");
        }
        this.constraint = c;
    }

    public String getConstraint() {
        return this.constraint;
    }

    private long getSizeForType(DArray v, boolean streaming) {
        PrimitiveVector pv = v.getPrimitiveVector();
        if (pv instanceof Float32PrimitiveVector) {
            return 4 * (streaming ? v.getFirstDimension().getSize() : 1);
        }
        if (pv instanceof Float64PrimitiveVector) {
            return 8 * (streaming ? v.getFirstDimension().getSize() : 1);
        }
        return 1L;
    }

    private long getSizeForType(BaseType v, boolean streaming) {
        if (v instanceof DFloat64) {
            return 8L;
        }
        if (v instanceof DFloat32) {
            return 4L;
        }
        if (v instanceof DArray) {
            return this.getSizeForType((DArray)v, streaming);
        }
        throw new IllegalArgumentException("not supported: " + v);
    }

    private long calcSize(Map<String, Object> attr) throws MalformedURLException, IOException, dods.dap.parser.ParseException {
        try {
            DDS dds = new DDS();
            dds.parse(new URL(this.getSource().toString() + ".dds" + this.constraint).openStream());
            Enumeration variables = dds.getVariables();
            long size = 0L;
            while (variables.hasMoreElements()) {
                Object o = variables.nextElement();
                if (o instanceof DSequence) {
                    Enumeration enume1 = ((DSequence)o).getVariables();
                    int j = 0;
                    while (enume1.hasMoreElements()) {
                        Object ele = enume1.nextElement();
                        if (ele instanceof DStructure) {
                            DStructure ds = (DStructure)ele;
                            Enumeration enume2 = ds.getVariables();
                            boolean jj = false;
                            while (enume2.hasMoreElements()) {
                                Object k = enume2.nextElement();
                                j = (int)((long)j + this.getSizeForType((BaseType)k, true));
                            }
                            continue;
                        }
                        if (ele instanceof DSequence) {
                            j += 0;
                            continue;
                        }
                        if (ele instanceof BaseType) {
                            j = (int)((long)j + this.getSizeForType((BaseType)ele, true));
                            continue;
                        }
                        throw new IllegalArgumentException("huh");
                    }
                    String srecCount = (String)attr.get("recCount");
                    if (srecCount != null) {
                        size = (long)j * Long.parseLong(srecCount);
                        continue;
                    }
                    size = -1L;
                    continue;
                }
                DArray v = (DArray)o;
                Enumeration dimensions = v.getDimensions();
                long s1 = this.getSizeForType(v, false);
                s1 *= 2L;
                while (dimensions.hasMoreElements()) {
                    DArrayDimension d = (DArrayDimension)dimensions.nextElement();
                    s1 *= (long)d.getSize();
                }
                size += s1;
            }
            return size;
        }
        catch (DDSException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadDataset(final ProgressMonitor mon, Map<String, Object> attr) throws FileNotFoundException, MalformedURLException, IOException, dods.dap.parser.ParseException, DDSException, DODSException, CancelledOperationException {
        if (this.constraint == null) {
            this.constraint = "";
        }
        long size = this.calcSize(attr);
        mon.setTaskSize(size);
        DConnect url = new DConnect(this.source.toString(), true);
        StatusUI sui = new StatusUI(){
            long byteCount = 0L;

            public void incrementByteCount(int bytes) {
                this.byteCount += (long)bytes;
                mon.setTaskProgress(this.byteCount);
            }

            public boolean userCancelled() {
                return mon.isCancelled();
            }

            public void finished() {
                mon.finished();
            }
        };
        mon.started();
        try {
            this.dds = url.getData(this.constraint, sui);
        }
        catch (DODSException ex) {
            if (mon.isCancelled()) {
                throw new CancelledOperationException("Dods load cancelled");
            }
            throw ex;
        }
    }

    public void setSliceIndex(int index) {
        this.sliceIndex = index;
    }

    public QDataSet getDataSet(Map<String, Object> attributes) {
        int j;
        DDataSet reduce;
        DodsVarDataSet zds;
        block42: {
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
            }
            try {
                BaseType btvar = this.dds.getVariable(this.variable);
                String type = btvar.getTypeName();
                if (type.equals("Grid")) {
                    DGrid zgrid = (DGrid)btvar;
                    DArray z = (DArray)zgrid.getVar(0);
                    zds = DodsVarDataSet.newDataSet(z, this.properties);
                    if (zds.property("UNITS") == null) {
                        zds.putProperty("UNITS", this.units);
                    }
                    for (int idim = 0; idim < z.numDimensions(); ++idim) {
                        DArray t = (DArray)zgrid.getVar(idim + 1);
                        HashMap<String, Units> tprops = new HashMap<String, Units>();
                        tprops.put("UNITS", this.dimUnits[idim]);
                        if (this.dimProperties[idim] != null) {
                            tprops.putAll(this.dimProperties[idim]);
                        }
                        DodsVarDataSet tds = DodsVarDataSet.newDataSet(t, tprops);
                        zds.putProperty("DEPEND_" + idim, tds);
                    }
                    break block42;
                }
                if (type.equals("Array")) {
                    DArray z = (DArray)btvar;
                    zds = DodsVarDataSet.newDataSet(z, this.properties);
                    if (zds.property("UNITS") == null) {
                        zds.putProperty("UNITS", this.units);
                    }
                    for (int idim = 0; idim < z.numDimensions(); ++idim) {
                        DodsVarDataSet tds;
                        if (this.dependName[idim] == null) continue;
                        DArray t = (DArray)this.dds.getVariable(this.dependName[idim]);
                        HashMap<String, Units> tprops = new HashMap<String, Units>();
                        tprops.put("UNITS", this.dimUnits[idim]);
                        if (this.dimProperties[idim] != null) {
                            tprops.putAll(this.dimProperties[idim]);
                        }
                        if (DataSetUtil.isMonotonic((QDataSet)(tds = DodsVarDataSet.newDataSet(t, tprops)))) {
                            tds.putProperty("MONOTONIC", Boolean.TRUE);
                        }
                        zds.putProperty("DEPEND_" + idim, tds);
                    }
                    break block42;
                }
                if (type.equals("Sequence")) {
                    int j2;
                    DSequence dseq = (DSequence)btvar;
                    int cols = dseq.elementCount(true);
                    int rows = dseq.getRowCount();
                    WritableDataSet[] dss = new WritableDataSet[cols];
                    String[] labels = new String[cols];
                    Type t = Type.scalars;
                    for (int i = 0; i < rows; ++i) {
                        Vector v = dseq.getRow(i);
                        j2 = 0;
                        for (Object ele : v) {
                            if (ele instanceof DStructure) {
                                DStructure ds = (DStructure)ele;
                                Enumeration enume = ds.getVariables();
                                while (enume.hasMoreElements()) {
                                    Object k = enume.nextElement();
                                    if (i == 0) {
                                        if ((BaseType)k instanceof DArray) {
                                            dss[j2] = DDataSet.createRank2((int)rows, (int)((DArray)k).getLength());
                                            t = Type.spectrogram;
                                        } else {
                                            dss[j2] = DDataSet.createRank1((int)rows);
                                        }
                                        labels[j2] = ((BaseType)k).getName();
                                        dss[j2].putProperty("NAME", (Object)labels[j2]);
                                    }
                                    this.putValue(dss[j2], i, (BaseType)k);
                                    ++j2;
                                }
                                continue;
                            }
                            if (ele instanceof BaseType) {
                                if (i == 0) {
                                    if ((BaseType)ele instanceof DArray) {
                                        dss[j2] = DDataSet.createRank2((int)rows, (int)((DArray)ele).getLength());
                                        t = Type.spectrogram;
                                    } else {
                                        dss[j2] = DDataSet.createRank1((int)rows);
                                    }
                                    labels[j2] = ((BaseType)ele).getName();
                                    dss[j2].putProperty("NAME", (Object)labels[j2]);
                                }
                                this.putValue(dss[j2], i, (BaseType)ele);
                                ++j2;
                                continue;
                            }
                            throw new IllegalArgumentException("huh");
                        }
                    }
                    if (cols > 2 && t == Type.scalars) {
                        t = Type.vectors;
                    }
                    WritableDataSet zresult = null;
                    if (t == Type.spectrogram || t == Type.scalars) {
                        dss[cols - 1].putProperty("DEPEND_0", (Object)dss[0]);
                        zresult = dss[cols - 1];
                        if (t == Type.spectrogram) {
                            dss[cols - 1].putProperty("DEPEND_1", (Object)DataSetOps.slice0((QDataSet)dss[1], (int)0));
                        }
                    } else if (t == Type.vectors) {
                        DDataSet rresult = DDataSet.createRank2((int)rows, (int)(cols - 1));
                        for (j2 = 0; j2 < cols - 1; ++j2) {
                            WritableDataSet ds = dss[j2 + 1];
                            for (int i = 0; i < rows; ++i) {
                                rresult.putValue(i, j2, ds.value(i));
                            }
                        }
                        rresult.putProperty("DEPEND_1", (Object)DataSetOps.trim((QDataSet)Ops.labels((String[])labels), (int)1, (int)(cols - 1)));
                        rresult.putProperty("DEPEND_0", (Object)dss[0]);
                        zresult = rresult;
                    }
                    if (zresult == null) {
                        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)t));
                    }
                    MutablePropertyDataSet dep0 = (MutablePropertyDataSet)zresult.property("DEPEND_0");
                    String sunits = (String)MetadataUtil.getNode(attributes, (String[])new String[]{labels[0], "units"});
                    if (sunits != null && sunits.contains("since")) {
                        try {
                            Units u = SemanticOps.lookupTimeUnits((String)sunits);
                            dep0.putProperty("UNITS", (Object)u);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(DodsAdapter.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    return zresult;
                }
                throw new IllegalStateException("not supported dds type:" + type);
            }
            catch (NoSuchVariableException ex) {
                throw new RuntimeException(ex);
            }
        }
        DodsVarDataSet ds = zds;
        if (zds.rank() == 3) {
            reduce = DDataSet.createRank2((int)zds.length(), (int)zds.length(0));
            for (int i = 0; i < zds.length(); ++i) {
                for (j = 0; j < zds.length(0); ++j) {
                    reduce.putValue(i, j, zds.value(i, j, 0));
                }
            }
            ds = reduce;
        } else if (zds.rank() == 4) {
            reduce = DDataSet.createRank2((int)zds.length(), (int)zds.length(0));
            for (int i = 0; i < zds.length(); ++i) {
                for (j = 0; j < zds.length(0); ++j) {
                    reduce.putValue(i, j, zds.value(i, j, 0, 0));
                }
            }
            ds = reduce;
        }
        return ds;
    }

    public String getDepend0Name() {
        return this.depend0Name;
    }

    public void setDepend0Name(String depend0Name) {
        this.depend0Name = depend0Name;
    }

    public String getDepend1Name() {
        return this.depend1Name;
    }

    public void setDepend1Name(String depend1Name) {
        this.depend1Name = depend1Name;
    }

    public double getAddOffset() {
        return this.addOffset;
    }

    public void setAddOffset(double addOffset) {
        this.addOffset = addOffset;
        this.properties.put("add_offset", new Double(addOffset));
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.properties.put("scale_factor", new Double(scaleFactor));
    }

    public void setValidRange(double min, double max) {
        this.properties.put("valid_range", "" + min + "," + max);
    }

    public Units getDimUnits(int index) {
        return this.dimUnits[index];
    }

    public void setDimUnits(int index, Units dimUnits) {
        this.dimUnits[index] = dimUnits;
    }

    public void putAllProperties(Map p) {
        this.properties.putAll(p);
    }

    public void setDimProperties(int dim, Map p) {
        this.dimProperties[dim] = new HashMap(p);
    }

    public HashMap getDimProperties(int i) {
        return this.dimProperties[i];
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public String getDependName(int index) {
        return this.dependName[index];
    }

    public void setDependName(int index, String dependName) {
        this.dependName[index] = dependName;
    }

    public URL getSource() {
        return this.source;
    }

    public String getVariable() {
        return this.variable;
    }

    private void putValue(WritableDataSet result, int i, BaseType value) {
        if (value instanceof DFloat64) {
            result.putValue(i, ((DFloat64)value).getValue());
        } else if (value instanceof DFloat32) {
            result.putValue(i, (double)((DFloat32)value).getValue());
        } else if (value instanceof DArray) {
            ArrayUtil.putValues(result, i, ((DArray)value).getPrimitiveVector().getInternalStorage());
        } else {
            throw new IllegalArgumentException("not supported: " + value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        spectrogram,
        vectors,
        scalars;

    }
}

