/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.DDSException;
import dods.dap.parser.ParseException;
import dods.dap.parser.TokenMgrError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.URISplit;
import org.virbo.dods.DodsDataSource;
import org.virbo.dods.MyDDSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DodsDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws IOException {
        try {
            return new DodsDataSource(uri);
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Does not appear to be a DDS: " + uri, ex);
        }
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            String file = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
            return this.getVars(file);
        }
        return Collections.emptyList();
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        if (surl.contains("?")) {
            return false;
        }
        try {
            URISplit split = URISplit.parse((String)surl);
            List<CompletionContext> cc = this.getVars(split.file);
            return cc.size() > 1;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return true;
        }
    }

    private List<CompletionContext> getVars(String file) throws DDSException, IOException, MalformedURLException, ParseException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        int i = file.lastIndexOf(46);
        String sMyUrl = file.substring(0, i);
        URL url = new URL(sMyUrl + ".dds");
        MyDDSParser parser = new MyDDSParser();
        try {
            parser.parse(url.openStream());
        }
        catch (TokenMgrError ex) {
            throw new ParseException("Does not appear to be a DDS: " + url);
        }
        catch (RuntimeException ex) {
            throw new ParseException("Does not appear to be a DDS: " + url);
        }
        String[] vars = parser.getVariableNames();
        for (int j = 0; j < vars.length; ++j) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, vars[j], (DataSourceFactory)this, "arg_0", null, null, true));
        }
        return result;
    }

    public <T> T getCapability(Class<T> clazz) {
        return null;
    }
}

